-- ----------------------------
-- Table structure for batch_task
-- ----------------------------

CREATE TABLE `batch_task` (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `task_type` varchar(32) DEFAULT NULL COMMENT '当前任务类型',
  `task_node` varchar(32) DEFAULT NULL COMMENT '当前自定义任务节点',
  `rpt_call_ind` varchar(2) DEFAULT NULL COMMENT '是否允许重复执行',
  `sts` varchar(2) DEFAULT NULL COMMENT '状态（00初始化，10待处理，20处理中，30异常，40完成）',
  `abnorm_rsn_cd` varchar(255) DEFAULT NULL COMMENT '异常原因码',
  `abnorm_rsn_desc` varchar(255) DEFAULT NULL COMMENT '异常原因描述',
  `exe_cnt` bigint(10) DEFAULT NULL COMMENT '执行次数',
  `pri` bigint(10) DEFAULT NULL COMMENT '优先级',
  `log_id` varchar(64) DEFAULT NULL COMMENT '日志ID',
  `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
  `sec_bu_id` bigint(20) DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) DEFAULT NULL COMMENT 'sec_ou_id',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='批处理任务';

-- ----------------------------
-- Table structure for batch_task_data_ra
-- ----------------------------

CREATE TABLE `batch_task_data_ra` (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `task_id` bigint(32) DEFAULT NULL COMMENT '任务ID',
  `table_id` bigint(32) DEFAULT NULL COMMENT '表id',
  `ra_type1` varchar(32) DEFAULT NULL COMMENT '类型1',
  `ra_type2` varchar(32) DEFAULT NULL COMMENT '类型2',
  `request_series` varchar(200) DEFAULT NULL COMMENT '请求序号',
  `response_desc` text COMMENT '响应描述',
  `sync_flag` tinyint(2) DEFAULT NULL COMMENT '是否成功：0失败、1成功、2部分成功',
  `supp_code` varchar(40) DEFAULT NULL COMMENT '供应商编号',
  `item_code` varchar(40) DEFAULT NULL COMMENT '商品编号',
  `result_desc` text COMMENT '结果描述',
  `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
  `sec_bu_id` bigint(20) DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) DEFAULT NULL COMMENT 'sec_ou_id',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='批处理任务数据采购退货地址关联表';

-- ----------------------------
-- Table structure for batch_task_data_ref
-- ----------------------------

CREATE TABLE `batch_task_data_ref` (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `task_id` bigint(32) DEFAULT NULL COMMENT '任务ID',
  `table_id` bigint(32) DEFAULT NULL COMMENT '表id',
  `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
  `sec_bu_id` bigint(20) DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) DEFAULT NULL COMMENT 'sec_ou_id',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='批处理任务数据关联表';

-- ----------------------------
-- Table structure for batch_task_his
-- ----------------------------

CREATE TABLE `batch_task_his` (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `task_id` bigint(32) DEFAULT NULL COMMENT '任务ID',
  `task_type` varchar(32) DEFAULT NULL COMMENT '当前任务类型',
  `task_node` varchar(32) DEFAULT NULL COMMENT '当前自定义任务节点',
  `rpt_call_ind` varchar(2) DEFAULT NULL COMMENT '是否允许重复执行',
  `sts` varchar(2) DEFAULT NULL COMMENT '状态（00初始化，10待处理，20处理中，30异常，40完成）',
  `abnorm_rsn_cd` varchar(255) DEFAULT NULL COMMENT '异常原因码',
  `abnorm_rsn_desc` varchar(255) DEFAULT NULL COMMENT '异常原因描述',
  `exe_cnt` bigint(10) DEFAULT NULL COMMENT '执行次数',
  `pri` bigint(10) DEFAULT NULL COMMENT '优先级',
  `log_id` varchar(64) DEFAULT NULL COMMENT '日志ID',
  `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
  `sec_bu_id` bigint(20) DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) DEFAULT NULL COMMENT 'sec_ou_id',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='批处理任务历史表';

-- ----------------------------
-- Table structure for com_area
-- ----------------------------

CREATE TABLE `com_area` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '记录唯一ID',
  `name` varchar(256) DEFAULT NULL COMMENT '区域名称',
  `parent_id` bigint(20) DEFAULT NULL,
  `category` varchar(256) DEFAULT NULL COMMENT '分类  UDC[COM:AREA_CATEGORY] （province：省份，city：市，county：县（区），street：乡、镇、街道）',
  `sort_no` int(11) DEFAULT NULL,
  `enabled` tinyint(1) DEFAULT NULL COMMENT '是否启用',
  `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) DEFAULT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
  `level` int(11) DEFAULT NULL COMMENT '层级',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_com_area_parent_id` (`parent_id`) USING BTREE,
  KEY `create_user_id_index` (`create_user_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='区域设置';

-- ----------------------------
-- Table structure for com_area_copy1
-- ----------------------------

CREATE TABLE `com_area_copy1` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '记录唯一ID',
  `name` varchar(256) DEFAULT NULL COMMENT '区域名称',
  `parent_id` bigint(20) DEFAULT NULL,
  `category` varchar(256) DEFAULT NULL COMMENT '分类  UDC[COM:AREA_CATEGORY] （province：省份，city：市，county：县（区），street：乡、镇、街道）',
  `sort_no` int(11) DEFAULT NULL,
  `enabled` tinyint(1) DEFAULT NULL COMMENT '是否启用',
  `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) DEFAULT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
  `level` int(11) DEFAULT NULL COMMENT '层级',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_com_area_parent_id` (`parent_id`) USING BTREE,
  KEY `create_user_id_index` (`create_user_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='区域设置';

-- ----------------------------
-- Table structure for com_district
-- ----------------------------

CREATE TABLE `com_district` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '唯一编号ID',
  `dist_code` varchar(32) NOT NULL DEFAULT '' COMMENT '区划代码',
  `dist_name` varchar(64) NOT NULL DEFAULT '' COMMENT '区划名称',
  `dist_name2` varchar(64) DEFAULT '' COMMENT '区划名称2',
  `dist_type` varchar(32) DEFAULT '' COMMENT '区划类型',
  `dist_type2` varchar(32) DEFAULT '' COMMENT '区划类型2',
  `dist_type3` varchar(32) DEFAULT '' COMMENT '区划类型33',
  `abbr_name` varchar(32) DEFAULT '' COMMENT '区划简称',
  `country` varchar(32) DEFAULT '' COMMENT '国家码: COM:COUNTRY',
  `province` varchar(32) DEFAULT '' COMMENT '省份、州码：COM:STATE',
  `city` varchar(32) DEFAULT '' COMMENT '城市码：COM:CITY',
  `county` varchar(32) DEFAULT '' COMMENT '区县码: COM:COUNTY',
  `street` varchar(128) DEFAULT '' COMMENT '乡镇街道',
  `dist_level` varchar(32) DEFAULT '' COMMENT '区域等级',
  `dist_level_num` int(11) DEFAULT '0' COMMENT '区域等级数值',
  `parent_id` bigint(20) DEFAULT '0' COMMENT '上级ID',
  `parent_code` varchar(32) DEFAULT '' COMMENT '上级代码',
  `path` varchar(1024) DEFAULT '' COMMENT '路径',
  `dist_status` varchar(32) DEFAULT '' COMMENT '地址状态',
  `dist_pinyin` varchar(256) DEFAULT '' COMMENT '汉语拼音',
  `dist_pinyin_caps` varchar(32) DEFAULT '' COMMENT '拼音首字母',
  `tel_head` varchar(32) DEFAULT '' COMMENT '电话区号',
  `zip_code` varchar(16) DEFAULT '' COMMENT '邮编',
  `dist_desc` varchar(256) DEFAULT '' COMMENT '区域描述',
  `es1` varchar(64) DEFAULT '' COMMENT '扩展字符串1',
  `es2` varchar(64) DEFAULT '' COMMENT '扩展字符串2',
  `es3` varchar(64) DEFAULT '' COMMENT '扩展字符串3',
  `tenant_id` bigint(20) DEFAULT '0' COMMENT '租户ID',
  `remark` varchar(255) DEFAULT '' COMMENT '备注',
  `create_user_id` bigint(20) DEFAULT '0' COMMENT '记录创建者ID',
  `create_time` datetime DEFAULT NULL,
  `modify_user_id` bigint(20) DEFAULT '0' COMMENT '记录最后更新者ID',
  `modify_time` datetime DEFAULT NULL,
  `delete_flag` int(11) DEFAULT '0' COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) DEFAULT '0' COMMENT '版本信息，前端不用传',
  `p_id` bigint(20) DEFAULT '0' COMMENT '上级ID',
  `p_code` varchar(32) DEFAULT '' COMMENT '上级代码',
  `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
  `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `dist_code` (`dist_code`) USING BTREE,
  KEY `dist_code_2` (`dist_code`,`dist_level_num`) USING BTREE,
  KEY `create_user_id_index` (`create_user_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='行政区划';

-- ----------------------------
-- Table structure for com_file
-- ----------------------------

CREATE TABLE `com_file` (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `sec_bu_id` bigint(20) DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) DEFAULT NULL COMMENT 'sec_ou_id',
  `original_name` varchar(256) DEFAULT NULL COMMENT '文件原名称',
  `upload_name` varchar(256) DEFAULT NULL COMMENT '文件上传名称',
  `file_path` varchar(1000) DEFAULT NULL COMMENT '文件地址',
  `file_size` int(11) DEFAULT NULL COMMENT '文件大小',
  `suffix` varchar(32) DEFAULT NULL COMMENT '后缀名',
  `mime_type` varchar(256) DEFAULT NULL COMMENT '文件类型',
  `file_code` varchar(256) DEFAULT NULL COMMENT '文件编码',
  `file_url` varchar(1000) DEFAULT NULL COMMENT '访问路径',
  `thumbnail_file_code` varchar(256) DEFAULT NULL COMMENT '缩略图文件编码',
  `thumbnail_file_path` varchar(1000) DEFAULT NULL COMMENT '缩略图文件地址',
  `thumbnail_file_url` varchar(1000) DEFAULT NULL COMMENT '缩略图文件下载路径',
  `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `create_user_id_index` (`create_user_id`) USING BTREE,
  KEY `sec_bu_id_index` (`sec_bu_id`) USING BTREE,
  KEY `sec_user_id_index` (`sec_user_id`) USING BTREE,
  KEY `sec_ou_id_index` (`sec_ou_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='文件上传日志表';

-- ----------------------------
-- Table structure for com_tax_code
-- ----------------------------

CREATE TABLE `com_tax_code` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '记录唯一ID',
  `tax_name` varchar(40) DEFAULT NULL COMMENT '税区/税码',
  `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) DEFAULT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
  `tax_type` varchar(40) DEFAULT NULL COMMENT '税区',
  `tax_code` varchar(40) DEFAULT NULL COMMENT '税码',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `create_user_id_index` (`create_user_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='税码';

-- ----------------------------
-- Table structure for com_tax_rate
-- ----------------------------

CREATE TABLE `com_tax_rate` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '唯一编号ID',
  `ou_id` bigint(20) DEFAULT NULL COMMENT '公司ID',
  `tax_rate_no` varchar(40) DEFAULT NULL COMMENT '税率编号',
  `tax_rate_desc` varchar(40) DEFAULT NULL COMMENT '税率说明',
  `valid_from` datetime DEFAULT NULL COMMENT '生效日期',
  `valid_to` datetime DEFAULT NULL COMMENT '失效日期',
  `tax_rate_value` float(20,8) DEFAULT NULL COMMENT '税率值',
  `tenant_id` bigint(20) DEFAULT '0' COMMENT '租户ID',
  `remark` varchar(255) DEFAULT '' COMMENT '备注',
  `create_user_id` bigint(20) DEFAULT '0' COMMENT '记录创建者ID',
  `create_time` datetime DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) DEFAULT '0' COMMENT '记录最后更新者ID',
  `modify_time` datetime DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) DEFAULT '0' COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) DEFAULT '0' COMMENT '版本信息，前端不用传',
  `tax_rate_index` varchar(40) DEFAULT NULL COMMENT '税率索引 [UOM]COM:TAX_RATE_INDEX',
  `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
  `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `tax_rate_no` (`tax_rate_no`) USING BTREE,
  KEY `create_user_id_index` (`create_user_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='税率';

-- ----------------------------
-- Table structure for common_org_bu_treed
-- ----------------------------

CREATE TABLE `common_org_bu_treed` (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `pid` bigint(20) DEFAULT NULL COMMENT '上级ID',
  `sort_no` int(11) DEFAULT NULL COMMENT '排序号',
  `level` int(11) DEFAULT NULL COMMENT '层级',
  `code_path` varchar(512) DEFAULT NULL COMMENT '树型结构编号全路径，使用/隔离',
  `bu_tree_id` bigint(20) DEFAULT NULL COMMENT '组织树ID',
  `bu_id` bigint(20) DEFAULT NULL COMMENT '组织ID',
  `bu_code` varchar(40) DEFAULT NULL,
  `delete_flag` int(11) DEFAULT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_bu_tree_pid` (`pid`) USING BTREE,
  KEY `idx_bu_tree_code_path` (`code_path`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='组织树明细';

-- ----------------------------
-- Table structure for common_org_emp
-- ----------------------------

CREATE TABLE `common_org_emp` (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `pid` bigint(20) DEFAULT NULL COMMENT '上级ID',
  `sort_no` int(11) DEFAULT NULL COMMENT '排序号',
  `level` int(11) DEFAULT NULL COMMENT '层级',
  `code_path` varchar(512) DEFAULT NULL COMMENT '树型结构编号全路径，使用/隔离',
  `user_id` bigint(20) DEFAULT NULL COMMENT '用户id',
  `user_name` varchar(40) DEFAULT NULL COMMENT '用户名',
  `emp_code` varchar(40) DEFAULT NULL COMMENT '雇员编号',
  `emp_name` varchar(40) DEFAULT NULL COMMENT '雇员姓名',
  `delete_flag` int(11) DEFAULT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_emp_pid` (`pid`) USING BTREE,
  KEY `idx_emp_code_path` (`code_path`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='员工';

-- ----------------------------
-- Table structure for dropship_log_query
-- ----------------------------

CREATE TABLE `dropship_log_query` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `sal_do_doc_no` varchar(40) DEFAULT NULL COMMENT '订单中心发（退）货单号',
  `sal_do_doc_time` datetime DEFAULT NULL COMMENT '订单中心发（退）货单创建时间',
  `status` varchar(1) DEFAULT NULL COMMENT '生成状态 0：生成失败，1：生成成功',
  `log` varchar(255) DEFAULT NULL COMMENT '日志信息',
  `sal_do_type` varchar(10) DEFAULT NULL COMMENT '源单据类型 [UDC]PUR:SAL_DO_TYPE',
  `tenant_id` bigint(20) DEFAULT NULL,
  `remark` varchar(255) DEFAULT NULL,
  `create_user_id` bigint(20) DEFAULT NULL,
  `creator` varchar(255) DEFAULT NULL,
  `create_time` datetime(6) DEFAULT NULL,
  `modify_user_id` bigint(20) DEFAULT NULL,
  `updater` varchar(255) DEFAULT NULL,
  `modify_time` datetime(6) DEFAULT NULL,
  `delete_flag` int(11) DEFAULT NULL,
  `audit_data_version` int(11) DEFAULT NULL,
  `sal_dod_id` bigint(20) DEFAULT '0' COMMENT '订单中心发（退）货单明细ID',
  `sal_dod_line_no` decimal(20,3) DEFAULT NULL COMMENT '订单中心发（退）货单明细行号',
  `pur_po_doc_no` varchar(40) DEFAULT NULL COMMENT '采购订（退）货单号',
  `pur_po_doc_time` datetime DEFAULT NULL COMMENT '采购订（退）货单创建时间',
  `pur_pod_id` bigint(20) DEFAULT '0' COMMENT '采购订（退）货单明细ID',
  `pur_pod_line_no` decimal(20,3) DEFAULT NULL COMMENT '采购订（退）货单明细行号',
  `sal_do_supp_id` bigint(20) DEFAULT '0' COMMENT '订单中心发（退）货单供应商ID',
  `sal_do_supp_code` varchar(40) DEFAULT NULL COMMENT '订单中心发（退）货单供应商编号',
  `sal_do_supp_name` varchar(40) DEFAULT NULL COMMENT '订单中心发（退）货单供应商名称',
  `sal_do_item_id` bigint(20) DEFAULT '0' COMMENT '订单中心发（退）货单供应商ID',
  `sal_do_item_code` varchar(40) DEFAULT NULL COMMENT '订单中心发（退）货单商品编号',
  `sal_do_name` varchar(40) DEFAULT NULL COMMENT '订单中心发（退）货单商品名称',
  `sal_do_qty` decimal(20,8) DEFAULT NULL COMMENT '订单中心发（退）货数量',
  `pur_po_qty` decimal(20,8) DEFAULT NULL COMMENT '采购订（退）货单数量',
  `sal_do_uom` varchar(10) DEFAULT NULL COMMENT '订单中心发（退）货单位',
  `sec_bu_id` bigint(20) DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) DEFAULT NULL COMMENT 'sec_ou_id',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `create_user_id_index` (`create_user_id`) USING BTREE,
  KEY `sec_bu_id_index` (`sec_bu_id`) USING BTREE,
  KEY `sec_user_id_index` (`sec_user_id`) USING BTREE,
  KEY `sec_ou_id_index` (`sec_ou_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=547293043331566658 DEFAULT CHARSET=utf8mb4 COMMENT='一件代发(退)生成状态信息查询';

-- ----------------------------
-- Table structure for inv_corssentry_pricepolicy
-- ----------------------------

CREATE TABLE `inv_corssentry_pricepolicy` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '记录唯一ID',
  `ou_id` bigint(20) DEFAULT NULL COMMENT '公司ID',
  `policy_type` varchar(64) DEFAULT NULL COMMENT '策略类型 [UDC]PRI:CE_POLICY',
  `from_ou_id` bigint(20) DEFAULT NULL COMMENT '从公司ID',
  `to_ou_id` bigint(20) DEFAULT NULL COMMENT '到公司ID',
  `item_id` bigint(20) DEFAULT NULL COMMENT '品项ID',
  `vari_id` bigint(20) DEFAULT NULL COMMENT '异构ID',
  `itemc1` varchar(64) DEFAULT NULL COMMENT '品项大类编号',
  `itemc2` varchar(64) DEFAULT NULL COMMENT '品项中类编号',
  `itemc3` varchar(64) DEFAULT NULL COMMENT '品项小类编号',
  `item_brand` varchar(64) DEFAULT NULL COMMENT '品牌',
  `item_brand2` varchar(64) DEFAULT NULL COMMENT '品牌2',
  `addup_ratio` decimal(20,8) DEFAULT NULL COMMENT '提价比例',
  `alter_ratio` decimal(20,8) DEFAULT NULL COMMENT '其它调价比例',
  `alter_ratio2` decimal(20,8) DEFAULT NULL COMMENT '其它调价比例2',
  `alter_ratio3` decimal(20,8) DEFAULT NULL COMMENT '其它调价比例3',
  `valid_from` datetime DEFAULT NULL COMMENT '生效时间',
  `valid_to` datetime DEFAULT NULL COMMENT '失效时间',
  `policy_status` varchar(64) DEFAULT NULL COMMENT '价格状态',
  `from_bu_id` bigint(20) DEFAULT NULL COMMENT '从BUID',
  `to_bu_id` bigint(20) DEFAULT NULL COMMENT '到BUID',
  `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) DEFAULT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `create_user_id_index` (`create_user_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='实体间交易价格策略';

-- ----------------------------
-- Table structure for inv_lot
-- ----------------------------

CREATE TABLE `inv_lot` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '记录唯一ID',
  `ou_id` bigint(20) DEFAULT NULL COMMENT '公司ID',
  `bu_id` bigint(20) DEFAULT NULL COMMENT 'BUID',
  `item_id` bigint(20) DEFAULT NULL COMMENT '品项ID',
  `vari_id` bigint(20) DEFAULT NULL COMMENT '异构ID',
  `item_code` varchar(40) DEFAULT NULL COMMENT '品项编号',
  `lot_no` varchar(40) DEFAULT NULL COMMENT '批次号',
  `lot_desc` varchar(40) DEFAULT NULL COMMENT '批次说明',
  `lot_status` varchar(40) DEFAULT NULL COMMENT '批次状态 允许的出入库类型，0,可以出，1不可以出',
  `lot_status2` varchar(40) DEFAULT NULL COMMENT '批次状态2 备用',
  `lot_status3` varchar(40) DEFAULT NULL COMMENT '批次状态3 备用',
  `qc_status` varchar(40) DEFAULT NULL COMMENT '质量状态',
  `sin_status` varchar(40) DEFAULT NULL COMMENT '卫检状态',
  `lock_reason` varchar(40) DEFAULT NULL COMMENT '锁定原因',
  `sin_qty` float(20,8) DEFAULT NULL COMMENT '已卫检数量',
  `expire_days` int(11) DEFAULT NULL COMMENT '保质期天数',
  `manu_date` datetime(6) DEFAULT NULL COMMENT '生产日期',
  `menu_lot_no` varchar(40) DEFAULT NULL COMMENT '生产批次',
  `batch_no` varchar(40) DEFAULT NULL COMMENT '整批号',
  `expire_date` datetime(6) DEFAULT NULL COMMENT '失效日期',
  `until_expire_days` int(11) DEFAULT NULL COMMENT '剩余效期天数 每天自动计算',
  `fress_type` varchar(40) DEFAULT NULL COMMENT '新鲜度 每天自动计算。[UDC]COM:FRESS_TYPE',
  `first_in_date` datetime(6) DEFAULT NULL COMMENT '首次入库日期',
  `last_out_date` datetime(6) DEFAULT NULL COMMENT '最后出库日期',
  `max_sale_date` datetime(6) DEFAULT NULL COMMENT '销售截止日期',
  `menu_country` varchar(40) DEFAULT NULL COMMENT '原产国',
  `menu_desc` varchar(40) DEFAULT NULL COMMENT '产地描述',
  `menu_doc_no` varchar(40) DEFAULT NULL COMMENT '产地证明编号',
  `manuer_id` bigint(20) DEFAULT NULL COMMENT '制造商ID',
  `manuer_code` varchar(40) DEFAULT NULL COMMENT '制造商编号',
  `manuer_name` varchar(40) DEFAULT NULL COMMENT '制造商名称',
  `supp_id` bigint(20) DEFAULT NULL COMMENT '供应商ID',
  `sin_id` bigint(20) DEFAULT NULL COMMENT '默认卫检单ID',
  `sin_no` varchar(40) DEFAULT NULL COMMENT '默认卫检单编号',
  `sin_date` datetime(6) DEFAULT NULL COMMENT '卫检日期',
  `owner_type` varchar(40) DEFAULT NULL COMMENT '货主类型 供应商/客户，DCH不用',
  `owner_id` bigint(20) DEFAULT NULL COMMENT '货主ID DCH不用',
  `owner_code` varchar(40) DEFAULT NULL COMMENT '货主编码 DCH不用',
  `src_doc_cls` varchar(40) DEFAULT NULL COMMENT '来源单据类别',
  `src_doc_id` bigint(20) DEFAULT NULL COMMENT '来源单据ID',
  `src_doc_no` varchar(40) DEFAULT NULL COMMENT '来源单据编号',
  `src_doc_did` bigint(20) DEFAULT NULL COMMENT '来源单据明细ID',
  `po_id` bigint(20) DEFAULT NULL COMMENT '采购单ID',
  `po_no` varchar(40) DEFAULT NULL COMMENT '采购单号',
  `po_type` varchar(40) DEFAULT NULL COMMENT '采购单类型',
  `po_did` bigint(20) DEFAULT NULL COMMENT '采购单明细ID',
  `es1` varchar(40) DEFAULT NULL COMMENT 'ES1',
  `es2` varchar(40) DEFAULT NULL COMMENT 'ES2',
  `es3` varchar(40) DEFAULT NULL COMMENT 'ES3',
  `es4` varchar(40) DEFAULT NULL COMMENT 'ES4',
  `es5` varchar(40) DEFAULT NULL COMMENT 'ES5',
  `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) DEFAULT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `create_user_id_index` (`create_user_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='批次主档';

-- ----------------------------
-- Table structure for inv_stk
-- ----------------------------

CREATE TABLE `inv_stk` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '记录唯一ID',
  `ou_id` bigint(20) DEFAULT NULL COMMENT '公司ID',
  `bu_id` bigint(20) DEFAULT NULL COMMENT 'BUID',
  `item_id` bigint(20) DEFAULT NULL COMMENT '品项ID',
  `vari_id` bigint(20) DEFAULT NULL COMMENT '异构ID',
  `item_code` varchar(40) DEFAULT NULL COMMENT '品项编号',
  `wh_id` bigint(20) DEFAULT NULL COMMENT '仓库ID',
  `deter1` varchar(40) DEFAULT NULL COMMENT '温层 [UDC]INV:TEMP_TYPE',
  `deter2` varchar(40) DEFAULT NULL COMMENT '功能区 [UDC]INV:FUNC_TYPE',
  `deter3` varchar(40) DEFAULT NULL COMMENT '客户标识',
  `deter4` varchar(40) DEFAULT NULL COMMENT '限定4',
  `deter5` varchar(40) DEFAULT NULL COMMENT '限定5',
  `deter6` varchar(40) DEFAULT NULL COMMENT '限定6',
  `deter7` varchar(40) DEFAULT NULL COMMENT '限定7',
  `deter8` varchar(40) DEFAULT NULL COMMENT '限定8',
  `wh_loc` varchar(40) DEFAULT NULL COMMENT '库位',
  `wh_posi` varchar(40) DEFAULT NULL COMMENT '货位',
  `lot_no` varchar(40) DEFAULT NULL COMMENT '批次号',
  `sn_no` varchar(40) DEFAULT NULL COMMENT '序列号',
  `in_date` datetime(6) DEFAULT NULL COMMENT '入库日期',
  `until_expire_days` int(11) DEFAULT NULL COMMENT '剩余效期天数 每天自动计算',
  `fress_type` varchar(40) DEFAULT NULL COMMENT '新鲜度 每天自动计算。[UDC]COM:FRESS_TYPE',
  `uom` varchar(10) DEFAULT NULL COMMENT '单位',
  `uom2` varchar(10) DEFAULT NULL COMMENT '单位2',
  `uom_ratio` float(20,8) DEFAULT NULL COMMENT '单位转换率',
  `uom_ratio2` float(20,8) DEFAULT NULL COMMENT '单位转换率2',
  `oh_qty` float(20,8) DEFAULT NULL COMMENT '现有量',
  `oh_qty2` float(20,8) DEFAULT NULL COMMENT '现有量2',
  `rsv_qty` float(20,8) DEFAULT NULL COMMENT 'SO硬承诺量 SO已配货',
  `rsv_qty2` float(20,8) DEFAULT NULL COMMENT 'RO预留量 未配货的可用预留量',
  `rsv_qty3` float(20,8) DEFAULT NULL COMMENT '预留量3',
  `rsv_qty4` float(20,8) DEFAULT NULL COMMENT '预留量4',
  `lock_qty` float(20,8) DEFAULT NULL COMMENT '锁定量 因各种原因锁定的量，如低于成本时防止过量销售，或是调拨中，或是做为活动预留，或是因不良、损坏',
  `lock_qty2` float(20,8) DEFAULT NULL COMMENT '锁定量2',
  `lock_qty3` float(20,8) DEFAULT NULL COMMENT '锁定量3',
  `lock_qty4` float(20,8) DEFAULT NULL COMMENT '锁定量4',
  `ow_qty` float(20,8) DEFAULT NULL COMMENT '在途量',
  `ow_qty2` float(20,8) DEFAULT NULL COMMENT '在途量2',
  `ow_qty3` float(20,8) DEFAULT NULL COMMENT '在途量3',
  `ow_qty4` float(20,8) DEFAULT NULL COMMENT '在途量4',
  `aval_qty` float(20,8) DEFAULT NULL COMMENT '可用量 根据本行适用策略计算的速取数，策略如现有量-预留量-锁定量+在途量=可用量',
  `aval_qty2` float(20,8) DEFAULT NULL COMMENT '可用量2',
  `volume` float(20,8) DEFAULT NULL COMMENT '体积',
  `net_weight` float(20,8) DEFAULT NULL COMMENT '净重',
  `gross_weight` float(20,8) DEFAULT NULL COMMENT '毛重',
  `weight` float(20,8) DEFAULT NULL COMMENT '重量',
  `weight_uom_code` varchar(40) DEFAULT NULL COMMENT '重量单位',
  `weight_ratio` float(20,8) DEFAULT NULL COMMENT '重量转换率',
  `amt` float(20,2) DEFAULT NULL COMMENT '金额',
  `stk_desc` varchar(40) DEFAULT NULL COMMENT '库存描述',
  `stk_desc2` varchar(40) DEFAULT NULL COMMENT '库存描述2',
  `src_doc_cls` varchar(40) DEFAULT NULL COMMENT '来源单据类别',
  `src_doc_id` bigint(20) DEFAULT NULL COMMENT '来源单据ID',
  `src_doc_did` bigint(20) DEFAULT NULL COMMENT '来源单据明细ID',
  `src_doc_cls2` varchar(40) DEFAULT NULL COMMENT '来源单据类别2',
  `src_doc_id2` bigint(20) DEFAULT NULL COMMENT '来源单据ID2',
  `src_doc_did2` bigint(20) DEFAULT NULL COMMENT '来源单据明细ID',
  `es1` varchar(40) DEFAULT NULL COMMENT 'ES1',
  `es2` varchar(40) DEFAULT NULL COMMENT 'ES2',
  `es3` varchar(40) DEFAULT NULL COMMENT 'ES3',
  `es4` varchar(40) DEFAULT NULL COMMENT 'ES4',
  `es5` varchar(40) DEFAULT NULL COMMENT 'ES5',
  `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) DEFAULT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
  `p_code` varchar(40) DEFAULT NULL COMMENT '库存合作伙伴编码',
  `p_type` varchar(40) DEFAULT NULL COMMENT '库存合作伙伴类型',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `create_user_id_index` (`create_user_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='库存结存明细';

-- ----------------------------
-- Table structure for inv_wh
-- ----------------------------

CREATE TABLE `inv_wh` (
  `id` bigint(100) NOT NULL AUTO_INCREMENT COMMENT '记录唯一ID',
  `ou_id` bigint(20) DEFAULT '0' COMMENT '公司ID',
  `bu_id` bigint(20) DEFAULT '0' COMMENT 'BUID',
  `owner_addr_no` int(11) DEFAULT NULL COMMENT '所有者地址号 用于寄售库和VMI库，DCH不用',
  `wh_code` varchar(200) DEFAULT NULL COMMENT '仓库编号',
  `wh_name` varchar(40) DEFAULT NULL COMMENT '仓库名称',
  `wh_name2` varchar(40) DEFAULT NULL COMMENT '仓库名称2',
  `wh_abbr` varchar(40) DEFAULT NULL COMMENT '简称',
  `wh_type` varchar(40) DEFAULT NULL COMMENT '仓库类型 [UDC]INV:WH_TYPE',
  `wh_type2` varchar(40) DEFAULT NULL COMMENT '仓库类型2',
  `wh_type3` varchar(40) DEFAULT NULL COMMENT '仓库类型3',
  `wh_status` varchar(40) DEFAULT NULL COMMENT '仓库状态',
  `wh_status2` varchar(40) DEFAULT NULL COMMENT '仓库状态2',
  `thirdpl_flag` int(11) DEFAULT NULL COMMENT '是否3PL仓库',
  `physical_wh_code` varchar(40) DEFAULT NULL COMMENT '物理仓编号',
  `addr_no` bigint(20) DEFAULT NULL COMMENT '地址号 仓库本身的地址号',
  `address_id` bigint(20) DEFAULT '0' COMMENT '地址ID 仓库的物理地址，维护仓库的地址时根据规则回写。指向 addr_address.',
  `pid` bigint(20) DEFAULT '0' COMMENT '上级ID',
  `wh_path` varchar(200) DEFAULT NULL COMMENT '路径',
  `region` varchar(40) DEFAULT NULL COMMENT '区域',
  `es1` varchar(40) DEFAULT NULL COMMENT 'ES1',
  `es2` varchar(40) DEFAULT NULL COMMENT 'ES2',
  `es3` varchar(40) DEFAULT NULL COMMENT 'ES3',
  `es4` varchar(40) DEFAULT NULL COMMENT 'ES4',
  `es5` varchar(40) DEFAULT NULL COMMENT 'ES5',
  `es6` varchar(40) DEFAULT NULL COMMENT 'ES6',
  `es7` varchar(40) DEFAULT NULL COMMENT 'ES7',
  `es8` varchar(40) DEFAULT NULL COMMENT 'ES8',
  `es9` varchar(40) DEFAULT NULL COMMENT 'ES9',
  `es10` varchar(40) DEFAULT NULL COMMENT 'ES10',
  `ee1` varchar(40) DEFAULT NULL COMMENT '采购仓库/销售仓库',
  `ee2` varchar(40) DEFAULT NULL COMMENT '是否有WMS',
  `ee3` varchar(40) DEFAULT NULL COMMENT 'EE3',
  `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) DEFAULT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
  `business_code` varchar(40) DEFAULT NULL COMMENT '营业厅编码',
  `delivery` varchar(40) DEFAULT NULL COMMENT '配送方式',
  `delivery_area` varchar(40) DEFAULT NULL COMMENT '配送范围',
  `erp_code` varchar(40) DEFAULT NULL COMMENT 'erp仓库编码',
  `area` decimal(20,8) DEFAULT NULL COMMENT '仓库面积',
  `structure` varchar(40) DEFAULT NULL COMMENT '仓库结构',
  `plateform_flag` int(11) DEFAULT NULL COMMENT '是否装卸平台',
  `fixed_assets` varchar(40) DEFAULT NULL COMMENT '仓库固定资产',
  `file_code` varchar(255) DEFAULT NULL COMMENT '附件fileCode',
  `area_code` varchar(40) DEFAULT NULL COMMENT '库区编号',
  `area_name` varchar(40) DEFAULT NULL COMMENT '库区名称',
  `area_type` varchar(40) DEFAULT NULL COMMENT '库区类型',
  `area_status` varchar(40) DEFAULT NULL COMMENT '库区状态',
  `erp_name` varchar(40) DEFAULT NULL COMMENT 'erp仓库名称',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `create_user_id_index` (`create_user_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='仓库';

-- ----------------------------
-- Table structure for itfsrm_fact_s1
-- ----------------------------

CREATE TABLE `itfsrm_fact_s1` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '记录唯一ID',
  `yearmonth` varchar(6) DEFAULT NULL COMMENT '年月',
  `corp_code` varchar(20) DEFAULT NULL COMMENT 'jde公司编码',
  `vendor_code` int(11) DEFAULT NULL COMMENT 'jde客商编码',
  `format_code` varchar(12) DEFAULT NULL COMMENT '业态编码',
  `format_name` varchar(350) DEFAULT NULL COMMENT '业态名称',
  `sale_gp` decimal(20,4) DEFAULT NULL COMMENT '毛利',
  `sale_amt` decimal(20,4) DEFAULT NULL COMMENT '销售金额（不含税）',
  `sale_cost` decimal(20,4) DEFAULT NULL COMMENT '出库成本（出库数据）',
  `stock_cost` decimal(20,4) DEFAULT NULL COMMENT '库存成本（库存数据）',
  `stock_cost_zx90` decimal(20,4) DEFAULT NULL COMMENT '90天滞销库存金额（库存数据）',
  `stock_cost_zx180` decimal(20,4) DEFAULT NULL COMMENT '180天滞销库存金额（库存数据）',
  `create_date` date DEFAULT NULL COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_itfsrm_fact_s1_corp_code` (`corp_code`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='指标-数仓';

-- ----------------------------
-- Table structure for itfsrm_fact_s2
-- ----------------------------

CREATE TABLE `itfsrm_fact_s2` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '记录唯一ID',
  `corp_code` varchar(40) DEFAULT NULL COMMENT '公司编码',
  `vendor_code` int(11) DEFAULT NULL COMMENT '供应商编码',
  `order_qty` int(8) DEFAULT NULL COMMENT '交易次数',
  `purchase_amt` decimal(20,4) DEFAULT NULL COMMENT '交易金额',
  `yearmonth` date DEFAULT NULL COMMENT '年月',
  `create_date` date DEFAULT NULL COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_itfsrm_fact_s2_corp_code` (`corp_code`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='指标采购记录表';

-- ----------------------------
-- Table structure for org_bd
-- ----------------------------

CREATE TABLE `org_bd` (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `sec_bu_id` bigint(20) DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) DEFAULT NULL COMMENT 'sec_ou_id',
  `bd_code` varchar(40) DEFAULT NULL COMMENT '事业部编号',
  `bd_name` varchar(40) DEFAULT NULL COMMENT '事业部名称',
  `bd_name2` varchar(40) DEFAULT NULL COMMENT '事业部名称2',
  `bd_type` varchar(40) DEFAULT NULL COMMENT '事业部类型',
  `bd_status` varchar(40) DEFAULT NULL COMMENT '事业部状态 [UDC]COM:STATUS_ACTIVEORNO',
  `bu_id` bigint(20) DEFAULT NULL COMMENT 'BUID 不用',
  `tob_type` varchar(40) DEFAULT NULL COMMENT '业态 [UDC]ORG:TOB_TYPE',
  `pic_emp_id` bigint(20) DEFAULT NULL COMMENT '负责人员工ID',
  `bd_level` varchar(40) DEFAULT NULL COMMENT '层级 [UDC]ORG:BD_LEVEL',
  `pid` bigint(20) DEFAULT NULL COMMENT '上级ID',
  `bd_path` varchar(1000) DEFAULT NULL COMMENT '路径',
  `outer_code` varchar(40) DEFAULT NULL COMMENT '外部编码',
  `sort_num` int(10) DEFAULT NULL COMMENT '排序字段',
  `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `create_user_id_index` (`create_user_id`) USING BTREE,
  KEY `sec_bu_id_index` (`sec_bu_id`) USING BTREE,
  KEY `sec_user_id_index` (`sec_user_id`) USING BTREE,
  KEY `sec_ou_id_index` (`sec_ou_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='事业部';

-- ----------------------------
-- Table structure for org_cust
-- ----------------------------

CREATE TABLE `org_cust` (
  `id` bigint(20) NOT NULL DEFAULT '0' COMMENT '唯一编号ID',
  `ou_id` bigint(20) DEFAULT NULL COMMENT '公司ID',
  `bu_id` bigint(20) DEFAULT NULL COMMENT 'BUID',
  `cust_code` varchar(40) DEFAULT NULL COMMENT '客户编号',
  `cust_name` varchar(200) DEFAULT NULL COMMENT '客户名称',
  `cust_name2` varchar(200) DEFAULT NULL COMMENT '客户名称2',
  `cust_abbr` varchar(100) DEFAULT NULL COMMENT '客户简称',
  `cust_type` varchar(40) DEFAULT NULL COMMENT '客户类型 [UDC]ORG:CUST_TYPE',
  `cust_type2` varchar(40) DEFAULT NULL COMMENT '客户类型2 [UDC]ORG:CUST_TYPE2',
  `cust_type3` varchar(40) DEFAULT NULL COMMENT '客户类型3 [UDC]ORG:CUST_TYPE3',
  `cust_type4` varchar(40) DEFAULT NULL COMMENT '客户类型4',
  `cust_type5` varchar(40) DEFAULT NULL COMMENT '客户类型5',
  `cust_status` varchar(40) DEFAULT NULL COMMENT '客户状态 ORG:CUST_STATUS',
  `cust_status2` varchar(40) DEFAULT NULL COMMENT '客户状态2',
  `cust_status3` varchar(40) DEFAULT NULL COMMENT '客户状态3',
  `cust_group` varchar(40) DEFAULT NULL COMMENT '客户组别',
  `cust_group2` varchar(40) DEFAULT NULL COMMENT '客户组别2',
  `cust_group3` varchar(40) DEFAULT NULL COMMENT '客户组别3',
  `cust_group4` varchar(40) DEFAULT NULL COMMENT '客户组别4',
  `c1_code` varchar(40) DEFAULT NULL COMMENT '大类编号 使用COM_C1表',
  `c2_code` varchar(40) DEFAULT NULL COMMENT '中类编号 使用COM_C2表',
  `c3_code` varchar(40) DEFAULT NULL COMMENT '小类编号',
  `pid` bigint(20) DEFAULT NULL COMMENT '上级ID',
  `cust_path` varchar(500) DEFAULT NULL COMMENT '路径',
  `addr_no` int(11) DEFAULT NULL COMMENT '地址号',
  `pinyin` varchar(800) DEFAULT NULL COMMENT '拼音',
  `pinyin_sh` varchar(200) DEFAULT NULL COMMENT '拼音简称',
  `comp_capital` varchar(40) DEFAULT NULL COMMENT '资金能力',
  `agent_emp_id` bigint(20) DEFAULT NULL COMMENT '业务员员工ID',
  `pay_method` varchar(40) DEFAULT NULL COMMENT '付款方式',
  `cust_curr` varchar(40) DEFAULT NULL COMMENT '币种',
  `credit_level` varchar(40) DEFAULT NULL COMMENT '信贷级别 [UDC]COM:CREDIT_LEVEL',
  `credit_limit` decimal(20,2) DEFAULT NULL COMMENT '信用额度',
  `credit_bal` decimal(20,2) DEFAULT NULL COMMENT '信用余额',
  `credit_check_type` varchar(40) DEFAULT NULL COMMENT '信贷检查类型 [UDC]COM:CREDIT_CHECK_TYPE',
  `payment_term` varchar(40) DEFAULT NULL COMMENT '支付条款',
  `settle_type` varchar(40) DEFAULT NULL COMMENT '结算方式',
  `recon_period` varchar(40) DEFAULT NULL COMMENT '对账周期',
  `settle_monthly_day` int(11) DEFAULT NULL COMMENT '月结日期',
  `def_bu_id` bigint(20) DEFAULT NULL COMMENT '默认BUID',
  `def_wh_id` bigint(20) DEFAULT NULL COMMENT '默认仓库ID',
  `country` varchar(40) DEFAULT NULL COMMENT '国家',
  `postcode` varchar(40) DEFAULT NULL COMMENT '邮编',
  `region` varchar(40) DEFAULT NULL COMMENT '区域',
  `cust_level` varchar(40) DEFAULT NULL COMMENT '客户等级',
  `channel_type` varchar(40) DEFAULT NULL COMMENT '渠道类型 [UDC]COM:CHANNEL_TYPE',
  `channel_type2` varchar(40) DEFAULT NULL COMMENT '渠道类型2 [UDC]COM:CHANNEL_TYPE2',
  `ka_type` varchar(40) DEFAULT NULL COMMENT 'KA类型',
  `store_type` varchar(40) DEFAULT NULL COMMENT '门店类型',
  `vip_no` varchar(40) DEFAULT NULL COMMENT '会员号码',
  `vip_level` varchar(10) DEFAULT NULL COMMENT '会员级别',
  `vip_group` varchar(20) DEFAULT NULL COMMENT '会员组别',
  `cust_point_flag` int(11) DEFAULT NULL COMMENT '是否积分',
  `point` decimal(10,2) DEFAULT NULL COMMENT '积分余额',
  `cust_source` varchar(20) DEFAULT NULL COMMENT '客户来源',
  `valid_from` datetime DEFAULT NULL,
  `valid_to` datetime DEFAULT NULL,
  `tax_type` varchar(40) DEFAULT NULL COMMENT '税区',
  `tax_code` varchar(40) DEFAULT NULL COMMENT '税码',
  `taxpayer_type` varchar(40) DEFAULT NULL COMMENT '纳税人类型',
  `taxer_no` varchar(100) DEFAULT NULL COMMENT '税号',
  `inv_type` varchar(40) DEFAULT NULL COMMENT '发票类型 [UDC]COM:INV_TYPE',
  `inv_title` varchar(40) DEFAULT NULL COMMENT '开票抬头',
  `inv_address` varchar(200) DEFAULT NULL COMMENT '开票地址',
  `inv_pic_name` varchar(40) DEFAULT NULL COMMENT '开票联系人',
  `inv_pic_phone` varchar(40) DEFAULT NULL COMMENT '开票联系人电话',
  `inv_bank_name` varchar(40) DEFAULT NULL COMMENT '开票银行名称',
  `inv_bank_branch` varchar(40) DEFAULT NULL COMMENT '开票银行支行',
  `inv_bank_acc` varchar(40) DEFAULT NULL COMMENT '开票银行账号',
  `tax_rate_no` varchar(40) DEFAULT NULL COMMENT '税率编号',
  `tax_rate` decimal(20,8) DEFAULT NULL COMMENT '税率',
  `fin_gl_type` varchar(40) DEFAULT NULL COMMENT '总账类型 [UDC]ORG:CUST_GL_TYPE',
  `ic_register_no` varchar(40) DEFAULT NULL COMMENT '工商登记号',
  `register_date` datetime DEFAULT NULL,
  `register_address` varchar(200) DEFAULT NULL COMMENT '注册地址',
  `register_trademark_no` varchar(40) DEFAULT NULL COMMENT '注册商标编号',
  `register_fund` varchar(40) DEFAULT NULL COMMENT '注册资金',
  `register_fund_curry` varchar(40) DEFAULT NULL COMMENT '注册资金货币',
  `ic_issued` varchar(40) DEFAULT NULL COMMENT '工商登记注册机关',
  `ic_issued_date` datetime DEFAULT NULL,
  `biz_code_cert` varchar(40) DEFAULT NULL COMMENT '组织机构代码证',
  `biz_type` varchar(40) DEFAULT NULL COMMENT '机构类型',
  `biz_issued` varchar(40) DEFAULT NULL COMMENT '组织机构代码证颁发单位',
  `cert_no` varchar(40) DEFAULT NULL COMMENT '统一信用代码',
  `tax_reg_no` varchar(40) DEFAULT NULL COMMENT '税务登记证编号',
  `taxpayer_id` varchar(40) DEFAULT NULL COMMENT '纳税人识别号',
  `repr` varchar(40) DEFAULT NULL COMMENT '法人代表',
  `repr_cert_type` varchar(40) DEFAULT NULL COMMENT '法人证件类型',
  `repr_cert_no` varchar(40) DEFAULT NULL COMMENT '法人证件编号',
  `repr_cert_mobile` varchar(40) DEFAULT NULL COMMENT '法人手机号',
  `comp_name` varchar(40) DEFAULT NULL COMMENT '公司名称',
  `comp_prop` varchar(40) DEFAULT NULL COMMENT '公司性质',
  `comp_scale` varchar(40) DEFAULT NULL COMMENT '公司规模',
  `comp_bussaddr` varchar(40) DEFAULT NULL COMMENT '经营地点',
  `comp_mainbuss` varchar(40) DEFAULT NULL COMMENT '主营业务',
  `comp_bussrange` varchar(2000) DEFAULT NULL COMMENT '经营范围',
  `outer_code` varchar(40) DEFAULT NULL COMMENT '外部编码',
  `tags` varchar(200) DEFAULT NULL COMMENT '标签',
  `es1` varchar(40) DEFAULT NULL COMMENT 'ES1',
  `es2` varchar(40) DEFAULT NULL COMMENT 'ES2',
  `es3` varchar(40) DEFAULT NULL COMMENT 'ES3',
  `es4` varchar(40) DEFAULT NULL COMMENT 'ES4',
  `es5` varchar(40) DEFAULT NULL COMMENT 'ES5',
  `es6` varchar(40) DEFAULT NULL COMMENT 'ES6',
  `es7` varchar(40) DEFAULT NULL COMMENT 'ES7',
  `es8` varchar(40) DEFAULT NULL COMMENT 'ES8',
  `es9` varchar(40) DEFAULT NULL COMMENT 'ES9',
  `es10` varchar(40) DEFAULT NULL COMMENT 'ES10',
  `tenant_id` bigint(20) DEFAULT '0' COMMENT '租户ID',
  `remark` varchar(255) DEFAULT '' COMMENT '备注',
  `create_user_id` bigint(20) DEFAULT '0' COMMENT '记录创建者ID',
  `create_time` datetime DEFAULT NULL,
  `modify_user_id` bigint(20) DEFAULT '0' COMMENT '记录最后更新者ID',
  `modify_time` datetime DEFAULT NULL,
  `delete_flag` int(11) DEFAULT '0' COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) DEFAULT '0' COMMENT '版本信息，前端不用传',
  `pc_id` bigint(20) DEFAULT NULL,
  `inv_tel` varchar(40) DEFAULT NULL COMMENT '开票电话',
  `allow_over_aap` int(11) DEFAULT NULL COMMENT '允许超允收期',
  `tax_incl_flag` int(11) DEFAULT NULL COMMENT '是否含税',
  `max_lot_num` int(11) DEFAULT NULL COMMENT '允许最大批次数量',
  `allow_pp_inv` int(11) DEFAULT NULL COMMENT '允许卫检单后补',
  `intf_status` varchar(40) DEFAULT NULL COMMENT '接口状态',
  `intf_time` datetime DEFAULT NULL,
  `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
  `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
  `open_so_amt` decimal(20,2) DEFAULT NULL COMMENT '活动订单金额',
  `en1` float(20,2) DEFAULT NULL COMMENT '预留浮点数1',
  `en2` float(20,2) DEFAULT NULL COMMENT '预留浮点数2',
  `en3` float(20,2) DEFAULT NULL COMMENT '预留浮点数3',
  `en4` float(20,2) DEFAULT NULL COMMENT '预留浮点数4',
  `en5` float(20,2) DEFAULT NULL COMMENT '预留浮点数5',
  `co_flag` tinyint(1) DEFAULT '0' COMMENT '是否有退货合同 0：否；1：是',
  `point_balance` decimal(10,2) DEFAULT NULL COMMENT '积分余额',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `cust_code` (`cust_code`) USING BTREE,
  KEY `delete_flag` (`delete_flag`) USING BTREE,
  KEY `cust_name` (`cust_name`) USING BTREE,
  KEY `ou_id` (`ou_id`) USING BTREE,
  KEY `create_user_id_index` (`create_user_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='客户';

-- ----------------------------
-- Table structure for org_employee
-- ----------------------------

CREATE TABLE `org_employee` (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `emp_no` varchar(255) DEFAULT NULL COMMENT '雇员编号',
  `name` varchar(255) DEFAULT NULL COMMENT '雇员姓名',
  `foreign_name` varchar(255) DEFAULT NULL COMMENT '雇员外文名',
  `ou_id` bigint(20) DEFAULT NULL COMMENT '所属OU ID',
  `bu_id` bigint(20) DEFAULT NULL COMMENT '所属BU ID',
  `report_to_id` bigint(20) DEFAULT NULL COMMENT '汇报雇员记录ID',
  `report_to_path` varchar(255) DEFAULT NULL COMMENT '汇报ID路径',
  `post_id` bigint(20) DEFAULT NULL COMMENT '岗位记录ID',
  `title` varchar(255) DEFAULT NULL COMMENT '行政职位, [UDC]ORG:TITLE',
  `sys_user_id` bigint(20) DEFAULT NULL COMMENT '系统用户ID',
  `sys_user_name` varchar(255) DEFAULT NULL COMMENT '系统用户账号',
  `email` varchar(255) DEFAULT NULL COMMENT '工作邮箱',
  `mobile` varchar(255) DEFAULT NULL COMMENT '工作手机号',
  `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) DEFAULT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
  `enable_flag` varchar(255) DEFAULT NULL COMMENT '员工状态',
  `emp_type` varchar(255) DEFAULT NULL COMMENT '员工类型',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `create_user_id_index` (`create_user_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='雇员信息';

-- ----------------------------
-- Table structure for org_employee_tag_ref
-- ----------------------------

CREATE TABLE `org_employee_tag_ref` (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `employee_id` bigint(20) DEFAULT NULL COMMENT '雇员记录ID',
  `tag_name` varchar(255) DEFAULT NULL COMMENT '雇员标签名称',
  `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) DEFAULT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `create_user_id_index` (`create_user_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='雇员标签关系表';

-- ----------------------------
-- Table structure for org_empoyee_tag
-- ----------------------------

CREATE TABLE `org_empoyee_tag` (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `tag_name` varchar(255) DEFAULT NULL COMMENT '标签名称',
  `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) DEFAULT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `create_user_id_index` (`create_user_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='雇员标签表';

-- ----------------------------
-- Table structure for org_ou
-- ----------------------------

CREATE TABLE `org_ou` (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `sec_bu_id` bigint(20) DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) DEFAULT NULL COMMENT 'sec_ou_id',
  `code` varchar(255) DEFAULT NULL COMMENT '公司编号',
  `name` varchar(255) DEFAULT NULL COMMENT '公司名称',
  `name2` varchar(255) DEFAULT NULL COMMENT '公司名称2',
  `name3` varchar(255) DEFAULT NULL COMMENT '公司名称3',
  `name4` varchar(255) DEFAULT NULL COMMENT '公司名称4',
  `abbr` varchar(255) DEFAULT NULL COMMENT '公司简称',
  `abbr_alpha` varchar(255) DEFAULT NULL COMMENT '字母缩写',
  `type` varchar(255) DEFAULT NULL COMMENT '公司类型',
  `type2` varchar(255) DEFAULT NULL COMMENT '公司类型2',
  `type3` varchar(255) DEFAULT NULL COMMENT '公司类型3',
  `status` varchar(255) DEFAULT NULL COMMENT '公司状态 [UDC]COM:STATUS_ACTIVEORNO',
  `status2` varchar(255) DEFAULT NULL COMMENT '公司状态2',
  `status3` varchar(255) DEFAULT NULL COMMENT '公司状态3',
  `bu_id` bigint(20) DEFAULT NULL COMMENT '经营单位ID',
  `bu_id2` bigint(20) DEFAULT NULL COMMENT '经营单位ID2',
  `bu_id3` bigint(20) DEFAULT NULL COMMENT '经营单位ID3',
  `bu_id4` bigint(20) DEFAULT NULL COMMENT '经营单位ID4',
  `parent_id` bigint(20) DEFAULT NULL COMMENT '上级ID',
  `sort_no` int(11) DEFAULT NULL COMMENT '顺序号',
  `path` varchar(255) DEFAULT NULL COMMENT '关系路径',
  `std_curr` varchar(255) DEFAULT NULL COMMENT '本位币',
  `fin_cal_code` varchar(255) DEFAULT NULL COMMENT '财务日历编号',
  `addr_no` bigint(20) DEFAULT NULL COMMENT '地址号',
  `country` varchar(255) DEFAULT NULL COMMENT '国家 [UDC]COM:COUNTRY',
  `province` varchar(255) DEFAULT NULL COMMENT '省份 [UDC]COM:PROVINCE',
  `city` varchar(255) DEFAULT NULL COMMENT '城市',
  `region` varchar(255) DEFAULT NULL COMMENT '区域',
  `taxpayer_type` varchar(255) DEFAULT NULL COMMENT '纳税人类型',
  `biz_code_cert` varchar(255) DEFAULT NULL COMMENT '组织机构代码证号',
  `taxer_code` varchar(255) DEFAULT NULL COMMENT '纳税人识别号',
  `ic_register_no` varchar(255) DEFAULT NULL COMMENT '工商登记号',
  `tax_reg_no` varchar(255) DEFAULT NULL COMMENT '税务登记号',
  `uni_cert_no` varchar(255) DEFAULT NULL COMMENT '统一信用代码',
  `external_code` varchar(255) DEFAULT NULL COMMENT '外部编码',
  `es1` varchar(255) DEFAULT NULL COMMENT 'ES1',
  `es2` varchar(255) DEFAULT NULL COMMENT 'ES2',
  `es3` varchar(255) DEFAULT NULL COMMENT 'ES3',
  `es4` varchar(255) DEFAULT NULL COMMENT 'ES4',
  `es5` varchar(255) DEFAULT NULL COMMENT 'ES5',
  `es6` varchar(255) DEFAULT NULL COMMENT 'ES6',
  `es7` varchar(255) DEFAULT NULL COMMENT 'ES7',
  `es8` varchar(255) DEFAULT NULL COMMENT 'ES8',
  `es9` varchar(255) DEFAULT NULL COMMENT 'ES9',
  `es10` varchar(255) DEFAULT NULL COMMENT 'ES10',
  `ou_code` varchar(40) DEFAULT NULL COMMENT '公司编号',
  `ou_name` varchar(200) DEFAULT NULL COMMENT '公司名称',
  `ou_name2` varchar(200) DEFAULT NULL COMMENT '公司名称2',
  `ou_name3` varchar(200) DEFAULT NULL COMMENT '公司名称3',
  `ou_name4` varchar(40) DEFAULT NULL COMMENT '公司名称4',
  `ou_abbr` varchar(100) DEFAULT NULL COMMENT '公司简称',
  `ou_type` varchar(40) DEFAULT NULL COMMENT '公司类型',
  `ou_type2` varchar(40) DEFAULT NULL COMMENT '公司类型2',
  `ou_type3` varchar(40) DEFAULT NULL COMMENT '公司类型3',
  `ou_status` varchar(40) DEFAULT NULL COMMENT '公司状态 [UDC]COM:STATUS_ACTIVEORNO',
  `ou_status2` varchar(40) DEFAULT NULL COMMENT '公司状态2',
  `ou_status3` varchar(40) DEFAULT NULL COMMENT '公司状态3',
  `pid` bigint(18) DEFAULT NULL COMMENT '上级ID',
  `ou_path` varchar(1000) DEFAULT NULL COMMENT '路径',
  `ou_curr` varchar(10) DEFAULT NULL COMMENT '本位币',
  `cert_no` varchar(40) DEFAULT NULL COMMENT '统一信用代码',
  `outer_code` varchar(40) DEFAULT NULL COMMENT '外部编码',
  `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `create_user_id_index` (`create_user_id`) USING BTREE,
  KEY `sec_bu_id_index` (`sec_bu_id`) USING BTREE,
  KEY `sec_user_id_index` (`sec_user_id`) USING BTREE,
  KEY `sec_ou_id_index` (`sec_ou_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='公司';

-- ----------------------------
-- Table structure for org_post
-- ----------------------------

CREATE TABLE `org_post` (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `sec_bu_id` bigint(20) DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) DEFAULT NULL COMMENT 'sec_ou_id',
  `post_code` varchar(255) DEFAULT NULL COMMENT '岗位编码',
  `post_name` varchar(255) DEFAULT NULL COMMENT '岗位名称',
  `post_weight` int(11) DEFAULT NULL COMMENT '岗位权重',
  `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `create_user_id_index` (`create_user_id`) USING BTREE,
  KEY `sec_bu_id_index` (`sec_bu_id`) USING BTREE,
  KEY `sec_user_id_index` (`sec_user_id`) USING BTREE,
  KEY `sec_ou_id_index` (`sec_ou_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='岗位主信息';

-- ----------------------------
-- Table structure for org_profcenter
-- ----------------------------

CREATE TABLE `org_profcenter` (
  `id` bigint(20) NOT NULL DEFAULT '0' COMMENT '唯一编号ID',
  `pc_code` varchar(32) NOT NULL DEFAULT '' COMMENT '利润中心编号',
  `pc_name` varchar(64) NOT NULL DEFAULT '' COMMENT '利润中心名称',
  `pc_type` varchar(32) DEFAULT '' COMMENT '利润中心类型 [UDC]ORG:PC_TYPE',
  `pc_status` varchar(32) DEFAULT '' COMMENT '利润中心状态 [UDC]COM:STATUS_ACTIVEORNO',
  `profit_type` varchar(32) DEFAULT '' COMMENT '成本利润属性 [UDC]ORG:PROFIT_TYPE',
  `pic_emp_id` bigint(20) DEFAULT '0' COMMENT '负责人员工ID',
  `p_id` bigint(20) DEFAULT '0' COMMENT '上级ID',
  `pc_path` varchar(255) DEFAULT '' COMMENT '上下级路径',
  `bu_id` bigint(20) DEFAULT '0' COMMENT 'BU ID',
  `bd_id` bigint(20) DEFAULT '0' COMMENT '事业部ID',
  `outer_code` varchar(64) DEFAULT '' COMMENT '外部编码',
  `tenant_id` bigint(20) DEFAULT '0' COMMENT '租户ID',
  `remark` varchar(255) DEFAULT '' COMMENT '备注',
  `create_user_id` bigint(20) DEFAULT '0' COMMENT '记录创建者ID',
  `create_time` datetime DEFAULT NULL,
  `modify_user_id` bigint(20) DEFAULT '0' COMMENT '记录最后更新者ID',
  `modify_time` datetime DEFAULT NULL,
  `delete_flag` int(11) DEFAULT '0' COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) DEFAULT '0' COMMENT '版本信息，前端不用传',
  `pid` bigint(20) DEFAULT NULL COMMENT '上级ID',
  `only_cc_flag` int(11) DEFAULT NULL COMMENT '是否只是成本中心',
  `sort_num` int(11) DEFAULT NULL COMMENT '排序字段',
  `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
  `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `UK_hdsycw2voekrejgi6smfrxric` (`pc_code`) USING BTREE,
  KEY `pc_code` (`pc_code`) USING BTREE,
  KEY `create_user_id_index` (`create_user_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='利润中心';

-- ----------------------------
-- Table structure for pln_repl_d
-- ----------------------------

CREATE TABLE `pln_repl_d` (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `task_id` bigint(20) DEFAULT NULL COMMENT '计算任务ID',
  `item_id` bigint(20) DEFAULT NULL COMMENT '品项ID',
  `wh_id` bigint(20) DEFAULT NULL COMMENT '仓库ID',
  `calc_date` datetime DEFAULT NULL COMMENT '日期',
  `data_type` varchar(40) DEFAULT NULL COMMENT '数据类型 [UDC]PLN:REPL_DATA_TYPE',
  `data_val` float(20,8) DEFAULT NULL COMMENT '数据值',
  `relate_doc_cls` varchar(40) DEFAULT NULL COMMENT '关联单据类别 如RMA。[UDC]COM:DOC_CLS',
  `relate_doc_type` varchar(40) DEFAULT NULL COMMENT '关联单据类型',
  `relate_doc_id` bigint(20) DEFAULT NULL COMMENT '关联单据ID',
  `relate_doc_no` varchar(40) DEFAULT NULL COMMENT '关联单据编号',
  `relate_doc_did` int(11) DEFAULT NULL COMMENT '关联单据明细ID',
  `relate_doc_lineno` float(20,2) DEFAULT NULL COMMENT '关联单据行号',
  `relate_doc2_cls` varchar(40) DEFAULT NULL COMMENT '关联单据类别 如RMA。[UDC]COM:DOC_CLS',
  `relate_doc2_type` varchar(40) DEFAULT NULL COMMENT '关联单据类型',
  `relate_doc2_id` bigint(20) DEFAULT NULL COMMENT '关联单据ID',
  `relate_doc2_no` varchar(40) DEFAULT NULL COMMENT '关联单据编号',
  `relate_doc2_did` int(11) DEFAULT NULL COMMENT '关联单据明细ID',
  `relate_doc2_lineno` float(20,2) DEFAULT NULL COMMENT '关联单据行号',
  `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) DEFAULT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `create_user_id_index` (`create_user_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='净需求计算底稿';

-- ----------------------------
-- Table structure for pur_account_add
-- ----------------------------

CREATE TABLE `pur_account_add` (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `sec_bu_id` bigint(20) DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) DEFAULT NULL COMMENT 'sec_ou_id',
  `mas_id` bigint(20) DEFAULT NULL COMMENT '主表ID PUR_PA.ID',
  `line_no` float(20,2) DEFAULT NULL COMMENT '行号',
  `add_type` varchar(40) DEFAULT NULL COMMENT '费用类型 [UDC]PUR:PAY_ADD_TYPE',
  `prom_id` bigint(20) DEFAULT NULL COMMENT '促销ID',
  `prom_no` varchar(40) DEFAULT NULL COMMENT '促销编号',
  `tax_rate_no` varchar(40) DEFAULT NULL COMMENT '税率编号',
  `tax_amt` decimal(20,8) DEFAULT NULL COMMENT '税额',
  `add_curr_amt` decimal(20,8) DEFAULT NULL COMMENT '费用金额(含税)',
  `add_curr_net_amt` decimal(20,8) DEFAULT NULL COMMENT '费用金额(未税)',
  `curr_code` varchar(40) DEFAULT NULL COMMENT '币种',
  `pur_account_check_id` bigint(20) DEFAULT NULL COMMENT '采购结算对账单ID',
  `account_flag` tinyint(2) DEFAULT NULL COMMENT '是否生成采购结算对账单0:未生成,1:已生成',
  `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
  `fin1` varchar(40) DEFAULT NULL COMMENT 'ERP成功标识',
  `fin2` varchar(40) DEFAULT NULL COMMENT 'ERP凭证号',
  `fin3` datetime(6) DEFAULT NULL COMMENT 'ERP传输日期',
  `fin4` varchar(40) DEFAULT NULL COMMENT '传输ERP唯一标识码-成本结转业务',
  `cost_flag` tinyint(4) DEFAULT '0' COMMENT '成本扣款标记 0 货扣,1 成本扣',
  `cost_deduc_type` varchar(40) DEFAULT NULL COMMENT '成本扣款类型 [UDC]PUR:COST_DEDUC_TYPE',
  `add_amt` decimal(20,8) DEFAULT NULL COMMENT '费用本币金额(含税)',
  `add_net_amt` decimal(20,8) DEFAULT NULL COMMENT '费用本币金额(未税)',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `create_user_id_index` (`create_user_id`) USING BTREE,
  KEY `sec_bu_id_index` (`sec_bu_id`) USING BTREE,
  KEY `sec_user_id_index` (`sec_user_id`) USING BTREE,
  KEY `sec_ou_id_index` (`sec_ou_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='对账单额外费用';

-- ----------------------------
-- Table structure for pur_account_add2
-- ----------------------------

CREATE TABLE `pur_account_add2` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `sal_do_doc_no` varchar(40) DEFAULT NULL COMMENT '订单中心发（退）货单号',
  `sal_do_doc_time` datetime DEFAULT NULL COMMENT '订单中心发（退）货单创建时间',
  `status` varchar(1) DEFAULT NULL COMMENT '生成状态 0：生成失败，1：生成成功',
  `log` varchar(1) DEFAULT NULL COMMENT '日志信息',
  `sal_do_type` varchar(10) DEFAULT NULL COMMENT '源单据类型 [UDC]PUR:SAL_DO_TYPE',
  `tenant_id` bigint(20) DEFAULT NULL,
  `remark` varchar(255) DEFAULT NULL,
  `create_user_id` bigint(20) DEFAULT NULL,
  `creator` varchar(255) DEFAULT NULL,
  `create_time` datetime(6) DEFAULT NULL,
  `modify_user_id` bigint(20) DEFAULT NULL,
  `updater` varchar(255) DEFAULT NULL,
  `modify_time` datetime(6) DEFAULT NULL,
  `delete_flag` int(11) DEFAULT NULL,
  `audit_data_version` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `create_user_id_index` (`create_user_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='对账单表';

-- ----------------------------
-- Table structure for pur_account_check
-- ----------------------------

CREATE TABLE `pur_account_check` (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `sec_bu_id` bigint(20) DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) DEFAULT NULL COMMENT 'sec_ou_id',
  `ou_id` bigint(20) DEFAULT NULL COMMENT '公司ID',
  `org_id` bigint(20) DEFAULT NULL COMMENT '组织ID',
  `bu_id` bigint(20) DEFAULT NULL COMMENT '部门ID',
  `supp_id` bigint(20) DEFAULT NULL COMMENT '供应商ID',
  `doc_status` varchar(40) DEFAULT NULL COMMENT '状态',
  `appr_status` varchar(20) DEFAULT NULL COMMENT '审批状态',
  `doc_no` varchar(40) DEFAULT NULL COMMENT '单据编号',
  `pc_no` varchar(40) DEFAULT NULL COMMENT '合同编号',
  `account_type` varchar(40) DEFAULT NULL COMMENT '对账类型',
  `pay_period` varchar(40) DEFAULT NULL COMMENT '账期 付款账期，比如2018-3，表示 2018年3月份',
  `pay_from_date` datetime DEFAULT NULL COMMENT '对账开始日期 对账开始日期',
  `pay_to_date` datetime DEFAULT NULL COMMENT '对账结束日期 对账结束日期',
  `doc_date` datetime DEFAULT NULL COMMENT '单据日期',
  `check_stat` varchar(10) DEFAULT NULL COMMENT '对账差异状态 标识是否有差异',
  `bill_type` varchar(40) DEFAULT NULL COMMENT '票据种类',
  `pri_acc_amt` decimal(20,8) DEFAULT NULL COMMENT '期初货款余额',
  `term_acc_amt` decimal(20,8) DEFAULT NULL COMMENT '期末货款余额',
  `f_contact_person` varchar(40) DEFAULT NULL COMMENT '财务联系人',
  `f_contact_tel` varchar(40) DEFAULT NULL COMMENT '财务联系电话',
  `b_contact_person` varchar(40) DEFAULT NULL COMMENT '业务联系人',
  `b_contact_tel` varchar(40) DEFAULT NULL COMMENT '业务联系人电话',
  `inv_no` varchar(40) DEFAULT NULL COMMENT '发票号码（汇总形式发票）',
  `tax_rate` decimal(20,2) DEFAULT NULL COMMENT '税率',
  `fax` varchar(40) DEFAULT NULL COMMENT '传真',
  `curr_code` varchar(40) DEFAULT NULL COMMENT '供应商币种',
  `ou_curr_code` varchar(40) DEFAULT NULL COMMENT '公司币种',
  `payment_term` varchar(40) DEFAULT NULL COMMENT '付款条款',
  `email` varchar(40) DEFAULT NULL COMMENT 'EMAIL',
  `address` varchar(200) DEFAULT NULL COMMENT '地址',
  `diff_flag` varchar(1) DEFAULT NULL COMMENT '是否有差异 0：无差异，1：差异',
  `curr_rate` decimal(20,8) DEFAULT NULL COMMENT '汇率',
  `sum_amt` decimal(20,4) DEFAULT NULL COMMENT '本币开票总额含税',
  `sum_net_amt` decimal(18,4) DEFAULT NULL COMMENT '本币开票总额未税',
  `sum_curr_amt` decimal(20,4) DEFAULT NULL COMMENT '开票总额含税',
  `sum_curr_net_amt` decimal(18,4) DEFAULT NULL COMMENT '开票总额未税',
  `gr_sum_curr_amt` decimal(20,4) DEFAULT NULL COMMENT '入库含税总金额',
  `gr_sum_curr_net_amt` decimal(18,4) DEFAULT NULL COMMENT '入库未税总金额',
  `sum_tax_amt` decimal(18,4) DEFAULT NULL COMMENT '开票税额',
  `sum_extra_curr_amt` decimal(18,4) DEFAULT NULL COMMENT '成本扣含税',
  `intf_status` varchar(40) DEFAULT NULL COMMENT '接口状态',
  `int_time` datetime DEFAULT NULL COMMENT '传输时间',
  `third_pay_flag` tinyint(1) DEFAULT '1' COMMENT '是否第三方支付，1：是，0：否',
  `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
  `emp_id` bigint(20) DEFAULT NULL COMMENT '员工ID',
  `emp_code` varchar(40) DEFAULT NULL COMMENT '员工编码',
  `emp_name` varchar(40) DEFAULT NULL COMMENT '员工名称',
  `operator_id` bigint(20) DEFAULT NULL COMMENT '经办人ID',
  `operator_code` varchar(40) DEFAULT NULL COMMENT '经办人编码',
  `operator_name` varchar(40) DEFAULT NULL COMMENT '经办人名称',
  `proc_inst_id` varchar(255) DEFAULT NULL COMMENT '流程实例ID',
  `proc_inst_status` varchar(255) DEFAULT NULL COMMENT '流程实例状态',
  `submit_time` datetime(6) DEFAULT NULL COMMENT '提交时间',
  `approved_time` datetime(6) DEFAULT NULL COMMENT '审批通过时间',
  `recv_date_s` datetime DEFAULT NULL COMMENT '发货开始日期',
  `recv_date_e` datetime DEFAULT NULL COMMENT '发货结束日期',
  `home_curr` varchar(40) DEFAULT NULL COMMENT '公司币种',
  `amt` decimal(20,8) DEFAULT NULL COMMENT '含税总金额',
  `net_amt` decimal(20,8) DEFAULT NULL COMMENT '未税总金额',
  `tax_amt` decimal(20,8) DEFAULT NULL COMMENT '税额',
  `curr_amt` decimal(20,8) DEFAULT NULL COMMENT '外币含税金额',
  `curr_net_amt` decimal(20,8) DEFAULT NULL COMMENT '外币不含税金额',
  `agent_emp_id` bigint(20) DEFAULT NULL COMMENT '对账人员工id',
  `agent_user_id` bigint(20) DEFAULT NULL COMMENT '对账人用户id',
  `status` varchar(40) DEFAULT NULL COMMENT '状态',
  `parts_sum_curr_amt` decimal(20,8) DEFAULT NULL COMMENT '配额含税总金额',
  `parts_sum_curr_net_amt` decimal(18,8) DEFAULT NULL COMMENT '配额未税总金额',
  `sum_local_tax_amt` decimal(18,4) DEFAULT NULL COMMENT '本币开票税额',
  `sum_extra_curr_net_amt` decimal(18,8) DEFAULT NULL COMMENT '成本扣未税',
  `cargo_deduce_curr_amt` decimal(18,8) DEFAULT NULL COMMENT '货扣含税',
  `cargo_deduc_curr_net_amt` decimal(18,8) DEFAULT NULL COMMENT '货扣未税',
  `payable_sum_curr_amt` decimal(18,8) DEFAULT NULL COMMENT '应付总额含税',
  `payable_sum_curr_net_amt` decimal(18,8) DEFAULT NULL COMMENT '应付总额未税',
  `payable_sum_tax_amt` decimal(18,4) DEFAULT NULL COMMENT '应付税额',
  `payable_sum_amt` decimal(18,8) DEFAULT NULL COMMENT '本币应付总额含税',
  `payable_sum_net_amt` decimal(18,8) DEFAULT NULL COMMENT '本币应付总额未税',
  `payable_sum_local_tax_amt` decimal(18,4) DEFAULT NULL COMMENT '本币应付税额',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `create_user_id_index` (`create_user_id`) USING BTREE,
  KEY `sec_bu_id_index` (`sec_bu_id`) USING BTREE,
  KEY `sec_user_id_index` (`sec_user_id`) USING BTREE,
  KEY `sec_ou_id_index` (`sec_ou_id`) USING BTREE,
  KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='对账单表';

-- ----------------------------
-- Table structure for pur_account_check_d
-- ----------------------------

CREATE TABLE `pur_account_check_d` (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `sec_bu_id` bigint(20) DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) DEFAULT NULL COMMENT 'sec_ou_id',
  `mas_id` bigint(20) DEFAULT '0' COMMENT '主表ID',
  `bill_d_id` bigint(20) DEFAULT NULL COMMENT '业务单据明细ID',
  `bill_id` bigint(20) DEFAULT NULL COMMENT '业务单据ID',
  `line_no` decimal(20,3) DEFAULT NULL COMMENT '采购订单行号',
  `gr_line_no` decimal(20,3) DEFAULT NULL COMMENT '采购收货单行号',
  `tbl_line_no` decimal(20,3) DEFAULT NULL COMMENT '中间表行号',
  `bill_doc_type` varchar(40) DEFAULT NULL COMMENT '单据类型',
  `account_type` varchar(40) DEFAULT NULL COMMENT '对账类型',
  `doc_no` varchar(40) DEFAULT NULL COMMENT '单据编号',
  `po_no` varchar(40) DEFAULT NULL COMMENT '单据编号',
  `item_id` bigint(20) DEFAULT '0' COMMENT '品项ID',
  `qty` decimal(20,8) DEFAULT NULL COMMENT '收货数量',
  `uom` varchar(10) DEFAULT NULL COMMENT '单位',
  `qty2` decimal(20,8) DEFAULT NULL COMMENT '收货数量2',
  `uom2` varchar(10) DEFAULT NULL COMMENT '单位2',
  `tax_amt` decimal(20,8) DEFAULT NULL COMMENT '税额',
  `amt` decimal(20,8) DEFAULT NULL COMMENT '含税金额',
  `net_amt` decimal(20,8) DEFAULT NULL COMMENT '不含税金额',
  `curr_amt` decimal(20,8) DEFAULT NULL COMMENT '外币含税金额',
  `curr_net_amt` decimal(20,8) DEFAULT NULL COMMENT '外币不含税金额',
  `wh_id` bigint(20) DEFAULT '0' COMMENT '仓库ID',
  `recv_emp_id` bigint(20) DEFAULT '0' COMMENT '收货人员工ID',
  `recv_emp_name` varchar(40) DEFAULT NULL COMMENT '收货人员工名字',
  `recv_date` datetime DEFAULT NULL COMMENT '发货日期',
  `net_price` decimal(20,8) DEFAULT NULL COMMENT '不含税价格',
  `price` decimal(20,8) DEFAULT NULL COMMENT '含税单价',
  `pb_price` decimal(20,8) DEFAULT NULL COMMENT '价格本价格',
  `pb_curr` varchar(40) DEFAULT NULL COMMENT '价格本币种',
  `pb_uom` varchar(10) DEFAULT NULL COMMENT '价格本单位',
  `tax_code` varchar(40) DEFAULT NULL COMMENT '税码',
  `tax_rate_no` varchar(40) DEFAULT NULL COMMENT '税率编号',
  `tax_rate` decimal(20,8) DEFAULT NULL COMMENT '税率',
  `curr_net_price` decimal(20,8) DEFAULT NULL COMMENT '外币含不税单价',
  `curr_price` decimal(20,8) DEFAULT NULL COMMENT '外币含税单价',
  `home_curr` varchar(40) DEFAULT NULL COMMENT '本币币种',
  `curr_code` varchar(40) DEFAULT NULL COMMENT '币种',
  `curr_rate` decimal(20,8) DEFAULT NULL COMMENT '汇率',
  `pur_account_check_id` bigint(20) DEFAULT NULL COMMENT '采购结算对账单ID',
  `account_flag` tinyint(2) DEFAULT NULL COMMENT '是否生成采购结算对账单0:未生成,1:已生成',
  `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
  `relate_doc_cls` varchar(40) DEFAULT NULL COMMENT '关联单据类别 [UDC]COM:DOC_CLS',
  `so_doc_id` bigint(20) DEFAULT '0' COMMENT '销售订单单据ID',
  `so_doc_did` bigint(20) DEFAULT '0' COMMENT '销售订单单据明细ID',
  `so_doc_no` varchar(40) DEFAULT NULL COMMENT '销售订单单据编号',
  `so_doc_lineno` decimal(20,3) DEFAULT NULL COMMENT '销售订单来源单据行号',
  `parts_amt_use` decimal(20,8) DEFAULT '0.00000000' COMMENT '配额分配金额(含税)',
  `parts_net_amt_use` decimal(20,8) DEFAULT '0.00000000' COMMENT '配额分配金额(不含税)',
  `recv_addr` varchar(2000) DEFAULT NULL COMMENT '收货地址',
  `trans_type` varchar(10) DEFAULT NULL COMMENT '运输方式',
  `po_id` bigint(20) DEFAULT NULL COMMENT '采购订单ID',
  `parts_amt_local_use` decimal(20,8) DEFAULT '0.00000000' COMMENT '配额分配本币金额(含税)',
  `parts_net_amt_local_use` decimal(20,8) DEFAULT '0.00000000' COMMENT '配额分配本币金额(不含税)',
  `relate_doc_date` datetime DEFAULT NULL COMMENT '单据日期',
  `relate_doc_no` varchar(40) DEFAULT NULL COMMENT '收发货单编码',
  `relate_doc_lineno` decimal(20,3) DEFAULT NULL COMMENT '采购订单行号',
  `relate_doc_id` bigint(20) DEFAULT '0' COMMENT '关联单据ID',
  `relate_doc_did` bigint(20) DEFAULT '0' COMMENT '关联单据明细ID',
  `relate_doc2_cls` varchar(40) DEFAULT NULL COMMENT '关联单据类别2 ',
  `relate_doc2_no` varchar(40) DEFAULT NULL COMMENT '订/退单编码',
  `relate_doc2_id` bigint(20) DEFAULT '0' COMMENT '关联单据2ID',
  `relate_doc2_did` bigint(20) DEFAULT '0' COMMENT '关联单据明细2ID',
  `relate_doc2_lineno` decimal(20,3) DEFAULT NULL COMMENT '订/退单行号',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `create_user_id_index` (`create_user_id`) USING BTREE,
  KEY `sec_bu_id_index` (`sec_bu_id`) USING BTREE,
  KEY `sec_user_id_index` (`sec_user_id`) USING BTREE,
  KEY `sec_ou_id_index` (`sec_ou_id`) USING BTREE,
  KEY `pur_account_check_id` (`pur_account_check_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='对账明细表';

-- ----------------------------
-- Table structure for pur_account_deduc
-- ----------------------------

CREATE TABLE `pur_account_deduc` (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `sec_bu_id` bigint(20) DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) DEFAULT NULL COMMENT 'sec_ou_id',
  `mas_id` bigint(20) DEFAULT NULL COMMENT '主表ID PUR_PA.ID',
  `line_no` float(20,2) DEFAULT NULL COMMENT '行号',
  `deduc_type` varchar(40) DEFAULT NULL COMMENT '扣款类型 [UDC]PUR:PAY_DEDUC_TYPE',
  `prom_id` bigint(20) DEFAULT NULL COMMENT '促销ID',
  `prom_no` varchar(40) DEFAULT NULL COMMENT '促销编号',
  `tax_rate_no` varchar(40) DEFAULT NULL COMMENT '税率编号',
  `tax_amt` decimal(20,8) DEFAULT NULL COMMENT '税额',
  `deduc_curr_amt` decimal(20,8) DEFAULT NULL COMMENT '扣款金额(含税)',
  `deduc_curr_net_amt` decimal(20,8) DEFAULT NULL COMMENT '扣款金额(未税)',
  `curr_code` varchar(40) DEFAULT NULL COMMENT '币种',
  `pur_account_check_id` bigint(20) DEFAULT NULL COMMENT '采购结算对账单ID',
  `account_flag` tinyint(2) DEFAULT NULL COMMENT '是否生成采购结算对账单0:未生成,1:已生成',
  `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
  `fin1` varchar(40) DEFAULT NULL COMMENT 'ERP成功标识',
  `fin2` varchar(40) DEFAULT NULL COMMENT 'ERP凭证号',
  `fin3` datetime(6) DEFAULT NULL COMMENT 'ERP传输日期',
  `fin4` varchar(40) DEFAULT NULL COMMENT '传输ERP唯一标识码-成本结转业务',
  `cost_flag` tinyint(4) DEFAULT '0' COMMENT '成本扣款标记 0 货扣,1 成本扣',
  `cost_deduc_type` varchar(40) DEFAULT NULL COMMENT '成本扣款类型 [UDC]PUR:COST_DEDUC_TYPE',
  `deduc_amt` decimal(20,8) DEFAULT NULL COMMENT '扣款本币金额(含税)',
  `deduc_net_amt` decimal(20,8) DEFAULT NULL COMMENT '扣款本币金额(未税)',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `create_user_id_index` (`create_user_id`) USING BTREE,
  KEY `sec_bu_id_index` (`sec_bu_id`) USING BTREE,
  KEY `sec_user_id_index` (`sec_user_id`) USING BTREE,
  KEY `sec_ou_id_index` (`sec_ou_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='对账单扣款';

-- ----------------------------
-- Table structure for pur_account_pa
-- ----------------------------

CREATE TABLE `pur_account_pa` (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `sec_bu_id` bigint(20) DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) DEFAULT NULL COMMENT 'sec_ou_id',
  `ou_id` bigint(20) DEFAULT NULL COMMENT '公司ID',
  `bill_id` bigint(20) DEFAULT NULL COMMENT '预付款ID',
  `bu_id` bigint(20) DEFAULT NULL COMMENT 'BUID',
  `doc_no` varchar(40) DEFAULT NULL COMMENT '预付款申请编号',
  `po_code` varchar(40) DEFAULT NULL COMMENT '采购订单编号',
  `doc_type` varchar(10) DEFAULT NULL COMMENT '采购付款申请类型 [UDC]PUR:PA_TYPE',
  `buss_type` varchar(10) DEFAULT NULL COMMENT '采购场景业务类型 [UDC]PUR:BUSS_TYPE',
  `src_doc_cls` varchar(40) DEFAULT 'PUR' COMMENT '来源单据类别',
  `doc_status` varchar(40) DEFAULT NULL COMMENT '单据状态 [UDC]PUR:PA_STATUS',
  `doc_date` datetime DEFAULT NULL COMMENT '请款日期',
  `doc_emp_id` bigint(20) DEFAULT NULL COMMENT '请款人员工ID',
  `appr_proc_inst_id` varchar(40) DEFAULT NULL COMMENT '流程实例ID',
  `appr_create_user_id` bigint(20) DEFAULT '0' COMMENT '提审人ID',
  `appr_status` varchar(40) DEFAULT NULL COMMENT '审批状态 [UDC]COM:APPR_STATUS',
  `appr_time` datetime DEFAULT NULL COMMENT '审批时间',
  `appr_user_id` bigint(20) DEFAULT NULL COMMENT '审批人ID',
  `appr_comment` varchar(500) DEFAULT NULL COMMENT '审批意见',
  `apply_emp_id` bigint(20) DEFAULT NULL COMMENT '申请人员工ID',
  `apply_date` datetime DEFAULT NULL COMMENT '申请日期',
  `apply_desc` varchar(100) DEFAULT NULL COMMENT '申请描述',
  `payment_term` varchar(40) DEFAULT NULL COMMENT '支付条款 COM_PAYMENT_TERM',
  `supp_id` bigint(20) DEFAULT NULL COMMENT '供应商ID',
  `curr_code` varchar(40) DEFAULT NULL COMMENT '供应商币种',
  `ou_curr_code` varchar(40) DEFAULT NULL COMMENT '公司币种',
  `attachments_no` decimal(20,3) DEFAULT NULL COMMENT '附件张数',
  `curr_rate` decimal(20,8) DEFAULT NULL COMMENT '汇率',
  `total_curr_pa_amt` decimal(20,8) DEFAULT NULL COMMENT '预付总金额',
  `total_pa_amt` decimal(20,8) DEFAULT NULL COMMENT '预付总金额(本位币)',
  `total_deduc_amt` decimal(20,8) DEFAULT NULL COMMENT '额外费用总金额',
  `actual_pay_amt` decimal(20,8) DEFAULT NULL COMMENT '实际支付金额',
  `actual_pay_date` datetime DEFAULT NULL COMMENT '实际支付日期',
  `pay_flag` tinyint(1) DEFAULT '1' COMMENT '是否预付 1：是，0：否',
  `pay_method` varchar(40) DEFAULT NULL COMMENT '支付方式 [UDC]PUR:PAY_TYPE',
  `receipt_no` varchar(40) DEFAULT NULL COMMENT '银行回单号',
  `pay_emp_id` bigint(20) DEFAULT NULL COMMENT '支付员工ID',
  `cancel_time` datetime DEFAULT NULL COMMENT '取消时间',
  `es1` varchar(40) DEFAULT NULL COMMENT 'ES1',
  `es2` varchar(40) DEFAULT NULL COMMENT 'ES2',
  `es3` varchar(40) DEFAULT NULL COMMENT 'ES3',
  `es4` varchar(40) DEFAULT NULL COMMENT 'ES4',
  `es5` varchar(40) DEFAULT NULL COMMENT 'ES5',
  `beneficiary` varchar(100) DEFAULT NULL COMMENT '收款单位',
  `bank` varchar(40) DEFAULT NULL COMMENT '开户银行',
  `bank_account` varchar(40) DEFAULT NULL COMMENT '银行账号',
  `appr_type` varchar(10) DEFAULT NULL COMMENT '审批类型',
  `pur_account_check_id` bigint(20) DEFAULT NULL COMMENT '采购结算对账单ID',
  `account_flag` tinyint(2) DEFAULT NULL COMMENT '是否生成采购结算对账单0:未生成,1:已生成',
  `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
  `current_account_amt` decimal(20,8) DEFAULT NULL COMMENT '本次核销金额',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `create_user_id_index` (`create_user_id`) USING BTREE,
  KEY `sec_bu_id_index` (`sec_bu_id`) USING BTREE,
  KEY `sec_user_id_index` (`sec_user_id`) USING BTREE,
  KEY `sec_ou_id_index` (`sec_ou_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='对账单预付款单';

-- ----------------------------
-- Table structure for pur_addr_address
-- ----------------------------

CREATE TABLE `pur_addr_address` (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `cont_person` varchar(40) DEFAULT NULL COMMENT '业务联系人姓名',
  `mobile` varchar(40) DEFAULT NULL COMMENT '业务联系人手机',
  `tel` varchar(40) DEFAULT NULL COMMENT '公司电话(电话)',
  `fax` varchar(40) DEFAULT NULL COMMENT '传真',
  `email` varchar(40) DEFAULT NULL COMMENT '邮箱(电邮)',
  `country` varchar(40) DEFAULT NULL COMMENT '国家',
  `province` varchar(10) DEFAULT NULL COMMENT '省',
  `city` varchar(10) DEFAULT NULL COMMENT '市',
  `county` varchar(40) DEFAULT NULL COMMENT '区县',
  `street` varchar(100) DEFAULT NULL COMMENT '街道/乡镇',
  `detail_addr` varchar(100) DEFAULT NULL COMMENT '联系地址(详细地址)',
  `default_flag` tinyint(1) DEFAULT NULL COMMENT '是否默认：1是，0否',
  `address_type` varchar(40) DEFAULT NULL COMMENT '地址类型 [UDC]ORG:ADDRESS_TYPE',
  `zip_code` varchar(40) DEFAULT NULL COMMENT '邮编',
  `mas_id` bigint(20) DEFAULT '0' COMMENT '主表ID',
  `mas_doc_cls` varchar(40) DEFAULT NULL COMMENT '主表业务类型',
  `line_no` decimal(20,3) DEFAULT NULL COMMENT '行号',
  `mas_did` bigint(20) DEFAULT '0' COMMENT '申请单明细ID',
  `webaddress` varchar(40) DEFAULT NULL COMMENT '公司网站(网址)',
  `addr_no` bigint(20) DEFAULT NULL COMMENT '地址号',
  `addr_name` varchar(40) DEFAULT NULL COMMENT '地址名称',
  `address_type2` varchar(40) DEFAULT NULL COMMENT '地址类型2',
  `address_status` varchar(40) DEFAULT NULL COMMENT '地址状态',
  `mobile2` varchar(40) DEFAULT NULL COMMENT '手机2',
  `tel2` varchar(40) DEFAULT NULL COMMENT '电话2',
  `email2` varchar(40) DEFAULT NULL COMMENT '电邮2',
  `xlon` float(10,6) DEFAULT NULL COMMENT '经度',
  `ylat` float(10,6) DEFAULT NULL COMMENT '纬度',
  `coord_type` varchar(40) DEFAULT NULL COMMENT '经纬度标准',
  `weibo` varchar(40) DEFAULT NULL COMMENT '微博',
  `wechat_mp` varchar(40) DEFAULT NULL COMMENT '微信公众号',
  `other_info1` varchar(40) DEFAULT NULL COMMENT '其它联系信息1',
  `other_info2` varchar(40) DEFAULT NULL COMMENT '其它联系信息2',
  `other_info3` varchar(40) DEFAULT NULL COMMENT '其它联系信息3',
  `position` varchar(40) DEFAULT NULL COMMENT '职位',
  `pid` bigint(20) DEFAULT '0' COMMENT '上级联系人ID',
  `es1` varchar(40) DEFAULT NULL COMMENT 'ES1',
  `es2` varchar(40) DEFAULT NULL COMMENT 'ES2',
  `es3` varchar(40) DEFAULT NULL COMMENT 'ES3',
  `es4` varchar(40) DEFAULT NULL COMMENT 'ES4',
  `es5` varchar(40) DEFAULT NULL COMMENT 'ES5',
  `es6` varchar(40) DEFAULT NULL COMMENT 'ES6',
  `es7` varchar(40) DEFAULT NULL COMMENT 'ES7',
  `es8` varchar(40) DEFAULT NULL COMMENT 'ES8',
  `es9` varchar(40) DEFAULT NULL COMMENT 'ES9',
  `es10` varchar(40) DEFAULT NULL COMMENT 'ES10',
  `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
  `sec_bu_id` bigint(20) DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) DEFAULT NULL COMMENT 'sec_ou_id',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='供应商地址号的具体地址信息';

-- ----------------------------
-- Table structure for pur_addr_apply_address
-- ----------------------------

CREATE TABLE `pur_addr_apply_address` (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `sec_bu_id` bigint(20) DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) DEFAULT NULL COMMENT 'sec_ou_id',
  `cont_person` varchar(40) DEFAULT NULL COMMENT '业务联系人姓名',
  `mobile` varchar(40) DEFAULT NULL COMMENT '业务联系人手机',
  `tel` varchar(40) DEFAULT NULL COMMENT '公司电话(电话)',
  `fax` varchar(40) DEFAULT NULL COMMENT '传真',
  `email` varchar(40) DEFAULT NULL COMMENT '邮箱(电邮)',
  `country` varchar(40) DEFAULT NULL COMMENT '国家',
  `province` varchar(10) DEFAULT NULL COMMENT '省',
  `city` varchar(10) DEFAULT NULL COMMENT '市',
  `county` varchar(40) DEFAULT NULL COMMENT '区县',
  `street` varchar(100) DEFAULT NULL COMMENT '街道/乡镇',
  `detail_addr` varchar(100) DEFAULT NULL COMMENT '联系地址(详细地址)',
  `default_flag` tinyint(1) DEFAULT NULL COMMENT '是否默认：1是，0否',
  `address_type` varchar(40) DEFAULT NULL COMMENT '地址类型 [UDC]ORG:ADDRESS_TYPE',
  `zip_code` varchar(40) DEFAULT NULL COMMENT '邮编',
  `mas_id` bigint(20) DEFAULT '0' COMMENT '主表ID',
  `mas_doc_cls` varchar(40) DEFAULT NULL COMMENT '主表业务类型',
  `line_no` decimal(20,3) DEFAULT NULL COMMENT '行号',
  `mas_did` bigint(20) DEFAULT '0' COMMENT '申请单明细ID',
  `webaddress` varchar(40) DEFAULT NULL COMMENT '公司网站(网址)',
  `addr_no` bigint(20) DEFAULT NULL COMMENT '地址号',
  `addr_name` varchar(40) DEFAULT NULL COMMENT '地址名称',
  `address_type2` varchar(40) DEFAULT NULL COMMENT '地址类型2',
  `address_status` varchar(40) DEFAULT NULL COMMENT '地址状态',
  `mobile2` varchar(40) DEFAULT NULL COMMENT '手机2',
  `tel2` varchar(40) DEFAULT NULL COMMENT '电话2',
  `email2` varchar(40) DEFAULT NULL COMMENT '电邮2',
  `xlon` float(10,6) DEFAULT NULL COMMENT '经度',
  `ylat` float(10,6) DEFAULT NULL COMMENT '纬度',
  `coord_type` varchar(40) DEFAULT NULL COMMENT '经纬度标准',
  `weibo` varchar(40) DEFAULT NULL COMMENT '微博',
  `wechat_mp` varchar(40) DEFAULT NULL COMMENT '微信公众号',
  `other_info1` varchar(40) DEFAULT NULL COMMENT '其它联系信息1',
  `other_info2` varchar(40) DEFAULT NULL COMMENT '其它联系信息2',
  `other_info3` varchar(40) DEFAULT NULL COMMENT '其它联系信息3',
  `position` varchar(40) DEFAULT NULL COMMENT '职位',
  `pid` bigint(20) DEFAULT '0' COMMENT '上级联系人ID',
  `es1` varchar(40) DEFAULT NULL COMMENT 'ES1',
  `es2` varchar(40) DEFAULT NULL COMMENT 'ES2',
  `es3` varchar(40) DEFAULT NULL COMMENT 'ES3',
  `es4` varchar(40) DEFAULT NULL COMMENT 'ES4',
  `es5` varchar(40) DEFAULT NULL COMMENT 'ES5',
  `es6` varchar(40) DEFAULT NULL COMMENT 'ES6',
  `es7` varchar(40) DEFAULT NULL COMMENT 'ES7',
  `es8` varchar(40) DEFAULT NULL COMMENT 'ES8',
  `es9` varchar(40) DEFAULT NULL COMMENT 'ES9',
  `es10` varchar(40) DEFAULT NULL COMMENT 'ES10',
  `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `create_user_id_index` (`create_user_id`) USING BTREE,
  KEY `sec_bu_id_index` (`sec_bu_id`) USING BTREE,
  KEY `sec_user_id_index` (`sec_user_id`) USING BTREE,
  KEY `sec_ou_id_index` (`sec_ou_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='地址号申请的具体地址信息';

-- ----------------------------
-- Table structure for pur_addr_apply_bank_acc
-- ----------------------------

CREATE TABLE `pur_addr_apply_bank_acc` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '唯一编号ID',
  `mas_id` bigint(20) DEFAULT '0' COMMENT '主表ID',
  `mas_did` bigint(20) DEFAULT '0' COMMENT '申请单明细ID',
  `addr_no` int(11) DEFAULT NULL COMMENT '地址号',
  `thirdparty_virtual_acc` varchar(255) DEFAULT NULL COMMENT '银行账户绑定流水号',
  `thirdparty_virtual_user_id` varchar(255) DEFAULT NULL COMMENT '用户ID',
  `line_no` decimal(20,3) DEFAULT NULL COMMENT '行号',
  `acc_type` varchar(40) DEFAULT NULL COMMENT '账号类型 收款/付款/收付款/保证金',
  `default_flag` int(11) DEFAULT NULL COMMENT '是否默认',
  `acc_no` varchar(40) DEFAULT NULL COMMENT '账号代码',
  `bank_id` bigint(20) DEFAULT '0' COMMENT '银行ID',
  `bank_code` varchar(40) DEFAULT NULL COMMENT '开户行代码',
  `bank_name` varchar(40) DEFAULT NULL COMMENT '开户行名称',
  `branch_name` varchar(40) DEFAULT NULL COMMENT '网点名称',
  `bank_acc` varchar(100) DEFAULT NULL COMMENT '开户行账号',
  `holder_name` varchar(40) DEFAULT NULL COMMENT '开户姓名',
  `curr_code` varchar(40) DEFAULT NULL COMMENT '币种',
  `acc_code` varchar(40) DEFAULT NULL COMMENT '总账级',
  `mas_doc_cls` varchar(40) DEFAULT NULL COMMENT '主表业务类型',
  `tenant_id` bigint(20) DEFAULT '0' COMMENT '租户ID',
  `remark` varchar(255) DEFAULT '' COMMENT '备注',
  `create_user_id` bigint(20) DEFAULT '0' COMMENT '记录创建者ID',
  `create_time` datetime DEFAULT NULL,
  `modify_user_id` bigint(20) DEFAULT '0' COMMENT '记录最后更新者ID',
  `modify_time` datetime DEFAULT NULL,
  `delete_flag` int(11) DEFAULT '0' COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) DEFAULT '0' COMMENT '版本信息，前端不用传',
  `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
  `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
  `supp_bank` varchar(40) DEFAULT NULL COMMENT '开户银行',
  `bank_branch` varchar(40) DEFAULT NULL COMMENT '开户支行',
  `bank_account` varchar(100) DEFAULT NULL COMMENT '银行账户',
  `payment_term` varchar(40) DEFAULT NULL COMMENT '付款条款',
  `pay_method` varchar(40) DEFAULT NULL COMMENT '付款方式',
  `inv_type` varchar(40) DEFAULT NULL COMMENT '默认发票类型',
  `tax_rate` varchar(40) DEFAULT NULL COMMENT '默认税率',
  `tax_payer_type` varchar(40) DEFAULT NULL COMMENT '纳税人类型',
  `tax_rate_no` varchar(40) DEFAULT NULL COMMENT '税率编号',
  `sec_bu_id` bigint(20) DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) DEFAULT NULL COMMENT 'sec_ou_id',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `create_user_id_index` (`create_user_id`) USING BTREE,
  KEY `sec_bu_id_index` (`sec_bu_id`) USING BTREE,
  KEY `sec_user_id_index` (`sec_user_id`) USING BTREE,
  KEY `sec_ou_id_index` (`sec_ou_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=553947573925449954 DEFAULT CHARSET=utf8mb4 COMMENT='地址号申请的银行账号';

-- ----------------------------
-- Table structure for pur_addr_apply_qualify
-- ----------------------------

CREATE TABLE `pur_addr_apply_qualify` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '唯一编号ID',
  `mas_id` bigint(20) DEFAULT '0' COMMENT '主表ID',
  `mas_did` bigint(20) DEFAULT '0' COMMENT '申请单明细ID',
  `addr_no` int(11) DEFAULT NULL COMMENT '地址号',
  `ou_id` bigint(20) DEFAULT '0' COMMENT '公司ID',
  `line_no` decimal(20,3) DEFAULT NULL COMMENT '行号',
  `qualify_type` varchar(40) DEFAULT NULL COMMENT '资质类型 [UDC]ORG:QUALIFY_TYPE',
  `qualify_name` varchar(40) DEFAULT NULL COMMENT '资质名称',
  `qualify_no` varchar(40) DEFAULT NULL COMMENT '资质文件编号',
  `qualify_address` varchar(200) DEFAULT NULL COMMENT '资质文件地址',
  `valid_from` datetime DEFAULT NULL,
  `valid_to` datetime DEFAULT NULL,
  `next_check_date` datetime DEFAULT NULL,
  `longterm_flag` int(11) DEFAULT NULL COMMENT '是否长期有效',
  `qualify_status` varchar(40) DEFAULT NULL COMMENT '资质证照状态',
  `qualify_status2` varchar(40) DEFAULT NULL COMMENT '资质证照状态2',
  `qualify_owner` varchar(40) DEFAULT NULL COMMENT '证照所有者',
  `related_item_id` varchar(1000) DEFAULT NULL COMMENT '关联物料ID 多ID用‘,’分割',
  `related_id1` bigint(20) DEFAULT '0' COMMENT '关联其它ID 首营ID',
  `related_id2` bigint(20) DEFAULT '0' COMMENT '关联其它ID2',
  `es1` varchar(2000) DEFAULT NULL COMMENT '扩展信息1 如I类经营范围',
  `es2` varchar(2000) DEFAULT NULL COMMENT '扩展信息2',
  `es3` varchar(2000) DEFAULT NULL COMMENT '扩展信息3',
  `es4` varchar(40) DEFAULT NULL COMMENT 'ES4',
  `es5` varchar(40) DEFAULT NULL COMMENT 'ES5',
  `es6` varchar(40) DEFAULT NULL COMMENT 'ES6',
  `es7` varchar(40) DEFAULT NULL COMMENT 'ES7',
  `es8` varchar(40) DEFAULT NULL COMMENT 'ES8',
  `es9` varchar(40) DEFAULT NULL COMMENT 'ES9',
  `es10` varchar(40) DEFAULT NULL COMMENT 'ES10',
  `mas_doc_cls` varchar(40) DEFAULT NULL COMMENT '主表业务类型',
  `tenant_id` bigint(20) DEFAULT '0' COMMENT '租户ID',
  `remark` varchar(255) DEFAULT '' COMMENT '备注',
  `create_user_id` bigint(20) DEFAULT '0' COMMENT '记录创建者ID',
  `create_time` datetime DEFAULT NULL,
  `modify_user_id` bigint(20) DEFAULT '0' COMMENT '记录最后更新者ID',
  `modify_time` datetime DEFAULT NULL,
  `delete_flag` int(11) DEFAULT '0' COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) DEFAULT '0' COMMENT '版本信息，前端不用传',
  `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
  `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
  `qualify_file_id` bigint(20) DEFAULT NULL COMMENT '资质文件ID',
  `qualify_file_name` varchar(200) DEFAULT NULL COMMENT '资质文件名称',
  `qualify_file_code` varchar(200) DEFAULT NULL COMMENT '资质文件编号(上传后系统生成的编号)',
  `sec_bu_id` bigint(20) DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) DEFAULT NULL COMMENT 'sec_ou_id',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `create_user_id_index` (`create_user_id`) USING BTREE,
  KEY `sec_bu_id_index` (`sec_bu_id`) USING BTREE,
  KEY `sec_user_id_index` (`sec_user_id`) USING BTREE,
  KEY `sec_ou_id_index` (`sec_ou_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=553947573925449955 DEFAULT CHARSET=utf8mb4 COMMENT='地址号申请的资质信息';

-- ----------------------------
-- Table structure for pur_addr_bank_acc
-- ----------------------------

CREATE TABLE `pur_addr_bank_acc` (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `acc_type` varchar(40) DEFAULT NULL COMMENT '账号类型:[UDC]ORG:ADDR_BANKACC_TYPE',
  `default_flag` tinyint(1) DEFAULT NULL COMMENT '是否默认：1是，0否',
  `bank_id` bigint(20) DEFAULT '0' COMMENT '银行ID',
  `bank_code` varchar(40) DEFAULT NULL COMMENT '开户行代码',
  `bank_name` varchar(40) DEFAULT NULL COMMENT '开户行名称',
  `branch_name` varchar(40) DEFAULT NULL COMMENT '网点名称',
  `bank_acc` varchar(100) DEFAULT NULL COMMENT '开户行账号',
  `holder_name` varchar(40) DEFAULT NULL COMMENT '开户姓名',
  `curr_code` varchar(40) DEFAULT NULL COMMENT '币种',
  `mas_id` bigint(20) DEFAULT '0' COMMENT '主表ID',
  `mas_doc_cls` varchar(40) DEFAULT NULL COMMENT '主表业务类型',
  `line_no` decimal(20,3) DEFAULT NULL COMMENT '行号',
  `supp_bank` varchar(40) DEFAULT NULL COMMENT '开户银行',
  `bank_branch` varchar(40) DEFAULT NULL COMMENT '开户支行',
  `bank_account` varchar(100) DEFAULT NULL COMMENT '银行账户',
  `payment_term` varchar(40) DEFAULT NULL COMMENT '付款条款 [UDC]ORG:PAYMENT_TERM',
  `pay_method` varchar(40) DEFAULT NULL COMMENT '付款方式 [UDC]PUR:PAY_TYPE',
  `inv_type` varchar(40) DEFAULT NULL COMMENT '默认发票类型 [UDC]COM:INV_TYPE',
  `tax_rate_no` varchar(40) DEFAULT NULL COMMENT '税率编号',
  `tax_payer_type` varchar(40) DEFAULT NULL COMMENT '纳税人类型 [UDC]ORG:PAYER_TYPE',
  `mas_did` bigint(20) DEFAULT '0' COMMENT '申请单明细ID',
  `addr_no` bigint(20) DEFAULT NULL COMMENT '地址号',
  `acc_no` varchar(40) DEFAULT NULL COMMENT '账号代码',
  `acc_code` varchar(40) DEFAULT NULL COMMENT '总账级',
  `thirdparty_virtual_user_id` varchar(255) DEFAULT NULL COMMENT '用户ID',
  `thirdparty_virtual_acc` varchar(255) DEFAULT NULL COMMENT '银行账户绑定流水号',
  `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
  `sec_bu_id` bigint(20) DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) DEFAULT NULL COMMENT 'sec_ou_id',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='供应商地址号的银行账号';

-- ----------------------------
-- Table structure for pur_addr_qualify
-- ----------------------------

CREATE TABLE `pur_addr_qualify` (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `qualify_no` varchar(40) DEFAULT NULL COMMENT '证照(资质文件)编号',
  `qualify_name` varchar(40) DEFAULT NULL COMMENT '证照(资质)名称',
  `qualify_type` varchar(40) DEFAULT NULL COMMENT '证照(资质)类型 :[UDC]ORG:ADDR_QUALIFY_TYPE',
  `qualify_status` varchar(40) DEFAULT NULL COMMENT '资质证照状态 :[UDC]COM:STATUS_ACTIVEORNO',
  `valid_from` datetime DEFAULT NULL COMMENT '生效时间',
  `valid_to` datetime DEFAULT NULL COMMENT '失效时间',
  `qualify_address` varchar(200) DEFAULT NULL COMMENT '附件(资质文件)地址',
  `qualify_file_id` bigint(20) DEFAULT NULL COMMENT '资质文件ID',
  `qualify_file_name` varchar(200) DEFAULT NULL COMMENT '资质文件名称',
  `qualify_file_code` varchar(200) DEFAULT NULL COMMENT '资质文件编号(上传后系统生成的编号)',
  `mas_id` bigint(20) DEFAULT '0' COMMENT '主表ID',
  `line_no` decimal(20,3) DEFAULT NULL COMMENT '行号',
  `mas_doc_cls` varchar(40) DEFAULT NULL COMMENT '主表业务类型',
  `mas_did` bigint(20) DEFAULT '0' COMMENT '申请单明细ID',
  `addr_no` bigint(20) DEFAULT NULL COMMENT '地址号',
  `ou_id` bigint(20) DEFAULT '0' COMMENT '公司ID',
  `next_check_date` datetime DEFAULT NULL COMMENT '下次检验日期',
  `longterm_flag` int(18) DEFAULT NULL COMMENT '是否长期有效',
  `qualify_status2` varchar(40) DEFAULT NULL COMMENT '资质证照状态2',
  `qualify_owner` varchar(40) DEFAULT NULL COMMENT '证照所有者',
  `related_item_id` varchar(1000) DEFAULT NULL COMMENT '关联物料ID 多ID用‘,’分割',
  `related_id1` bigint(20) DEFAULT '0' COMMENT '关联其它ID 首营ID',
  `related_id2` bigint(20) DEFAULT '0' COMMENT '关联其它ID2',
  `es1` varchar(2000) DEFAULT NULL COMMENT '扩展信息1 如I类经营范围',
  `es2` varchar(2000) DEFAULT NULL COMMENT '扩展信息2',
  `es3` varchar(2000) DEFAULT NULL COMMENT '扩展信息3',
  `es4` varchar(40) DEFAULT NULL COMMENT 'ES4',
  `es5` varchar(40) DEFAULT NULL COMMENT 'ES5',
  `es6` varchar(40) DEFAULT NULL COMMENT 'ES6',
  `es7` varchar(40) DEFAULT NULL COMMENT 'ES7',
  `es8` varchar(40) DEFAULT NULL COMMENT 'ES8',
  `es9` varchar(40) DEFAULT NULL COMMENT 'ES9',
  `es10` varchar(40) DEFAULT NULL COMMENT 'ES10',
  `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
  `sec_bu_id` bigint(20) DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) DEFAULT NULL COMMENT 'sec_ou_id',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='供应商地址号的资质信息';

-- ----------------------------
-- Table structure for pur_app
-- ----------------------------

CREATE TABLE `pur_app` (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `sec_bu_id` bigint(20) DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) DEFAULT NULL COMMENT 'sec_ou_id',
  `ou_id` bigint(20) DEFAULT NULL COMMENT '公司ID',
  `bu_id` bigint(20) DEFAULT NULL COMMENT 'BUID',
  `addr_no` int(18) DEFAULT NULL COMMENT '对方地址号',
  `cust_id` bigint(20) DEFAULT NULL COMMENT '客户ID',
  `supp_id` bigint(20) DEFAULT NULL COMMENT '供应商ID',
  `aap_no` varchar(40) DEFAULT NULL COMMENT '允收期编号',
  `aap_type` varchar(40) DEFAULT NULL COMMENT '允收期方式 [UOM]INV:MOQ_TYPE',
  `aap_type2` varchar(40) DEFAULT NULL COMMENT '允收期类型 [UOM]ITM:AAP_TYPE',
  `item_id` bigint(20) DEFAULT NULL COMMENT '品项ID',
  `period_from` int(18) DEFAULT NULL COMMENT '期间开始',
  `period_to` int(18) DEFAULT NULL COMMENT '期间结束',
  `period_type` varchar(40) DEFAULT NULL COMMENT '期间类型',
  `brand` varchar(40) DEFAULT NULL COMMENT '品牌',
  `brand2` varchar(40) DEFAULT NULL COMMENT '品牌2',
  `aap_ratio` double(20,8) DEFAULT NULL COMMENT '允收比例',
  `guarantee_days` int(18) DEFAULT NULL COMMENT '保质期天数',
  `aap_date_type` varchar(40) DEFAULT NULL COMMENT '基准日期类型 [UOM]ITM:AAP_DATE_TYPE',
  `valid_from` datetime DEFAULT NULL COMMENT '生效时间',
  `valid_to` datetime DEFAULT NULL COMMENT '失效时间',
  `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
  `aap_days` int(18) DEFAULT NULL COMMENT '允收天数',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `create_user_id_index` (`create_user_id`) USING BTREE,
  KEY `sec_bu_id_index` (`sec_bu_id`) USING BTREE,
  KEY `sec_user_id_index` (`sec_user_id`) USING BTREE,
  KEY `sec_ou_id_index` (`sec_ou_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='品项允收期';

-- ----------------------------
-- Table structure for pur_cp_apply
-- ----------------------------

CREATE TABLE `pur_cp_apply` (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `ou_id` bigint(20) DEFAULT '0' COMMENT '公司ID',
  `bu_id` bigint(20) DEFAULT '0' COMMENT 'BUID',
  `supp_id` bigint(20) DEFAULT '0' COMMENT '供应商ID',
  `supp_code` varchar(40) DEFAULT NULL COMMENT '供应商编号',
  `doc_no` varchar(40) DEFAULT NULL COMMENT '单据编号',
  `doc_status` varchar(40) DEFAULT NULL COMMENT '单据状态 [UDC]',
  `doc_time` datetime DEFAULT NULL COMMENT '申请时间',
  `complete_date` datetime DEFAULT NULL COMMENT '完工时间',
  `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
  `sec_bu_id` bigint(20) DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) DEFAULT NULL COMMENT 'sec_ou_id',
  `proc_inst_id` varchar(255) DEFAULT NULL COMMENT '流程实例ID',
  `proc_inst_status` varchar(255) DEFAULT NULL COMMENT '流程实例状态',
  `submit_time` datetime(6) DEFAULT NULL COMMENT '提交时间',
  `approved_time` datetime(6) DEFAULT NULL COMMENT '审批通过时间',
  `file_code` varchar(2000) DEFAULT NULL COMMENT '文件服务器编码',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='完工申请单';

-- ----------------------------
-- Table structure for pur_cp_apply_d
-- ----------------------------

CREATE TABLE `pur_cp_apply_d` (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `mas_id` bigint(20) DEFAULT '0' COMMENT '主表ID',
  `ou_id` bigint(20) DEFAULT '0' COMMENT '公司ID',
  `bu_id` bigint(20) DEFAULT '0' COMMENT 'BUID',
  `line_no` decimal(20,4) DEFAULT NULL COMMENT '行号',
  `line_type` varchar(40) DEFAULT NULL COMMENT '行类型 [UDC]PUR:PO_LINE_TYPE',
  `line_status` varchar(40) DEFAULT NULL COMMENT '行状态',
  `supp_id` bigint(20) DEFAULT '0' COMMENT '供应商ID',
  `item_id` bigint(20) DEFAULT '0' COMMENT '品项ID',
  `item_code` varchar(40) DEFAULT NULL COMMENT '品项编号',
  `qty` decimal(20,4) DEFAULT NULL COMMENT '数量',
  `sn_qty` decimal(20,4) DEFAULT NULL COMMENT 'sn_qty',
  `uom` varchar(10) DEFAULT NULL COMMENT '单位',
  `complete_date` datetime DEFAULT NULL COMMENT '生产日期',
  `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
  `sec_bu_id` bigint(20) DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) DEFAULT NULL COMMENT 'sec_ou_id',
  `item_prop_code` varchar(40) DEFAULT NULL COMMENT '产品编码',
  `file_code` varchar(2000) DEFAULT NULL COMMENT '文件服务器编码',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='完工申请单明细';

-- ----------------------------
-- Table structure for pur_cp_apply_sn
-- ----------------------------

CREATE TABLE `pur_cp_apply_sn` (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `mas_id` bigint(20) DEFAULT NULL COMMENT '主表id',
  `cpa_d_id` bigint(20) DEFAULT NULL COMMENT 'cpa_d_id',
  `ou_id` bigint(20) DEFAULT '0' COMMENT '公司ID',
  `bu_id` bigint(20) DEFAULT '0' COMMENT 'BUID',
  `line_no` decimal(20,4) DEFAULT NULL COMMENT '行号',
  `line_type` varchar(40) DEFAULT NULL COMMENT '行类型 [UDC]PUR:PO_LINE_TYPE',
  `line_status` varchar(40) DEFAULT NULL COMMENT '行状态',
  `serial_id` bigint(20) DEFAULT NULL COMMENT 'serial_id',
  `serial_no` varchar(40) DEFAULT NULL COMMENT 'serial_no',
  `supp_id` bigint(20) DEFAULT '0' COMMENT '供应商ID',
  `item_id` bigint(20) DEFAULT '0' COMMENT '品项ID',
  `item_code` varchar(40) DEFAULT NULL COMMENT '品项编号',
  `complete_date` datetime DEFAULT NULL COMMENT '生产日期',
  `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
  `sec_bu_id` bigint(20) DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) DEFAULT NULL COMMENT 'sec_ou_id',
  `sn_apply_did` bigint(20) DEFAULT NULL COMMENT '二维码申请明细id',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='完工申请单明细绑定SN';

-- ----------------------------
-- Table structure for pur_gr
-- ----------------------------

CREATE TABLE `pur_gr` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '记录唯一ID',
  `ou_id` bigint(20) DEFAULT '0' COMMENT '公司ID',
  `bu_id` bigint(20) DEFAULT '0' COMMENT 'BUID',
  `doc_no` varchar(40) DEFAULT NULL COMMENT '单据编号',
  `doc_type` varchar(10) DEFAULT NULL COMMENT '单据类型 [UDC]PUR:GR_TYPE',
  `doc_status` varchar(40) DEFAULT NULL COMMENT '单据状态 [UDC]PUR:GR_STATUS',
  `recv_date` datetime DEFAULT NULL COMMENT '收货日期',
  `po_id` bigint(20) DEFAULT '0' COMMENT '采购订单ID',
  `supp_id` bigint(20) DEFAULT '0' COMMENT '供应商ID',
  `wh_id` bigint(20) DEFAULT '0' COMMENT '仓库ID',
  `deter1` varchar(40) DEFAULT NULL COMMENT '温层 [UDC]INV:TEMP_TYPE',
  `deter2` varchar(40) DEFAULT NULL COMMENT '功能区 [UDC]INV:FUNC_TYPE',
  `deter3` varchar(40) DEFAULT NULL COMMENT '客户标识',
  `deter4` varchar(40) DEFAULT NULL COMMENT '限定4',
  `deter5` varchar(40) DEFAULT NULL COMMENT '限定5',
  `deter6` varchar(40) DEFAULT NULL COMMENT '限定6',
  `deter7` varchar(40) DEFAULT NULL COMMENT '限定7',
  `deter8` varchar(40) DEFAULT NULL COMMENT '限定8',
  `wh_loc` varchar(40) DEFAULT NULL COMMENT '库位',
  `wh_posi` varchar(40) DEFAULT NULL COMMENT '货位',
  `supp_doc_no` varchar(40) DEFAULT NULL COMMENT '供应商发货单号',
  `recv_emp_id` bigint(20) DEFAULT '0' COMMENT '收货人员工ID',
  `crosswh_flag` int(11) DEFAULT NULL COMMENT '越库标识',
  `qty` decimal(20,8) DEFAULT NULL COMMENT '总数量',
  `qty_uom` varchar(10) DEFAULT NULL COMMENT '数量单位',
  `qty2` decimal(20,8) DEFAULT NULL COMMENT '总数量2',
  `qty2_uom` varchar(10) DEFAULT NULL COMMENT '数量2单位',
  `net_weight` decimal(20,8) DEFAULT NULL COMMENT '净重',
  `gross_weight` decimal(20,8) DEFAULT NULL COMMENT '毛重',
  `weight_uom` varchar(10) DEFAULT NULL COMMENT '重量单位',
  `volume` decimal(20,8) DEFAULT NULL COMMENT '体积',
  `volume_uom` varchar(10) DEFAULT NULL COMMENT '体积单位',
  `tax_amt` decimal(20,8) DEFAULT NULL COMMENT '税额',
  `amt` decimal(20,8) DEFAULT NULL COMMENT '含税金额',
  `net_amt` decimal(20,8) DEFAULT NULL COMMENT '不含税金额',
  `home_curr` varchar(10) DEFAULT NULL COMMENT '记账币种',
  `curr_code` varchar(10) DEFAULT NULL COMMENT '交易币种',
  `curr_rate` decimal(20,8) DEFAULT NULL COMMENT '汇率',
  `curr_net_amt` decimal(20,2) DEFAULT NULL COMMENT '外币不含税金额',
  `curr_amt` decimal(20,2) DEFAULT NULL COMMENT '外币含税金额',
  `gen_type` varchar(40) DEFAULT NULL COMMENT '生成类型 [UDC]COM:DOC_GEN_TYPE',
  `gen_type2` varchar(40) DEFAULT NULL COMMENT '生成类型2',
  `root_id` bigint(20) DEFAULT '0' COMMENT '根ID',
  `relate_doc_cls` varchar(40) DEFAULT NULL COMMENT '关联单据类别 [UDC]COM:DOC_CLS',
  `relate_doc_type` varchar(40) DEFAULT NULL COMMENT '关联单据类型',
  `relate_doc_id` bigint(20) DEFAULT '0' COMMENT '关联单据ID',
  `relate_doc_no` varchar(40) DEFAULT NULL COMMENT '关联单据编号',
  `relate_doc2_cls` varchar(40) DEFAULT NULL COMMENT '关联单据2类别 [UDC]COM:DOC_CLS',
  `relate_doc2_type` varchar(40) DEFAULT NULL COMMENT '关联单据2类型',
  `relate_doc2_id` bigint(20) DEFAULT '0' COMMENT '关联单据2ID',
  `relate_doc2_no` varchar(40) DEFAULT NULL COMMENT '关联单据2编号',
  `relate_id` bigint(20) DEFAULT '0' COMMENT '关联ID',
  `relate_no` varchar(40) DEFAULT NULL COMMENT '关联编号',
  `relate2_id` bigint(20) DEFAULT '0' COMMENT '关联2ID',
  `relate2_no` varchar(40) DEFAULT NULL COMMENT '关联2编号',
  `es1` varchar(40) DEFAULT NULL COMMENT 'ES1',
  `es2` varchar(40) DEFAULT NULL COMMENT 'ES2',
  `es3` varchar(40) DEFAULT NULL COMMENT 'ES3',
  `es4` varchar(40) DEFAULT NULL COMMENT 'ES4',
  `es5` varchar(40) DEFAULT NULL COMMENT 'ES5',
  `tax_incl_flag` int(11) DEFAULT NULL COMMENT '是否含税',
  `tax_code` varchar(40) DEFAULT NULL COMMENT '税码',
  `tax_rate_no` varchar(40) DEFAULT NULL COMMENT '税率编号',
  `tax_rate` decimal(20,8) DEFAULT NULL COMMENT '税率',
  `outer_ou` varchar(40) DEFAULT NULL COMMENT '外部单据公司',
  `outer_type` varchar(40) DEFAULT NULL COMMENT '外部单据类型',
  `outer_no` varchar(40) DEFAULT NULL COMMENT '外部单据编号',
  `emp_id` bigint(20) DEFAULT NULL COMMENT '员工ID',
  `emp_code` varchar(40) DEFAULT NULL COMMENT '员工编码',
  `payment_term` varchar(40) DEFAULT NULL COMMENT '付款条款',
  `po_type` varchar(10) DEFAULT NULL COMMENT '采购单据类型',
  `intf_flag` tinyint(4) DEFAULT NULL COMMENT '是否有接口0:无接口,1:有接口',
  `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) DEFAULT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
  `recv_emp_name` varchar(40) DEFAULT NULL COMMENT '收货人员工名字',
  `pur_account_check_id` bigint(20) DEFAULT NULL COMMENT '采购结算对账单ID',
  `account_flag` tinyint(2) DEFAULT NULL COMMENT '是否生成采购结算对账单0:未生成,1:已生成',
  `outer_id` bigint(20) DEFAULT '0' COMMENT '外部单据编号Id',
  `sale_wh_id` bigint(20) DEFAULT '0' COMMENT '销售发货仓库ID',
  `file_code` varchar(2000) DEFAULT NULL COMMENT '文件服务器编码',
  `sec_bu_id` bigint(20) DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) DEFAULT '0' COMMENT 'sec_ou_id',
  `group_flag` tinyint(1) DEFAULT '0' COMMENT '是否总部团内集采交易',
  `root_doc_id` bigint(20) DEFAULT '0' COMMENT '来源单据Id',
  `root_doc_no` varchar(64) DEFAULT NULL COMMENT '来源单据编号',
  `root_doc_cls` varchar(64) DEFAULT NULL COMMENT '来源单据类别 [UDC]COM:DOC_CLS',
  `root_doc_type` varchar(64) DEFAULT NULL COMMENT '来源单据类型',
  `tel` varchar(40) DEFAULT NULL COMMENT '联系人电话',
  `detail_addr` varchar(255) DEFAULT NULL COMMENT '收货地址',
  `jd_po_order_no` varchar(40) DEFAULT NULL COMMENT '京云仓采购入库单号',
  `reject_qty` decimal(20,8) DEFAULT NULL COMMENT '收货单拒收数量',
  `is_suppwh` int(11) DEFAULT NULL COMMENT '是否供应商仓库',
  `parts_amt_add` decimal(20,2) DEFAULT NULL COMMENT '配额发生',
  `parts_amt_use` decimal(20,2) DEFAULT NULL COMMENT '配额分配',
  `recv_addr` varchar(200) DEFAULT NULL COMMENT '收货地址',
  `trans_type` varchar(40) DEFAULT NULL COMMENT '运输方式',
  `sync_do_status` tinyint(1) DEFAULT NULL COMMENT '同步销售发货单状态',
  `sync_do_fail_reason` varchar(255) DEFAULT NULL COMMENT '同步销售发货单失败原因',
  `item_code` varchar(40) DEFAULT NULL COMMENT '商品编码',
  `scene_type_id` bigint(20) DEFAULT NULL COMMENT '采购场景ID',
  `scene_type_code` varchar(40) DEFAULT NULL COMMENT '采购场景编码',
  `po_doc_time` datetime(6) DEFAULT NULL COMMENT '采购订单订购时间',
  `sell_method` varchar(40) DEFAULT NULL COMMENT '出货方式',
  `reject_status` varchar(40) DEFAULT NULL COMMENT '拒收状态',
  `confirm_time` datetime(6) DEFAULT NULL COMMENT '签收时间',
  `confirm_qty` decimal(20,8) DEFAULT NULL COMMENT '签收总数量',
  `confirm_amt` decimal(20,8) DEFAULT NULL COMMENT '已签收含税金额',
  `confirm_net_amt` decimal(20,8) DEFAULT NULL COMMENT '已签收不含税金额',
  `confirm_curr_amt` decimal(20,8) DEFAULT NULL COMMENT '已签收外币含税金额',
  `confirm_curr_net_amt` decimal(20,8) DEFAULT NULL COMMENT '已签收外币不含税金额',
  `country` varchar(40) DEFAULT NULL COMMENT '国家',
  `province` varchar(40) DEFAULT NULL COMMENT '省',
  `city` varchar(40) DEFAULT NULL COMMENT '市',
  `county` varchar(40) DEFAULT NULL COMMENT '区县',
  `approve_user_id` bigint(20) DEFAULT NULL COMMENT '审批人',
  `approve_time` datetime(6) DEFAULT NULL COMMENT '审批时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `create_user_id_index` (`create_user_id`) USING BTREE,
  KEY `sec_bu_id_index` (`sec_bu_id`) USING BTREE,
  KEY `sec_user_id_index` (`sec_user_id`) USING BTREE,
  KEY `sec_ou_id_index` (`sec_ou_id`) USING BTREE,
  KEY `id_index` (`id`) USING BTREE,
  KEY `doc_no_index` (`doc_no`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=553996119420698704 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='采购收货单';

-- ----------------------------
-- Table structure for pur_gr_d
-- ----------------------------

CREATE TABLE `pur_gr_d` (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `sec_bu_id` bigint(20) DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) DEFAULT NULL COMMENT 'sec_ou_id',
  `mas_id` bigint(20) DEFAULT '0' COMMENT '主表ID',
  `line_no` decimal(20,3) DEFAULT NULL COMMENT '行号',
  `line_status` varchar(40) DEFAULT NULL COMMENT '行状态',
  `po_d_id` bigint(20) DEFAULT '0' COMMENT '采购订单明细ID',
  `ss_d_id` bigint(20) DEFAULT '0' COMMENT '供应商发货单明细ID',
  `item_id` bigint(20) DEFAULT '0' COMMENT '品项ID',
  `vari_id` bigint(20) DEFAULT '0' COMMENT '异构ID',
  `po_qty` decimal(20,8) DEFAULT NULL COMMENT '订购数量',
  `ss_qty` decimal(20,8) DEFAULT NULL COMMENT '发货数量',
  `qty` decimal(20,8) DEFAULT NULL COMMENT '收货数量',
  `uom` varchar(10) DEFAULT NULL COMMENT '单位',
  `qty2` decimal(20,8) DEFAULT NULL COMMENT '收货数量2',
  `uom2` varchar(10) DEFAULT NULL COMMENT '单位2',
  `uom_ratio` decimal(20,8) DEFAULT NULL COMMENT '单位转换率',
  `uom_ratio2` decimal(20,8) DEFAULT NULL COMMENT '单位转换率2',
  `trans_price` decimal(20,8) DEFAULT NULL COMMENT '交易单价 折扣后，不含税',
  `tax_amt` decimal(20,8) DEFAULT NULL COMMENT '税额',
  `amt` decimal(20,8) DEFAULT NULL COMMENT '含税金额',
  `net_amt` decimal(20,8) DEFAULT NULL COMMENT '不含税金额',
  `curr_amt` decimal(20,8) DEFAULT NULL COMMENT '外币含税金额',
  `curr_net_amt` decimal(20,8) DEFAULT NULL COMMENT '外币不含税金额',
  `wh_id` bigint(20) DEFAULT '0' COMMENT '仓库ID',
  `deter1` varchar(40) DEFAULT NULL COMMENT '温层 [UDC]INV:TEMP_TYPE',
  `deter2` varchar(40) DEFAULT NULL COMMENT '功能区 [UDC]INV:FUNC_TYPE',
  `deter3` varchar(40) DEFAULT NULL COMMENT '客户标识',
  `deter4` varchar(40) DEFAULT NULL COMMENT '限定4',
  `deter5` varchar(40) DEFAULT NULL COMMENT '限定5',
  `deter6` varchar(40) DEFAULT NULL COMMENT '限定6',
  `deter7` varchar(40) DEFAULT NULL COMMENT '限定7',
  `deter8` varchar(40) DEFAULT NULL COMMENT '限定8',
  `wh_loc` varchar(40) DEFAULT NULL COMMENT '库位',
  `wh_posi` varchar(40) DEFAULT NULL COMMENT '货位',
  `lot_no` varchar(40) DEFAULT NULL COMMENT '收货批次',
  `menu_lot_no` varchar(40) DEFAULT NULL COMMENT '生产批次',
  `manu_date` datetime DEFAULT NULL COMMENT '生产日期',
  `batch_no` varchar(40) DEFAULT NULL COMMENT '整批号',
  `expire_date` datetime DEFAULT NULL COMMENT '过期日期',
  `expire_days` int(18) DEFAULT NULL COMMENT '保质期天数',
  `until_expire_days` int(18) DEFAULT NULL COMMENT '剩余效期天数',
  `demand_fresh_percent` decimal(20,8) DEFAULT NULL COMMENT '要求保质期比例',
  `demand_aap_days` int(18) DEFAULT NULL COMMENT '最低允收期天数',
  `is_fress_valid` int(1) DEFAULT NULL COMMENT '是否新鲜度合格',
  `actual_fresh_percent` decimal(20,8) DEFAULT NULL COMMENT '到货保质期比例',
  `shipment_date` datetime DEFAULT NULL COMMENT '供应商发货日期',
  `exception_desc` varchar(40) DEFAULT NULL COMMENT '异常备注',
  `barcode` varchar(40) DEFAULT NULL COMMENT '条码',
  `root_id` bigint(20) DEFAULT '0' COMMENT '根ID',
  `relate_doc_cls` varchar(40) DEFAULT NULL COMMENT '关联单据类别 [UDC]COM:DOC_CLS',
  `relate_doc_type` varchar(40) DEFAULT NULL COMMENT '关联单据类型',
  `relate_doc_id` bigint(20) DEFAULT '0' COMMENT '关联单据ID',
  `relate_doc_no` varchar(40) DEFAULT NULL COMMENT '关联单据编号',
  `relate_doc_did` bigint(20) DEFAULT '0' COMMENT '关联单据明细ID',
  `relate_doc_lineno` decimal(20,3) DEFAULT NULL COMMENT '关联单据行号',
  `relate_doc2_cls` varchar(40) DEFAULT NULL COMMENT '关联单据2类别 [UDC]COM:DOC_CLS',
  `relate_doc2_type` varchar(40) DEFAULT NULL COMMENT '关联单据2类型',
  `relate_doc2_id` bigint(20) DEFAULT '0' COMMENT '关联单据2ID',
  `relate_doc2_no` varchar(40) DEFAULT NULL COMMENT '关联单据2编号',
  `relate_doc2_did` bigint(20) DEFAULT '0' COMMENT '关联单据2明细ID',
  `relate_doc2_lineno` decimal(20,3) DEFAULT NULL COMMENT '关联单据2行号',
  `es1` varchar(40) DEFAULT NULL COMMENT 'ES1',
  `es2` varchar(40) DEFAULT NULL COMMENT 'ES2',
  `es3` varchar(40) DEFAULT NULL COMMENT 'ES3',
  `es4` varchar(40) DEFAULT NULL COMMENT 'ES4',
  `es5` varchar(40) DEFAULT NULL COMMENT 'ES5',
  `dbrand` varchar(40) DEFAULT NULL COMMENT '品牌',
  `base_price` decimal(20,8) DEFAULT NULL COMMENT '基价',
  `price_type` varchar(40) DEFAULT NULL COMMENT '价格类型',
  `net_price` decimal(20,8) DEFAULT NULL COMMENT '不含税价格',
  `price` decimal(20,8) DEFAULT NULL COMMENT '含税单价',
  `pb_price` decimal(20,8) DEFAULT NULL COMMENT '价格本价格',
  `pb_curr` varchar(40) DEFAULT NULL COMMENT '价格本币种',
  `pb_uom` varchar(10) DEFAULT NULL COMMENT '价格本单位',
  `disc_type` varchar(40) DEFAULT NULL COMMENT '折扣类型',
  `disc_ratio` decimal(20,8) DEFAULT NULL COMMENT '折扣率',
  `disc_amt` decimal(20,2) DEFAULT NULL COMMENT '折扣额',
  `disc_desc` varchar(100) DEFAULT NULL COMMENT '折扣描述',
  `disced_price` decimal(20,8) DEFAULT NULL COMMENT '折扣后价格',
  `tax_code` varchar(40) DEFAULT NULL COMMENT '税码',
  `tax_rate_no` varchar(40) DEFAULT NULL COMMENT '税率编号',
  `tax_rate` decimal(20,8) DEFAULT NULL COMMENT '税率',
  `curr_net_price` decimal(20,8) DEFAULT NULL COMMENT '外币含不税单价',
  `curr_price` decimal(20,8) DEFAULT NULL COMMENT '外币含税单价',
  `home_curr` varchar(40) DEFAULT NULL COMMENT '本币币种',
  `curr_code` varchar(40) DEFAULT NULL COMMENT '币种',
  `curr_rate` decimal(20,8) DEFAULT NULL COMMENT '汇率',
  `outer_ou` varchar(40) DEFAULT NULL COMMENT '外部单据公司',
  `outer_type` varchar(40) DEFAULT NULL COMMENT '外部单据类型',
  `outer_no` varchar(40) DEFAULT NULL COMMENT '外部单据编号',
  `outer_lineno` varchar(40) DEFAULT NULL COMMENT '外部单据行号',
  `payed_qty` decimal(20,8) DEFAULT NULL COMMENT '数量2',
  `payed_amt` decimal(20,2) DEFAULT NULL COMMENT '已付金额',
  `gr_no` varchar(40) DEFAULT NULL COMMENT '收货单据编号',
  `line_type` varchar(40) DEFAULT NULL COMMENT '行类型',
  `outer_line_type` varchar(40) DEFAULT NULL COMMENT '外部单据行类型',
  `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
  `item_code` varchar(40) DEFAULT NULL COMMENT '商品编码',
  `reject_qty` decimal(20,8) DEFAULT NULL COMMENT '收货单拒收数量',
  `sale_wh_id` bigint(20) DEFAULT '0' COMMENT '销售发货仓库ID',
  `cost_price_flag` tinyint(2) DEFAULT NULL COMMENT '成本价标志位0:否,1:是',
  `outer_id` bigint(20) DEFAULT '0' COMMENT '外部单据编号Id',
  `outer_did` bigint(20) DEFAULT '0' COMMENT '外部单据编号明细Id',
  `root_doc_cls` varchar(64) DEFAULT NULL COMMENT '来源单据类别 [UDC]COM:DOC_CLS',
  `root_doc_type` varchar(64) DEFAULT NULL COMMENT '来源单据类型',
  `root_doc_id` bigint(20) DEFAULT '0' COMMENT '来源单据Id',
  `root_doc_no` varchar(64) DEFAULT NULL COMMENT '来源单据编号',
  `root_doc_did` bigint(20) DEFAULT '0' COMMENT '来源单据明细ID',
  `root_doc_lineno` decimal(20,2) DEFAULT NULL COMMENT '来源单据行号',
  `fin1` varchar(5) DEFAULT NULL COMMENT '传输成功标志',
  `fin2` varchar(40) DEFAULT NULL COMMENT '数据传输批号',
  `fin3` datetime DEFAULT NULL COMMENT '数据传输日期',
  `fin4` varchar(40) DEFAULT NULL COMMENT '备用字段',
  `rejecting_flag` varchar(40) DEFAULT NULL COMMENT '拒收状态',
  `is_suppwh` int(1) DEFAULT NULL COMMENT '是否供应商仓库',
  `is_crossflag_suppwh` int(1) DEFAULT NULL COMMENT '是否越库供应商仓库',
  `parts_amt_add` decimal(20,4) DEFAULT NULL COMMENT '配额发生',
  `parts_amt_use` decimal(20,4) DEFAULT NULL COMMENT '配额分配',
  `returned_qty` decimal(20,8) DEFAULT '0.00000000' COMMENT '采购收货已退货数量',
  `confirm_qty` decimal(20,8) DEFAULT '0.00000000' COMMENT '采购退货登记单已签收数量',
  `confirm_qty2` decimal(20,8) DEFAULT '0.00000000' COMMENT '采购退货登记单已签收数量',
  `confirm_time` datetime DEFAULT NULL COMMENT '采购退货登记单签收日期',
  `rejecting_qty` decimal(20,8) DEFAULT '0.00000000' COMMENT '采购退货登记单拒收中数量',
  `confirm_amt` decimal(20,8) DEFAULT NULL COMMENT '已签收含税金额',
  `confirm_net_amt` decimal(20,8) DEFAULT NULL COMMENT '已签收不含税金额',
  `confirm_curr_amt` decimal(20,8) DEFAULT NULL COMMENT '已签收外币含税金额',
  `confirm_curr_net_amt` decimal(20,8) DEFAULT NULL COMMENT '已签收外币不含税金额',
  `check_qty` decimal(20,8) DEFAULT '0.00000000' COMMENT '对账数量',
  `date1` datetime DEFAULT NULL COMMENT 'DATE1',
  `date2` datetime DEFAULT NULL COMMENT 'DATE2',
  `date3` datetime DEFAULT NULL COMMENT 'DATE3',
  `date4` datetime DEFAULT NULL COMMENT 'DATE4',
  `date5` datetime DEFAULT NULL COMMENT 'DATE5',

  PRIMARY KEY (`id`) USING BTREE,
  KEY `create_user_id_index` (`create_user_id`) USING BTREE,
  KEY `sec_bu_id_index` (`sec_bu_id`) USING BTREE,
  KEY `sec_user_id_index` (`sec_user_id`) USING BTREE,
  KEY `sec_ou_id_index` (`sec_ou_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='采购收货单明细';

-- ----------------------------
-- Table structure for pur_inv
-- ----------------------------

CREATE TABLE `pur_inv` (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `sec_bu_id` bigint(20) DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) DEFAULT NULL COMMENT 'sec_ou_id',
  `ou_id` bigint(20) DEFAULT NULL COMMENT '公司ID',
  `org_id` bigint(20) DEFAULT NULL COMMENT '组织ID',
  `bu_id` bigint(20) DEFAULT NULL COMMENT '部门ID',
  `supp_id` bigint(20) DEFAULT NULL COMMENT '供应商ID',
  `source_mode` varchar(40) DEFAULT NULL COMMENT '来源方式',
  `from_addr_no` int(18) DEFAULT NULL COMMENT '开票方地址号',
  `to_addr_no` int(18) DEFAULT NULL COMMENT '收票方地址号',
  `inv_form` varchar(40) DEFAULT NULL COMMENT '发票形式 发票形式（汇总发票，正式发票）',
  `inv_type` varchar(40) DEFAULT NULL COMMENT '发票类型 发票类型（普通发票、增值税发票等）',
  `account_type` varchar(40) DEFAULT NULL COMMENT '对账类型',
  `inv_status` varchar(40) DEFAULT NULL COMMENT '发票状态',
  `inv_no` varchar(40) DEFAULT NULL COMMENT '发票号码',
  `tax_code` varchar(40) DEFAULT NULL COMMENT '税码',
  `tax_rate` decimal(20,2) DEFAULT NULL COMMENT '税率',
  `curr_rate` decimal(20,8) DEFAULT NULL COMMENT '汇率',
  `tax_amt` decimal(20,8) DEFAULT NULL COMMENT '税额',
  `net_amt` decimal(20,8) DEFAULT NULL COMMENT '不含税金额(本币)',
  `amt` decimal(20,8) DEFAULT NULL COMMENT '含税总金额(本币)',
  `curr_net_amt` decimal(20,8) DEFAULT NULL COMMENT '不含税金额',
  `curr_amt` decimal(20,8) DEFAULT NULL COMMENT '含税总金额',
  `account_check_id` bigint(20) DEFAULT NULL COMMENT '对账单ID',
  `account_check_code` varchar(64) DEFAULT NULL COMMENT '对账单Code',
  `proc_inst_id` varchar(64) DEFAULT NULL COMMENT '流程ID',
  `zfinv_amt` float(18,4) DEFAULT NULL COMMENT '发票总金额（含税） 发票总金额（含税）',
  `zfinv_netamt` float(18,4) DEFAULT NULL COMMENT '发票总金额（未税） 发票总金额（未税）',
  `zftax_amt` float(18,4) DEFAULT NULL COMMENT '发票总税额 发票总税额',
  `diff_amt` float(18,4) DEFAULT NULL COMMENT '开票总差异 开票总差异（含税金额差异）',
  `diff_netamt` float(18,4) DEFAULT NULL COMMENT '未税差异 未税差异',
  `diff_tax` float(18,4) DEFAULT NULL COMMENT '税额差异 税额差异',
  `ex_ou_id` bigint(20) DEFAULT NULL COMMENT '快递公司ID',
  `ex_ou` varchar(40) DEFAULT NULL COMMENT '快递公司',
  `ex_no` varchar(40) DEFAULT NULL COMMENT '快递单号',
  `inv_fix` varchar(10) DEFAULT NULL COMMENT '发票定额(CODE)',
  `curr_code` varchar(40) DEFAULT NULL COMMENT '币种',
  `appr_status` varchar(20) DEFAULT NULL COMMENT '审批状态',
  `appr_time` datetime DEFAULT NULL COMMENT '审批时间',
  `appr_user_id` bigint(20) DEFAULT NULL COMMENT '审批人ID',
  `tms_flag` int(18) DEFAULT NULL COMMENT '是否有物流信息',
  `diff_flag` int(18) DEFAULT NULL COMMENT '是否有差异',
  `third_pay_flag` tinyint(1) DEFAULT '1' COMMENT '是否第三方支付，1：是，0：否',
  `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
  `emp_id` bigint(20) DEFAULT NULL COMMENT '员工ID',
  `emp_code` varchar(40) DEFAULT NULL COMMENT '员工编码',
  `emp_name` varchar(40) DEFAULT NULL COMMENT '员工名称',
  `operator_id` bigint(20) DEFAULT NULL COMMENT '经办人ID',
  `operator_code` varchar(40) DEFAULT NULL COMMENT '经办人编码',
  `operator_name` varchar(40) DEFAULT NULL COMMENT '经办人名称',
  `fin1` varchar(40) DEFAULT NULL COMMENT 'ERP成功标识',
  `fin2` varchar(40) DEFAULT NULL COMMENT 'ERP凭证号',
  `fin3` datetime(6) DEFAULT NULL COMMENT 'ERP传输日期',
  `fin4` varchar(40) DEFAULT NULL COMMENT '传输ERP唯一标识码-成本结转业务',
  `fin_appr_status` varchar(20) DEFAULT NULL COMMENT '财务域审批状态',
  `fin_appr_time` datetime DEFAULT NULL COMMENT '财务域审批时间',
  `fin_appr_user_id` bigint(20) DEFAULT NULL COMMENT '财务域审批人ID',
  `fin_appr_comment` varchar(100) DEFAULT NULL COMMENT '审核拒绝理由',
  `proc_inst_status` varchar(255) DEFAULT NULL COMMENT '流程实例状态',
  `submit_time` datetime DEFAULT NULL COMMENT '提交时间',
  `approved_time` datetime DEFAULT NULL COMMENT '审批通过时间',
  `payment_term` varchar(40) DEFAULT NULL COMMENT '付款条款',
  `gr_sum_curr_amt` decimal(20,4) DEFAULT NULL COMMENT '入库含税总金额',
  `gr_sum_curr_net_amt` decimal(18,4) DEFAULT NULL COMMENT '入库未税总金额',
  `parts_sum_curr_amt` decimal(20,8) DEFAULT NULL COMMENT '配额含税总金额',
  `parts_sum_curr_net_amt` decimal(18,8) DEFAULT NULL COMMENT '配额未税总金额',
  `sum_extra_curr_amt` decimal(18,8) DEFAULT NULL COMMENT '成本扣含税',
  `sum_extra_curr_net_amt` decimal(18,8) DEFAULT NULL COMMENT '成本扣未税',
  `cargo_deduce_curr_amt` decimal(18,8) DEFAULT NULL COMMENT '货扣含税',
  `cargo_deduc_curr_net_amt` decimal(18,8) DEFAULT NULL COMMENT '货扣未税',
  `local_tax_amt` decimal(18,4) DEFAULT NULL COMMENT '本币开票税额',
  `zfinv_local_amt` decimal(20,8) DEFAULT NULL COMMENT '本币发票总额含税',
  `zfinv_local_netamt` decimal(20,8) DEFAULT NULL COMMENT '本币发票总额未税',
  `zftax_local_amt` decimal(20,8) DEFAULT NULL COMMENT '本币发票总额税额',
  `diff_local_amt` decimal(20,8) DEFAULT NULL COMMENT '本币开票含税差异',
  `diff_local_netamt` decimal(20,8) DEFAULT NULL COMMENT '本币开票未税差异',
  `diff_local_tax` decimal(20,8) DEFAULT NULL COMMENT '本币开票税额差异',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `create_user_id_index` (`create_user_id`) USING BTREE,
  KEY `sec_bu_id_index` (`sec_bu_id`) USING BTREE,
  KEY `sec_user_id_index` (`sec_user_id`) USING BTREE,
  KEY `sec_ou_id_index` (`sec_ou_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='发票';

-- ----------------------------
-- Table structure for pur_inv_d
-- ----------------------------

CREATE TABLE `pur_inv_d` (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `sec_bu_id` bigint(20) DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) DEFAULT NULL COMMENT 'sec_ou_id',
  `finv_code` varchar(40) DEFAULT NULL COMMENT '正式发票代码',
  `finv_no` varchar(40) DEFAULT NULL COMMENT '正式发票号码 正式发票号码',
  `finv_class` varchar(40) DEFAULT NULL COMMENT '发票种类',
  `finv_amt` decimal(20,8) DEFAULT NULL COMMENT '发票金额',
  `finv_netamt` decimal(20,8) DEFAULT NULL COMMENT '未税金额',
  `ftax_amt` decimal(20,8) DEFAULT NULL COMMENT '税额',
  `tax_rate` bigint(20) DEFAULT NULL COMMENT '税率',
  `finv_date` date DEFAULT NULL COMMENT '开票日期',
  `finv_symbol` varchar(40) DEFAULT NULL COMMENT '发票校验码',
  `inv_type` varchar(40) DEFAULT NULL COMMENT '发票类型',
  `inv_no` varchar(40) DEFAULT NULL COMMENT '形式发票号码',
  `status` varchar(40) DEFAULT '人工验证' COMMENT '验证状态',
  `appr_time` datetime DEFAULT NULL COMMENT '审批时间',
  `appr_user_id` bigint(20) DEFAULT NULL COMMENT '审批人ID',
  `ou_id` bigint(20) DEFAULT NULL COMMENT '公司ID',
  `supp_id` bigint(20) DEFAULT '0' COMMENT '供应商ID',
  `mas_id` bigint(20) DEFAULT '0' COMMENT '主表ID',
  `line_no` decimal(20,2) DEFAULT NULL COMMENT '行号',
  `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
  `item_id` bigint(20) DEFAULT '0' COMMENT '品项ID',
  `item_code` varchar(40) DEFAULT NULL COMMENT '品项编号',
  `qty` decimal(20,8) DEFAULT NULL COMMENT '数量',
  `curr_net_price` decimal(20,8) DEFAULT NULL COMMENT '外币含不税单价',
  `curr_price` decimal(20,8) DEFAULT NULL COMMENT '外币含税单价',
  `tax_rate_value` decimal(20,2) DEFAULT NULL COMMENT '税率值',
  `finv_local_amt` decimal(20,8) DEFAULT NULL COMMENT '本币发票金额含税',
  `finv_local_netamt` decimal(20,8) DEFAULT NULL COMMENT '本币发票金额不含税',
  `ftax_local_amt` decimal(20,8) DEFAULT NULL COMMENT '本币发票税额',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `create_user_id_index` (`create_user_id`) USING BTREE,
  KEY `sec_bu_id_index` (`sec_bu_id`) USING BTREE,
  KEY `sec_user_id_index` (`sec_user_id`) USING BTREE,
  KEY `sec_ou_id_index` (`sec_ou_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='发票明细';

-- ----------------------------
-- Table structure for pur_inv_item
-- ----------------------------

CREATE TABLE `pur_inv_item` (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `sec_bu_id` bigint(20) DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) DEFAULT NULL COMMENT 'sec_ou_id',
  `inv_id` bigint(20) DEFAULT NULL COMMENT '开票ID',
  `inv_no` varchar(40) DEFAULT NULL COMMENT '发票号码',
  `finv_code` varchar(40) DEFAULT NULL COMMENT '正式发票代码 正式发票代码',
  `finv_no` varchar(40) DEFAULT NULL COMMENT '正式发票号码 正式发票号码',
  `finv_class` varchar(40) DEFAULT NULL COMMENT '发票种类 增值税专票、增值税普票',
  `finv_amt` decimal(20,8) DEFAULT NULL COMMENT '发票金额 正式发票含税金额',
  `finv_netamt` decimal(20,8) DEFAULT NULL COMMENT '未税金额 正式发票未税金额',
  `ftax_amt` decimal(20,8) DEFAULT NULL COMMENT '税额 正式发票税额',
  `finv_date` datetime DEFAULT NULL COMMENT '开票日期 正式发票开票日期',
  `finv_symbol` varchar(40) DEFAULT NULL COMMENT '发票校验码 正式发票发票校验码',
  `inv_type` varchar(40) DEFAULT NULL COMMENT '发票类型 正式发票/形式发票',
  `doc_no` varchar(40) DEFAULT NULL COMMENT '对账单号码',
  `ou_id` bigint(20) DEFAULT NULL COMMENT '公司ID',
  `supp_id` bigint(20) DEFAULT '0' COMMENT '供应商ID',
  `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `create_user_id_index` (`create_user_id`) USING BTREE,
  KEY `sec_bu_id_index` (`sec_bu_id`) USING BTREE,
  KEY `sec_user_id_index` (`sec_user_id`) USING BTREE,
  KEY `sec_ou_id_index` (`sec_ou_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='正式发票明细';

-- ----------------------------
-- Table structure for pur_inv_sync_log
-- ----------------------------

CREATE TABLE `pur_inv_sync_log` (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `session_code` varchar(40) DEFAULT NULL COMMENT '唯一标识码(批号)',
  `message` varchar(500) DEFAULT NULL COMMENT '日志信息',
  `log_date` datetime(6) DEFAULT NULL COMMENT '同步日期',
  `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
  `sec_bu_id` bigint(20) DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) DEFAULT NULL COMMENT 'sec_ou_id',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='暂估差异同步日志表';

-- ----------------------------
-- Table structure for pur_invoice
-- ----------------------------

CREATE TABLE `pur_invoice` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '记录唯一ID',
  `relation_number` varchar(32) DEFAULT NULL COMMENT '关联对账单号',
  `invoice_number` varchar(32) DEFAULT NULL COMMENT '发票号码',
  `invoice_code` varchar(32) DEFAULT NULL COMMENT '发票代码',
  `invoice_type` varchar(20) DEFAULT NULL COMMENT '发票类型',
  `tax_rate` decimal(4,2) DEFAULT NULL COMMENT '税率',
  `tax_amount` decimal(20,4) DEFAULT NULL COMMENT '税额',
  `no_tax_amount` decimal(20,4) DEFAULT NULL COMMENT '无税金额',
  `total_amount` decimal(20,4) DEFAULT NULL COMMENT '金额',
  `check_state` varchar(20) DEFAULT NULL COMMENT '验证状态',
  `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) DEFAULT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
  `total_amount_base` decimal(20,4) DEFAULT NULL,
  `invoice_date` datetime DEFAULT NULL,
  `pur_settle_id` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `create_user_id_index` (`create_user_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='采购发票信息';

-- ----------------------------
-- Table structure for pur_moq
-- ----------------------------

CREATE TABLE `pur_moq` (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `sec_bu_id` bigint(20) DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) DEFAULT NULL COMMENT 'sec_ou_id',
  `ou_id` bigint(20) DEFAULT NULL COMMENT '公司ID',
  `bu_id` bigint(20) DEFAULT NULL COMMENT 'BUID',
  `supp_id` bigint(20) DEFAULT NULL COMMENT '供应商ID',
  `item_id` bigint(20) DEFAULT NULL COMMENT '品项ID',
  `period_from` int(18) DEFAULT NULL COMMENT '期间开始',
  `period_to` int(18) DEFAULT NULL COMMENT '期间结束',
  `period_type` varchar(40) DEFAULT NULL COMMENT '期间类型',
  `trans_type` varchar(40) DEFAULT NULL COMMENT '运输方式 [UDC]COM:TP_TYPE',
  `moq_type` varchar(40) DEFAULT NULL COMMENT 'MOQ类型 [UOM]ITM:MOQ_TYPE',
  `brand` varchar(40) DEFAULT NULL COMMENT '品牌',
  `brand2` varchar(40) DEFAULT NULL COMMENT '品牌2',
  `qty` double(20,8) DEFAULT NULL COMMENT '数量',
  `uom` varchar(10) DEFAULT NULL COMMENT '单位',
  `amt` decimal(20,4) DEFAULT NULL COMMENT '金额',
  `step_qty` double(20,8) DEFAULT NULL COMMENT '阶梯数量',
  `step_amt` decimal(20,4) DEFAULT NULL COMMENT '阶梯金额',
  `curr_code` varchar(40) DEFAULT NULL COMMENT '币种',
  `valid_from` datetime DEFAULT NULL COMMENT '生效时间',
  `valid_to` datetime DEFAULT NULL COMMENT '失效时间',
  `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `create_user_id_index` (`create_user_id`) USING BTREE,
  KEY `sec_bu_id_index` (`sec_bu_id`) USING BTREE,
  KEY `sec_user_id_index` (`sec_user_id`) USING BTREE,
  KEY `sec_ou_id_index` (`sec_ou_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='采购MOQ';

-- ----------------------------
-- Table structure for pur_order_details
-- ----------------------------

CREATE TABLE `pur_order_details` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '记录唯一ID',
  `relation_number` varchar(32) DEFAULT NULL COMMENT '关联对账单号',
  `pur_order_number` varchar(32) DEFAULT NULL COMMENT '采购单号',
  `pur_order_name` varchar(32) DEFAULT NULL COMMENT '采购单名称',
  `contact_code` varchar(32) DEFAULT NULL COMMENT '往来对象代码',
  `contact_name` varchar(32) DEFAULT NULL COMMENT '往来对象',
  `settle_entity_name` varchar(32) DEFAULT NULL COMMENT '结算主体',
  `dept_name` varchar(32) DEFAULT NULL COMMENT '部门',
  `item_name` varchar(32) DEFAULT NULL COMMENT '产品名称',
  `item_class` varchar(32) DEFAULT NULL COMMENT '产品类别',
  `qty` decimal(20,4) DEFAULT NULL COMMENT '数量',
  `price` decimal(20,4) DEFAULT NULL COMMENT '单价',
  `total_amount` decimal(20,4) DEFAULT NULL COMMENT '金额',
  `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) DEFAULT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
  `item_id` bigint(20) DEFAULT NULL COMMENT '产品ID',
  `contact_id` bigint(20) DEFAULT NULL,
  `settle_entity_id` bigint(40) DEFAULT NULL,
  `dept_id` bigint(20) DEFAULT NULL,
  `uom` varchar(20) DEFAULT NULL COMMENT '单位',
  `sku_code` varchar(20) DEFAULT NULL,
  `sku_name` varchar(50) DEFAULT NULL,
  `tax_rate` decimal(4,2) DEFAULT NULL,
  `pur_settle_id` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `create_user_id_index` (`create_user_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='采购单明细';

-- ----------------------------
-- Table structure for pur_pa
-- ----------------------------

CREATE TABLE `pur_pa` (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `sec_bu_id` bigint(20) DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) DEFAULT NULL COMMENT 'sec_ou_id',
  `ou_id` bigint(20) DEFAULT NULL COMMENT '公司ID',
  `bu_id` bigint(20) DEFAULT NULL COMMENT 'BUID',
  `doc_no` varchar(40) DEFAULT NULL COMMENT '预付款申请编号',
  `po_code` varchar(40) DEFAULT NULL COMMENT '采购订单编号',
  `doc_type` varchar(10) DEFAULT NULL COMMENT '采购付款申请类型 [UDC]PUR:PA_TYPE',
  `buss_type` varchar(10) DEFAULT NULL COMMENT '采购场景业务类型 [UDC]PUR:BUSS_TYPE',
  `src_doc_cls` varchar(40) DEFAULT 'PUR' COMMENT '来源单据类别',
  `doc_status` varchar(40) DEFAULT NULL COMMENT '单据状态 [UDC]PUR:PA_STATUS',
  `doc_date` datetime DEFAULT NULL COMMENT '请款日期',
  `doc_emp_id` bigint(20) DEFAULT NULL COMMENT '请款人员工ID',
  `appr_proc_inst_id` varchar(40) DEFAULT NULL COMMENT '流程实例ID',
  `appr_create_user_id` bigint(20) DEFAULT '0' COMMENT '提审人ID',
  `appr_status` varchar(40) DEFAULT NULL COMMENT '审批状态 [UDC]COM:APPR_STATUS',
  `appr_time` datetime DEFAULT NULL COMMENT '审批时间',
  `appr_user_id` bigint(20) DEFAULT NULL COMMENT '审批人ID',
  `appr_comment` varchar(500) DEFAULT NULL COMMENT '审批意见',
  `apply_emp_id` bigint(20) DEFAULT NULL COMMENT '申请人员工ID',
  `apply_date` datetime DEFAULT NULL COMMENT '申请日期',
  `apply_desc` varchar(100) DEFAULT NULL COMMENT '申请描述',
  `supp_id` bigint(20) DEFAULT NULL COMMENT '供应商ID',
  `curr_code` varchar(40) DEFAULT NULL COMMENT '供应商币种',
  `ou_curr_code` varchar(40) DEFAULT NULL COMMENT '公司币种',
  `attachments_no` decimal(20,3) DEFAULT NULL COMMENT '附件张数',
  `curr_rate` decimal(20,8) DEFAULT NULL COMMENT '汇率',
  `total_curr_pa_amt` decimal(20,8) DEFAULT NULL COMMENT '预付总金额',
  `total_pa_amt` decimal(20,8) DEFAULT NULL COMMENT '预付总金额(本位币)',
  `total_deduc_amt` decimal(20,8) DEFAULT NULL COMMENT '额外费用总金额',
  `actual_pay_amt` decimal(20,8) DEFAULT '0.00000000' COMMENT '实际支付金额',
  `actual_pay_date` datetime DEFAULT NULL COMMENT '实际支付日期',
  `pay_flag` tinyint(1) DEFAULT '1' COMMENT '是否预付 1：是，0：否',
  `payment_term` varchar(40) DEFAULT NULL COMMENT '支付条款',
  `pay_method` varchar(40) DEFAULT NULL COMMENT '付款方式 [UDC]PUR:PAY_TYPE',
  `third_pay_flag` tinyint(1) DEFAULT '1' COMMENT '是否第三方支付，1：是，0：否',
  `receipt_no` varchar(40) DEFAULT NULL COMMENT '银行回单号',
  `pay_emp_id` bigint(20) DEFAULT NULL COMMENT '支付员工ID',
  `cancel_time` datetime DEFAULT NULL COMMENT '取消时间',
  `es1` varchar(40) DEFAULT NULL COMMENT 'ES1',
  `es2` varchar(40) DEFAULT NULL COMMENT 'ES2',
  `es3` varchar(40) DEFAULT NULL COMMENT 'ES3',
  `es4` varchar(40) DEFAULT NULL COMMENT 'ES4',
  `es5` varchar(40) DEFAULT NULL COMMENT 'ES5',
  `beneficiary` varchar(100) DEFAULT NULL COMMENT '收款单位',
  `bank` varchar(40) DEFAULT NULL COMMENT '开户银行',
  `bank_account` varchar(40) DEFAULT NULL COMMENT '银行账号',
  `appr_type` varchar(10) DEFAULT NULL COMMENT '审批类型',
  `pur_account_check_id` bigint(20) DEFAULT NULL COMMENT '采购结算对账单ID',
  `account_flag` tinyint(2) DEFAULT NULL COMMENT '是否生成采购结算对账单0:未生成,1:已生成',
  `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
  `init_flag` tinyint(1) DEFAULT '1' COMMENT '期初标志，1：是，0：否',
  `fin_appr_status` varchar(20) DEFAULT NULL COMMENT '财务域审批状态',
  `fin_appr_time` datetime DEFAULT NULL COMMENT '财务域审批时间',
  `fin_appr_user_id` bigint(20) DEFAULT NULL COMMENT '财务域审批人ID',
  `fin_appr_comment` varchar(100) DEFAULT NULL COMMENT '审核拒绝理由',
  `accounting_amt` decimal(20,8) DEFAULT '0.00000000' COMMENT '核销中金额',
  `accounted_amt` decimal(20,8) DEFAULT '0.00000000' COMMENT '已核销金额',
  `proc_inst_id` varchar(255) DEFAULT NULL COMMENT '流程实例ID',
  `proc_inst_status` varchar(255) DEFAULT NULL COMMENT '流程实例状态',
  `submit_time` datetime(6) DEFAULT NULL COMMENT '提交时间',
  `approved_time` datetime(6) DEFAULT NULL COMMENT '审批通过时间',
  `bu_name` varchar(200) DEFAULT NULL COMMENT 'BU名称',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `create_user_id_index` (`create_user_id`) USING BTREE,
  KEY `sec_bu_id_index` (`sec_bu_id`) USING BTREE,
  KEY `sec_user_id_index` (`sec_user_id`) USING BTREE,
  KEY `sec_ou_id_index` (`sec_ou_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='预付款申请';

-- ----------------------------
-- Table structure for pur_pa_d
-- ----------------------------

CREATE TABLE `pur_pa_d` (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `sec_bu_id` bigint(20) DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) DEFAULT NULL COMMENT 'sec_ou_id',
  `mas_id` bigint(20) DEFAULT NULL COMMENT '主表ID PUR_PA.ID',
  `line_no` decimal(20,3) DEFAULT NULL COMMENT '行号',
  `po_id` bigint(20) DEFAULT NULL COMMENT '采购或退货单ID',
  `scene_type_id` bigint(20) DEFAULT NULL COMMENT '采购场景类型ID',
  `po_code` varchar(40) DEFAULT NULL COMMENT '采购订单编号',
  `supp_code` varchar(40) DEFAULT NULL COMMENT '供应商编号',
  `pad_cls` varchar(40) DEFAULT NULL COMMENT '付款类别 [UDC]PUR:PAD_CLS',
  `pad_type` varchar(40) DEFAULT NULL COMMENT '付款类型 [UDC]PUR:PAD_TYPE',
  `pa_amt` decimal(20,8) DEFAULT NULL COMMENT '请款金额',
  `curr_amt` decimal(20,8) DEFAULT NULL COMMENT '采购订单金额',
  `curr_code` varchar(40) DEFAULT NULL COMMENT '币种',
  `curr_rate` decimal(20,8) DEFAULT NULL COMMENT '汇率',
  `curr_pa_amt` decimal(20,8) DEFAULT NULL COMMENT '外币预付金额',
  `home_curr` varchar(10) DEFAULT NULL COMMENT '本币币种',
  `plan_pay_date` datetime DEFAULT NULL COMMENT '预计付款日期',
  `due_date` datetime DEFAULT NULL COMMENT '账款到期日',
  `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `create_user_id_index` (`create_user_id`) USING BTREE,
  KEY `sec_bu_id_index` (`sec_bu_id`) USING BTREE,
  KEY `sec_user_id_index` (`sec_user_id`) USING BTREE,
  KEY `sec_ou_id_index` (`sec_ou_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='采购付款申请明细';

-- ----------------------------
-- Table structure for pur_pa_deduc
-- ----------------------------

CREATE TABLE `pur_pa_deduc` (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `sec_bu_id` bigint(20) DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) DEFAULT NULL COMMENT 'sec_ou_id',
  `mas_id` bigint(20) DEFAULT NULL COMMENT '主表ID PUR_PA.ID',
  `pa_id` bigint(20) DEFAULT '0' COMMENT '预付款单ID',
  `line_no` decimal(20,2) DEFAULT NULL COMMENT '行号',
  `deduc_type` varchar(40) DEFAULT NULL COMMENT '费用类型 [UDC]PUR:PAY_DEDUC_TYPE',
  `prom_id` bigint(20) DEFAULT NULL COMMENT '促销ID',
  `prom_no` varchar(40) DEFAULT NULL COMMENT '促销编号',
  `deduc_amt` decimal(20,8) DEFAULT NULL COMMENT '金额',
  `curr_code` varchar(40) DEFAULT NULL COMMENT '币种',
  `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `create_user_id_index` (`create_user_id`) USING BTREE,
  KEY `sec_bu_id_index` (`sec_bu_id`) USING BTREE,
  KEY `sec_user_id_index` (`sec_user_id`) USING BTREE,
  KEY `sec_ou_id_index` (`sec_ou_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='采购付款申请扣款';

-- ----------------------------
-- Table structure for pur_pa_docs
-- ----------------------------

CREATE TABLE `pur_pa_docs` (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `sec_bu_id` bigint(20) DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) DEFAULT NULL COMMENT 'sec_ou_id',
  `mas_id` bigint(20) DEFAULT NULL COMMENT '主表ID PUR_PA.ID',
  `doc_type` varchar(40) DEFAULT NULL COMMENT '文档类型 [UDC]ORG:ADDR_EXT_ES1',
  `doc_no` varchar(40) DEFAULT NULL COMMENT '文档编号',
  `doc_name` varchar(40) DEFAULT NULL COMMENT '文档名称',
  `doc_status` varchar(40) DEFAULT NULL COMMENT '文档状态',
  `doc_brief` varchar(100) DEFAULT NULL COMMENT '摘要信息',
  `manda_flag` int(1) DEFAULT NULL COMMENT '是否必需',
  `provide_date` datetime DEFAULT NULL COMMENT '提供日期',
  `pic_emp_id` bigint(20) DEFAULT NULL COMMENT '维护人员工ID',
  `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `create_user_id_index` (`create_user_id`) USING BTREE,
  KEY `sec_bu_id_index` (`sec_bu_id`) USING BTREE,
  KEY `sec_user_id_index` (`sec_user_id`) USING BTREE,
  KEY `sec_ou_id_index` (`sec_ou_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='采购付款申请文档';

-- ----------------------------
-- Table structure for pur_pa_files
-- ----------------------------

CREATE TABLE `pur_pa_files` (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `sec_bu_id` bigint(20) DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) DEFAULT NULL COMMENT 'sec_ou_id',
  `mas_id` bigint(20) DEFAULT NULL COMMENT '主表ID',
  `pa_id` bigint(20) DEFAULT NULL,
  `pa_file_name` varchar(40) DEFAULT NULL COMMENT '文件名称',
  `supp_type` varchar(10) DEFAULT NULL COMMENT '供应商单据类型',
  `file` varchar(2000) DEFAULT NULL COMMENT '合同条款附件编码',
  `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `create_user_id_index` (`create_user_id`) USING BTREE,
  KEY `sec_bu_id_index` (`sec_bu_id`) USING BTREE,
  KEY `sec_user_id_index` (`sec_user_id`) USING BTREE,
  KEY `sec_ou_id_index` (`sec_ou_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='预付款申请附件条款';

-- ----------------------------
-- Table structure for pur_pa_src
-- ----------------------------

CREATE TABLE `pur_pa_src` (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `sec_bu_id` bigint(20) DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) DEFAULT NULL COMMENT 'sec_ou_id',
  `mas_id` bigint(20) DEFAULT NULL COMMENT '主表ID PUR_PA.ID',
  `line_no` decimal(20,3) DEFAULT NULL COMMENT '行号',
  `relate_doc_cls` varchar(40) DEFAULT NULL COMMENT '关联单据类别 [UDC]采购单/收货单/退货单。COM:DOC_CLS',
  `relate_doc_type` varchar(40) DEFAULT NULL COMMENT '关联单据类型',
  `relate_doc_id` bigint(20) DEFAULT NULL COMMENT '关联单据ID',
  `relate_doc_no` varchar(40) DEFAULT NULL COMMENT '关联单据编号',
  `relate_doc_did` bigint(20) DEFAULT NULL COMMENT '关联单据明细ID',
  `relate_doc_lineno` decimal(20,3) DEFAULT NULL COMMENT '关联单据行号',
  `pa_qty` float(20,8) DEFAULT NULL COMMENT '付款数量',
  `pa_curr_amt` decimal(20,8) DEFAULT NULL COMMENT '付款外币含税金额',
  `pa_curr_netamt` decimal(20,8) DEFAULT NULL COMMENT '付款外币不含税金额',
  `pa_amt` decimal(20,8) DEFAULT NULL COMMENT '付款含税金额',
  `pa_net_amt` decimal(20,8) DEFAULT NULL COMMENT '付款不含税金额',
  `pa_tax_amt` decimal(20,8) DEFAULT NULL COMMENT '付款税额',
  `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `create_user_id_index` (`create_user_id`) USING BTREE,
  KEY `sec_bu_id_index` (`sec_bu_id`) USING BTREE,
  KEY `sec_user_id_index` (`sec_user_id`) USING BTREE,
  KEY `sec_ou_id_index` (`sec_ou_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='采购付款申请来源';

-- ----------------------------
-- Table structure for pur_parts_amount
-- ----------------------------

CREATE TABLE `pur_parts_amount` (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `sec_bu_id` bigint(20) DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) DEFAULT NULL COMMENT 'sec_ou_id',
  `ou_id` bigint(20) DEFAULT NULL COMMENT '额度公司ID',
  `ou_code` varchar(40) DEFAULT NULL COMMENT '额度公司编号',
  `ou_name` varchar(200) DEFAULT NULL COMMENT '额度公司名称',
  `com_size` varchar(40) DEFAULT NULL COMMENT '公司规模',
  `parts_amount` decimal(20,4) DEFAULT NULL COMMENT '配件铺底额度',
  `valid_from` date DEFAULT NULL COMMENT '生效日期',
  `valid_to` date DEFAULT NULL COMMENT '失效日期',
  `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
  `bu_id` bigint(20) DEFAULT NULL COMMENT 'BUID',
  `bu_code` varchar(40) DEFAULT NULL COMMENT 'BU编号',
  `bu_name` varchar(200) DEFAULT NULL COMMENT 'BU名称',
  `ou_id1` bigint(20) DEFAULT NULL COMMENT '额度公司ID',
  `ou_code1` varchar(40) DEFAULT NULL COMMENT '额度公司编号',
  `ou_name1` varchar(200) DEFAULT NULL COMMENT '额度公司名称',
  `item_id` bigint(20) DEFAULT NULL COMMENT '品项ID',
  `item_code` varchar(40) DEFAULT NULL COMMENT '品项编号',
  `item_code2` varchar(40) DEFAULT NULL COMMENT '第二编号',
  `item_code3` varchar(40) DEFAULT NULL COMMENT '第三编号',
  `item_name` varchar(100) DEFAULT NULL COMMENT '品项名称',
  `item_name2` varchar(100) DEFAULT NULL COMMENT '第二名称',
  `item_name3` varchar(100) DEFAULT NULL COMMENT '第三名称',
  `spec` varchar(40) DEFAULT NULL COMMENT '规格',
  `status` varchar(40) DEFAULT NULL COMMENT '状态',
  `proc_inst_id` varchar(255) DEFAULT NULL COMMENT '流程实例ID',
  `proc_inst_status` varchar(255) DEFAULT NULL COMMENT '流程实例状态',
  `submit_time` datetime(6) DEFAULT NULL COMMENT '提交时间',
  `approved_time` datetime(6) DEFAULT NULL COMMENT '审批通过时间',
  `mas_id` bigint(20) DEFAULT NULL COMMENT '主表ID',
  `update_status` varchar(40) DEFAULT NULL COMMENT '变更状态',
  `update_parts_amount` decimal(20,4) DEFAULT NULL COMMENT '变更前配件铺底额度',
  `update_id` bigint(20) DEFAULT NULL COMMENT '记录变更的ID',
  `up_date_status` varchar(40) DEFAULT NULL COMMENT '变更状态',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `create_user_id_index` (`create_user_id`) USING BTREE,
  KEY `sec_bu_id_index` (`sec_bu_id`) USING BTREE,
  KEY `sec_user_id_index` (`sec_user_id`) USING BTREE,
  KEY `sec_ou_id_index` (`sec_ou_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='配件铺底额度';

-- ----------------------------
-- Table structure for pur_parts_amount_h
-- ----------------------------

CREATE TABLE `pur_parts_amount_h` (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `doc_no` varchar(40) DEFAULT NULL COMMENT '单据号',
  `status` varchar(40) DEFAULT NULL COMMENT '状态',
  `proc_inst_id` varchar(255) DEFAULT NULL COMMENT '流程实例ID',
  `proc_inst_status` varchar(255) DEFAULT NULL COMMENT '流程实例状态',
  `submit_time` datetime(6) DEFAULT NULL COMMENT '提交时间',
  `approved_time` datetime(6) DEFAULT NULL COMMENT '审批通过时间',
  `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
  `sec_bu_id` bigint(20) DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) DEFAULT NULL COMMENT 'sec_ou_id',
  `update_flag` tinyint(1) DEFAULT '0' COMMENT '是否是变更单：1是，0否',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='配件铺底额度表头';

-- ----------------------------
-- Table structure for pur_parts_ratio
-- ----------------------------

CREATE TABLE `pur_parts_ratio` (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `sec_bu_id` bigint(20) DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) DEFAULT NULL COMMENT 'sec_ou_id',
  `ou_id` bigint(20) DEFAULT NULL COMMENT '公司ID',
  `ou_code` varchar(40) DEFAULT NULL COMMENT '公司编号',
  `ou_name` varchar(200) DEFAULT NULL COMMENT '公司名称',
  `bu_id` bigint(20) DEFAULT NULL COMMENT 'BUID',
  `bu_code` varchar(40) DEFAULT NULL COMMENT 'BU编号',
  `bu_name` varchar(200) DEFAULT NULL COMMENT 'BU名称',
  `supp_id` bigint(20) DEFAULT NULL COMMENT '供应商ID',
  `supp_code` varchar(40) DEFAULT NULL COMMENT '供应商编号',
  `supp_abbr` varchar(40) DEFAULT NULL COMMENT '供应商简称',
  `supp_name` varchar(200) DEFAULT NULL COMMENT '供应商名称',
  `item_id` bigint(20) DEFAULT NULL COMMENT '品项ID',
  `item_code` varchar(40) DEFAULT NULL COMMENT '品项编号',
  `item_code2` varchar(40) DEFAULT NULL COMMENT '第二编号',
  `item_code3` varchar(40) DEFAULT NULL COMMENT '第三编号',
  `item_name` varchar(100) DEFAULT NULL COMMENT '品项名称',
  `item_name2` varchar(100) DEFAULT NULL COMMENT '第二名称',
  `item_name3` varchar(100) DEFAULT NULL COMMENT '第三名称',
  `spec` varchar(40) DEFAULT NULL COMMENT '规格',
  `manuer_name` varchar(40) DEFAULT NULL COMMENT '厂家名称',
  `parts_ratio` double(20,8) DEFAULT NULL COMMENT '配件外购比例',
  `valid_from` date DEFAULT NULL COMMENT '生效日期',
  `valid_to` date DEFAULT NULL COMMENT '失效日期',
  `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
  `status` varchar(40) DEFAULT NULL COMMENT '状态',
  `proc_inst_id` varchar(255) DEFAULT NULL COMMENT '流程实例ID',
  `proc_inst_status` varchar(255) DEFAULT NULL COMMENT '流程实例状态',
  `submit_time` datetime(6) DEFAULT NULL COMMENT '提交时间',
  `approved_time` datetime(6) DEFAULT NULL COMMENT '审批通过时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `create_user_id_index` (`create_user_id`) USING BTREE,
  KEY `sec_bu_id_index` (`sec_bu_id`) USING BTREE,
  KEY `sec_user_id_index` (`sec_user_id`) USING BTREE,
  KEY `sec_ou_id_index` (`sec_ou_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='外购配件比例';

-- ----------------------------
-- Table structure for pur_parts_ratio_apply
-- ----------------------------

CREATE TABLE `pur_parts_ratio_apply` (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `doc_no` varchar(40) DEFAULT NULL COMMENT '单据编号',
  `doc_status` varchar(40) DEFAULT NULL COMMENT '单据状态',
  `proc_inst_id` varchar(255) DEFAULT NULL COMMENT '流程实例ID',
  `proc_inst_status` varchar(255) DEFAULT NULL COMMENT '流程实例状态',
  `submit_time` datetime(6) DEFAULT NULL COMMENT '提交时间',
  `approved_time` datetime(6) DEFAULT NULL COMMENT '审批通过时间',
  `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
  `sec_bu_id` bigint(20) DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) DEFAULT NULL COMMENT 'sec_ou_id',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='外购配件比例申请';

-- ----------------------------
-- Table structure for pur_parts_ratio_apply_d
-- ----------------------------

CREATE TABLE `pur_parts_ratio_apply_d` (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `mas_id` bigint(20) DEFAULT NULL COMMENT '主表ID PUR_PA.ID',
  `ou_id` bigint(20) DEFAULT NULL COMMENT '公司ID',
  `ou_code` varchar(40) DEFAULT NULL COMMENT '公司编号',
  `ou_name` varchar(200) DEFAULT NULL COMMENT '公司名称',
  `bu_id` bigint(20) DEFAULT NULL COMMENT 'BUID',
  `bu_code` varchar(40) DEFAULT NULL COMMENT 'BU编号',
  `bu_name` varchar(200) DEFAULT NULL COMMENT 'BU名称',
  `supp_id` bigint(20) DEFAULT NULL COMMENT '供应商ID',
  `supp_code` varchar(40) DEFAULT NULL COMMENT '供应商编号',
  `supp_abbr` varchar(40) DEFAULT NULL COMMENT '供应商简称',
  `supp_name` varchar(200) DEFAULT NULL COMMENT '供应商名称',
  `item_id` bigint(20) DEFAULT NULL COMMENT '品项ID',
  `item_code` varchar(40) DEFAULT NULL COMMENT '品项编号',
  `item_code2` varchar(40) DEFAULT NULL COMMENT '第二编号',
  `item_code3` varchar(40) DEFAULT NULL COMMENT '第三编号',
  `item_name` varchar(100) DEFAULT NULL COMMENT '品项名称',
  `item_name2` varchar(100) DEFAULT NULL COMMENT '第二名称',
  `item_name3` varchar(100) DEFAULT NULL COMMENT '第三名称',
  `spec` varchar(40) DEFAULT NULL COMMENT '规格',
  `manuer_name` varchar(40) DEFAULT NULL COMMENT '厂家名称',
  `parts_ratio` double(20,8) DEFAULT NULL COMMENT '配件外购比例',
  `valid_from` date DEFAULT NULL COMMENT '生效日期',
  `valid_to` date DEFAULT NULL COMMENT '失效日期',
  `status` varchar(40) DEFAULT NULL COMMENT '状态',
  `proc_inst_id` varchar(255) DEFAULT NULL COMMENT '流程实例ID',
  `proc_inst_status` varchar(255) DEFAULT NULL COMMENT '流程实例状态',
  `submit_time` datetime(6) DEFAULT NULL COMMENT '提交时间',
  `approved_time` datetime(6) DEFAULT NULL COMMENT '审批通过时间',
  `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
  `sec_bu_id` bigint(20) DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) DEFAULT NULL COMMENT 'sec_ou_id',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='外购配件比例申请明细';

-- ----------------------------
-- Table structure for pur_pay
-- ----------------------------

CREATE TABLE `pur_pay` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '记录唯一ID',
  `relation_number` varchar(32) DEFAULT NULL COMMENT '关联对账单号',
  `verify_off_advance` varchar(32) DEFAULT NULL COMMENT '核销预付',
  `verify_amount` decimal(20,4) DEFAULT NULL COMMENT '核销金额',
  `pay_amount` decimal(20,4) DEFAULT NULL COMMENT '支付金额',
  `no_pay_amount` decimal(20,4) DEFAULT NULL COMMENT '待付金额',
  `receive_entity` varchar(32) DEFAULT NULL COMMENT '收款对象',
  `contact_name` varchar(32) DEFAULT NULL COMMENT '往来对象名称',
  `account` varchar(32) DEFAULT NULL COMMENT '账户',
  `settle_entity_name` varchar(32) DEFAULT NULL COMMENT '结算主体',
  `pay_method` varchar(32) DEFAULT NULL COMMENT '付款方式',
  `plan_pay_time` datetime DEFAULT NULL COMMENT '计划付款日期',
  `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) DEFAULT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
  `pay_no` varchar(20) DEFAULT NULL,
  `contact_id` bigint(20) DEFAULT NULL,
  `settle_entity_id` bigint(20) DEFAULT NULL,
  `settle_cycle` varchar(20) DEFAULT NULL,
  `contract_no` varchar(20) DEFAULT NULL,
  `reimburse_no` varchar(20) DEFAULT NULL,
  `pre_flag` tinyint(1) DEFAULT NULL,
  `pre_settle_no` varchar(20) DEFAULT NULL,
  `pur_settle_id` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `create_user_id_index` (`create_user_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='采购付款信息';

-- ----------------------------
-- Table structure for pur_pc
-- ----------------------------

CREATE TABLE `pur_pc` (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `sec_bu_id` bigint(20) DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) DEFAULT NULL COMMENT 'sec_ou_id',
  `ou_id` bigint(20) DEFAULT NULL COMMENT '公司ID',
  `bu_id` bigint(20) DEFAULT NULL COMMENT 'BUID',
  `doc_no` varchar(40) DEFAULT NULL COMMENT '合同编号',
  `doc_name` varchar(40) DEFAULT NULL COMMENT '合同名称',
  `doc_type` varchar(10) DEFAULT NULL COMMENT '合同类型 [UDC]PUR:PC_TYPE',
  `doc_status` varchar(40) DEFAULT NULL COMMENT '合同状态 [UDC]PUR:PC_STATUS',
  `supp_bank` varchar(40) DEFAULT NULL COMMENT '开户银行',
  `bank_account` varchar(40) DEFAULT NULL COMMENT '银行账号',
  `pay_type` varchar(10) DEFAULT NULL COMMENT '付款方式 [UDC]PUR:PAY_TYPE',
  `cooperation_type` varchar(10) DEFAULT NULL COMMENT '合作方式 [UDC]PUR:COOPERATION_TYPE',
  `doc_date` datetime DEFAULT NULL COMMENT '签订日期',
  `supp_id` bigint(20) DEFAULT NULL COMMENT '供应商ID',
  `sign_date` datetime DEFAULT NULL COMMENT '签署日期',
  `valid_from` datetime DEFAULT NULL COMMENT '生效日期',
  `valid_to` datetime DEFAULT NULL COMMENT '失效日期',
  `determine_date` datetime DEFAULT NULL COMMENT '终止日期',
  `doc_emp_id` bigint(20) DEFAULT NULL COMMENT '合同负责人员工ID',
  `relate_doc_cls` varchar(40) DEFAULT NULL COMMENT '关联单据类别 [UDC]COM:DOC_CLS',
  `relate_doc_type` varchar(40) DEFAULT NULL COMMENT '关联单据类型',
  `relate_doc_id` bigint(20) DEFAULT NULL COMMENT '关联单据ID',
  `relate_doc_no` varchar(40) DEFAULT NULL COMMENT '关联单据编号',
  `relate_id` bigint(20) DEFAULT NULL COMMENT '关联ID',
  `relate_no` varchar(40) DEFAULT NULL COMMENT '关联编号',
  `relate2_id` bigint(20) DEFAULT NULL COMMENT '关联2ID',
  `relate2_no` varchar(40) DEFAULT NULL COMMENT '关联2编号',
  `file_code` varchar(2000) DEFAULT NULL COMMENT '文件服务器编码',
  `es1` varchar(40) DEFAULT NULL COMMENT 'ES1',
  `es2` varchar(40) DEFAULT NULL COMMENT 'ES2',
  `es3` varchar(40) DEFAULT NULL COMMENT 'ES3',
  `es4` varchar(40) DEFAULT NULL COMMENT 'ES4',
  `es5` varchar(40) DEFAULT NULL COMMENT 'ES5',
  `payment_term` varchar(40) DEFAULT NULL COMMENT '付款条款',
  `change_reason` varchar(200) DEFAULT NULL COMMENT '变更原因',
  `version_no` decimal(20,3) DEFAULT NULL COMMENT '行号',
  `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
  `proc_inst_id` varchar(255) DEFAULT NULL COMMENT '流程实例ID',
  `proc_inst_status` varchar(255) DEFAULT NULL COMMENT '流程实例状态',
  `submit_time` datetime(6) DEFAULT NULL COMMENT '提交时间',
  `approved_time` datetime(6) DEFAULT NULL COMMENT '审批通过时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `create_user_id_index` (`create_user_id`) USING BTREE,
  KEY `sec_bu_id_index` (`sec_bu_id`) USING BTREE,
  KEY `sec_user_id_index` (`sec_user_id`) USING BTREE,
  KEY `sec_ou_id_index` (`sec_ou_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='采购合同';

-- ----------------------------
-- Table structure for pur_pc_terms
-- ----------------------------

CREATE TABLE `pur_pc_terms` (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `sec_bu_id` bigint(20) DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) DEFAULT NULL COMMENT 'sec_ou_id',
  `mas_id` bigint(20) DEFAULT NULL COMMENT '主表ID',
  `line_no` decimal(20,3) DEFAULT NULL COMMENT '行号',
  `term_name` varchar(40) DEFAULT NULL COMMENT '条款名称',
  `term_content` varchar(200) DEFAULT NULL COMMENT '条款内容',
  `term_type` varchar(10) DEFAULT NULL COMMENT '条款类型',
  `file` varchar(2000) DEFAULT NULL COMMENT '合同条款附件编码',
  `version_no` decimal(20,3) DEFAULT NULL COMMENT '行号',
  `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `create_user_id_index` (`create_user_id`) USING BTREE,
  KEY `sec_bu_id_index` (`sec_bu_id`) USING BTREE,
  KEY `sec_user_id_index` (`sec_user_id`) USING BTREE,
  KEY `sec_ou_id_index` (`sec_ou_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='采购合同条款';

-- ----------------------------
-- Table structure for pur_po
-- ----------------------------

CREATE TABLE `pur_po` (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `sec_bu_id` bigint(20) DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) DEFAULT NULL COMMENT 'sec_ou_id',
  `ou_id` bigint(20) DEFAULT '0' COMMENT '公司ID',
  `pa_id` bigint(20) DEFAULT '0' COMMENT '预付款单ID',
  `line_no` decimal(20,2) DEFAULT NULL COMMENT '行号',
  `bu_id` bigint(20) DEFAULT '0' COMMENT 'BUID',
  `bd_id` bigint(20) DEFAULT '0' COMMENT '事业部ID',
  `supp_id` bigint(20) DEFAULT '0' COMMENT '供应商ID',
  `supp_code` varchar(40) DEFAULT NULL COMMENT '供应商编号',
  `supp_contact_name` varchar(40) DEFAULT NULL COMMENT '供应商联系人',
  `supp_contact_tel` varchar(40) DEFAULT NULL COMMENT '供应商联系电话',
  `supp_contact_email` varchar(40) DEFAULT NULL COMMENT '供应商联系人邮箱',
  `doc_no` varchar(40) DEFAULT NULL COMMENT '单据编号',
  `doc_no2` varchar(40) DEFAULT NULL COMMENT '单据编号2',
  `doc_type` varchar(10) DEFAULT NULL COMMENT '单据类型 [UDC]PUR:PO_TYPE',
  `doc_type2` varchar(10) DEFAULT NULL COMMENT '单据类型2 [UDC]PUR:PO_TYPE2',
  `scene_type_id` bigint(20) DEFAULT '0' COMMENT '采购场景类型ID',
  `doc_type3` varchar(10) DEFAULT NULL COMMENT '单据类型3',
  `doc_status` varchar(40) DEFAULT NULL COMMENT '单据状态 [UDC]PUR:PO_STATUS',
  `doc_status2` varchar(40) DEFAULT NULL COMMENT '单据状态2',
  `doc_status3` varchar(40) DEFAULT NULL COMMENT '单据状态3',
  `appr_proc_inst_id` varchar(40) DEFAULT NULL COMMENT '流程实例ID',
  `appr_status` varchar(40) DEFAULT NULL COMMENT '审批状态 [UDC]COM:APPR_STATUS',
  `appr_time` datetime DEFAULT NULL COMMENT '审批时间',
  `appr_user_id` bigint(20) DEFAULT '0' COMMENT '审批人ID',
  `appr_comment` varchar(500) DEFAULT NULL COMMENT '审批意见',
  `finish_comment` varchar(500) DEFAULT NULL COMMENT '订单完成备注',
  `doc_time` datetime DEFAULT NULL COMMENT '订单时间',
  `hold_reason_code` varchar(40) DEFAULT NULL COMMENT '暂挂原因码 [UDC]PUR:PO_HOLD_REASON',
  `hold_time` datetime DEFAULT NULL COMMENT '暂挂时间',
  `hold_reason_desc` varchar(40) DEFAULT NULL COMMENT '暂挂描述',
  `agent_emp_id` bigint(20) DEFAULT '0' COMMENT '采购员员工ID',
  `merch_emp_id` bigint(20) DEFAULT '0' COMMENT '跟单员员工ID',
  `region` varchar(40) DEFAULT NULL COMMENT '区域',
  `req_dept` varchar(40) DEFAULT NULL COMMENT '要求部门',
  `proj_no` varchar(10) DEFAULT NULL COMMENT '项目号',
  `proj_name` varchar(100) DEFAULT NULL COMMENT '项目名称',
  `po_source` varchar(40) DEFAULT NULL COMMENT '采购来源',
  `po_mode` varchar(10) DEFAULT NULL COMMENT '采购方式',
  `crosswh_flag` int(18) DEFAULT NULL COMMENT '越库标识',
  `thirdpl_flag` int(18) DEFAULT NULL COMMENT '是否直连',
  `need_prepay_flag` int(10) DEFAULT NULL COMMENT '是否需要预付款',
  `home_curr` varchar(40) DEFAULT NULL COMMENT '本币币种',
  `curr_code` varchar(40) DEFAULT NULL COMMENT '币种',
  `curr_rate` decimal(20,8) DEFAULT NULL COMMENT '汇率',
  `tax_incl_flag` int(10) DEFAULT NULL COMMENT '是否含税',
  `tax_code` varchar(40) DEFAULT NULL COMMENT '税码',
  `tax_rate_no` varchar(40) DEFAULT NULL COMMENT '税率编号',
  `tax_rate` decimal(20,8) DEFAULT NULL COMMENT '税率',
  `tax_amt` decimal(20,2) DEFAULT NULL COMMENT '税额',
  `amt` decimal(20,8) DEFAULT NULL COMMENT '含税总金额',
  `net_amt` decimal(20,8) DEFAULT NULL COMMENT '未税总金额',
  `curr_amt` decimal(20,8) DEFAULT NULL COMMENT '外币含税金额',
  `curr_net_amt` decimal(20,8) DEFAULT NULL COMMENT '外币不含税金额',
  `prepaid_amt` decimal(20,8) DEFAULT NULL COMMENT '已预付金额（含税）',
  `remian_amt` decimal(20,8) DEFAULT NULL COMMENT '剩余可付金额（含税）',
  `qty` decimal(20,8) DEFAULT NULL COMMENT '总数量',
  `qty_uom` varchar(10) DEFAULT NULL COMMENT '数量单位',
  `qty2` decimal(20,8) DEFAULT NULL COMMENT '总数量2',
  `qty2_uom` varchar(10) DEFAULT NULL COMMENT '数量2单位',
  `accept_qty` decimal(20,8) DEFAULT NULL COMMENT '已收数量',
  `accept_uom` varchar(10) DEFAULT NULL COMMENT '已收单位',
  `shipped_qty` decimal(20,8) DEFAULT NULL COMMENT '发货数量',
  `shipment_uom` varchar(10) DEFAULT NULL COMMENT '发货单位',
  `net_weight` decimal(20,8) DEFAULT NULL COMMENT '净重',
  `gross_weight` decimal(20,8) DEFAULT NULL COMMENT '毛重',
  `weight_uom` varchar(10) DEFAULT NULL COMMENT '重量单位',
  `volume` decimal(20,8) DEFAULT NULL COMMENT '体积',
  `volume_uom` varchar(10) DEFAULT NULL COMMENT '体积单位',
  `payment_term` varchar(40) DEFAULT NULL COMMENT '付款条款',
  `moq_id` bigint(20) DEFAULT '0' COMMENT 'MOQID',
  `logis_status` varchar(40) DEFAULT NULL COMMENT '物流状态',
  `overdue_status` varchar(40) DEFAULT NULL COMMENT '延交状态',
  `recv_status` varchar(40) DEFAULT NULL COMMENT '收货状态',
  `demand_fresh_percent` decimal(20,8) DEFAULT NULL COMMENT '要求保质期比例',
  `demand_aap_days` int(10) DEFAULT NULL COMMENT '要求效期天数',
  `orig_date` datetime DEFAULT NULL COMMENT '原始交期',
  `prepaid_date` datetime DEFAULT NULL COMMENT '预计付款日期',
  `due_date` datetime DEFAULT NULL COMMENT '账款到期日',
  `demand_date` datetime DEFAULT NULL COMMENT '要求交期',
  `promise_date` datetime DEFAULT NULL COMMENT '供应商承诺交期',
  `demand_confirm_time` datetime DEFAULT NULL COMMENT '要求供应商确认时间',
  `supp_sign_status` varchar(40) DEFAULT NULL COMMENT '供应商回签状态',
  `supp_confirm_time` datetime DEFAULT NULL COMMENT '供应商确认时间',
  `supp_confirm_userid` bigint(20) DEFAULT '0' COMMENT '供应商确认用户ID',
  `supp_remark` varchar(500) DEFAULT NULL COMMENT '供应商反馈',
  `shipment_type` varchar(40) DEFAULT NULL COMMENT '发运类型',
  `trans_type` varchar(40) DEFAULT NULL COMMENT '运输方式 [UDC]COM:TP_TYPE',
  `transport_temp` varchar(40) DEFAULT NULL COMMENT '运输温层 [UDC]INV:TRANSPORT_TEMP',
  `wh_id` bigint(20) DEFAULT '0' COMMENT '收货仓库ID',
  `wh_contact_name` varchar(40) DEFAULT NULL COMMENT '收货仓库联系人',
  `wh_contact_tel` varchar(40) DEFAULT NULL COMMENT '收货仓库联系人电话',
  `wh_contact_email` varchar(40) DEFAULT NULL COMMENT '收货仓库联系人邮箱',
  `shipment_instruct` varchar(100) DEFAULT NULL COMMENT '交货要求',
  `shipment_instruct2` varchar(100) DEFAULT NULL COMMENT '交货要求2',
  `shipment_addr_no` int(10) DEFAULT NULL COMMENT '发运地址号',
  `shipment_contact_name` varchar(40) DEFAULT NULL COMMENT '发运联系人',
  `shipment_contact_tel` varchar(40) DEFAULT NULL COMMENT '发运联系电话',
  `shipment_contact_email` varchar(40) DEFAULT NULL COMMENT '发运联系人邮箱',
  `shipment_country` varchar(40) DEFAULT NULL COMMENT '发运国家',
  `shipment_province` varchar(10) DEFAULT NULL COMMENT '发运省',
  `shipment_city` varchar(10) DEFAULT NULL COMMENT '发运市',
  `shipment_county` varchar(40) DEFAULT NULL COMMENT '发运区县',
  `shipment_street` varchar(40) DEFAULT NULL COMMENT '发运乡镇街道',
  `shipment_detailaddr` varchar(100) DEFAULT NULL COMMENT '发运详细地址',
  `carrier_supp_id` bigint(20) DEFAULT '0' COMMENT '承运商供应商ID',
  `carrier` varchar(40) DEFAULT NULL COMMENT '承运商',
  `from_loc` varchar(40) DEFAULT NULL COMMENT '从地点 [UOM]COM:CITY',
  `to_loc` varchar(40) DEFAULT NULL COMMENT '到地点 [UOM]COM:CITY',
  `accept_ou_id` bigint(20) DEFAULT '0' COMMENT '收货单位ID',
  `recv_port` varchar(40) DEFAULT NULL COMMENT '到达港口 [UDC]COM:TP_PORT',
  `recv_addr` varchar(400) DEFAULT NULL COMMENT '收货地址',
  `return_addr` varchar(400) DEFAULT NULL COMMENT '退货地址',
  `urgent_flag` int(10) DEFAULT NULL COMMENT '是否加急',
  `allow_ahead_flag` int(10) DEFAULT NULL COMMENT '是否允许早交',
  `recv_tolerance` decimal(10,2) DEFAULT NULL COMMENT '收货允差',
  `recv_tolerance2` decimal(10,2) DEFAULT NULL COMMENT '收货允差2',
  `pr_id` bigint(20) DEFAULT '0' COMMENT '采购申请ID',
  `pr_no` varchar(40) DEFAULT NULL COMMENT '采购申请单号',
  `pp_id` bigint(20) DEFAULT '0' COMMENT '采购计划ID',
  `pp_versoin` varchar(40) DEFAULT NULL COMMENT '采购计划版本号',
  `contract_id` bigint(20) DEFAULT '0' COMMENT '合同ID',
  `contract_no` varchar(40) DEFAULT NULL COMMENT '合同编号',
  `supp_contract_no` varchar(40) DEFAULT NULL COMMENT '供方合同号',
  `supp_doc_no` varchar(40) DEFAULT NULL COMMENT '供方单号',
  `prma_id` bigint(20) DEFAULT '0' COMMENT '采购RMA_ID',
  `cancel_qty` decimal(20,8) DEFAULT NULL COMMENT '取消数量',
  `cancel_time` datetime DEFAULT NULL COMMENT '取消时间',
  `cancel_reason` varchar(40) DEFAULT NULL COMMENT '取消原因',
  `cancel_user_id` bigint(20) DEFAULT '0' COMMENT '取消用户ID',
  `close_date` datetime DEFAULT NULL COMMENT '关闭日期',
  `close_reason` varchar(40) DEFAULT NULL COMMENT '关闭原因',
  `close_user_id` bigint(20) DEFAULT '0' COMMENT '关闭用户ID',
  `complete_status` varchar(40) DEFAULT NULL COMMENT '完成状态',
  `gen_type` varchar(40) DEFAULT NULL COMMENT '生成类型',
  `relate_doc_cls` varchar(40) DEFAULT NULL COMMENT '关联单据类别 来源销售单等。[UDC]COM:DOC_CLS',
  `relate_doc_type` varchar(40) DEFAULT NULL COMMENT '关联单据类型',
  `relate_doc_id` bigint(20) DEFAULT '0' COMMENT '关联单据ID',
  `relate_doc_no` varchar(40) DEFAULT NULL COMMENT '关联单据编号',
  `relate_doc2_cls` varchar(40) DEFAULT NULL COMMENT '关联单据2类别 [UDC]COM:DOC_CLS',
  `relate_doc2_type` varchar(40) DEFAULT NULL COMMENT '关联单据2类型',
  `relate_doc2_id` bigint(20) DEFAULT '0' COMMENT '关联单据2ID',
  `relate_doc2_no` varchar(40) DEFAULT NULL COMMENT '关联单据2编号',
  `realte_id` bigint(20) DEFAULT '0' COMMENT '关联ID',
  `realte_no` varchar(40) DEFAULT NULL COMMENT '关联编号',
  `realte2_id` bigint(20) DEFAULT '0' COMMENT '关联2ID',
  `realte2_no` varchar(40) DEFAULT NULL COMMENT '关联2编号',
  `remark2` varchar(200) DEFAULT NULL COMMENT '备注2 货柜',
  `intf_flag` int(1) DEFAULT NULL COMMENT '是否走接口',
  `deter2` varchar(40) DEFAULT NULL COMMENT '功能区 [UDC]INV:FUNC_TYPE',
  `es1` varchar(40) DEFAULT NULL COMMENT 'ES1',
  `es2` varchar(40) DEFAULT NULL COMMENT 'ES2',
  `es3` varchar(40) DEFAULT NULL COMMENT 'ES3',
  `es4` varchar(40) DEFAULT NULL COMMENT 'ES4',
  `es5` varchar(40) DEFAULT NULL COMMENT 'ES5',
  `es6` varchar(40) DEFAULT NULL COMMENT 'ES6',
  `es7` varchar(40) DEFAULT NULL COMMENT 'ES7',
  `es8` varchar(40) DEFAULT NULL COMMENT 'ES8',
  `es9` varchar(40) DEFAULT NULL COMMENT 'ES9',
  `es10` varchar(40) DEFAULT NULL COMMENT 'ES10',
  `en1` decimal(20,2) DEFAULT NULL COMMENT 'EN1',
  `en2` decimal(20,2) DEFAULT NULL COMMENT 'EN2',
  `en3` decimal(20,2) DEFAULT NULL COMMENT 'EN3',
  `en4` decimal(20,2) DEFAULT NULL COMMENT 'EN4',
  `en5` decimal(20,2) DEFAULT NULL COMMENT 'EN5',
  `ed1` datetime DEFAULT NULL COMMENT 'ED1',
  `ed2` datetime DEFAULT NULL COMMENT 'ED2',
  `ed3` datetime DEFAULT NULL COMMENT 'ED3',
  `zeroval_type` varchar(40) DEFAULT NULL COMMENT '免值标记',
  `orig_qty` decimal(20,8) DEFAULT NULL COMMENT '原始参考数量',
  `orig_net_amt` decimal(20,8) DEFAULT NULL COMMENT '原始参考金额',
  `sal_so_flag` tinyint(1) DEFAULT '0' COMMENT '团内订单是否已转销售订单：1是，0否',
  `sal_so_id` bigint(20) DEFAULT NULL COMMENT '销售订单ID',
  `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(300) DEFAULT NULL,
  `create_user_id` bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
  `proc_inst_id` varchar(40) DEFAULT NULL COMMENT '流程实例ID',
  `proc_inst_status` varchar(255) DEFAULT NULL COMMENT '流程实例状态',
  `submit_time` datetime(6) DEFAULT NULL COMMENT '提交时间',
  `approved_time` datetime(6) DEFAULT NULL COMMENT '审批通过时间',
  `supp_confirm_status` varchar(10) DEFAULT NULL COMMENT '供应商确认状态',
  `sal_doc_date` date DEFAULT NULL COMMENT '发货单日期',
  `cust_id` bigint(20) DEFAULT '0' COMMENT '客户ID',
  `cust_name` varchar(40) DEFAULT NULL COMMENT '供应商联系人',
  `root_doc_cls` varchar(40) DEFAULT NULL COMMENT '来源单据类别[UDC]COM:DOC_CLS]',
  `root_doc_type` varchar(40) DEFAULT NULL COMMENT '来源单据类型',
  `root_doc_id` bigint(20) DEFAULT '0' COMMENT '来源单据ID',
  `root_doc_no` varchar(40) DEFAULT NULL COMMENT '来源单据编号',
  `root_doc_did` bigint(20) DEFAULT '0' COMMENT '来源单据明细ID',
  `fin3` varchar(255) DEFAULT NULL,
  `finish_flag` int(1) DEFAULT '0' COMMENT '是否订单完成',
  `rejected_qty` decimal(20,8) DEFAULT NULL COMMENT '已拒收数量',
  `fin_batch_number` varchar(200) DEFAULT NULL COMMENT '批次号',
  `fin_voucher_no` varchar(200) DEFAULT NULL COMMENT '回传凭证号',
  `sync_status` varchar(40) DEFAULT NULL COMMENT '传输状态',
  `sync_time` datetime DEFAULT NULL COMMENT '传输时间',
  `sync_fail_reason` varchar(2000) DEFAULT NULL COMMENT '失败原因',
  `sell_method` varchar(20) DEFAULT NULL COMMENT '出货方式',
  `use_parts_flag` varchar(2) DEFAULT NULL COMMENT '使用配额标识',
  `jyc_type` varchar(2) DEFAULT NULL COMMENT '京云仓订单类型',
  `recv_addr_method` varchar(10) DEFAULT NULL COMMENT '地址填写方式',
  `recv_addr_type` varchar(10) DEFAULT NULL COMMENT '收货地址类型',
  `province` varchar(10) DEFAULT NULL COMMENT '省',
  `city` varchar(10) DEFAULT NULL COMMENT '市',
  `county` varchar(10) DEFAULT NULL COMMENT '区',
  `recv_contact_name` varchar(100) DEFAULT NULL COMMENT '收货联系人姓名',
  `recv_contact_phone` varchar(100) DEFAULT NULL COMMENT '收货联系人电话',
  `recv_store_code` varchar(40) DEFAULT NULL COMMENT '收货门店编码',
  `recv_store_name` varchar(200) DEFAULT NULL COMMENT '收货门店名称',
  `country` varchar(40) DEFAULT NULL COMMENT '国家',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `create_user_id_index` (`create_user_id`) USING BTREE,
  KEY `sec_bu_id_index` (`sec_bu_id`) USING BTREE,
  KEY `sec_user_id_index` (`sec_user_id`) USING BTREE,
  KEY `sec_ou_id_index` (`sec_ou_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='采购订单';

-- ----------------------------
-- Table structure for pur_po_0908
-- ----------------------------

CREATE TABLE `pur_po_0908` (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `sec_bu_id` bigint(20) DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) DEFAULT NULL COMMENT 'sec_ou_id',
  `ou_id` bigint(20) DEFAULT '0' COMMENT '公司ID',
  `pa_id` bigint(20) DEFAULT '0' COMMENT '预付款单ID',
  `line_no` decimal(20,2) DEFAULT NULL COMMENT '行号',
  `bu_id` bigint(20) DEFAULT '0' COMMENT 'BUID',
  `bd_id` bigint(20) DEFAULT '0' COMMENT '事业部ID',
  `supp_id` bigint(20) DEFAULT '0' COMMENT '供应商ID',
  `supp_code` varchar(40) DEFAULT NULL COMMENT '供应商编号',
  `supp_contact_name` varchar(40) DEFAULT NULL COMMENT '供应商联系人',
  `supp_contact_tel` varchar(40) DEFAULT NULL COMMENT '供应商联系电话',
  `supp_contact_email` varchar(40) DEFAULT NULL COMMENT '供应商联系人邮箱',
  `doc_no` varchar(40) DEFAULT NULL COMMENT '单据编号',
  `doc_no2` varchar(40) DEFAULT NULL COMMENT '单据编号2',
  `doc_type` varchar(10) DEFAULT NULL COMMENT '单据类型 [UDC]PUR:PO_TYPE',
  `doc_type2` varchar(10) DEFAULT NULL COMMENT '单据类型2 [UDC]PUR:PO_TYPE2',
  `scene_type_id` bigint(20) DEFAULT '0' COMMENT '采购场景类型ID',
  `doc_type3` varchar(10) DEFAULT NULL COMMENT '单据类型3',
  `doc_status` varchar(40) DEFAULT NULL COMMENT '单据状态 [UDC]PUR:PO_STATUS',
  `doc_status2` varchar(40) DEFAULT NULL COMMENT '单据状态2',
  `doc_status3` varchar(40) DEFAULT NULL COMMENT '单据状态3',
  `appr_proc_inst_id` varchar(40) DEFAULT NULL COMMENT '流程实例ID',
  `appr_status` varchar(40) DEFAULT NULL COMMENT '审批状态 [UDC]COM:APPR_STATUS',
  `appr_time` datetime DEFAULT NULL COMMENT '审批时间',
  `appr_user_id` bigint(20) DEFAULT '0' COMMENT '审批人ID',
  `appr_comment` varchar(500) DEFAULT NULL COMMENT '审批意见',
  `finish_comment` varchar(500) DEFAULT NULL COMMENT '订单完成备注',
  `doc_time` datetime DEFAULT NULL COMMENT '订单时间',
  `hold_reason_code` varchar(40) DEFAULT NULL COMMENT '暂挂原因码 [UDC]PUR:PO_HOLD_REASON',
  `hold_time` datetime DEFAULT NULL COMMENT '暂挂时间',
  `hold_reason_desc` varchar(40) DEFAULT NULL COMMENT '暂挂描述',
  `agent_emp_id` bigint(20) DEFAULT '0' COMMENT '采购员员工ID',
  `merch_emp_id` bigint(20) DEFAULT '0' COMMENT '跟单员员工ID',
  `region` varchar(40) DEFAULT NULL COMMENT '区域',
  `req_dept` varchar(40) DEFAULT NULL COMMENT '要求部门',
  `proj_no` varchar(10) DEFAULT NULL COMMENT '项目号',
  `proj_name` varchar(100) DEFAULT NULL COMMENT '项目名称',
  `po_source` varchar(40) DEFAULT NULL COMMENT '采购来源',
  `po_mode` varchar(10) DEFAULT NULL COMMENT '采购方式',
  `crosswh_flag` int(18) DEFAULT NULL COMMENT '越库标识',
  `thirdpl_flag` int(18) DEFAULT NULL COMMENT '是否直连',
  `need_prepay_flag` int(10) DEFAULT NULL COMMENT '是否需要预付款',
  `home_curr` varchar(40) DEFAULT NULL COMMENT '本币币种',
  `curr_code` varchar(40) DEFAULT NULL COMMENT '币种',
  `curr_rate` decimal(20,8) DEFAULT NULL COMMENT '汇率',
  `tax_incl_flag` int(10) DEFAULT NULL COMMENT '是否含税',
  `tax_code` varchar(40) DEFAULT NULL COMMENT '税码',
  `tax_rate_no` varchar(40) DEFAULT NULL COMMENT '税率编号',
  `tax_rate` decimal(20,8) DEFAULT NULL COMMENT '税率',
  `tax_amt` decimal(20,2) DEFAULT NULL COMMENT '税额',
  `amt` decimal(20,8) DEFAULT NULL COMMENT '含税总金额',
  `net_amt` decimal(20,8) DEFAULT NULL COMMENT '未税总金额',
  `curr_amt` decimal(20,8) DEFAULT NULL COMMENT '外币含税金额',
  `curr_net_amt` decimal(20,8) DEFAULT NULL COMMENT '外币不含税金额',
  `prepaid_amt` decimal(20,8) DEFAULT NULL COMMENT '已预付金额（含税）',
  `remian_amt` decimal(20,8) DEFAULT NULL COMMENT '剩余可付金额（含税）',
  `qty` decimal(20,8) DEFAULT NULL COMMENT '总数量',
  `qty_uom` varchar(10) DEFAULT NULL COMMENT '数量单位',
  `qty2` decimal(20,8) DEFAULT NULL COMMENT '总数量2',
  `qty2_uom` varchar(10) DEFAULT NULL COMMENT '数量2单位',
  `accept_qty` decimal(20,8) DEFAULT NULL COMMENT '已收数量',
  `accept_uom` varchar(10) DEFAULT NULL COMMENT '已收单位',
  `shipped_qty` decimal(20,8) DEFAULT NULL COMMENT '发货数量',
  `shipment_uom` varchar(10) DEFAULT NULL COMMENT '发货单位',
  `net_weight` decimal(20,8) DEFAULT NULL COMMENT '净重',
  `gross_weight` decimal(20,8) DEFAULT NULL COMMENT '毛重',
  `weight_uom` varchar(10) DEFAULT NULL COMMENT '重量单位',
  `volume` decimal(20,8) DEFAULT NULL COMMENT '体积',
  `volume_uom` varchar(10) DEFAULT NULL COMMENT '体积单位',
  `payment_term` varchar(40) DEFAULT NULL COMMENT '付款条款',
  `moq_id` bigint(20) DEFAULT '0' COMMENT 'MOQID',
  `logis_status` varchar(40) DEFAULT NULL COMMENT '物流状态',
  `overdue_status` varchar(40) DEFAULT NULL COMMENT '延交状态',
  `recv_status` varchar(40) DEFAULT NULL COMMENT '收货状态',
  `demand_fresh_percent` decimal(20,8) DEFAULT NULL COMMENT '要求保质期比例',
  `demand_aap_days` int(10) DEFAULT NULL COMMENT '要求效期天数',
  `orig_date` datetime DEFAULT NULL COMMENT '原始交期',
  `prepaid_date` datetime DEFAULT NULL COMMENT '预计付款日期',
  `due_date` datetime DEFAULT NULL COMMENT '账款到期日',
  `demand_date` datetime DEFAULT NULL COMMENT '要求交期',
  `promise_date` datetime DEFAULT NULL COMMENT '供应商承诺交期',
  `demand_confirm_time` datetime DEFAULT NULL COMMENT '要求供应商确认时间',
  `supp_sign_status` varchar(40) DEFAULT NULL COMMENT '供应商回签状态',
  `supp_confirm_time` datetime DEFAULT NULL COMMENT '供应商确认时间',
  `supp_confirm_userid` bigint(20) DEFAULT '0' COMMENT '供应商确认用户ID',
  `supp_remark` varchar(500) DEFAULT NULL COMMENT '供应商反馈',
  `shipment_type` varchar(40) DEFAULT NULL COMMENT '发运类型',
  `trans_type` varchar(40) DEFAULT NULL COMMENT '运输方式 [UDC]COM:TP_TYPE',
  `transport_temp` varchar(40) DEFAULT NULL COMMENT '运输温层 [UDC]INV:TRANSPORT_TEMP',
  `wh_id` bigint(20) DEFAULT '0' COMMENT '收货仓库ID',
  `wh_contact_name` varchar(40) DEFAULT NULL COMMENT '收货仓库联系人',
  `wh_contact_tel` varchar(40) DEFAULT NULL COMMENT '收货仓库联系人电话',
  `wh_contact_email` varchar(40) DEFAULT NULL COMMENT '收货仓库联系人邮箱',
  `shipment_instruct` varchar(100) DEFAULT NULL COMMENT '交货要求',
  `shipment_instruct2` varchar(100) DEFAULT NULL COMMENT '交货要求2',
  `shipment_addr_no` int(10) DEFAULT NULL COMMENT '发运地址号',
  `shipment_contact_name` varchar(40) DEFAULT NULL COMMENT '发运联系人',
  `shipment_contact_tel` varchar(40) DEFAULT NULL COMMENT '发运联系电话',
  `shipment_contact_email` varchar(40) DEFAULT NULL COMMENT '发运联系人邮箱',
  `shipment_country` varchar(40) DEFAULT NULL COMMENT '发运国家',
  `shipment_province` varchar(10) DEFAULT NULL COMMENT '发运省',
  `shipment_city` varchar(10) DEFAULT NULL COMMENT '发运市',
  `shipment_county` varchar(40) DEFAULT NULL COMMENT '发运区县',
  `shipment_street` varchar(40) DEFAULT NULL COMMENT '发运乡镇街道',
  `shipment_detailaddr` varchar(100) DEFAULT NULL COMMENT '发运详细地址',
  `carrier_supp_id` bigint(20) DEFAULT '0' COMMENT '承运商供应商ID',
  `carrier` varchar(40) DEFAULT NULL COMMENT '承运商',
  `from_loc` varchar(40) DEFAULT NULL COMMENT '从地点 [UOM]COM:CITY',
  `to_loc` varchar(40) DEFAULT NULL COMMENT '到地点 [UOM]COM:CITY',
  `accept_ou_id` bigint(20) DEFAULT '0' COMMENT '收货单位ID',
  `recv_port` varchar(40) DEFAULT NULL COMMENT '到达港口 [UDC]COM:TP_PORT',
  `recv_addr` varchar(400) DEFAULT NULL COMMENT '收货地址',
  `return_addr` varchar(400) DEFAULT NULL COMMENT '退货地址',
  `urgent_flag` int(10) DEFAULT NULL COMMENT '是否加急',
  `allow_ahead_flag` int(10) DEFAULT NULL COMMENT '是否允许早交',
  `recv_tolerance` decimal(10,2) DEFAULT NULL COMMENT '收货允差',
  `recv_tolerance2` decimal(10,2) DEFAULT NULL COMMENT '收货允差2',
  `pr_id` bigint(20) DEFAULT '0' COMMENT '采购申请ID',
  `pr_no` varchar(40) DEFAULT NULL COMMENT '采购申请单号',
  `pp_id` bigint(20) DEFAULT '0' COMMENT '采购计划ID',
  `pp_versoin` varchar(40) DEFAULT NULL COMMENT '采购计划版本号',
  `contract_id` bigint(20) DEFAULT '0' COMMENT '合同ID',
  `contract_no` varchar(40) DEFAULT NULL COMMENT '合同编号',
  `supp_contract_no` varchar(40) DEFAULT NULL COMMENT '供方合同号',
  `supp_doc_no` varchar(40) DEFAULT NULL COMMENT '供方单号',
  `prma_id` bigint(20) DEFAULT '0' COMMENT '采购RMA_ID',
  `cancel_qty` decimal(20,8) DEFAULT NULL COMMENT '取消数量',
  `cancel_time` datetime DEFAULT NULL COMMENT '取消时间',
  `cancel_reason` varchar(40) DEFAULT NULL COMMENT '取消原因',
  `cancel_user_id` bigint(20) DEFAULT '0' COMMENT '取消用户ID',
  `close_date` datetime DEFAULT NULL COMMENT '关闭日期',
  `close_reason` varchar(40) DEFAULT NULL COMMENT '关闭原因',
  `close_user_id` bigint(20) DEFAULT '0' COMMENT '关闭用户ID',
  `complete_status` varchar(40) DEFAULT NULL COMMENT '完成状态',
  `gen_type` varchar(40) DEFAULT NULL COMMENT '生成类型',
  `relate_doc_cls` varchar(40) DEFAULT NULL COMMENT '关联单据类别 来源销售单等。[UDC]COM:DOC_CLS',
  `relate_doc_type` varchar(40) DEFAULT NULL COMMENT '关联单据类型',
  `relate_doc_id` bigint(20) DEFAULT '0' COMMENT '关联单据ID',
  `relate_doc_no` varchar(40) DEFAULT NULL COMMENT '关联单据编号',
  `relate_doc2_cls` varchar(40) DEFAULT NULL COMMENT '关联单据2类别 [UDC]COM:DOC_CLS',
  `relate_doc2_type` varchar(40) DEFAULT NULL COMMENT '关联单据2类型',
  `relate_doc2_id` bigint(20) DEFAULT '0' COMMENT '关联单据2ID',
  `relate_doc2_no` varchar(40) DEFAULT NULL COMMENT '关联单据2编号',
  `realte_id` bigint(20) DEFAULT '0' COMMENT '关联ID',
  `realte_no` varchar(40) DEFAULT NULL COMMENT '关联编号',
  `realte2_id` bigint(20) DEFAULT '0' COMMENT '关联2ID',
  `realte2_no` varchar(40) DEFAULT NULL COMMENT '关联2编号',
  `remark2` varchar(200) DEFAULT NULL COMMENT '备注2 货柜',
  `intf_flag` int(1) DEFAULT NULL COMMENT '是否走接口',
  `deter2` varchar(40) DEFAULT NULL COMMENT '功能区 [UDC]INV:FUNC_TYPE',
  `es1` varchar(40) DEFAULT NULL COMMENT 'ES1',
  `es2` varchar(40) DEFAULT NULL COMMENT 'ES2',
  `es3` varchar(40) DEFAULT NULL COMMENT 'ES3',
  `es4` varchar(40) DEFAULT NULL COMMENT 'ES4',
  `es5` varchar(40) DEFAULT NULL COMMENT 'ES5',
  `es6` varchar(40) DEFAULT NULL COMMENT 'ES6',
  `es7` varchar(40) DEFAULT NULL COMMENT 'ES7',
  `es8` varchar(40) DEFAULT NULL COMMENT 'ES8',
  `es9` varchar(40) DEFAULT NULL COMMENT 'ES9',
  `es10` varchar(40) DEFAULT NULL COMMENT 'ES10',
  `en1` decimal(20,2) DEFAULT NULL COMMENT 'EN1',
  `en2` decimal(20,2) DEFAULT NULL COMMENT 'EN2',
  `en3` decimal(20,2) DEFAULT NULL COMMENT 'EN3',
  `en4` decimal(20,2) DEFAULT NULL COMMENT 'EN4',
  `en5` decimal(20,2) DEFAULT NULL COMMENT 'EN5',
  `ed1` datetime DEFAULT NULL COMMENT 'ED1',
  `ed2` datetime DEFAULT NULL COMMENT 'ED2',
  `ed3` datetime DEFAULT NULL COMMENT 'ED3',
  `zeroval_type` varchar(40) DEFAULT NULL COMMENT '免值标记',
  `orig_qty` decimal(20,8) DEFAULT NULL COMMENT '原始参考数量',
  `orig_net_amt` decimal(20,8) DEFAULT NULL COMMENT '原始参考金额',
  `sal_so_flag` tinyint(1) DEFAULT '0' COMMENT '团内订单是否已转销售订单：1是，0否',
  `sal_so_id` bigint(20) DEFAULT NULL COMMENT '销售订单ID',
  `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
  `proc_inst_id` varchar(40) DEFAULT NULL COMMENT '流程实例ID',
  `proc_inst_status` varchar(255) DEFAULT NULL COMMENT '流程实例状态',
  `submit_time` datetime(6) DEFAULT NULL COMMENT '提交时间',
  `approved_time` datetime(6) DEFAULT NULL COMMENT '审批通过时间',
  `sal_doc_date` date DEFAULT NULL COMMENT '发货单日期',
  `supp_confirm_status` varchar(10) DEFAULT NULL COMMENT '供应商确认状态',
  `cust_id` bigint(20) DEFAULT NULL,
  `cust_name` varchar(40) DEFAULT NULL,
  `root_doc_id` bigint(20) DEFAULT NULL,
  `root_doc_did` bigint(20) DEFAULT NULL,
  `root_doc_cls` varchar(40) DEFAULT NULL,
  `root_doc_type` varchar(40) DEFAULT NULL,
  `root_doc_no` varchar(40) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `create_user_id_index` (`create_user_id`) USING BTREE,
  KEY `sec_bu_id_index` (`sec_bu_id`) USING BTREE,
  KEY `sec_user_id_index` (`sec_user_id`) USING BTREE,
  KEY `sec_ou_id_index` (`sec_ou_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='采购订单';

-- ----------------------------
-- Table structure for pur_po_d
-- ----------------------------

CREATE TABLE `pur_po_d` (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `sec_bu_id` bigint(20) DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) DEFAULT NULL COMMENT 'sec_ou_id',
  `mas_id` bigint(20) DEFAULT '0' COMMENT '主表ID',
  `ou_id` bigint(20) DEFAULT '0' COMMENT '公司ID',
  `bu_id` bigint(20) DEFAULT '0' COMMENT 'BUID',
  `bd_id` bigint(20) DEFAULT '0' COMMENT '事业部ID',
  `line_no` decimal(20,3) DEFAULT NULL COMMENT '行号',
  `line_type` varchar(40) DEFAULT NULL COMMENT '行类型 [UDC]PUR:PO_LINE_TYPE',
  `hold_reason_code` varchar(40) DEFAULT NULL COMMENT '暂挂原因码 [UDC]PUR:PO_HOLD_REASON',
  `line_status` varchar(40) DEFAULT NULL COMMENT '行状态',
  `deter2` varchar(40) DEFAULT NULL COMMENT '功能区 [UDC]INV:FUNC_TYPE',
  `wh_id` bigint(20) DEFAULT '0' COMMENT '收货仓库ID',
  `supp_id` bigint(20) DEFAULT '0' COMMENT '供应商ID',
  `item_id` bigint(20) DEFAULT '0' COMMENT '品项ID',
  `item_code` varchar(40) DEFAULT NULL COMMENT '品项编号',
  `item_name` varchar(200) DEFAULT NULL COMMENT '品项名称',
  `item_spec` varchar(200) DEFAULT NULL COMMENT '品项规格',
  `item_id2` bigint(20) DEFAULT '0' COMMENT '品项ID',
  `item_code2` varchar(40) DEFAULT NULL COMMENT '品项编号',
  `item_name2` varchar(100) DEFAULT NULL COMMENT '品项名称2',
  `item_spec2` varchar(40) DEFAULT NULL COMMENT '品项规格',
  `item_cs_code` varchar(40) DEFAULT NULL COMMENT '供应商品项编号',
  `barcode` varchar(40) DEFAULT NULL COMMENT '条码',
  `qty` decimal(20,8) DEFAULT NULL COMMENT '数量',
  `uom` varchar(10) DEFAULT NULL COMMENT '单位',
  `qty2` decimal(20,8) DEFAULT NULL COMMENT '数量2',
  `payed_qty` decimal(20,8) DEFAULT NULL COMMENT '数量2',
  `payed_amt` decimal(20,2) DEFAULT NULL COMMENT '已付金额',
  `uom2` varchar(10) DEFAULT NULL COMMENT '单位2',
  `uom_ratio` decimal(20,8) DEFAULT NULL COMMENT '单位转换率',
  `uom_ratio2` decimal(20,8) DEFAULT NULL COMMENT '单位转换率2',
  `pack_demand` varchar(40) DEFAULT NULL COMMENT '包装要求',
  `net_weight` decimal(20,8) DEFAULT NULL COMMENT '净重',
  `gross_weight` decimal(20,8) DEFAULT NULL COMMENT '毛重',
  `weight_uom` varchar(10) DEFAULT NULL COMMENT '重量单位',
  `weight_ratio` decimal(20,8) DEFAULT NULL COMMENT '重量转换率 重量单位与主单位',
  `volume` decimal(20,8) DEFAULT NULL COMMENT '体积',
  `volume_uom` varchar(10) DEFAULT NULL COMMENT '体积单位',
  `base_price` decimal(20,8) DEFAULT NULL COMMENT '基价',
  `price_type` varchar(40) DEFAULT NULL COMMENT '价格类型',
  `net_price` decimal(20,8) DEFAULT NULL COMMENT '不含税价格',
  `price` decimal(20,8) DEFAULT NULL COMMENT '含税单价',
  `curr_net_price` decimal(20,8) DEFAULT NULL COMMENT '未税单价',
  `curr_price` decimal(20,8) DEFAULT NULL COMMENT '含税单价',
  `pb_price` decimal(20,8) DEFAULT NULL COMMENT '价格本价格',
  `pb_curr` varchar(40) DEFAULT NULL COMMENT '价格本币种',
  `pb_uom` varchar(40) DEFAULT NULL COMMENT '价格本单位',
  `disc_type` varchar(40) DEFAULT NULL COMMENT '折扣类型',
  `disc_ratio` decimal(20,8) DEFAULT NULL COMMENT '折扣率',
  `disc_amt` decimal(20,2) DEFAULT NULL COMMENT '折扣额',
  `disc_desc` varchar(100) DEFAULT NULL COMMENT '折扣描述',
  `disced_price` decimal(20,8) DEFAULT NULL COMMENT '折扣后价格',
  `trans_price` decimal(20,8) DEFAULT NULL COMMENT '交易单价 折扣后，不含税',
  `inv_status` varchar(40) DEFAULT NULL COMMENT '发票状态',
  `inv_date` datetime DEFAULT NULL COMMENT '发票日期',
  `supp_tax_type` varchar(40) DEFAULT NULL COMMENT '供应商税类型',
  `item_tax_type` varchar(40) DEFAULT NULL COMMENT '商品税类型',
  `tax_code` varchar(40) DEFAULT NULL COMMENT '税码',
  `tax_rate_no` varchar(40) DEFAULT NULL COMMENT '税率编号',
  `tax_rate` decimal(20,8) DEFAULT NULL COMMENT '税率',
  `tax_amt` decimal(20,2) DEFAULT NULL COMMENT '税额',
  `amt` decimal(20,8) DEFAULT NULL COMMENT '含税金额',
  `net_amt` decimal(20,8) DEFAULT NULL COMMENT '不含税金额',
  `curr_amt` decimal(20,8) DEFAULT NULL COMMENT '外币含税金额',
  `curr_net_amt` decimal(20,8) DEFAULT NULL COMMENT '外币不含税金额',
  `home_curr` varchar(40) DEFAULT NULL COMMENT '本币币种',
  `curr_code` varchar(40) DEFAULT NULL COMMENT '币种',
  `curr_rate` decimal(20,8) DEFAULT NULL COMMENT '汇率',
  `logis_status` varchar(40) DEFAULT NULL COMMENT '物流状态',
  `promise_qty` decimal(20,8) DEFAULT NULL COMMENT '承诺数量',
  `shipped_qty` decimal(20,8) DEFAULT NULL COMMENT '已出库数量',
  `shipment_uom` varchar(40) DEFAULT NULL COMMENT '发货单位',
  `accept_qty` decimal(20,8) DEFAULT '0.00000000' COMMENT '已收数量',
  `accept_uom` varchar(40) DEFAULT NULL COMMENT '收货单位',
  `accept_date` datetime DEFAULT NULL COMMENT '收货日期',
  `returned_qty` decimal(20,8) DEFAULT '0.00000000' COMMENT '已退数量',
  `diff_qty` decimal(20,8) DEFAULT NULL COMMENT '差异数量',
  `supp_shipment_status` varchar(40) DEFAULT NULL COMMENT '供应商送货状态',
  `overdue_status` varchar(40) DEFAULT NULL COMMENT '延交状态',
  `recv_status` varchar(40) DEFAULT NULL COMMENT '收货状态',
  `demand_fresh_percent` decimal(20,8) DEFAULT NULL COMMENT '要求保质期比例',
  `demand_aap_days` int(18) DEFAULT NULL COMMENT '要求效期天数',
  `orig_date` datetime DEFAULT NULL COMMENT '原始交期',
  `demand_date` datetime DEFAULT NULL COMMENT '要求交期',
  `promise_date` datetime DEFAULT NULL COMMENT '供应商承诺交期',
  `eta_date` datetime DEFAULT NULL COMMENT '预计到货日期',
  `scheduled_arrive_date` datetime DEFAULT NULL COMMENT '供应商预约到货日期',
  `first_recv_date` datetime DEFAULT NULL COMMENT '最早收货日期',
  `last_recv_date` datetime DEFAULT NULL COMMENT '最后收货日期',
  `recv_tolerance` decimal(10,2) DEFAULT NULL COMMENT '收货允差',
  `recv_tolerance2` decimal(10,2) DEFAULT NULL COMMENT '收货允差2',
  `urgent_flag` int(18) DEFAULT NULL COMMENT '是否加急',
  `urge_comment` varchar(200) DEFAULT NULL COMMENT '催货说明',
  `supp_comment` varchar(500) DEFAULT NULL COMMENT '供应商进度说明',
  `supp_doc_no` varchar(40) DEFAULT NULL COMMENT '供方单号',
  `cancel_qty` decimal(20,8) DEFAULT '0.00000000' COMMENT '已取消数量',
  `cancel_time` datetime DEFAULT NULL COMMENT '取消时间',
  `cancel_reason` varchar(40) DEFAULT NULL COMMENT '取消原因',
  `cancel_user_id` bigint(20) DEFAULT '0' COMMENT '取消用户ID',
  `close_time` datetime DEFAULT NULL COMMENT '关闭时间',
  `close_reason` varchar(40) DEFAULT NULL COMMENT '关闭原因',
  `close_user_id` bigint(20) DEFAULT '0' COMMENT '关闭用户ID',
  `zeroval_type` varchar(40) DEFAULT NULL COMMENT '免值标记',
  `prom_id` bigint(20) DEFAULT '0' COMMENT '促销ID',
  `prom_no` varchar(40) DEFAULT NULL COMMENT '促销编号',
  `relate_doc_cls` varchar(40) DEFAULT NULL COMMENT '关联单据类别 [UDC]COM:DOC_CLS',
  `relate_doc_type` varchar(40) DEFAULT NULL COMMENT '关联单据类型',
  `relate_doc_id` bigint(20) DEFAULT '0' COMMENT '关联单据ID',
  `relate_doc_no` varchar(40) DEFAULT NULL COMMENT '关联单据编号',
  `relate_doc_did` bigint(20) DEFAULT '0' COMMENT '关联单据明细ID',
  `relate_doc_lineno` decimal(20,3) DEFAULT NULL COMMENT '关联单据行号',
  `relate_doc2_cls` varchar(40) DEFAULT NULL COMMENT '关联单据2类别 [UDC]COM:DOC_CLS',
  `relate_doc2_type` varchar(40) DEFAULT NULL COMMENT '关联单据2类型',
  `relate_doc2_id` bigint(20) DEFAULT '0' COMMENT '关联单据2ID',
  `relate_doc2_no` varchar(40) DEFAULT NULL COMMENT '关联单据2编号',
  `relate_doc2_did` bigint(20) DEFAULT '0' COMMENT '关联单据2明细ID',
  `relate_doc2_lineno` decimal(20,3) DEFAULT NULL COMMENT '关联单据2行号',
  `lot_flag` tinyint(1) DEFAULT NULL COMMENT '是否启用批次',
  `es1` varchar(40) DEFAULT NULL COMMENT 'ES1',
  `es2` varchar(40) DEFAULT NULL COMMENT 'ES2',
  `es3` varchar(40) DEFAULT NULL COMMENT 'ES3',
  `es4` varchar(40) DEFAULT NULL COMMENT 'ES4',
  `es5` varchar(40) DEFAULT NULL COMMENT 'ES5',
  `es6` varchar(40) DEFAULT NULL COMMENT 'ES6',
  `es7` varchar(40) DEFAULT NULL COMMENT 'ES7',
  `es8` varchar(40) DEFAULT NULL COMMENT 'ES8',
  `es9` varchar(40) DEFAULT NULL COMMENT 'ES9',
  `es10` varchar(40) DEFAULT NULL COMMENT 'ES10',
  `en1` decimal(20,2) DEFAULT NULL COMMENT 'EN1',
  `en2` decimal(20,2) DEFAULT NULL COMMENT 'EN2',
  `en3` decimal(20,2) DEFAULT NULL COMMENT 'EN3',
  `en4` decimal(20,2) DEFAULT NULL COMMENT 'EN4',
  `en5` decimal(20,2) DEFAULT NULL COMMENT 'EN5',
  `ed1` datetime DEFAULT NULL COMMENT 'ED1',
  `ed2` datetime DEFAULT NULL COMMENT 'ED2',
  `ed3` datetime DEFAULT NULL COMMENT 'ED3',
  `dbrand` varchar(40) DEFAULT NULL COMMENT '品牌名称+code',
  `root_doc_cls` varchar(40) DEFAULT NULL COMMENT '来源单据类别[UDC]COM:DOC_CLS]',
  `root_doc_type` varchar(40) DEFAULT NULL COMMENT '来源单据类型',
  `root_doc_id` bigint(20) DEFAULT '0' COMMENT '来源单据ID',
  `root_doc_no` varchar(40) DEFAULT NULL COMMENT '来源单据编号',
  `root_doc_did` bigint(20) DEFAULT '0' COMMENT '来源单据明细ID',
  `root_doc_lineno` decimal(20,3) DEFAULT NULL COMMENT '来源单据行号',
  `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
  `fin1` varchar(50) DEFAULT NULL,
  `fin2` datetime(6) DEFAULT NULL,
  `fin3` varchar(50) DEFAULT NULL,
  `fin4` varchar(255) DEFAULT NULL,
  `so_doc_id` bigint(20) DEFAULT '0' COMMENT '销售订单单据ID',
  `so_doc_did` bigint(20) DEFAULT '0' COMMENT '销售订单单据明细ID',
  `so_doc_no` varchar(40) DEFAULT NULL COMMENT '销售订单单据编号',
  `so_doc_lineno` decimal(20,3) DEFAULT NULL COMMENT '销售订单来源单据行号',
  `canceled_qty` decimal(20,8) DEFAULT '0.00000000' COMMENT '已取消数量',
  `rejected_qty` decimal(20,8) DEFAULT NULL COMMENT '已拒收数量',
  `parts_ratio` decimal(20,8) DEFAULT NULL COMMENT '配额比例',
  `recv_amt` decimal(20,8) DEFAULT NULL COMMENT '已收货金额（含税）',
  `sell_method` varchar(20) DEFAULT NULL COMMENT '出货方式',
  `outer_lineno` varchar(10) DEFAULT NULL COMMENT '行号',
  `recv_addr_type` varchar(10) DEFAULT NULL COMMENT '收货地址类型',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `create_user_id_index` (`create_user_id`) USING BTREE,
  KEY `sec_bu_id_index` (`sec_bu_id`) USING BTREE,
  KEY `sec_user_id_index` (`sec_user_id`) USING BTREE,
  KEY `sec_ou_id_index` (`sec_ou_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='采购订单明细';

-- ----------------------------
-- Table structure for pur_po_d_0908
-- ----------------------------

CREATE TABLE `pur_po_d_0908` (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `sec_bu_id` bigint(20) DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) DEFAULT NULL COMMENT 'sec_ou_id',
  `mas_id` bigint(20) DEFAULT '0' COMMENT '主表ID',
  `ou_id` bigint(20) DEFAULT '0' COMMENT '公司ID',
  `bu_id` bigint(20) DEFAULT '0' COMMENT 'BUID',
  `bd_id` bigint(20) DEFAULT '0' COMMENT '事业部ID',
  `line_no` decimal(20,3) DEFAULT NULL COMMENT '行号',
  `line_type` varchar(40) DEFAULT NULL COMMENT '行类型 [UDC]PUR:PO_LINE_TYPE',
  `hold_reason_code` varchar(40) DEFAULT NULL COMMENT '暂挂原因码 [UDC]PUR:PO_HOLD_REASON',
  `line_status` varchar(40) DEFAULT NULL COMMENT '行状态',
  `deter2` varchar(40) DEFAULT NULL COMMENT '功能区 [UDC]INV:FUNC_TYPE',
  `wh_id` bigint(20) DEFAULT '0' COMMENT '收货仓库ID',
  `supp_id` bigint(20) DEFAULT '0' COMMENT '供应商ID',
  `item_id` bigint(20) DEFAULT '0' COMMENT '品项ID',
  `item_code` varchar(40) DEFAULT NULL COMMENT '品项编号',
  `item_name` varchar(200) DEFAULT NULL COMMENT '品项名称',
  `item_spec` varchar(40) DEFAULT NULL COMMENT '品项规格',
  `item_id2` bigint(20) DEFAULT '0' COMMENT '品项ID',
  `item_code2` varchar(40) DEFAULT NULL COMMENT '品项编号',
  `item_name2` varchar(100) DEFAULT NULL COMMENT '品项名称2',
  `item_spec2` varchar(40) DEFAULT NULL COMMENT '品项规格',
  `item_cs_code` varchar(40) DEFAULT NULL COMMENT '供应商品项编号',
  `barcode` varchar(40) DEFAULT NULL COMMENT '条码',
  `qty` decimal(20,8) DEFAULT NULL COMMENT '数量',
  `uom` varchar(10) DEFAULT NULL COMMENT '单位',
  `qty2` decimal(20,8) DEFAULT NULL COMMENT '数量2',
  `payed_qty` decimal(20,8) DEFAULT NULL COMMENT '数量2',
  `payed_amt` decimal(20,2) DEFAULT NULL COMMENT '已付金额',
  `uom2` varchar(10) DEFAULT NULL COMMENT '单位2',
  `uom_ratio` decimal(20,8) DEFAULT NULL COMMENT '单位转换率',
  `uom_ratio2` decimal(20,8) DEFAULT NULL COMMENT '单位转换率2',
  `pack_demand` varchar(40) DEFAULT NULL COMMENT '包装要求',
  `net_weight` decimal(20,8) DEFAULT NULL COMMENT '净重',
  `gross_weight` decimal(20,8) DEFAULT NULL COMMENT '毛重',
  `weight_uom` varchar(10) DEFAULT NULL COMMENT '重量单位',
  `weight_ratio` decimal(20,8) DEFAULT NULL COMMENT '重量转换率 重量单位与主单位',
  `volume` decimal(20,8) DEFAULT NULL COMMENT '体积',
  `volume_uom` varchar(10) DEFAULT NULL COMMENT '体积单位',
  `base_price` decimal(20,8) DEFAULT NULL COMMENT '基价',
  `price_type` varchar(40) DEFAULT NULL COMMENT '价格类型',
  `net_price` decimal(20,8) DEFAULT NULL COMMENT '不含税价格',
  `price` decimal(20,8) DEFAULT NULL COMMENT '含税单价',
  `curr_net_price` decimal(20,8) DEFAULT NULL COMMENT '未税单价',
  `curr_price` decimal(20,8) DEFAULT NULL COMMENT '含税单价',
  `pb_price` decimal(20,8) DEFAULT NULL COMMENT '价格本价格',
  `pb_curr` varchar(40) DEFAULT NULL COMMENT '价格本币种',
  `pb_uom` varchar(40) DEFAULT NULL COMMENT '价格本单位',
  `disc_type` varchar(40) DEFAULT NULL COMMENT '折扣类型',
  `disc_ratio` decimal(20,8) DEFAULT NULL COMMENT '折扣率',
  `disc_amt` decimal(20,2) DEFAULT NULL COMMENT '折扣额',
  `disc_desc` varchar(100) DEFAULT NULL COMMENT '折扣描述',
  `disced_price` decimal(20,8) DEFAULT NULL COMMENT '折扣后价格',
  `trans_price` decimal(20,8) DEFAULT NULL COMMENT '交易单价 折扣后，不含税',
  `inv_status` varchar(40) DEFAULT NULL COMMENT '发票状态',
  `inv_date` datetime DEFAULT NULL COMMENT '发票日期',
  `supp_tax_type` varchar(40) DEFAULT NULL COMMENT '供应商税类型',
  `item_tax_type` varchar(40) DEFAULT NULL COMMENT '商品税类型',
  `tax_code` varchar(40) DEFAULT NULL COMMENT '税码',
  `tax_rate_no` varchar(40) DEFAULT NULL COMMENT '税率编号',
  `tax_rate` decimal(20,8) DEFAULT NULL COMMENT '税率',
  `tax_amt` decimal(20,2) DEFAULT NULL COMMENT '税额',
  `amt` decimal(20,8) DEFAULT NULL COMMENT '含税金额',
  `net_amt` decimal(20,8) DEFAULT NULL COMMENT '不含税金额',
  `curr_amt` decimal(20,8) DEFAULT NULL COMMENT '外币含税金额',
  `curr_net_amt` decimal(20,8) DEFAULT NULL COMMENT '外币不含税金额',
  `home_curr` varchar(40) DEFAULT NULL COMMENT '本币币种',
  `curr_code` varchar(40) DEFAULT NULL COMMENT '币种',
  `curr_rate` decimal(20,8) DEFAULT NULL COMMENT '汇率',
  `logis_status` varchar(40) DEFAULT NULL COMMENT '物流状态',
  `promise_qty` decimal(20,8) DEFAULT NULL COMMENT '承诺数量',
  `shipped_qty` decimal(20,8) DEFAULT NULL COMMENT '已出库数量',
  `shipment_uom` varchar(40) DEFAULT NULL COMMENT '发货单位',
  `accept_qty` decimal(20,8) DEFAULT NULL COMMENT '已收数量',
  `accept_uom` varchar(40) DEFAULT NULL COMMENT '收货单位',
  `accept_date` datetime DEFAULT NULL COMMENT '收货日期',
  `returned_qty` decimal(20,8) DEFAULT '0.00000000' COMMENT '已退数量',
  `diff_qty` decimal(20,8) DEFAULT NULL COMMENT '差异数量',
  `supp_shipment_status` varchar(40) DEFAULT NULL COMMENT '供应商送货状态',
  `overdue_status` varchar(40) DEFAULT NULL COMMENT '延交状态',
  `recv_status` varchar(40) DEFAULT NULL COMMENT '收货状态',
  `demand_fresh_percent` decimal(20,8) DEFAULT NULL COMMENT '要求保质期比例',
  `demand_aap_days` int(18) DEFAULT NULL COMMENT '要求效期天数',
  `orig_date` datetime DEFAULT NULL COMMENT '原始交期',
  `demand_date` datetime DEFAULT NULL COMMENT '要求交期',
  `promise_date` datetime DEFAULT NULL COMMENT '供应商承诺交期',
  `eta_date` datetime DEFAULT NULL COMMENT '预计到货日期',
  `scheduled_arrive_date` datetime DEFAULT NULL COMMENT '供应商预约到货日期',
  `first_recv_date` datetime DEFAULT NULL COMMENT '最早收货日期',
  `last_recv_date` datetime DEFAULT NULL COMMENT '最后收货日期',
  `recv_tolerance` decimal(10,2) DEFAULT NULL COMMENT '收货允差',
  `recv_tolerance2` decimal(10,2) DEFAULT NULL COMMENT '收货允差2',
  `urgent_flag` int(18) DEFAULT NULL COMMENT '是否加急',
  `urge_comment` varchar(200) DEFAULT NULL COMMENT '催货说明',
  `supp_comment` varchar(500) DEFAULT NULL COMMENT '供应商进度说明',
  `supp_doc_no` varchar(40) DEFAULT NULL COMMENT '供方单号',
  `cancel_qty` decimal(20,8) DEFAULT NULL COMMENT '已取消数量',
  `cancel_time` datetime DEFAULT NULL COMMENT '取消时间',
  `cancel_reason` varchar(40) DEFAULT NULL COMMENT '取消原因',
  `cancel_user_id` bigint(20) DEFAULT '0' COMMENT '取消用户ID',
  `close_time` datetime DEFAULT NULL COMMENT '关闭时间',
  `close_reason` varchar(40) DEFAULT NULL COMMENT '关闭原因',
  `close_user_id` bigint(20) DEFAULT '0' COMMENT '关闭用户ID',
  `zeroval_type` varchar(40) DEFAULT NULL COMMENT '免值标记',
  `prom_id` bigint(20) DEFAULT '0' COMMENT '促销ID',
  `prom_no` varchar(40) DEFAULT NULL COMMENT '促销编号',
  `relate_doc_cls` varchar(40) DEFAULT NULL COMMENT '关联单据类别 [UDC]COM:DOC_CLS',
  `relate_doc_type` varchar(40) DEFAULT NULL COMMENT '关联单据类型',
  `relate_doc_id` bigint(20) DEFAULT '0' COMMENT '关联单据ID',
  `relate_doc_no` varchar(40) DEFAULT NULL COMMENT '关联单据编号',
  `relate_doc_did` bigint(20) DEFAULT '0' COMMENT '关联单据明细ID',
  `relate_doc_lineno` decimal(20,3) DEFAULT NULL COMMENT '关联单据行号',
  `relate_doc2_cls` varchar(40) DEFAULT NULL COMMENT '关联单据2类别 [UDC]COM:DOC_CLS',
  `relate_doc2_type` varchar(40) DEFAULT NULL COMMENT '关联单据2类型',
  `relate_doc2_id` bigint(20) DEFAULT '0' COMMENT '关联单据2ID',
  `relate_doc2_no` varchar(40) DEFAULT NULL COMMENT '关联单据2编号',
  `relate_doc2_did` bigint(20) DEFAULT '0' COMMENT '关联单据2明细ID',
  `relate_doc2_lineno` decimal(20,3) DEFAULT NULL COMMENT '关联单据2行号',
  `lot_flag` tinyint(1) DEFAULT NULL COMMENT '是否启用批次',
  `es1` varchar(40) DEFAULT NULL COMMENT 'ES1',
  `es2` varchar(40) DEFAULT NULL COMMENT 'ES2',
  `es3` varchar(40) DEFAULT NULL COMMENT 'ES3',
  `es4` varchar(40) DEFAULT NULL COMMENT 'ES4',
  `es5` varchar(40) DEFAULT NULL COMMENT 'ES5',
  `es6` varchar(40) DEFAULT NULL COMMENT 'ES6',
  `es7` varchar(40) DEFAULT NULL COMMENT 'ES7',
  `es8` varchar(40) DEFAULT NULL COMMENT 'ES8',
  `es9` varchar(40) DEFAULT NULL COMMENT 'ES9',
  `es10` varchar(40) DEFAULT NULL COMMENT 'ES10',
  `en1` decimal(20,2) DEFAULT NULL COMMENT 'EN1',
  `en2` decimal(20,2) DEFAULT NULL COMMENT 'EN2',
  `en3` decimal(20,2) DEFAULT NULL COMMENT 'EN3',
  `en4` decimal(20,2) DEFAULT NULL COMMENT 'EN4',
  `en5` decimal(20,2) DEFAULT NULL COMMENT 'EN5',
  `ed1` datetime DEFAULT NULL COMMENT 'ED1',
  `ed2` datetime DEFAULT NULL COMMENT 'ED2',
  `ed3` datetime DEFAULT NULL COMMENT 'ED3',
  `dbrand` varchar(40) DEFAULT NULL COMMENT '品牌名称+code',
  `root_doc_cls` varchar(40) DEFAULT NULL COMMENT '来源单据类别[UDC]COM:DOC_CLS]',
  `root_doc_type` varchar(40) DEFAULT NULL COMMENT '来源单据类型',
  `root_doc_id` bigint(20) DEFAULT '0' COMMENT '来源单据ID',
  `root_doc_no` varchar(40) DEFAULT NULL COMMENT '来源单据编号',
  `root_doc_did` bigint(20) DEFAULT '0' COMMENT '来源单据明细ID',
  `root_doc_lineno` decimal(20,3) DEFAULT NULL COMMENT '来源单据行号',
  `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
  `fin1` varchar(50) DEFAULT NULL,
  `fin2` datetime(6) DEFAULT NULL,
  `fin3` varchar(50) DEFAULT NULL,
  `fin4` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `create_user_id_index` (`create_user_id`) USING BTREE,
  KEY `sec_bu_id_index` (`sec_bu_id`) USING BTREE,
  KEY `sec_user_id_index` (`sec_user_id`) USING BTREE,
  KEY `sec_ou_id_index` (`sec_ou_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='采购订单明细';

-- ----------------------------
-- Table structure for pur_po_docs
-- ----------------------------

CREATE TABLE `pur_po_docs` (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `sec_bu_id` bigint(20) DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) DEFAULT NULL COMMENT 'sec_ou_id',
  `mas_id` bigint(20) DEFAULT '0' COMMENT '主表ID',
  `po_d_id` bigint(20) DEFAULT '0' COMMENT '采购订单明细ID',
  `doc_type` varchar(40) DEFAULT NULL COMMENT '文档类型 [UDC]ORG:ADDR_EXT_ES1',
  `doc_no` varchar(40) DEFAULT NULL COMMENT '文档编号',
  `doc_name` varchar(40) DEFAULT NULL COMMENT '文档名称',
  `doc_status` varchar(40) DEFAULT NULL COMMENT '文档状态',
  `doc_brief` varchar(100) DEFAULT NULL COMMENT '摘要信息',
  `manda_flag` int(10) DEFAULT NULL COMMENT '是否必需',
  `provide_date` datetime DEFAULT NULL COMMENT '提供日期',
  `pic_emp_id` bigint(20) DEFAULT '0' COMMENT '维护人员工ID',
  `contr_no` varchar(40) DEFAULT NULL COMMENT '合同号',
  `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `create_user_id_index` (`create_user_id`) USING BTREE,
  KEY `sec_bu_id_index` (`sec_bu_id`) USING BTREE,
  KEY `sec_user_id_index` (`sec_user_id`) USING BTREE,
  KEY `sec_ou_id_index` (`sec_ou_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='采购订单文档';

-- ----------------------------
-- Table structure for pur_po_parts_amt
-- ----------------------------

CREATE TABLE `pur_po_parts_amt` (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `ou_id` bigint(20) DEFAULT '0' COMMENT '公司ID',
  `bu_id` bigint(20) DEFAULT '0' COMMENT 'BUID',
  `bd_id` bigint(20) DEFAULT '0' COMMENT '事业部ID',
  `mas_id` bigint(20) DEFAULT '0' COMMENT '主表ID',
  `doc_no` varchar(40) DEFAULT NULL COMMENT '单据编号',
  `amt_parts_add` decimal(20,8) DEFAULT NULL COMMENT '发生配额',
  `amt_parts_add_rtn` decimal(20,8) DEFAULT NULL COMMENT '发生配额(退)',
  `amt_parts_use` decimal(20,8) DEFAULT NULL COMMENT '分配金额',
  `amt_parts_use_r` decimal(20,8) DEFAULT NULL COMMENT '分配金额(退)',
  `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
  `sec_bu_id` bigint(20) DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) DEFAULT NULL COMMENT 'sec_ou_id',
  `parts_amt_lock` decimal(20,8) DEFAULT '0.00000000' COMMENT '占用配额',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='订单配件额度';

-- ----------------------------
-- Table structure for pur_po_payplan
-- ----------------------------

CREATE TABLE `pur_po_payplan` (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `sec_bu_id` bigint(20) DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) DEFAULT NULL COMMENT 'sec_ou_id',
  `mas_id` bigint(20) DEFAULT '0' COMMENT '主表ID',
  `po_d_id` bigint(20) DEFAULT '0' COMMENT '采购订单明细ID',
  `pay_sequ` int(10) DEFAULT NULL COMMENT '第几笔付款',
  `pay_type` varchar(40) DEFAULT NULL COMMENT '付款类型 [UDC]PUR:PO_PAY_TYPE',
  `pay_amt` decimal(20,8) DEFAULT NULL COMMENT '付款金额',
  `plan_pay_date` datetime DEFAULT NULL COMMENT '计划付款日期',
  `pay_status` varchar(40) DEFAULT NULL COMMENT '付款状态',
  `pay_apply_no` varchar(40) DEFAULT NULL COMMENT '付款申请单号',
  `actual_pay_date` datetime DEFAULT NULL COMMENT '实际付款日期',
  `actual_pay_amt` decimal(20,8) DEFAULT NULL COMMENT '实际付款金额',
  `plan_pay_amt` decimal(20,8) DEFAULT NULL COMMENT '实际付款金额',
  `pay_plan_no` varchar(40) DEFAULT NULL COMMENT '付款计划编号',
  `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `create_user_id_index` (`create_user_id`) USING BTREE,
  KEY `sec_bu_id_index` (`sec_bu_id`) USING BTREE,
  KEY `sec_user_id_index` (`sec_user_id`) USING BTREE,
  KEY `sec_ou_id_index` (`sec_ou_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='采购订单付款计划';

-- ----------------------------
-- Table structure for pur_pr
-- ----------------------------

CREATE TABLE `pur_pr` (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `sec_bu_id` bigint(20) DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) DEFAULT NULL COMMENT 'sec_ou_id',
  `ou_id` bigint(20) DEFAULT '0' COMMENT '公司ID',
  `bu_id` bigint(20) DEFAULT '0' COMMENT 'BUID',
  `bu_id2` bigint(20) DEFAULT '0' COMMENT 'BUID2',
  `bu_id3` bigint(20) DEFAULT '0' COMMENT 'BUID3',
  `supp_id` bigint(20) DEFAULT '0' COMMENT '供应商ID',
  `supp_code` varchar(40) DEFAULT NULL COMMENT '供应商编号',
  `doc_no` varchar(40) DEFAULT NULL COMMENT '单据编号',
  `doc_no2` varchar(40) DEFAULT NULL COMMENT '单据编号2',
  `doc_type` varchar(10) DEFAULT NULL COMMENT '单据类型 [UDC]PUR:PR_TYPE',
  `doc_type2` varchar(10) DEFAULT NULL COMMENT '单据类型2',
  `doc_type3` varchar(10) DEFAULT NULL COMMENT '单据类型3',
  `scene_type_id` bigint(20) DEFAULT '0' COMMENT '采购场景类型ID',
  `doc_status` varchar(40) DEFAULT NULL COMMENT '单据状态',
  `doc_status2` varchar(40) DEFAULT NULL COMMENT '单据状态2',
  `doc_status3` varchar(40) DEFAULT NULL COMMENT '单据状态3',
  `doc_time` datetime DEFAULT NULL COMMENT '单据时间',
  `apply_emp_id` bigint(20) DEFAULT '0' COMMENT '申请人员工ID',
  `appr_proc_inst_id` varchar(40) DEFAULT NULL COMMENT '流程实例ID',
  `appr_create_user_id` bigint(20) DEFAULT '0' COMMENT '提审人ID',
  `apply_date` datetime DEFAULT NULL COMMENT '申请日期',
  `apply_desc` varchar(100) DEFAULT NULL COMMENT '申请描述',
  `appr_status` varchar(40) DEFAULT NULL COMMENT '审批状态 [UDC]COM:APPR_STATUS',
  `appr_time` datetime DEFAULT NULL COMMENT '审批时间',
  `appr_user_id` bigint(20) DEFAULT '0' COMMENT '审批人ID',
  `appr_comment` varchar(500) DEFAULT NULL COMMENT '审批意见',
  `region` varchar(40) DEFAULT NULL COMMENT '区域',
  `req_dept` varchar(40) DEFAULT NULL COMMENT '要求部门',
  `proj_no` varchar(10) DEFAULT NULL COMMENT '项目号',
  `proj_name` varchar(100) DEFAULT NULL COMMENT '项目名称',
  `po_mode` varchar(10) DEFAULT NULL COMMENT '采购方式',
  `relate_id` bigint(20) DEFAULT '0' COMMENT '相关ID',
  `relate_id2` bigint(20) DEFAULT '0' COMMENT '相关ID2',
  `relate_no` varchar(40) DEFAULT NULL COMMENT '相关编号',
  `relate_no2` varchar(40) DEFAULT NULL COMMENT '相关编号2',
  `agent_emp_id` bigint(20) DEFAULT '0' COMMENT '采购员员工ID',
  `curr_code` varchar(40) DEFAULT NULL COMMENT '币种',
  `curr_rate` decimal(20,8) DEFAULT NULL COMMENT '汇率',
  `payment_term` varchar(40) DEFAULT NULL COMMENT '付款条款',
  `tax_code` varchar(40) DEFAULT NULL COMMENT '税码',
  `tax_rate` decimal(20,8) DEFAULT NULL COMMENT '税率',
  `tax_amt` decimal(20,2) DEFAULT NULL COMMENT '税额',
  `net_amt` decimal(20,2) DEFAULT NULL COMMENT '未税总金额',
  `amt` decimal(20,2) DEFAULT NULL COMMENT '含税总金额',
  `curr_net_amt` decimal(20,2) DEFAULT NULL COMMENT '外币不含税金额',
  `curr_amt` decimal(20,2) DEFAULT NULL COMMENT '外币含税金额',
  `qty` decimal(20,8) DEFAULT NULL COMMENT '总数量',
  `qty_uom` varchar(10) DEFAULT NULL COMMENT '数量单位',
  `qty2` decimal(20,8) DEFAULT NULL COMMENT '总数量2',
  `qty2_uom` varchar(10) DEFAULT NULL COMMENT '数量2单位',
  `net_weight` decimal(20,8) DEFAULT NULL COMMENT '净重',
  `gross_weight` decimal(20,8) DEFAULT NULL COMMENT '毛重',
  `weight_uom` varchar(10) DEFAULT NULL COMMENT '重量单位',
  `contract_id` bigint(20) DEFAULT '0' COMMENT '合同ID',
  `contract_no` varchar(40) DEFAULT NULL COMMENT '合同编号',
  `demand_date` datetime DEFAULT NULL COMMENT '要求交期',
  `trans_type` varchar(40) DEFAULT NULL COMMENT '运输方式 [UDC]COM:TP_TYPE',
  `from_addr` varchar(400) DEFAULT NULL COMMENT '发货地址',
  `accept_ou_id` bigint(20) DEFAULT '0' COMMENT '收货单位ID',
  `recv_port` varchar(40) DEFAULT NULL COMMENT '到达港口 [UDC]COM:TP_PORT',
  `to_addr` varchar(400) DEFAULT NULL COMMENT '收货地址',
  `wh_id` bigint(20) DEFAULT '0' COMMENT '收货仓库ID',
  `carrier` varchar(40) DEFAULT NULL COMMENT '承运商',
  `urgent_flag` int(10) DEFAULT NULL COMMENT '是否加急',
  `intf_status` varchar(10) DEFAULT NULL COMMENT '同步状态',
  `intf_time` datetime DEFAULT NULL COMMENT '接口处理时间',
  `intf_batch_id` bigint(20) DEFAULT '0' COMMENT '接口批号',
  `intf2_status` varchar(40) DEFAULT NULL COMMENT '接口状态2',
  `intf2_time` datetime DEFAULT NULL COMMENT '接口处理时间2',
  `intf2_batch_id` bigint(20) DEFAULT '0' COMMENT '接口批号2',
  `outer_doc_no` varchar(40) DEFAULT NULL COMMENT '外部单号',
  `outer_shan_desc` varchar(200) DEFAULT NULL COMMENT '外部系统发运至描述',
  `outer_shan` varchar(40) DEFAULT NULL COMMENT '外部系统发运至',
  `outer_bu` varchar(40) DEFAULT NULL COMMENT '外部系统BU',
  `outer_user_code` varchar(40) DEFAULT NULL COMMENT '外部制单人',
  `outer_appruser_code` varchar(40) DEFAULT NULL COMMENT '外部审批人',
  `fcst_version` varchar(40) DEFAULT NULL COMMENT '预测版本号',
  `src_cls` varchar(40) DEFAULT NULL COMMENT '来源类别',
  `src_id` bigint(20) DEFAULT '0' COMMENT '来源ID',
  `src_no` varchar(40) DEFAULT NULL COMMENT '来源编号',
  `src_did` bigint(20) DEFAULT '0' COMMENT '来源明细ID',
  `remark2` varchar(200) DEFAULT NULL COMMENT '备注2',
  `deter2` varchar(40) DEFAULT NULL COMMENT '功能区 [UDC]INV:FUNC_TYPE',
  `es1` varchar(40) DEFAULT NULL COMMENT 'ES1',
  `es2` varchar(40) DEFAULT NULL COMMENT 'ES2',
  `es3` varchar(40) DEFAULT NULL COMMENT 'ES3',
  `es4` varchar(40) DEFAULT NULL COMMENT 'ES4',
  `es5` varchar(40) DEFAULT NULL COMMENT 'ES5',
  `es6` varchar(40) DEFAULT NULL COMMENT 'ES6',
  `es7` varchar(40) DEFAULT NULL COMMENT 'ES7',
  `es8` varchar(40) DEFAULT NULL COMMENT 'ES8',
  `es9` varchar(40) DEFAULT NULL COMMENT 'ES9',
  `es10` varchar(40) DEFAULT NULL COMMENT 'ES10',
  `en1` decimal(20,2) DEFAULT NULL COMMENT 'EN1',
  `en2` decimal(20,2) DEFAULT NULL COMMENT 'EN2',
  `en3` decimal(20,2) DEFAULT NULL COMMENT 'EN3',
  `en4` decimal(20,2) DEFAULT NULL COMMENT 'EN4',
  `en5` decimal(20,2) DEFAULT NULL COMMENT 'EN5',
  `ed1` datetime DEFAULT NULL COMMENT 'ED1',
  `ed2` datetime DEFAULT NULL COMMENT 'ED2',
  `ed3` datetime DEFAULT NULL COMMENT 'ED3',
  `zeroval_type` varchar(40) DEFAULT NULL COMMENT '免值标记',
  `demand_fresh_percent` decimal(20,8) DEFAULT NULL COMMENT '要求保质期比例',
  `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
  `recv_addr` varchar(400) DEFAULT NULL COMMENT '收货地址',
  `proc_inst_id` varchar(255) DEFAULT NULL COMMENT '流程实例ID',
  `proc_inst_status` varchar(255) DEFAULT NULL COMMENT '流程实例状态',
  `submit_time` datetime(6) DEFAULT NULL COMMENT '提交时间',
  `approved_time` datetime(6) DEFAULT NULL COMMENT '审批通过时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `create_user_id_index` (`create_user_id`) USING BTREE,
  KEY `sec_bu_id_index` (`sec_bu_id`) USING BTREE,
  KEY `sec_user_id_index` (`sec_user_id`) USING BTREE,
  KEY `sec_ou_id_index` (`sec_ou_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='采购申请';

-- ----------------------------
-- Table structure for pur_pr_d
-- ----------------------------

CREATE TABLE `pur_pr_d` (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `sec_bu_id` bigint(20) DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) DEFAULT NULL COMMENT 'sec_ou_id',
  `mas_id` bigint(20) DEFAULT '0' COMMENT '主表ID',
  `line_no` decimal(20,2) DEFAULT NULL COMMENT '行号',
  `line_status` varchar(40) DEFAULT NULL COMMENT '行状态',
  `line_type` varchar(40) DEFAULT NULL COMMENT '行类型',
  `item_id` bigint(20) DEFAULT '0' COMMENT '品项ID',
  `item_code` varchar(40) DEFAULT NULL COMMENT '品项编号',
  `item_name` varchar(200) DEFAULT NULL COMMENT '品项名称',
  `item_name2` varchar(100) DEFAULT NULL COMMENT '品项名称2',
  `item_spec` varchar(40) DEFAULT NULL COMMENT '品项规格',
  `wh_id` bigint(20) DEFAULT '0' COMMENT '仓库ID',
  `qty` decimal(20,8) DEFAULT NULL COMMENT '数量',
  `uom` varchar(10) DEFAULT NULL COMMENT '单位',
  `qty2` decimal(20,8) DEFAULT NULL COMMENT '数量2',
  `uom2` varchar(10) DEFAULT NULL COMMENT '单位2',
  `uom_ratio` decimal(20,8) DEFAULT NULL COMMENT '单位转换率',
  `uom_ratio2` decimal(20,8) DEFAULT NULL COMMENT '单位转换率2',
  `net_weight` decimal(20,8) DEFAULT NULL COMMENT '净重',
  `gross_weight` decimal(20,8) DEFAULT NULL COMMENT '毛重',
  `weight_uom` varchar(10) DEFAULT NULL COMMENT '重量单位',
  `weight_ratio` decimal(20,8) DEFAULT NULL COMMENT '重量转换率 重量单位与主单位',
  `net_price` decimal(20,8) DEFAULT NULL COMMENT '未税单价',
  `price` decimal(20,8) DEFAULT NULL COMMENT '含税单价',
  `curr_net_price` decimal(20,8) DEFAULT NULL COMMENT '未税单价',
  `curr_price` decimal(20,8) DEFAULT NULL COMMENT '含税单价',
  `pb_price` decimal(20,8) DEFAULT NULL COMMENT '价格本价格',
  `pb_curr` varchar(40) DEFAULT NULL COMMENT '价格本币种',
  `pb_uom` varchar(40) DEFAULT NULL COMMENT '价格本单位',
  `tax_code` varchar(40) DEFAULT NULL COMMENT '税码',
  `tax_rate_no` varchar(40) DEFAULT NULL COMMENT '税率编号',
  `tax_rate` decimal(20,8) DEFAULT NULL COMMENT '税率',
  `tax_amt` decimal(20,2) DEFAULT NULL COMMENT '税额',
  `net_amt` decimal(20,2) DEFAULT NULL COMMENT '未税金额',
  `amt` decimal(20,2) DEFAULT NULL COMMENT '含税金额',
  `curr_net_amt` decimal(20,2) DEFAULT NULL COMMENT '外币不含税金额',
  `curr_amt` decimal(20,2) DEFAULT NULL COMMENT '外币含税金额',
  `curr_code` varchar(40) DEFAULT NULL COMMENT '币种',
  `curr_rate` decimal(20,8) DEFAULT NULL COMMENT '汇率',
  `demand_date` datetime DEFAULT NULL COMMENT '要求交期',
  `zeroval_type` varchar(40) DEFAULT NULL COMMENT '免值标记',
  `relate_no` varchar(40) DEFAULT NULL COMMENT '促销ANP编号',
  `intf_status` varchar(10) DEFAULT NULL COMMENT '同步状态',
  `intf_time` datetime DEFAULT NULL COMMENT '接口处理时间',
  `intf_batch_id` bigint(20) DEFAULT '0' COMMENT '接口批号',
  `lot_flag` tinyint(1) DEFAULT NULL COMMENT '是否启用批次',
  `es1` varchar(2000) DEFAULT NULL COMMENT 'ES1',
  `es2` varchar(40) DEFAULT NULL COMMENT 'ES2',
  `es3` varchar(40) DEFAULT NULL COMMENT 'ES3',
  `es4` varchar(40) DEFAULT NULL COMMENT 'ES4',
  `es5` varchar(40) DEFAULT NULL COMMENT 'ES5',
  `es6` varchar(40) DEFAULT NULL COMMENT 'ES6',
  `es7` varchar(40) DEFAULT NULL COMMENT 'ES7',
  `es8` varchar(40) DEFAULT NULL COMMENT 'ES8',
  `es9` varchar(40) DEFAULT NULL COMMENT 'ES9',
  `es10` varchar(40) DEFAULT NULL COMMENT 'ES10',
  `en1` decimal(20,2) DEFAULT NULL COMMENT 'EN1',
  `en2` decimal(20,2) DEFAULT NULL COMMENT 'EN2',
  `en3` decimal(20,2) DEFAULT NULL COMMENT 'EN3',
  `en4` decimal(20,2) DEFAULT NULL COMMENT 'EN4',
  `en5` decimal(20,2) DEFAULT NULL COMMENT 'EN5',
  `ed1` datetime DEFAULT NULL COMMENT 'ED1',
  `ed2` datetime DEFAULT NULL COMMENT 'ED2',
  `ed3` datetime DEFAULT NULL COMMENT 'ED3',
  `dbrand` varchar(40) DEFAULT NULL COMMENT '品牌名+code',
  `deter2` varchar(40) DEFAULT NULL COMMENT '功能区 [UDC]INV:FUNC_TYPE',
  `demand_fresh_percent` decimal(20,8) DEFAULT NULL COMMENT '要求保质期比例',
  `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `create_user_id_index` (`create_user_id`) USING BTREE,
  KEY `sec_bu_id_index` (`sec_bu_id`) USING BTREE,
  KEY `sec_user_id_index` (`sec_user_id`) USING BTREE,
  KEY `sec_ou_id_index` (`sec_ou_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='采购申请明细';

-- ----------------------------
-- Table structure for pur_pr_src
-- ----------------------------

CREATE TABLE `pur_pr_src` (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `sec_bu_id` bigint(20) DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) DEFAULT NULL COMMENT 'sec_ou_id',
  `mas_id` bigint(20) DEFAULT '0' COMMENT '主表ID PUR_PR.ID',
  `pr_d_id` bigint(20) DEFAULT '0' COMMENT '采购申请明细ID PUR_PR_D.ID',
  `relate_doc_cls` varchar(40) DEFAULT NULL COMMENT '关联单据类别 [UDC]COM:DOC_CLS',
  `relate_doc_type` varchar(40) DEFAULT NULL COMMENT '关联单据类型',
  `relate_doc_id` bigint(20) DEFAULT '0' COMMENT '关联单据ID',
  `relate_doc_no` varchar(40) DEFAULT NULL COMMENT '关联单据编号',
  `relate_doc_did` bigint(20) DEFAULT '0' COMMENT '关联单据明细ID',
  `relate_doc_lineno` float(20,2) DEFAULT NULL COMMENT '关联单据行号',
  `relate_doc_qty` float(20,8) DEFAULT NULL COMMENT '关联单据数量',
  `qty` float(20,8) DEFAULT NULL COMMENT '进入申请单的数量',
  `uom` varchar(40) DEFAULT NULL COMMENT '单位',
  `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `create_user_id_index` (`create_user_id`) USING BTREE,
  KEY `sec_bu_id_index` (`sec_bu_id`) USING BTREE,
  KEY `sec_user_id_index` (`sec_user_id`) USING BTREE,
  KEY `sec_ou_id_index` (`sec_ou_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='采购申请来源明细';

-- ----------------------------
-- Table structure for pur_pre_settle
-- ----------------------------

CREATE TABLE `pur_pre_settle` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '记录唯一ID',
  `settle_entity_id` bigint(20) DEFAULT NULL,
  `settle_entity_name` varchar(50) DEFAULT NULL,
  `pre_settle_no` varchar(32) DEFAULT NULL,
  `pre_settle_name` varchar(32) DEFAULT NULL,
  `create_mode` varchar(20) DEFAULT NULL,
  `receive_type` varchar(20) DEFAULT NULL,
  `contact_name` varchar(50) DEFAULT NULL,
  `contact_id` bigint(20) DEFAULT NULL,
  `state` varchar(20) DEFAULT NULL COMMENT '状态',
  `process_time` datetime DEFAULT NULL,
  `currency` varchar(20) DEFAULT NULL COMMENT '币种',
  `total_amount` decimal(20,4) DEFAULT NULL,
  `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) DEFAULT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
  `pre_flag` tinyint(1) DEFAULT NULL,
  `pay_type` varchar(20) DEFAULT NULL,
  `approve_user_id` bigint(20) DEFAULT NULL,
  `approve_user` varchar(20) DEFAULT NULL,
  `check_user_id` bigint(20) DEFAULT NULL,
  `check_user` varchar(20) DEFAULT NULL,
  `curr_code` varchar(20) DEFAULT NULL,
  `curr_name` varchar(20) DEFAULT NULL,
  `pre_type_id` bigint(20) DEFAULT NULL,
  `pre_type_code` varchar(20) DEFAULT NULL,
  `pre_type_name` varchar(50) DEFAULT NULL,
  `verify_state` varchar(20) DEFAULT NULL,
  `pay_flag` tinyint(1) DEFAULT NULL,
  `reimburse_flag` tinyint(1) DEFAULT NULL,
  `transfer_state` varchar(20) DEFAULT NULL,
  `total_amount_base` decimal(20,4) DEFAULT NULL,
  `tax_amount` decimal(20,4) DEFAULT NULL,
  `approve_date` datetime DEFAULT NULL,
  `exchange_rate` decimal(4,2) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `create_user_id_index` (`create_user_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='预付款单';

-- ----------------------------
-- Table structure for pur_pre_settle_def_entity
-- ----------------------------

CREATE TABLE `pur_pre_settle_def_entity` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '记录唯一ID',
  `define_id` bigint(20) DEFAULT NULL,
  `ou_id` bigint(20) DEFAULT NULL,
  `ou_name` varchar(50) DEFAULT NULL,
  `ou_code` varchar(20) DEFAULT NULL,
  `ou_type` varchar(20) DEFAULT NULL,
  `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `create_user_id_index` (`create_user_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='付款单类型定义对应公司';

-- ----------------------------
-- Table structure for pur_pre_settle_def_type
-- ----------------------------

CREATE TABLE `pur_pre_settle_def_type` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '记录唯一ID',
  `define_id` bigint(20) DEFAULT NULL,
  `settle_type_name` varchar(50) DEFAULT NULL,
  `settle_type_code` varchar(20) DEFAULT NULL,
  `settle_type_id` bigint(20) DEFAULT NULL,
  `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `create_user_id_index` (`create_user_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='付款单类型定义对应采购结算类型';

-- ----------------------------
-- Table structure for pur_pre_settle_define
-- ----------------------------

CREATE TABLE `pur_pre_settle_define` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '记录唯一ID',
  `pre_type_code` varchar(32) DEFAULT NULL,
  `pre_type_name` varchar(32) DEFAULT NULL,
  `currency` varchar(20) DEFAULT NULL COMMENT '币种',
  `pay_method` varchar(20) DEFAULT NULL,
  `settle_approve_flag` tinyint(1) DEFAULT NULL,
  `fin_approve_flag` tinyint(1) DEFAULT NULL,
  `pay_flag` tinyint(1) DEFAULT NULL,
  `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) DEFAULT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
  `curr_code` varchar(20) DEFAULT NULL,
  `curr_name` varchar(20) DEFAULT NULL,
  `enable_flag` tinyint(1) DEFAULT NULL,
  `settle_type_name` varchar(50) DEFAULT NULL,
  `settle_type_id` bigint(20) DEFAULT NULL,
  `settle_type_code` varchar(20) DEFAULT NULL,
  `reimburse_flag` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `create_user_id_index` (`create_user_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='预付款单类型定义';

-- ----------------------------
-- Table structure for pur_pre_settle_dtl
-- ----------------------------

CREATE TABLE `pur_pre_settle_dtl` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '记录唯一ID',
  `pre_settle_id` bigint(20) DEFAULT NULL,
  `pur_order_number` varchar(32) DEFAULT NULL,
  `pur_order_name` varchar(32) DEFAULT NULL,
  `contact_code` varchar(32) DEFAULT NULL,
  `contact_name` varchar(50) DEFAULT NULL,
  `settle_entity_name` varchar(50) DEFAULT NULL,
  `dept_name` varchar(50) DEFAULT NULL,
  `item_name` varchar(50) DEFAULT NULL,
  `item_class` varchar(50) DEFAULT NULL,
  `item_id` bigint(20) DEFAULT NULL,
  `qty` decimal(20,4) DEFAULT NULL COMMENT '数量',
  `price` decimal(20,4) DEFAULT NULL COMMENT '单价',
  `total_amount` decimal(20,4) DEFAULT NULL,
  `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) DEFAULT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
  `contact_id` bigint(20) DEFAULT NULL,
  `settle_entity_id` bigint(20) DEFAULT NULL,
  `dept_id` bigint(20) DEFAULT NULL,
  `pur_order_no` varchar(20) DEFAULT NULL,
  `tax_amount` decimal(20,4) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `create_user_id_index` (`create_user_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='预付款采购单明细';

-- ----------------------------
-- Table structure for pur_pre_settle_inv
-- ----------------------------

CREATE TABLE `pur_pre_settle_inv` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '记录唯一ID',
  `pre_settle_id` bigint(20) DEFAULT NULL,
  `invoice_number` varchar(20) DEFAULT NULL,
  `invoice_code` varchar(20) DEFAULT NULL,
  `invoice_type` varchar(20) DEFAULT NULL,
  `tax_rate` decimal(4,2) DEFAULT NULL,
  `tax_amount` decimal(20,4) DEFAULT NULL,
  `no_tax_amount` decimal(20,4) DEFAULT NULL,
  `total_amount` decimal(20,4) DEFAULT NULL,
  `total_amount_base` decimal(20,4) DEFAULT NULL,
  `check_state` varchar(20) DEFAULT NULL,
  `invoice_date` datetime DEFAULT NULL,
  `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `create_user_id_index` (`create_user_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='采购发票明细';

-- ----------------------------
-- Table structure for pur_pre_settle_pay
-- ----------------------------

CREATE TABLE `pur_pre_settle_pay` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '记录唯一ID',
  `pre_settle_id` bigint(20) DEFAULT NULL,
  `receive_entity` varchar(50) DEFAULT NULL,
  `contact_name` varchar(50) DEFAULT NULL,
  `account` varchar(20) DEFAULT NULL COMMENT '账户',
  `pay_amount` decimal(20,4) DEFAULT NULL,
  `no_pay_amount` varchar(20) DEFAULT NULL,
  `settle_entity_name` varchar(50) DEFAULT NULL,
  `pay_method` varchar(20) DEFAULT NULL,
  `plan_pay_time` datetime DEFAULT NULL,
  `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) DEFAULT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
  `contact_id` bigint(20) DEFAULT NULL,
  `settle_entity_id` bigint(20) DEFAULT NULL,
  `approve_amount` decimal(20,4) DEFAULT NULL,
  `contract_no` varchar(20) DEFAULT NULL,
  `pre_type_id` bigint(20) DEFAULT NULL,
  `pre_type_code` varchar(20) DEFAULT NULL,
  `pre_type_name` varchar(50) DEFAULT NULL,
  `contract_plan` varchar(50) DEFAULT NULL,
  `verify_amount` decimal(20,4) DEFAULT NULL,
  `we_account` varchar(20) DEFAULT NULL,
  `we_account_name` varchar(50) DEFAULT NULL,
  `pay_type` varchar(20) DEFAULT NULL,
  `reimburse_no` varchar(20) DEFAULT NULL,
  `account_name` varchar(20) DEFAULT NULL,
  `pay_clause` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `create_user_id_index` (`create_user_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='预付款单付款信息';

-- ----------------------------
-- Table structure for pur_pre_verify
-- ----------------------------

CREATE TABLE `pur_pre_verify` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '记录唯一ID',
  `business_no` varchar(32) DEFAULT NULL,
  `business_date` datetime DEFAULT NULL,
  `order_no` varchar(32) DEFAULT NULL,
  `create_mode` varchar(20) DEFAULT NULL,
  `currency` varchar(20) DEFAULT NULL COMMENT '币种',
  `business_amount` decimal(20,4) DEFAULT NULL,
  `can_verify_amount` decimal(20,4) DEFAULT NULL,
  `account_name` varchar(50) DEFAULT NULL,
  `account` varchar(20) DEFAULT NULL COMMENT '账户',
  `contract_no` varchar(20) DEFAULT NULL,
  `state` varchar(20) DEFAULT NULL COMMENT '状态',
  `verify_state` varchar(20) DEFAULT NULL,
  `receive_entity` varchar(50) DEFAULT NULL,
  `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) DEFAULT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
  `verify_no` varchar(32) DEFAULT NULL,
  `settle_entity_id` bigint(20) DEFAULT NULL,
  `settle_entity_name` varchar(50) DEFAULT NULL,
  `contact_id` bigint(20) DEFAULT NULL,
  `contact_name` varchar(50) DEFAULT NULL,
  `pre_settle_no` varchar(20) DEFAULT NULL,
  `curr_code` varchar(20) DEFAULT NULL,
  `curr_name` varchar(20) DEFAULT NULL,
  `pre_flag` tinyint(1) DEFAULT NULL,
  `bu_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `create_user_id_index` (`create_user_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='预付款核销';

-- ----------------------------
-- Table structure for pur_pre_verify_dtl
-- ----------------------------

CREATE TABLE `pur_pre_verify_dtl` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '记录唯一ID',
  `pre_verify_id` bigint(20) DEFAULT NULL,
  `pre_settle_no` varchar(32) DEFAULT NULL,
  `pre_settle_name` varchar(32) DEFAULT NULL,
  `pur_settle_number` varchar(32) DEFAULT NULL,
  `pur_settle_name` varchar(32) DEFAULT NULL,
  `relation_number` varchar(32) DEFAULT NULL,
  `state` varchar(20) DEFAULT NULL COMMENT '单据状态',
  `total_amount` decimal(20,4) DEFAULT NULL,
  `settle_entity_name` varchar(50) DEFAULT NULL,
  `receive_account` varchar(20) DEFAULT NULL,
  `receivement` varchar(50) DEFAULT NULL COMMENT '收款方',
  `verify_amount` decimal(20,4) DEFAULT NULL,
  `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) DEFAULT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
  `pur_settle_id` bigint(20) DEFAULT NULL,
  `pre_settle_id` bigint(20) DEFAULT NULL,
  `pur_settle_code` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `create_user_id_index` (`create_user_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='预收款核销明细';

-- ----------------------------
-- Table structure for pur_purc_price
-- ----------------------------

CREATE TABLE `pur_purc_price` (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `sec_bu_id` bigint(20) DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) DEFAULT NULL COMMENT 'sec_ou_id',
  `ou_id` bigint(20) DEFAULT NULL COMMENT '公司ID',
  `bu_id` bigint(20) DEFAULT NULL COMMENT '组织中心(BU)ID',
  `bd_id` bigint(20) DEFAULT NULL COMMENT '事业部ID',
  `price_no` varchar(40) DEFAULT NULL COMMENT '价格编号',
  `price_type` varchar(40) DEFAULT NULL COMMENT '价格类型',
  `price_type2` varchar(40) DEFAULT NULL COMMENT '价格类型2',
  `price_type3` varchar(40) DEFAULT NULL COMMENT '价格类型3',
  `item_id` bigint(20) DEFAULT NULL COMMENT '品项ID',
  `item_brand` varchar(40) DEFAULT NULL COMMENT '品牌',
  `item_brand2` varchar(40) DEFAULT NULL COMMENT '品牌2',
  `nonitem_type` varchar(40) DEFAULT NULL COMMENT '非品项价格对象类型',
  `nonitem_code` varchar(40) DEFAULT NULL COMMENT '非品项价格对象编号',
  `supp_id` bigint(20) DEFAULT NULL COMMENT '供应商ID',
  `supp_code` varchar(40) DEFAULT NULL COMMENT '供应商编号',
  `supp_abbr` varchar(40) DEFAULT NULL COMMENT '供应商简称',
  `supp_name` varchar(200) DEFAULT NULL COMMENT '供应商名称',
  `region` varchar(40) DEFAULT NULL COMMENT '采购区域',
  `price_group` varchar(40) DEFAULT NULL COMMENT '价格组',
  `shipto_addr_no` bigint(18) DEFAULT NULL COMMENT '配送地址号',
  `wh_id` bigint(20) DEFAULT NULL COMMENT '仓库ID',
  `from_qty` double(20,8) DEFAULT NULL COMMENT '从数量',
  `to_qty` double(20,8) DEFAULT NULL COMMENT '到数量',
  `uom` varchar(10) DEFAULT NULL COMMENT '单位',
  `net_price` decimal(20,4) DEFAULT NULL COMMENT '不含税单价',
  `tax_code` varchar(40) DEFAULT NULL COMMENT '税码',
  `tax_rate_no` varchar(40) DEFAULT NULL COMMENT '税率编号',
  `tax_rate` double(20,8) DEFAULT NULL COMMENT '税率',
  `price` decimal(20,4) DEFAULT NULL COMMENT '含税单价',
  `freight_tax_price` decimal(20,4) DEFAULT NULL COMMENT '含运费含税价格',
  `freight_net_price` decimal(20,4) DEFAULT NULL COMMENT '含运费净价',
  `freight_price` decimal(20,4) DEFAULT NULL COMMENT '运费',
  `fee1_desc` varchar(40) DEFAULT NULL COMMENT '费用1描述',
  `fee1` decimal(20,4) DEFAULT NULL COMMENT '费用1',
  `fee2_desc` varchar(40) DEFAULT NULL COMMENT '费用2描述',
  `fee2` decimal(20,4) DEFAULT NULL COMMENT '费用2',
  `fee3_desc` varchar(40) DEFAULT NULL COMMENT '费用3描述',
  `fee3` decimal(20,4) DEFAULT NULL COMMENT '费用3',
  `disc_ratio` double(20,8) DEFAULT NULL COMMENT '折扣率',
  `total_price` decimal(20,4) DEFAULT NULL COMMENT '总价',
  `freight_uom` varchar(10) DEFAULT NULL COMMENT '运费单位',
  `e_price1` decimal(20,4) DEFAULT NULL COMMENT '辅助价格1',
  `e_price2` decimal(20,4) DEFAULT NULL COMMENT '辅助价格2',
  `e_price3` decimal(20,4) DEFAULT NULL COMMENT '辅助价格3',
  `curr_code` varchar(40) DEFAULT NULL COMMENT '币种',
  `price_date` datetime DEFAULT NULL COMMENT '定价时间',
  `valid_from` datetime DEFAULT NULL COMMENT '生效时间',
  `valid_to` datetime DEFAULT NULL COMMENT '失效时间',
  `period_id` bigint(20) DEFAULT NULL COMMENT '期间ID',
  `relate_id1` bigint(20) DEFAULT NULL COMMENT '相关ID1 促销活动等',
  `relate_id2` bigint(20) DEFAULT NULL COMMENT '相关ID2',
  `relate_id3` bigint(20) DEFAULT NULL COMMENT '相关ID3',
  `buyed_qty` double(20,8) DEFAULT NULL COMMENT '实际采购量',
  `price_delta` double(20,8) DEFAULT NULL COMMENT '价格涨跌幅',
  `price_status` varchar(40) DEFAULT NULL COMMENT '价格状态',
  `price_source` varchar(40) DEFAULT NULL COMMENT '价格来源',
  `src_doc_cls` varchar(40) DEFAULT NULL COMMENT '来源单据类别',
  `src_doc_id` bigint(20) DEFAULT NULL COMMENT '来源单据ID',
  `src_doc_no` varchar(40) DEFAULT NULL COMMENT '来源单据编号',
  `src_d_id` bigint(20) DEFAULT NULL COMMENT '来源单据明细ID',
  `src_doc_cls2` varchar(40) DEFAULT NULL COMMENT '来源单据类别2',
  `src_doc_id2` bigint(20) DEFAULT NULL COMMENT '来源单据ID2',
  `src_doc_no2` varchar(40) DEFAULT NULL COMMENT '来源单据编号2',
  `src_d_id2` bigint(20) DEFAULT NULL COMMENT '来源单据明细ID2',
  `es1` varchar(40) DEFAULT NULL COMMENT 'ES1',
  `es2` varchar(40) DEFAULT NULL COMMENT 'ES2',
  `es3` varchar(40) DEFAULT NULL COMMENT 'ES3',
  `es4` varchar(40) DEFAULT NULL COMMENT 'ES4',
  `es5` varchar(40) DEFAULT NULL COMMENT 'ES5',
  `en1` double(20,8) DEFAULT NULL COMMENT 'EN1',
  `en2` double(20,8) DEFAULT NULL COMMENT 'EN2',
  `en3` double(20,8) DEFAULT NULL COMMENT 'EN3',
  `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `create_user_id_index` (`create_user_id`) USING BTREE,
  KEY `sec_bu_id_index` (`sec_bu_id`) USING BTREE,
  KEY `sec_user_id_index` (`sec_user_id`) USING BTREE,
  KEY `sec_ou_id_index` (`sec_ou_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='品项采购价格';

-- ----------------------------
-- Table structure for pur_purc_price_apply
-- ----------------------------

CREATE TABLE `pur_purc_price_apply` (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `sec_bu_id` bigint(20) DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) DEFAULT NULL COMMENT 'sec_ou_id',
  `doc_no` varchar(40) DEFAULT NULL COMMENT '单据编号',
  `doc_status` varchar(40) DEFAULT NULL COMMENT '单据状态',
  `doc_type` varchar(10) DEFAULT NULL COMMENT '单据类型 [UDC]',
  `ou_id` bigint(20) DEFAULT NULL COMMENT '公司ID',
  `bu_id` bigint(20) DEFAULT NULL COMMENT '组织ID',
  `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
  `proc_inst_id` varchar(255) DEFAULT NULL COMMENT '流程实例ID',
  `proc_inst_status` varchar(255) DEFAULT NULL COMMENT '流程实例状态',
  `submit_time` datetime(6) DEFAULT NULL COMMENT '提交时间',
  `approved_time` datetime(6) DEFAULT NULL COMMENT '审批通过时间',
  `file_code` varchar(2000) DEFAULT NULL COMMENT '文件服务器编码',
  `price_apply_type` varchar(2) DEFAULT NULL COMMENT '价格申请类型',
  `supp_id` bigint(20) DEFAULT NULL COMMENT '供应商ID',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `create_user_id_index` (`create_user_id`) USING BTREE,
  KEY `sec_bu_id_index` (`sec_bu_id`) USING BTREE,
  KEY `sec_user_id_index` (`sec_user_id`) USING BTREE,
  KEY `sec_ou_id_index` (`sec_ou_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='采购价格申请';

-- ----------------------------
-- Table structure for pur_purc_price_apply_d
-- ----------------------------

CREATE TABLE `pur_purc_price_apply_d` (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `sec_bu_id` bigint(20) DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) DEFAULT NULL COMMENT 'sec_ou_id',
  `mas_id` bigint(20) DEFAULT NULL COMMENT '主表ID',
  `ou_id` bigint(20) DEFAULT NULL COMMENT '公司ID',
  `bu_id` bigint(20) DEFAULT NULL COMMENT '组织中心(BU)ID',
  `bd_id` bigint(20) DEFAULT NULL COMMENT '事业部ID',
  `price_no` varchar(40) DEFAULT NULL COMMENT '价格编号',
  `price_type` varchar(40) DEFAULT NULL COMMENT '价格类型',
  `price_type2` varchar(40) DEFAULT NULL COMMENT '价格类型2',
  `price_type3` varchar(40) DEFAULT NULL COMMENT '价格类型3',
  `item_id` bigint(20) DEFAULT NULL COMMENT '品项ID',
  `item_brand` varchar(40) DEFAULT NULL COMMENT '品牌',
  `item_brand2` varchar(40) DEFAULT NULL COMMENT '品牌2',
  `nonitem_type` varchar(40) DEFAULT NULL COMMENT '非品项价格对象类型',
  `nonitem_code` varchar(40) DEFAULT NULL COMMENT '非品项价格对象编号',
  `supp_id` bigint(20) DEFAULT NULL COMMENT '供应商ID',
  `supp_code` varchar(40) DEFAULT NULL COMMENT '供应商编号',
  `supp_abbr` varchar(40) DEFAULT NULL COMMENT '供应商简称',
  `supp_name` varchar(200) DEFAULT NULL COMMENT '供应商名称',
  `region` varchar(40) DEFAULT NULL COMMENT '采购区域',
  `price_group` varchar(40) DEFAULT NULL COMMENT '价格组',
  `shipto_addr_no` bigint(18) DEFAULT NULL COMMENT '配送地址号',
  `wh_id` bigint(20) DEFAULT NULL COMMENT '仓库ID',
  `from_qty` double(20,8) DEFAULT NULL COMMENT '从数量',
  `to_qty` double(20,8) DEFAULT NULL COMMENT '到数量',
  `uom` varchar(10) DEFAULT NULL COMMENT '单位',
  `net_price` decimal(20,4) DEFAULT NULL COMMENT '不含税单价',
  `tax_code` varchar(40) DEFAULT NULL COMMENT '税码',
  `tax_rate_no` varchar(40) DEFAULT NULL COMMENT '税率编号',
  `tax_rate` double(20,8) DEFAULT NULL COMMENT '税率',
  `price` decimal(20,4) DEFAULT NULL COMMENT '含税单价',
  `freight_tax_price` decimal(20,4) DEFAULT NULL COMMENT '含运费含税价格',
  `freight_net_price` decimal(20,4) DEFAULT NULL COMMENT '含运费净价',
  `freight_price` decimal(20,4) DEFAULT NULL COMMENT '运费',
  `fee1_desc` varchar(40) DEFAULT NULL COMMENT '费用1描述',
  `fee1` decimal(20,4) DEFAULT NULL COMMENT '费用1',
  `fee2_desc` varchar(40) DEFAULT NULL COMMENT '费用2描述',
  `fee2` decimal(20,4) DEFAULT NULL COMMENT '费用2',
  `fee3_desc` varchar(40) DEFAULT NULL COMMENT '费用3描述',
  `fee3` decimal(20,4) DEFAULT NULL COMMENT '费用3',
  `disc_ratio` double(20,8) DEFAULT NULL COMMENT '折扣率',
  `total_price` decimal(20,4) DEFAULT NULL COMMENT '总价',
  `freight_uom` varchar(10) DEFAULT NULL COMMENT '运费单位',
  `e_price1` decimal(20,4) DEFAULT NULL COMMENT '辅助价格1',
  `e_price2` decimal(20,4) DEFAULT NULL COMMENT '辅助价格2',
  `e_price3` decimal(20,4) DEFAULT NULL COMMENT '辅助价格3',
  `curr_code` varchar(40) DEFAULT NULL COMMENT '币种',
  `price_date` datetime DEFAULT NULL COMMENT '定价时间',
  `valid_from` datetime DEFAULT NULL COMMENT '生效时间',
  `valid_to` datetime DEFAULT NULL COMMENT '失效时间',
  `period_id` bigint(20) DEFAULT NULL COMMENT '期间ID',
  `relate_id1` bigint(20) DEFAULT NULL COMMENT '相关ID1 促销活动等',
  `relate_id2` bigint(20) DEFAULT NULL COMMENT '相关ID2',
  `relate_id3` bigint(20) DEFAULT NULL COMMENT '相关ID3',
  `buyed_qty` double(20,8) DEFAULT NULL COMMENT '实际采购量',
  `price_delta` double(20,8) DEFAULT NULL COMMENT '价格涨跌幅',
  `price_status` varchar(40) DEFAULT NULL COMMENT '价格状态',
  `price_source` varchar(40) DEFAULT NULL COMMENT '价格来源',
  `src_doc_cls` varchar(40) DEFAULT NULL COMMENT '来源单据类别',
  `src_doc_id` bigint(20) DEFAULT NULL COMMENT '来源单据ID',
  `src_doc_no` varchar(40) DEFAULT NULL COMMENT '来源单据编号',
  `src_d_id` bigint(20) DEFAULT NULL COMMENT '来源单据明细ID',
  `src_doc_cls2` varchar(40) DEFAULT NULL COMMENT '来源单据类别2',
  `src_doc_id2` bigint(20) DEFAULT NULL COMMENT '来源单据ID2',
  `src_doc_no2` varchar(40) DEFAULT NULL COMMENT '来源单据编号2',
  `src_d_id2` bigint(20) DEFAULT NULL COMMENT '来源单据明细ID2',
  `es1` varchar(40) DEFAULT NULL COMMENT 'ES1',
  `es2` varchar(40) DEFAULT NULL COMMENT 'ES2',
  `es3` varchar(40) DEFAULT NULL COMMENT 'ES3',
  `es4` varchar(40) DEFAULT NULL COMMENT 'ES4',
  `es5` varchar(40) DEFAULT NULL COMMENT 'ES5',
  `en1` double(20,8) DEFAULT NULL COMMENT 'EN1',
  `en2` double(20,8) DEFAULT NULL COMMENT 'EN2',
  `en3` double(20,8) DEFAULT NULL COMMENT 'EN3',
  `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
  `expiry_date` datetime(6) DEFAULT NULL COMMENT '终止日期',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `create_user_id_index` (`create_user_id`) USING BTREE,
  KEY `sec_bu_id_index` (`sec_bu_id`) USING BTREE,
  KEY `sec_user_id_index` (`sec_user_id`) USING BTREE,
  KEY `sec_ou_id_index` (`sec_ou_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='采购价格申请';

-- ----------------------------
-- Table structure for pur_return_address
-- ----------------------------

CREATE TABLE `pur_return_address` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '记录唯一ID',
  `supp_id` bigint(20) DEFAULT NULL COMMENT '供应商ID',
  `supp_code` varchar(40) DEFAULT NULL COMMENT '供应商编号',
  `item_id` bigint(20) DEFAULT NULL COMMENT '商品ID',
  `item_code` varchar(40) DEFAULT NULL COMMENT '商品编号',
  `return_person` varchar(40) DEFAULT NULL COMMENT '退货联络人',
  `return_tel` varchar(40) DEFAULT NULL COMMENT '联络人电话',
  `country` varchar(40) DEFAULT NULL COMMENT '国家',
  `province` varchar(40) DEFAULT NULL COMMENT '省',
  `city` varchar(40) DEFAULT NULL COMMENT '市',
  `county` varchar(40) DEFAULT NULL COMMENT '区县',
  `street` varchar(100) DEFAULT NULL COMMENT '街道/乡镇',
  `detail_addr` varchar(100) DEFAULT NULL COMMENT '退货详细地址',
  `sync_flag` tinyint(1) DEFAULT NULL COMMENT '是否同步：1是，0否',
  `es1` varchar(64) DEFAULT NULL COMMENT 'ES1',
  `es2` varchar(64) DEFAULT NULL COMMENT 'ES2',
  `es3` varchar(64) DEFAULT NULL COMMENT 'ES3',
  `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
  `sec_bu_id` bigint(20) DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) DEFAULT NULL COMMENT 'sec_ou_id',
  `return_address_type` varchar(64) DEFAULT NULL COMMENT '采购退货地址类型 [UDC]PUR:RN_ADDR_TYPE',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `sec_bu_id_index` (`sec_bu_id`) USING BTREE,
  KEY `sec_user_id_index` (`sec_user_id`) USING BTREE,
  KEY `sec_ou_id_index` (`sec_ou_id`) USING BTREE,
  KEY `create_user_id_index` (`create_user_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=527462521487814657 DEFAULT CHARSET=utf8mb4 COMMENT='采购退货地址';

-- ----------------------------
-- Table structure for pur_rma
-- ----------------------------

CREATE TABLE `pur_rma` (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `sec_bu_id` bigint(20) DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) DEFAULT NULL COMMENT 'sec_ou_id',
  `ou_id` bigint(20) DEFAULT NULL COMMENT '公司ID',
  `bu_id` bigint(20) DEFAULT NULL COMMENT 'BUID',
  `doc_no` varchar(40) DEFAULT NULL COMMENT 'RMA编号',
  `doc_type` varchar(10) DEFAULT NULL COMMENT 'RMA类型 [UDC]PUR:RMA_TYPE',
  `doc_status` varchar(40) DEFAULT NULL COMMENT 'RMA状态 [UDC]PUR:RMA_STATUS',
  `doc_date` datetime DEFAULT NULL COMMENT '发起日期',
  `doc_emp_id` bigint(20) DEFAULT NULL COMMENT '发起人员工ID',
  `supp_id` bigint(20) DEFAULT NULL COMMENT '供应商ID',
  `wh_id` bigint(20) DEFAULT NULL COMMENT '仓库ID',
  `qty` decimal(20,8) DEFAULT NULL COMMENT '总数量',
  `curr_amt` decimal(20,8) DEFAULT NULL COMMENT '外币含税总金额',
  `curr_net_amt` decimal(20,8) DEFAULT NULL COMMENT '外币未税总金额',
  `reason_code` varchar(40) DEFAULT NULL COMMENT '原因码 [UDC]COM:REASON_CODE',
  `relate_doc_cls` varchar(40) DEFAULT NULL COMMENT '关联单据类别 [UDC]COM:DOC_CLS',
  `relate_doc_type` varchar(40) DEFAULT NULL COMMENT '关联单据类型',
  `relate_doc_id` bigint(20) DEFAULT NULL COMMENT '关联单据ID',
  `relate_doc_no` varchar(40) DEFAULT NULL COMMENT '关联单据编号',
  `relate_id` bigint(20) DEFAULT NULL COMMENT '关联ID',
  `relate_no` varchar(40) DEFAULT NULL COMMENT '关联编号 过期处理单',
  `relate2_id` bigint(20) DEFAULT NULL COMMENT '关联2ID',
  `relate2_no` varchar(40) DEFAULT NULL COMMENT '关联2编号',
  `file_code` varchar(2000) DEFAULT NULL COMMENT '文件服务器编码',
  `deter2` varchar(40) DEFAULT NULL COMMENT '功能区 [UDC]INV:FUNC_TYPE',
  `es1` varchar(40) DEFAULT NULL COMMENT 'ES1',
  `es2` varchar(40) DEFAULT NULL COMMENT 'ES2',
  `es3` varchar(40) DEFAULT NULL COMMENT 'ES3',
  `es4` varchar(40) DEFAULT NULL COMMENT 'ES4',
  `es5` varchar(40) DEFAULT NULL COMMENT 'ES5',
  `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
  `po_id` bigint(20) DEFAULT '0' COMMENT '采购订单主表ID',
  `amt` decimal(20,8) DEFAULT NULL COMMENT '含税总金额',
  `net_amt` decimal(20,8) DEFAULT NULL COMMENT '未税总金额',
  `proc_inst_id` varchar(255) DEFAULT NULL COMMENT '流程实例ID',
  `proc_inst_status` varchar(255) DEFAULT NULL COMMENT '流程实例状态',
  `submit_time` datetime(6) DEFAULT NULL COMMENT '提交时间',
  `approved_time` datetime(6) DEFAULT NULL COMMENT '审批通过时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `create_user_id_index` (`create_user_id`) USING BTREE,
  KEY `sec_bu_id_index` (`sec_bu_id`) USING BTREE,
  KEY `sec_user_id_index` (`sec_user_id`) USING BTREE,
  KEY `sec_ou_id_index` (`sec_ou_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='采购RMA';

-- ----------------------------
-- Table structure for pur_rma_d
-- ----------------------------

CREATE TABLE `pur_rma_d` (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `sec_bu_id` bigint(20) DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) DEFAULT NULL COMMENT 'sec_ou_id',
  `mas_id` bigint(20) DEFAULT NULL COMMENT '主表ID',
  `line_no` float(20,2) DEFAULT NULL COMMENT '行号',
  `wh_id` bigint(20) DEFAULT NULL COMMENT '仓库ID',
  `deter1` varchar(40) DEFAULT NULL COMMENT '温层 [UDC]INV:TEMP_TYPE',
  `deter2` varchar(40) DEFAULT NULL COMMENT '功能区 [UDC]INV:FUNC_TYPE',
  `deter3` varchar(40) DEFAULT NULL COMMENT '客户标识',
  `deter4` varchar(40) DEFAULT NULL COMMENT '限定4',
  `deter5` varchar(40) DEFAULT NULL COMMENT '限定5',
  `deter6` varchar(40) DEFAULT NULL COMMENT '限定6',
  `deter7` varchar(40) DEFAULT NULL COMMENT '限定7',
  `deter8` varchar(40) DEFAULT NULL COMMENT '限定8',
  `item_id` bigint(20) DEFAULT NULL COMMENT '品项ID',
  `vari_id` bigint(20) DEFAULT NULL COMMENT '异构ID',
  `brand` varchar(40) DEFAULT NULL COMMENT '品牌',
  `lot_no` varchar(40) DEFAULT NULL COMMENT '批次',
  `qty` decimal(20,8) DEFAULT NULL COMMENT '数量',
  `uom` varchar(10) DEFAULT NULL COMMENT '单位',
  `qty2` decimal(20,8) DEFAULT NULL COMMENT '数量2',
  `uom2` varchar(10) DEFAULT NULL COMMENT '单位2',
  `uom_ratio` float(20,8) DEFAULT NULL COMMENT '单位转换率',
  `uom_ratio2` float(20,8) DEFAULT NULL COMMENT '单位转换率2',
  `net_price` decimal(20,8) DEFAULT NULL COMMENT '不含税价格',
  `price` decimal(20,8) DEFAULT NULL COMMENT '含税单价',
  `trans_price` decimal(20,8) DEFAULT NULL COMMENT '交易单价 折扣后，不含税',
  `tax_rate` decimal(20,8) DEFAULT NULL COMMENT '税率',
  `tax_amt` decimal(20,8) DEFAULT NULL COMMENT '税额',
  `amt` decimal(20,8) DEFAULT NULL COMMENT '含税金额',
  `net_amt` decimal(20,8) DEFAULT NULL COMMENT '不含税金额',
  `curr_amt` decimal(20,8) DEFAULT NULL COMMENT '外币含税金额',
  `home_curr` varchar(40) DEFAULT NULL COMMENT '本币币种',
  `curr_code` varchar(40) DEFAULT NULL COMMENT '币种',
  `curr_rate` decimal(20,8) DEFAULT NULL COMMENT '汇率',
  `curr_net_amt` decimal(20,8) DEFAULT NULL COMMENT '外币不含税金额',
  `reason_code` varchar(40) DEFAULT NULL COMMENT '原因码 [UDC]COM:REASON_CODE',
  `relate_doc_cls` varchar(40) DEFAULT NULL COMMENT '关联单据类别 [UDC]COM:DOC_CLS',
  `relate_doc_type` varchar(40) DEFAULT NULL COMMENT '关联单据类型',
  `relate_doc_id` bigint(20) DEFAULT NULL COMMENT '关联单据ID',
  `relate_doc_no` varchar(40) DEFAULT NULL COMMENT '关联单据编号',
  `relate_doc_did` int(18) DEFAULT NULL COMMENT '关联单据明细ID',
  `relate_doc_lineno` float(20,2) DEFAULT NULL COMMENT '关联单据行号',
  `relate_doc2_cls` varchar(40) DEFAULT NULL COMMENT '关联单据2类别 [UDC]COM:DOC_CLS',
  `relate_doc2_type` varchar(40) DEFAULT NULL COMMENT '关联单据2类型',
  `relate_doc2_id` bigint(20) DEFAULT NULL COMMENT '关联单据2ID',
  `relate_doc2_no` varchar(40) DEFAULT NULL COMMENT '关联单据2编号',
  `relate_doc2_did` int(18) DEFAULT NULL COMMENT '关联单据2明细ID',
  `relate_doc2_lineno` float(20,2) DEFAULT NULL COMMENT '关联单据2行号',
  `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
  `lot_flag` tinyint(1) DEFAULT NULL COMMENT '是否启用批次',
  `curr_net_price` decimal(20,8) DEFAULT NULL COMMENT '不含税价格',
  `curr_price` decimal(20,8) DEFAULT NULL COMMENT '含税单价',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `create_user_id_index` (`create_user_id`) USING BTREE,
  KEY `sec_bu_id_index` (`sec_bu_id`) USING BTREE,
  KEY `sec_user_id_index` (`sec_user_id`) USING BTREE,
  KEY `sec_ou_id_index` (`sec_ou_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='采购RMA明细';

-- ----------------------------
-- Table structure for pur_rma_deal
-- ----------------------------

CREATE TABLE `pur_rma_deal` (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `sec_bu_id` bigint(20) DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) DEFAULT NULL COMMENT 'sec_ou_id',
  `rma_d_id` bigint(20) DEFAULT NULL COMMENT 'RMA明细ID',
  `deal_method` varchar(40) DEFAULT NULL COMMENT '处理方式类型 [UDC]PUR:RMA_DEAL_METHOD',
  `qty` float(20,8) DEFAULT NULL COMMENT '数量',
  `uom` varchar(10) DEFAULT NULL COMMENT '单位',
  `deal_desc` varchar(100) DEFAULT NULL COMMENT '处理描述',
  `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `create_user_id_index` (`create_user_id`) USING BTREE,
  KEY `sec_bu_id_index` (`sec_bu_id`) USING BTREE,
  KEY `sec_user_id_index` (`sec_user_id`) USING BTREE,
  KEY `sec_ou_id_index` (`sec_ou_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='采购RMA处理';

-- ----------------------------
-- Table structure for pur_rns
-- ----------------------------

CREATE TABLE `pur_rns` (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `sec_bu_id` bigint(20) DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) DEFAULT NULL COMMENT 'sec_ou_id',
  `ou_id` bigint(20) DEFAULT NULL COMMENT '公司ID',
  `po_id` bigint(20) DEFAULT NULL COMMENT '公司ID',
  `bu_id` bigint(20) DEFAULT NULL COMMENT 'BUID',
  `doc_no` varchar(40) DEFAULT NULL COMMENT '退货单编号',
  `doc_type` varchar(10) DEFAULT NULL COMMENT '退货类型 [UDC]PUR:RNS_TYPE',
  `doc_status` varchar(40) DEFAULT NULL COMMENT '退货单状态 [UDC]PUR:RNS_STATUS',
  `doc_date` datetime DEFAULT NULL COMMENT '发起日期',
  `doc_emp_id` bigint(20) DEFAULT '0' COMMENT '退货人员工ID',
  `supp_id` bigint(20) DEFAULT '0' COMMENT '供应商ID',
  `scene_type_id` bigint(20) DEFAULT '0' COMMENT '采购场景类型ID',
  `finish_comment` varchar(500) DEFAULT NULL COMMENT '订单完成备注',
  `supp_contact_name` varchar(40) DEFAULT NULL COMMENT '供应商联系人 供应商跟单人员',
  `supp_contact_tel` varchar(40) DEFAULT NULL COMMENT '供应商联系电话',
  `supp_contact_email` varchar(40) DEFAULT NULL COMMENT '供应商联系人邮箱',
  `return_addr` varchar(400) DEFAULT NULL COMMENT '退货地址',
  `carrier_supp_id` bigint(20) DEFAULT '0' COMMENT '承运商供应商ID',
  `carrier` varchar(40) DEFAULT NULL COMMENT '承运商',
  `deliver_desc` varchar(40) DEFAULT NULL COMMENT '配送方式',
  `wh_id` bigint(20) DEFAULT NULL COMMENT '仓库ID',
  `pickup_addr` varchar(400) DEFAULT NULL COMMENT '提货地址',
  `qty` decimal(20,8) DEFAULT NULL COMMENT '总数量',
  `accept_qty` decimal(20,8) DEFAULT NULL COMMENT '已收数量',
  `qty_uom` varchar(10) DEFAULT NULL COMMENT '数量单位',
  `qty2` decimal(20,8) DEFAULT NULL COMMENT '总数量2',
  `qty2_uom` varchar(10) DEFAULT NULL COMMENT '数量2单位',
  `net_weight` decimal(20,8) DEFAULT NULL COMMENT '净重',
  `gross_weight` decimal(20,8) DEFAULT NULL COMMENT '毛重',
  `weight_uom` varchar(10) DEFAULT NULL COMMENT '重量单位',
  `volume` decimal(20,8) DEFAULT NULL COMMENT '体积',
  `volume_uom` varchar(10) DEFAULT NULL COMMENT '体积单位',
  `tax_amt` decimal(20,8) DEFAULT NULL COMMENT '税额',
  `tax_code` varchar(40) DEFAULT NULL COMMENT '税种',
  `tax_rate_no` varchar(40) DEFAULT NULL COMMENT '税率编号',
  `tax_rate` decimal(20,8) DEFAULT NULL COMMENT '税率编号',
  `amt` decimal(20,8) DEFAULT NULL COMMENT '含税金额',
  `net_amt` decimal(20,8) DEFAULT NULL COMMENT '不含税金额',
  `home_curr` varchar(10) DEFAULT NULL COMMENT '记账币种',
  `curr_code` varchar(10) DEFAULT NULL COMMENT '交易币种',
  `curr_rate` decimal(20,8) DEFAULT NULL COMMENT '汇率',
  `curr_net_amt` decimal(20,8) DEFAULT NULL COMMENT '外币不含税金额',
  `curr_amt` decimal(20,8) DEFAULT NULL COMMENT '外币含税金额',
  `gen_type` varchar(40) DEFAULT NULL COMMENT '生成类型 [UDC]COM:DOC_GEN_TYPE',
  `gen_type2` varchar(40) DEFAULT NULL COMMENT '生成类型2',
  `root_id` bigint(20) DEFAULT '0' COMMENT '根ID',
  `relate_doc_cls` varchar(40) DEFAULT NULL COMMENT '关联单据类别 [UDC]RMA。COM:DOC_CLS',
  `relate_doc_type` varchar(40) DEFAULT NULL COMMENT '关联单据类型',
  `relate_doc_id` bigint(20) DEFAULT '0' COMMENT '关联单据ID',
  `relate_doc_no` varchar(40) DEFAULT NULL COMMENT '关联单据编号',
  `relate_id` bigint(20) DEFAULT '0' COMMENT '关联ID',
  `relate_no` varchar(40) DEFAULT NULL COMMENT '关联编号',
  `relate2_id` bigint(20) DEFAULT '0' COMMENT '关联2ID',
  `relate2_no` varchar(40) DEFAULT NULL COMMENT '关联2编号',
  `deter2` varchar(40) DEFAULT NULL COMMENT '功能区 [UDC]INV:FUNC_TYPE',
  `es1` varchar(40) DEFAULT NULL COMMENT 'ES1',
  `es2` varchar(40) DEFAULT NULL COMMENT 'ES2',
  `es3` varchar(40) DEFAULT NULL COMMENT 'ES3',
  `es4` varchar(40) DEFAULT NULL COMMENT 'ES4',
  `es5` varchar(40) DEFAULT NULL COMMENT 'ES5',
  `pb_price` decimal(40,0) DEFAULT NULL COMMENT '定价价格',
  `pb_curr` varchar(40) DEFAULT NULL COMMENT '定价币种',
  `pb_uom` varchar(40) DEFAULT NULL COMMENT '定价单位',
  `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
  `proc_inst_id` varchar(40) DEFAULT NULL COMMENT '流程实例ID',
  `proc_inst_status` varchar(40) DEFAULT NULL COMMENT '流程实例状态',
  `submit_time` datetime(6) DEFAULT NULL COMMENT '提交时间',
  `approved_time` datetime(6) DEFAULT NULL COMMENT '审批通过时间',
  `sal_doc_date` date DEFAULT NULL COMMENT '发货单日期',
  `close_date` datetime DEFAULT NULL COMMENT '关闭日期',
  `region` varchar(40) DEFAULT NULL COMMENT '区域',
  `po_doc_no` varchar(255) DEFAULT NULL COMMENT '采购订单号',
  `relate_doc2_id` bigint(20) DEFAULT '0' COMMENT '关联单据2ID',
  `relate_doc2_no` varchar(40) DEFAULT NULL COMMENT '关联单据2编号',
  `relate_doc3_id` bigint(20) DEFAULT '0' COMMENT '关联单据3ID',
  `relate_doc3_no` varchar(40) DEFAULT NULL COMMENT '关联单据3编号',
  `returned_qty` decimal(20,8) DEFAULT NULL COMMENT '已退数量',
  `thfs` varchar(2) DEFAULT NULL COMMENT '提货方式',
  `use_parts_flag` varchar(2) DEFAULT NULL COMMENT '使用配额标识',
  `country` varchar(40) DEFAULT NULL COMMENT '国家',
  `province` varchar(10) DEFAULT NULL COMMENT '省',
  `city` varchar(10) DEFAULT NULL COMMENT '市',
  `county` varchar(40) DEFAULT NULL COMMENT '区县',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `create_user_id_index` (`create_user_id`) USING BTREE,
  KEY `sec_bu_id_index` (`sec_bu_id`) USING BTREE,
  KEY `sec_user_id_index` (`sec_user_id`) USING BTREE,
  KEY `sec_ou_id_index` (`sec_ou_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='采购退货单';

-- ----------------------------
-- Table structure for pur_rns_d
-- ----------------------------

CREATE TABLE `pur_rns_d` (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `sec_bu_id` bigint(20) DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) DEFAULT NULL COMMENT 'sec_ou_id',
  `mas_id` bigint(20) DEFAULT '0' COMMENT '主表ID',
  `line_no` decimal(20,2) DEFAULT NULL COMMENT '行号',
  `wh_id` bigint(20) DEFAULT '0' COMMENT '仓库ID',
  `deter1` varchar(40) DEFAULT NULL COMMENT '温层 [UDC]INV:TEMP_TYPE',
  `deter2` varchar(40) DEFAULT NULL COMMENT '功能区 [UDC]INV:FUNC_TYPE',
  `deter3` varchar(40) DEFAULT NULL COMMENT '客户标识',
  `deter4` varchar(40) DEFAULT NULL COMMENT '限定4',
  `deter5` varchar(40) DEFAULT NULL COMMENT '限定5',
  `deter6` varchar(40) DEFAULT NULL COMMENT '限定6',
  `deter7` varchar(40) DEFAULT NULL COMMENT '限定7',
  `deter8` varchar(40) DEFAULT NULL COMMENT '限定8',
  `item_id` bigint(20) DEFAULT '0' COMMENT '品项ID',
  `vari_id` bigint(20) DEFAULT '0' COMMENT '异构ID',
  `lot_no` varchar(40) DEFAULT NULL COMMENT '批次',
  `qty` decimal(20,8) DEFAULT NULL COMMENT '数量',
  `uom` varchar(10) DEFAULT NULL COMMENT '单位',
  `item_spec` varchar(140) DEFAULT NULL COMMENT '品项规格',
  `qty2` decimal(20,8) DEFAULT NULL COMMENT '数量2',
  `uom2` varchar(10) DEFAULT NULL COMMENT '单位2',
  `uom_ratio` decimal(20,8) DEFAULT NULL COMMENT '单位转换率',
  `uom_ratio2` decimal(20,8) DEFAULT NULL COMMENT '单位转换率2',
  `curr_net_price` decimal(20,8) DEFAULT NULL COMMENT '未税单价',
  `curr_price` decimal(20,8) DEFAULT NULL COMMENT '含税单价',
  `net_price` decimal(20,8) DEFAULT NULL COMMENT '不含税价格',
  `price` decimal(20,8) DEFAULT NULL COMMENT '含税单价',
  `trans_price` decimal(20,8) DEFAULT NULL COMMENT '交易单价 折扣后，不含税',
  `tax_rate` decimal(20,8) DEFAULT NULL COMMENT '税率',
  `tax_rate_no` varchar(40) DEFAULT NULL COMMENT '税率编号',
  `tax_code` varchar(40) DEFAULT NULL COMMENT '税种',
  `tax_amt` decimal(20,8) DEFAULT NULL COMMENT '税额',
  `amt` decimal(20,8) DEFAULT NULL COMMENT '含税金额',
  `net_amt` decimal(20,8) DEFAULT NULL COMMENT '不含税金额',
  `curr_amt` decimal(20,8) DEFAULT NULL COMMENT '外币含税金额',
  `home_curr` varchar(40) DEFAULT NULL COMMENT '本币币种',
  `curr_code` varchar(40) DEFAULT NULL COMMENT '币种',
  `curr_rate` decimal(20,8) DEFAULT NULL COMMENT '汇率',
  `curr_net_amt` decimal(20,8) DEFAULT NULL COMMENT '外币不含税金额',
  `rns_reason` varchar(40) DEFAULT NULL COMMENT '退货原因码 [UDC]PUR:RNS_REASON',
  `root_id` bigint(20) DEFAULT '0' COMMENT '根ID',
  `relate_doc_cls` varchar(40) DEFAULT NULL COMMENT '关联单据类别 [UDC]COM:DOC_CLS',
  `relate_doc_type` varchar(40) DEFAULT NULL COMMENT '关联单据类型',
  `relate_doc_id` bigint(20) DEFAULT '0' COMMENT '关联单据ID',
  `relate_doc_no` varchar(40) DEFAULT NULL COMMENT '关联单据编号',
  `relate_doc_did` bigint(20) DEFAULT '0' COMMENT '关联单据明细ID',
  `relate_doc_lineno` decimal(20,2) DEFAULT NULL COMMENT '关联单据行号',
  `relate_doc2_cls` varchar(40) DEFAULT NULL COMMENT '关联单据2类别 [UDC]COM:DOC_CLS',
  `relate_doc2_type` varchar(40) DEFAULT NULL COMMENT '关联单据2类型',
  `relate_doc2_id` bigint(20) DEFAULT '0' COMMENT '关联单据2ID',
  `relate_doc2_no` varchar(40) DEFAULT NULL COMMENT '关联单据2编号',
  `relate_doc2_did` bigint(20) DEFAULT '0' COMMENT '关联单据2明细ID',
  `relate_doc2_lineno` decimal(20,2) DEFAULT NULL COMMENT '关联单据2行号',
  `dbrand` varchar(40) DEFAULT NULL COMMENT '品牌',
  `payed_qty` decimal(20,8) DEFAULT NULL COMMENT '数量2',
  `payed_amt` decimal(20,2) DEFAULT NULL COMMENT '已付金额',
  `lot_flag` tinyint(1) DEFAULT NULL COMMENT '是否启用批次',
  `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
  `po_id` bigint(20) DEFAULT NULL COMMENT 'POID',
  `root_doc_cls` varchar(40) DEFAULT NULL COMMENT '来源单据类别[UDC]COM:DOC_CLS]',
  `root_doc_type` varchar(40) DEFAULT NULL COMMENT '来源单据类型',
  `root_doc_id` bigint(20) DEFAULT '0' COMMENT '来源单据ID',
  `root_doc_no` varchar(40) DEFAULT NULL COMMENT '来源单据编号',
  `root_doc_did` bigint(20) DEFAULT '0' COMMENT '来源单据明细ID',
  `root_doc_lineno` decimal(20,3) DEFAULT NULL COMMENT '来源单据行号',
  `so_doc_id` bigint(20) DEFAULT '0' COMMENT '销售订单单据ID',
  `so_doc_did` bigint(20) DEFAULT '0' COMMENT '销售订单单据明细ID',
  `so_doc_no` varchar(40) DEFAULT NULL COMMENT '销售订单单据编号',
  `so_doc_lineno` decimal(20,3) DEFAULT NULL COMMENT '销售订单来源单据行号',
  `fin1` varchar(40) DEFAULT NULL COMMENT 'ERP成功标识',
  `fin2` varchar(40) DEFAULT NULL COMMENT 'ERP凭证号',
  `fin3` datetime(6) DEFAULT NULL COMMENT 'ERP传输日期',
  `fin4` varchar(40) DEFAULT NULL COMMENT '传输ERP唯一标识码',
  `po_qty` decimal(20,8) DEFAULT NULL COMMENT '采购订单数量',
  `po_doc_no` varchar(255) DEFAULT NULL COMMENT '采购订单号',
  `po_did` bigint(20) DEFAULT NULL COMMENT '采购单明细ID',
  `po_doc_line_no` decimal(20,3) DEFAULT NULL COMMENT '行号',
  `relate_doc3_cls` varchar(40) DEFAULT NULL COMMENT '关联单据3类别 [UDC]COM:DOC_CLS',
  `relate_doc3_type` varchar(40) DEFAULT NULL COMMENT '关联单据3类型',
  `relate_doc3_id` bigint(20) DEFAULT '0' COMMENT '关联单据3ID',
  `relate_doc3_no` varchar(40) DEFAULT NULL COMMENT '关联单据3编号',
  `relate_doc3_did` bigint(20) DEFAULT '0' COMMENT '关联单据3明细ID',
  `relate_doc3_lineno` decimal(20,2) DEFAULT NULL COMMENT '关联单据3行号',
  `returned_qty` decimal(20,8) DEFAULT '0.00000000' COMMENT '已退数量',
  `accept_qty` decimal(20,8) DEFAULT '0.00000000' COMMENT '已收数量',
  `confirm_qty` decimal(20,8) DEFAULT NULL COMMENT '已签收数量',
  `rejected_qty` decimal(20,8) DEFAULT NULL COMMENT '已拒收数量',
  `confirm_qty2` decimal(20,8) DEFAULT '0.00000000' COMMENT '采购退货登记单已签收数量',
  `confirm_time` datetime DEFAULT NULL COMMENT '采购退货登记单签收日期',
  `rejecting_qty` decimal(20,8) DEFAULT '0.00000000' COMMENT '采购退货登记单拒收中数量',
  `confirm_amt` decimal(20,8) DEFAULT NULL COMMENT '已签收含税金额',
  `confirm_net_amt` decimal(20,8) DEFAULT NULL COMMENT '已签收不含税金额',
  `confirm_curr_amt` decimal(20,8) DEFAULT NULL COMMENT '已签收外币含税金额',
  `confirm_curr_net_amt` decimal(20,8) DEFAULT NULL COMMENT '已签收外币不含税金额',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `create_user_id_index` (`create_user_id`) USING BTREE,
  KEY `sec_bu_id_index` (`sec_bu_id`) USING BTREE,
  KEY `sec_user_id_index` (`sec_user_id`) USING BTREE,
  KEY `sec_ou_id_index` (`sec_ou_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='采购退货单明细';

-- ----------------------------
-- Table structure for pur_scene
-- ----------------------------

CREATE TABLE `pur_scene` (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `sec_bu_id` bigint(20) DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) DEFAULT NULL COMMENT 'sec_ou_id',
  `ou_id` bigint(20) DEFAULT '0' COMMENT '公司ID',
  `bu_id` bigint(20) DEFAULT '0' COMMENT 'BUID',
  `scene_code` varchar(40) DEFAULT NULL COMMENT '场景编号',
  `scene_name` varchar(40) DEFAULT NULL COMMENT '场景名称',
  `scene_status` varchar(40) DEFAULT NULL COMMENT '场景状态 [UDC]COM:STATUS_ACTIVEORNO',
  `es1` varchar(40) DEFAULT NULL COMMENT '国内国外 [UDC]PUR:PO_TYPE2',
  `es2` varchar(40) DEFAULT NULL COMMENT '是否团内 [UDC]ORG:SUPP_TYPE2',
  `es3` varchar(40) DEFAULT NULL COMMENT '是否免值 [UDC]COM:ZEROVAL_TYPE',
  `es4` varchar(40) DEFAULT NULL COMMENT '来源 [UDC]PUR:PO_GEN_TYPE',
  `es5` varchar(40) DEFAULT NULL COMMENT 'ES5',
  `es6` int(1) DEFAULT NULL COMMENT 'ES6',
  `es7` varchar(40) DEFAULT NULL COMMENT 'ES7',
  `es8` varchar(40) DEFAULT NULL COMMENT 'ES8',
  `es9` varchar(40) DEFAULT NULL COMMENT 'ES9',
  `es10` int(1) DEFAULT NULL COMMENT 'ES10',
  `ee1` int(1) DEFAULT NULL COMMENT '能否手开',
  `ee2` int(1) DEFAULT NULL COMMENT 'EE2',
  `ee3` int(1) DEFAULT NULL COMMENT 'EE3',
  `ee4` int(1) DEFAULT NULL COMMENT 'EE4',
  `ee5` int(1) DEFAULT NULL COMMENT 'EE5',
  `po_type` varchar(40) DEFAULT NULL COMMENT '订单类型 [UDC]PUR:PO_TYPE',
  `appr_flag` int(1) DEFAULT NULL COMMENT '是否启用审批',
  `moq_flag` int(1) DEFAULT NULL COMMENT '是否检查MOQ',
  `valid_from` datetime DEFAULT NULL COMMENT '生效时间',
  `valid_to` datetime DEFAULT NULL COMMENT '失效时间',
  `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
  `relate_scene_id` varchar(10000) CHARACTER SET utf8 DEFAULT NULL COMMENT '关联采购场景',
  `account_type` varchar(40) DEFAULT NULL COMMENT '对账类型',
  `es11` varchar(40) DEFAULT NULL COMMENT 'ES11 是否需要出入库 [UDC]PUR:STORAGE_TYPE',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `create_user_id_index` (`create_user_id`) USING BTREE,
  KEY `sec_bu_id_index` (`sec_bu_id`) USING BTREE,
  KEY `sec_user_id_index` (`sec_user_id`) USING BTREE,
  KEY `sec_ou_id_index` (`sec_ou_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='采购场景';

-- ----------------------------
-- Table structure for pur_setting
-- ----------------------------

CREATE TABLE `pur_setting` (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `sec_bu_id` bigint(20) DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) DEFAULT NULL COMMENT 'sec_ou_id',
  `setting_no` varchar(40) DEFAULT NULL COMMENT '设置编号',
  `setting_name` varchar(40) DEFAULT NULL COMMENT '设置名',
  `setting_type` varchar(40) DEFAULT NULL COMMENT '设置类型',
  `setting_type2` varchar(40) DEFAULT NULL COMMENT '设置类型2',
  `setting_type3` varchar(40) DEFAULT NULL COMMENT '设置类型3',
  `setting_status` varchar(40) DEFAULT NULL COMMENT '设置状态',
  `setting_desc` varchar(500) DEFAULT NULL COMMENT '设置描述',
  `setting_val` varchar(500) DEFAULT NULL COMMENT '设置值',
  `def_val` varchar(100) DEFAULT NULL COMMENT '默认值',
  `sort_no` int(18) DEFAULT NULL COMMENT '排序号',
  `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `create_user_id_index` (`create_user_id`) USING BTREE,
  KEY `sec_bu_id_index` (`sec_bu_id`) USING BTREE,
  KEY `sec_user_id_index` (`sec_user_id`) USING BTREE,
  KEY `sec_ou_id_index` (`sec_ou_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='设置项';

-- ----------------------------
-- Table structure for pur_settle
-- ----------------------------

CREATE TABLE `pur_settle` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '记录唯一ID',
  `pur_settle_code` varchar(32) DEFAULT NULL COMMENT '结算单号',
  `settle_entity_id` bigint(20) DEFAULT NULL COMMENT '结算主体ID',
  `relation_number` varchar(32) DEFAULT NULL COMMENT '关联对账单号',
  `settle_entity_name` varchar(40) DEFAULT NULL COMMENT '结算主体名称',
  `create_mode` varchar(20) DEFAULT NULL COMMENT '生成方式',
  `settle_type` varchar(20) DEFAULT NULL COMMENT '结算类型',
  `contact_id` bigint(20) DEFAULT NULL COMMENT '往来对象ID',
  `contact_name` varchar(40) DEFAULT NULL COMMENT '往来对象名称',
  `state` varchar(20) DEFAULT NULL COMMENT '状态',
  `process_time` datetime DEFAULT NULL COMMENT '处理日期',
  `currency` varchar(20) DEFAULT NULL COMMENT '币种',
  `total_amount` decimal(20,4) DEFAULT NULL COMMENT '总金额',
  `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) DEFAULT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
  `verify_state` varchar(20) DEFAULT NULL,
  `total_qty` decimal(20,4) DEFAULT NULL,
  `total_amount_base` decimal(20,4) DEFAULT NULL,
  `tax_amount` decimal(20,4) DEFAULT NULL,
  `transfer_state` varchar(20) DEFAULT NULL,
  `pay_amount` decimal(20,4) DEFAULT NULL,
  `approve_user_id` bigint(20) DEFAULT NULL,
  `approve_user` varchar(20) DEFAULT NULL,
  `pur_settle_name` varchar(50) DEFAULT NULL,
  `settle_type_name` varchar(20) DEFAULT NULL,
  `settle_type_code` varchar(20) DEFAULT NULL,
  `settle_type_id` bigint(20) DEFAULT NULL,
  `curr_code` varchar(20) DEFAULT NULL,
  `curr_name` varchar(20) DEFAULT NULL,
  `check_user_id` bigint(20) DEFAULT NULL,
  `check_user` varchar(20) DEFAULT NULL,
  `pay_flag` tinyint(1) DEFAULT NULL,
  `reimburse_flag` tinyint(1) DEFAULT NULL,
  `approve_date` datetime DEFAULT NULL,
  `source_no` varchar(20) DEFAULT NULL,
  `reimburse_no` varchar(20) DEFAULT NULL,
  `settle_entity_addr_no` bigint(20) DEFAULT NULL,
  `contact_addr_no` bigint(20) DEFAULT NULL,
  `invoice_diff` varchar(50) DEFAULT NULL,
  `pre_flag` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `create_user_id_index` (`create_user_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='采购结算单';

-- ----------------------------
-- Table structure for pur_settle_def_entity
-- ----------------------------

CREATE TABLE `pur_settle_def_entity` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '记录唯一ID',
  `def_id` bigint(20) DEFAULT NULL,
  `entity_id` bigint(20) DEFAULT NULL,
  `entity_name` varchar(32) DEFAULT NULL,
  `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) DEFAULT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
  `define_id` bigint(20) DEFAULT NULL,
  `ou_id` bigint(20) DEFAULT NULL,
  `ou_name` varchar(50) DEFAULT NULL,
  `ou_code` varchar(20) DEFAULT NULL,
  `ou_type` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `create_user_id_index` (`create_user_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='类型定义对应结算主体';

-- ----------------------------
-- Table structure for pur_settle_def_scene
-- ----------------------------

CREATE TABLE `pur_settle_def_scene` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '记录唯一ID',
  `define_id` bigint(20) DEFAULT NULL,
  `scene_id` bigint(20) DEFAULT NULL,
  `scene_code` varchar(50) DEFAULT NULL,
  `scene_name` varchar(50) DEFAULT NULL,
  `es7` varchar(20) DEFAULT NULL COMMENT '业务类型',
  `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `create_user_id_index` (`create_user_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='采购结算单类型定义对应业务场景';

-- ----------------------------
-- Table structure for pur_settle_define
-- ----------------------------

CREATE TABLE `pur_settle_define` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '记录唯一ID',
  `settle_type_code` varchar(32) DEFAULT NULL COMMENT '结算单类型代码',
  `settle_type_name` varchar(32) DEFAULT NULL COMMENT '结算单类型名称',
  `approve_flag` tinyint(1) DEFAULT NULL COMMENT '审核标志（0：否，1：是）',
  `pay_flag` tinyint(1) DEFAULT NULL COMMENT '支付标志（0：否，1：是）',
  `verify_flag` tinyint(1) DEFAULT NULL COMMENT '核销标志（0：否，1：是）',
  `enable_flag` tinyint(1) DEFAULT NULL COMMENT '启用标志（0：否，1：是）',
  `reimburse_flag` tinyint(1) DEFAULT NULL COMMENT '报账标志（0：否，1：是）',
  `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) DEFAULT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
  `pur_type` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `create_user_id_index` (`create_user_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='采购结算单类型定义';

-- ----------------------------
-- Table structure for pur_settle_to_pay
-- ----------------------------

CREATE TABLE `pur_settle_to_pay` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '记录唯一ID',
  `pur_settle_id` bigint(20) DEFAULT NULL,
  `total_amount` decimal(20,4) DEFAULT NULL,
  `pre_pay_id` bigint(20) DEFAULT NULL,
  `pre_settle_id` bigint(20) DEFAULT NULL,
  `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `create_user_id_index` (`create_user_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='采购结算单对应生成付款单';

-- ----------------------------
-- Table structure for pur_settle_to_pre
-- ----------------------------

CREATE TABLE `pur_settle_to_pre` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '记录唯一ID',
  `pur_settle_id` bigint(20) DEFAULT NULL,
  `pur_settle_code` varchar(32) DEFAULT NULL,
  `pre_settle_no` varchar(20) DEFAULT NULL,
  `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `create_user_id_index` (`create_user_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='采购结算单对应预付款单号';

-- ----------------------------
-- Table structure for pur_sn_apply
-- ----------------------------

CREATE TABLE `pur_sn_apply` (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `ou_id` bigint(20) DEFAULT '0' COMMENT '公司ID',
  `bu_id` bigint(20) DEFAULT '0' COMMENT 'BUID',
  `supp_id` bigint(20) DEFAULT '0' COMMENT '供应商ID',
  `supp_code` varchar(40) DEFAULT NULL COMMENT '供应商编号',
  `doc_no` varchar(40) DEFAULT NULL COMMENT '单据编号',
  `doc_status` varchar(40) DEFAULT NULL COMMENT '单据状态 [UDC]',
  `doc_time` datetime DEFAULT NULL COMMENT '申请时间',
  `product_date` datetime DEFAULT NULL COMMENT '生产时间',
  `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
  `sec_bu_id` bigint(20) DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) DEFAULT NULL COMMENT 'sec_ou_id',
  `ou_code` varchar(40) DEFAULT NULL COMMENT '公司编码',
  `proc_inst_id` varchar(255) DEFAULT NULL COMMENT '流程实例ID',
  `proc_inst_status` varchar(255) DEFAULT NULL COMMENT '流程实例状态',
  `submit_time` datetime(6) DEFAULT NULL COMMENT '提交时间',
  `approved_time` datetime(6) DEFAULT NULL COMMENT '审批通过时间',
  `file_code` varchar(2000) DEFAULT NULL COMMENT '文件服务器编码',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='二维码申请单';

-- ----------------------------
-- Table structure for pur_sn_apply_d
-- ----------------------------

CREATE TABLE `pur_sn_apply_d` (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `mas_id` bigint(20) DEFAULT '0' COMMENT '主表ID',
  `ou_id` bigint(20) DEFAULT '0' COMMENT '公司ID',
  `bu_id` bigint(20) DEFAULT '0' COMMENT 'BUID',
  `line_no` decimal(20,8) DEFAULT NULL COMMENT '行号',
  `line_type` varchar(40) DEFAULT NULL COMMENT '行类型 [UDC]PUR:PO_LINE_TYPE',
  `line_status` varchar(40) DEFAULT NULL COMMENT '行状态',
  `supp_id` bigint(20) DEFAULT '0' COMMENT '供应商ID',
  `item_id` bigint(20) DEFAULT '0' COMMENT '品项ID',
  `item_code` varchar(40) DEFAULT NULL COMMENT '品项编号',
  `qty` decimal(20,8) DEFAULT NULL COMMENT '数量',
  `uom` varchar(10) DEFAULT NULL COMMENT '单位',
  `product_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '生产日期',
  `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
  `sec_bu_id` bigint(20) DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) DEFAULT NULL COMMENT 'sec_ou_id',
  `item_prop_code` varchar(40) DEFAULT NULL COMMENT '产品编码',
  `completion_status` varchar(10) DEFAULT NULL COMMENT '完工状态',
  `completion_qty` decimal(20,8) DEFAULT NULL COMMENT '完工数量',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='二维码申请单明细';

-- ----------------------------
-- Table structure for pur_ss
-- ----------------------------

CREATE TABLE `pur_ss` (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `sec_bu_id` bigint(20) DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) DEFAULT NULL COMMENT 'sec_ou_id',
  `ou_id` bigint(20) DEFAULT '0' COMMENT '公司ID',
  `bu_id` bigint(20) DEFAULT '0' COMMENT 'BUID',
  `doc_no` varchar(40) DEFAULT NULL COMMENT '单据编号',
  `doc_type` varchar(10) DEFAULT NULL COMMENT '单据类型 [UDC]PUR:SS_TYPE',
  `doc_status` varchar(40) DEFAULT NULL COMMENT '单据状态 [UDC]PUR:SS_STATUS',
  `qty` decimal(20,2) DEFAULT NULL COMMENT '收货总数',
  `shipment_date` datetime DEFAULT NULL COMMENT '发货日期',
  `po_id` bigint(20) DEFAULT '0' COMMENT '采购订单ID',
  `supp_id` bigint(20) DEFAULT '0' COMMENT '供应商ID',
  `supp_doc_no` varchar(64) DEFAULT NULL COMMENT '供应商发货单号',
  `crosswh_flag` int(16) DEFAULT NULL COMMENT '越库标识',
  `wh_id` bigint(20) DEFAULT '0' COMMENT '仓库ID',
  `deter1` varchar(64) DEFAULT NULL COMMENT '温层 [UDC]INV:TEMP_TYPE',
  `deter2` varchar(64) DEFAULT NULL COMMENT '功能区 [UDC]INV:FUNC_TYPE',
  `deter3` varchar(64) DEFAULT NULL COMMENT '客户标识',
  `deter4` varchar(64) DEFAULT NULL COMMENT '限定4',
  `deter5` varchar(64) DEFAULT NULL COMMENT '限定5',
  `deter6` varchar(64) DEFAULT NULL COMMENT '限定6',
  `deter7` varchar(64) DEFAULT NULL COMMENT '限定7',
  `deter8` varchar(64) DEFAULT NULL COMMENT '限定8',
  `wh_loc` varchar(64) DEFAULT NULL COMMENT '库位',
  `wh_posi` varchar(64) DEFAULT NULL COMMENT '货位',
  `eta_date` datetime DEFAULT NULL COMMENT '预计到货日期',
  `shipment_contact_name` varchar(40) DEFAULT NULL COMMENT '发运联系人',
  `shipment_contact_tel` varchar(40) DEFAULT NULL COMMENT '发运联系电话',
  `reject_reason` varchar(64) DEFAULT NULL COMMENT '拒收原因',
  `reject_time` datetime DEFAULT NULL COMMENT '拒收时间',
  `root_id` bigint(20) DEFAULT '0' COMMENT '根ID',
  `relate_doc_cls` varchar(64) DEFAULT NULL COMMENT '关联单据类别 [UDC]COM:DOC_CLS',
  `relate_doc_type` varchar(64) DEFAULT NULL COMMENT '关联单据类型',
  `relate_doc_id` bigint(20) DEFAULT '0' COMMENT '关联单据ID',
  `relate_doc_no` varchar(64) DEFAULT NULL COMMENT '关联单据编号',
  `relate_doc2_cls` varchar(64) DEFAULT NULL COMMENT '关联单据2类别 [UDC]COM:DOC_CLS',
  `relate_doc2_type` varchar(64) DEFAULT NULL COMMENT '关联单据2类型',
  `relate_doc2_id` bigint(20) DEFAULT '0' COMMENT '关联单据2ID',
  `relate_doc2_no` varchar(64) DEFAULT NULL COMMENT '关联单据2编号',
  `relate_id` bigint(20) DEFAULT '0' COMMENT '关联ID',
  `relate_no` varchar(64) DEFAULT NULL COMMENT '关联编号',
  `relate2_id` bigint(20) DEFAULT '0' COMMENT '关联2ID',
  `relate2_no` varchar(64) DEFAULT NULL COMMENT '关联2编号',
  `es1` varchar(64) DEFAULT NULL COMMENT 'ES1',
  `es2` varchar(64) DEFAULT NULL COMMENT 'ES2',
  `es3` varchar(64) DEFAULT NULL COMMENT 'ES3',
  `es4` varchar(64) DEFAULT NULL COMMENT 'ES4',
  `es5` varchar(64) DEFAULT NULL COMMENT 'ES5',
  `recv_addr` varchar(200) DEFAULT NULL COMMENT '收货地址',
  `home_curr` varchar(40) DEFAULT NULL COMMENT '本币币种',
  `curr_code` varchar(40) DEFAULT NULL COMMENT '币种',
  `curr_rate` decimal(20,8) DEFAULT NULL COMMENT '汇率',
  `tax_incl_flag` int(1) DEFAULT NULL COMMENT '是否含税',
  `tax_code` varchar(40) DEFAULT NULL COMMENT '税码',
  `tax_rate_no` varchar(40) DEFAULT NULL COMMENT '税率编号',
  `tax_rate` decimal(20,8) DEFAULT NULL COMMENT '税率',
  `tax_amt` decimal(20,2) DEFAULT NULL COMMENT '税额',
  `amt` decimal(20,2) DEFAULT NULL COMMENT '含税总金额',
  `net_amt` decimal(20,2) DEFAULT NULL COMMENT '未税总金额',
  `curr_net_amt` decimal(20,2) DEFAULT NULL COMMENT '外币不含税金额',
  `curr_amt` decimal(20,2) DEFAULT NULL COMMENT '外币含税金额',
  `intf_flag` tinyint(2) DEFAULT NULL COMMENT '是否有接口0:无接口,1:有接口',
  `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
  `sale_wh_id` bigint(20) DEFAULT '0' COMMENT '销售发货仓库ID',
  `shipment_country` varchar(40) DEFAULT NULL COMMENT '发货国家',
  `shipment_country_name` varchar(40) DEFAULT NULL COMMENT '发货国家-名称',
  `shipment_province` varchar(40) DEFAULT NULL COMMENT '详细地址-省',
  `shipment_province_name` varchar(40) DEFAULT NULL COMMENT '详细地址-省-名称',
  `shipment_city` varchar(40) DEFAULT NULL COMMENT '详细地址-市',
  `shipment_city_name` varchar(40) DEFAULT NULL COMMENT '详细地址-市-名称',
  `shipment_county` varchar(40) DEFAULT NULL COMMENT '详细地址-区',
  `shipment_county_name` varchar(40) DEFAULT NULL COMMENT '详细地址-区-名称',
  `shipment_detailaddr` varchar(255) DEFAULT NULL COMMENT '详细地址',
  `carriage_flag` tinyint(1) DEFAULT '0' COMMENT '是否配货',
  `carrier_supp_id` bigint(20) DEFAULT '0' COMMENT '承运联系人ID',
  `root_doc_cls` varchar(64) DEFAULT NULL COMMENT '来源单据类别 [UDC]COM:DOC_CLS',
  `root_doc_type` varchar(64) DEFAULT NULL COMMENT '来源单据类型',
  `root_doc_id` bigint(20) DEFAULT '0' COMMENT '来源单据Id',
  `root_doc_no` varchar(64) DEFAULT NULL COMMENT '来源单据编号',
  `outer_ou` varchar(40) DEFAULT NULL COMMENT '外部单据公司',
  `outer_type` varchar(40) DEFAULT NULL COMMENT '外部单据类型',
  `outer_no` varchar(40) DEFAULT NULL COMMENT '外部单据编号',
  `outer_id` bigint(20) DEFAULT '0' COMMENT '外部单据编号Id',
  `recv_emp_id` bigint(20) DEFAULT '0' COMMENT '收货人员工ID',
  `recv_emp_name` varchar(40) DEFAULT NULL COMMENT '收货人员工名字',
  `tel` varchar(40) DEFAULT NULL COMMENT '联系人电话',
  `detail_addr` varchar(40) DEFAULT NULL COMMENT '地址',
  `accept_qty` decimal(20,8) DEFAULT NULL COMMENT '已收数量',
  `rejected_qty` decimal(20,8) DEFAULT NULL COMMENT '收货单已拒收数量',
  `logistics_ou_code` varchar(25) DEFAULT NULL COMMENT '快递公司编号',
  `logistics_doc_no` varchar(30) DEFAULT NULL COMMENT '物流单号',
  `car_number` varchar(30) DEFAULT NULL COMMENT '车号',
  `driver` varchar(20) DEFAULT NULL COMMENT '司机',
  `driver_phone` varchar(15) DEFAULT NULL COMMENT '司机电话',
  `packing_qty` varchar(15) DEFAULT NULL COMMENT '包装数量',
  `total_weight` varchar(15) DEFAULT NULL COMMENT '总重量',
  `logistics_remark` varchar(100) DEFAULT NULL COMMENT '物流备注',
  `trans_type` varchar(40) DEFAULT NULL COMMENT '运输方式 [UDC]COM:TP_TYPE',
  `carrier_contact_name` varchar(20) DEFAULT NULL COMMENT '承运商联系人',
  `carrier_contact_tel` varchar(15) DEFAULT NULL COMMENT '承运商联系电话',
  `sell_method` varchar(40) DEFAULT NULL COMMENT '出货方式 [UDC]COM:TP_TYPE',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `create_user_id_index` (`create_user_id`) USING BTREE,
  KEY `sec_bu_id_index` (`sec_bu_id`) USING BTREE,
  KEY `sec_user_id_index` (`sec_user_id`) USING BTREE,
  KEY `sec_ou_id_index` (`sec_ou_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='供应商发货单';

-- ----------------------------
-- Table structure for pur_ss_d
-- ----------------------------

CREATE TABLE `pur_ss_d` (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `sec_bu_id` bigint(20) DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) DEFAULT NULL COMMENT 'sec_ou_id',
  `mas_id` bigint(20) DEFAULT '0' COMMENT '主表ID',
  `line_no` decimal(20,2) DEFAULT NULL COMMENT '行号',
  `po_d_id` bigint(20) DEFAULT '0' COMMENT '采购订单明细ID',
  `item_id` bigint(20) DEFAULT '0' COMMENT '品项ID',
  `vari_id` bigint(20) DEFAULT '0' COMMENT '异构ID',
  `wh_id` bigint(20) DEFAULT '0' COMMENT '仓库ID',
  `deter1` varchar(64) DEFAULT NULL COMMENT '温层 [UDC]INV:TEMP_TYPE',
  `deter2` varchar(64) DEFAULT NULL COMMENT '功能区 [UDC]INV:FUNC_TYPE',
  `deter3` varchar(64) DEFAULT NULL COMMENT '客户标识',
  `deter4` varchar(64) DEFAULT NULL COMMENT '限定4',
  `deter5` varchar(64) DEFAULT NULL COMMENT '限定5',
  `deter6` varchar(64) DEFAULT NULL COMMENT '限定6',
  `deter7` varchar(64) DEFAULT NULL COMMENT '限定7',
  `deter8` varchar(64) DEFAULT NULL COMMENT '限定8',
  `wh_loc` varchar(64) DEFAULT NULL COMMENT '库位',
  `wh_posi` varchar(64) DEFAULT NULL COMMENT '货位',
  `qty` decimal(20,8) DEFAULT NULL COMMENT '发货数量',
  `uom` varchar(10) DEFAULT NULL COMMENT '单位',
  `qty2` decimal(20,8) DEFAULT NULL COMMENT '发货数量2',
  `uom2` varchar(10) DEFAULT NULL COMMENT '单位2',
  `uom_ratio` decimal(20,8) DEFAULT NULL COMMENT '单位转换率',
  `uom_ratio2` decimal(20,8) DEFAULT NULL COMMENT '单位转换率2',
  `lot_no` varchar(64) DEFAULT NULL COMMENT '发货批次',
  `menu_lot_no` varchar(64) DEFAULT NULL COMMENT '生产批次',
  `manu_date` datetime DEFAULT NULL COMMENT '生产日期',
  `expire_date` datetime DEFAULT NULL COMMENT '过期日期',
  `expire_days` int(64) DEFAULT NULL COMMENT '保质期天数',
  `until_expire_days` int(64) DEFAULT NULL COMMENT '剩余效期天数',
  `demand_fresh_percent` decimal(20,8) DEFAULT NULL COMMENT '要求保质期比例',
  `demand_aap_days` int(64) DEFAULT NULL COMMENT '最低允收期天数',
  `eta_aap_days` int(64) DEFAULT NULL COMMENT '预计到货时效期天数',
  `is_fress_valid` int(10) DEFAULT NULL COMMENT '是否新鲜度合格',
  `actual_fresh_percent` decimal(20,8) DEFAULT NULL COMMENT '到货保质期比例',
  `barcode` varchar(64) DEFAULT NULL COMMENT '条码',
  `root_id` bigint(20) DEFAULT '0' COMMENT '根ID',
  `relate_doc_cls` varchar(64) DEFAULT NULL COMMENT '关联单据类别 [UDC]COM:DOC_CLS',
  `relate_doc_type` varchar(64) DEFAULT NULL COMMENT '关联单据类型',
  `relate_doc_id` bigint(20) DEFAULT '0' COMMENT '关联单据ID',
  `relate_doc_no` varchar(64) DEFAULT NULL COMMENT '关联单据编号',
  `relate_doc_did` bigint(20) DEFAULT '0' COMMENT '关联单据明细ID',
  `relate_doc_lineno` decimal(20,2) DEFAULT NULL COMMENT '关联单据行号',
  `relate_doc2_cls` varchar(64) DEFAULT NULL COMMENT '关联单据2类别 [UDC]COM:DOC_CLS',
  `relate_doc2_type` varchar(64) DEFAULT NULL COMMENT '关联单据2类型',
  `relate_doc2_id` bigint(20) DEFAULT '0' COMMENT '关联单据2ID',
  `relate_doc2_no` varchar(64) DEFAULT NULL COMMENT '关联单据2编号',
  `relate_doc2_did` bigint(20) DEFAULT '0' COMMENT '关联单据2明细ID',
  `relate_doc2_lineno` decimal(20,2) DEFAULT NULL COMMENT '关联单据2行号',
  `es1` varchar(64) DEFAULT NULL COMMENT 'ES1',
  `es2` varchar(64) DEFAULT NULL COMMENT 'ES2',
  `es3` varchar(64) DEFAULT NULL COMMENT 'ES3',
  `es4` varchar(64) DEFAULT NULL COMMENT 'ES4',
  `es5` varchar(64) DEFAULT NULL COMMENT 'ES5',
  `dbrand` varchar(64) DEFAULT NULL COMMENT '品牌',
  `base_price` decimal(20,8) DEFAULT NULL COMMENT '基价',
  `price_type` varchar(40) DEFAULT NULL COMMENT '价格类型',
  `net_price` decimal(20,8) DEFAULT NULL COMMENT '不含税价格',
  `price` decimal(20,8) DEFAULT NULL COMMENT '含税单价',
  `pb_price` decimal(20,8) DEFAULT NULL COMMENT '价格本价格',
  `pb_curr` varchar(40) DEFAULT NULL COMMENT '价格本币种',
  `pb_uom` varchar(10) DEFAULT NULL COMMENT '价格本单位',
  `disc_type` varchar(40) DEFAULT NULL COMMENT '折扣类型',
  `disc_ratio` decimal(20,8) DEFAULT NULL COMMENT '折扣率',
  `disc_amt` decimal(20,2) DEFAULT NULL COMMENT '折扣额',
  `disc_desc` varchar(100) DEFAULT NULL COMMENT '折扣描述',
  `disced_price` decimal(20,8) DEFAULT NULL COMMENT '折扣后价格',
  `trans_price` decimal(20,8) DEFAULT NULL COMMENT '交易单价 折扣后，不含税',
  `tax_code` varchar(40) DEFAULT NULL COMMENT '税码',
  `tax_rate_no` varchar(40) DEFAULT NULL COMMENT '税率编号',
  `tax_rate` decimal(20,8) DEFAULT NULL COMMENT '税率',
  `tax_amt` decimal(20,2) DEFAULT NULL COMMENT '税额',
  `amt` decimal(20,2) DEFAULT NULL COMMENT '含税金额',
  `net_amt` decimal(20,2) DEFAULT NULL COMMENT '不含税金额',
  `curr_net_price` decimal(20,8) DEFAULT NULL COMMENT '外币含不税单价',
  `curr_price` decimal(20,8) DEFAULT NULL COMMENT '外币含税单价',
  `curr_amt` decimal(20,2) DEFAULT NULL COMMENT '外币含税金额',
  `home_curr` varchar(40) DEFAULT NULL COMMENT '本币币种',
  `curr_code` varchar(40) DEFAULT NULL COMMENT '币种',
  `curr_rate` decimal(20,8) DEFAULT NULL COMMENT '汇率',
  `curr_net_amt` decimal(20,2) DEFAULT NULL COMMENT '外币不含税金额',
  `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
  `accept_qty` decimal(20,8) DEFAULT NULL COMMENT '已收数量',
  `accept_uom` varchar(40) DEFAULT NULL COMMENT '收货单位',
  `rejected_qty` decimal(20,8) DEFAULT NULL COMMENT '收货单已拒收数量',
  `root_doc_cls` varchar(64) DEFAULT NULL COMMENT '来源单据类别 [UDC]COM:DOC_CLS',
  `root_doc_type` varchar(64) DEFAULT NULL COMMENT '来源单据类型',
  `root_doc_id` bigint(20) DEFAULT '0' COMMENT '来源单据Id',
  `root_doc_no` varchar(64) DEFAULT NULL COMMENT '来源单据编号',
  `root_doc_did` bigint(20) DEFAULT '0' COMMENT '来源单据明细ID',
  `root_doc_deter2` varchar(64) DEFAULT NULL COMMENT '来源单据功能区',
  `root_doc_lineno` decimal(20,2) DEFAULT NULL COMMENT '来源单据行号',
  `outer_id` bigint(20) DEFAULT '0' COMMENT '外部单据编号Id',
  `outer_did` bigint(20) DEFAULT '0' COMMENT '外部单据编号明细Id',
  `outer_type` varchar(40) DEFAULT NULL COMMENT '外部单据类型',
  `outer_no` varchar(40) DEFAULT NULL COMMENT '外部单据编号',
  `outer_lineno` decimal(20,3) DEFAULT NULL COMMENT '行号',
  `is_suppwh` int(1) DEFAULT NULL COMMENT '是否供应商仓库',
  `is_crossflag_suppwh` int(1) DEFAULT NULL COMMENT '是否越库供应商仓库',
  `returned_qty` decimal(20,8) DEFAULT '0.00000000' COMMENT '发货单已退货数量',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `create_user_id_index` (`create_user_id`) USING BTREE,
  KEY `sec_bu_id_index` (`sec_bu_id`) USING BTREE,
  KEY `sec_user_id_index` (`sec_user_id`) USING BTREE,
  KEY `sec_ou_id_index` (`sec_ou_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='供应商发货单明细';

-- ----------------------------
-- Table structure for pur_supp
-- ----------------------------

CREATE TABLE `pur_supp` (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `sec_bu_id` bigint(20) DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) DEFAULT NULL COMMENT 'sec_ou_id',
  `supp_code` varchar(40) DEFAULT NULL COMMENT '供应商编码',
  `supp_name` varchar(200) DEFAULT NULL COMMENT '企业(供应商)名称',
  `supp_abbr` varchar(100) DEFAULT NULL COMMENT '企业(供应商)简称',
  `supp_type` varchar(64) DEFAULT NULL COMMENT '供应商类型 [UDC]PUR:SUPP_TYPE',
  `supp_type2` varchar(40) DEFAULT NULL COMMENT '供应商类型2 [UDC]PUR:SUPP_TYPE2',
  `appr_status` varchar(40) DEFAULT NULL COMMENT '审批状态 [UDC]COM:APPR_STATUS',
  `approve_status` varchar(64) DEFAULT NULL COMMENT '审批状态',
  `supp_status` varchar(40) DEFAULT NULL COMMENT '供应商状态 [UDC]PUR:SUPP_STATUS',
  `comp_prop` varchar(40) DEFAULT NULL COMMENT '供应商(企业)性质 [UDC]PUR:COMP_PROP',
  `domes_type` varchar(40) DEFAULT NULL COMMENT '国内国外 [UDC]PUR:DOMES_TYPE',
  `indus_flag1` varchar(40) DEFAULT NULL COMMENT '行业类型(标识)1 [UDC]PUR:INDUS_FLAG',
  `register_fund` varchar(40) DEFAULT NULL COMMENT '注册资金',
  `register_address` varchar(100) DEFAULT NULL COMMENT '注册地址',
  `ou_id2` bigint(20) DEFAULT NULL COMMENT '内部交易公司ID',
  `ou_code2` varchar(40) DEFAULT NULL COMMENT '内部交易公司编码',
  `ou_name2` varchar(40) DEFAULT NULL COMMENT '内部交易公司名称',
  `repr_name` varchar(40) DEFAULT NULL COMMENT '法人姓名(代表)',
  `ic_register_no` varchar(40) DEFAULT NULL COMMENT '营业执照注册号(工商登记号)',
  `tax_reg_no` varchar(40) DEFAULT NULL COMMENT '税务登记证编号',
  `tax_payer_id` varchar(40) DEFAULT NULL COMMENT '纳税人识别号',
  `cert_no` varchar(64) DEFAULT NULL COMMENT '统一信用代码',
  `total_staff` int(18) DEFAULT NULL COMMENT '公司总人数',
  `establishment_years` int(18) DEFAULT NULL COMMENT '成立年限',
  `web_address` varchar(200) DEFAULT NULL COMMENT '公司网站',
  `erp_supp_code` varchar(40) DEFAULT NULL COMMENT 'ERP供应商编码',
  `mall_settlement_status` varchar(40) DEFAULT NULL COMMENT '商城入驻状态 [UDC]PUR:SETTLEMENT_STATUS',
  `mall_settlement_time` datetime DEFAULT NULL COMMENT '商城入驻时间',
  `legal_person_phone` varchar(40) DEFAULT NULL COMMENT '法人手机号',
  `legal_person_mailbox` varchar(40) DEFAULT NULL COMMENT '法人邮箱',
  `certificate_type` varchar(40) DEFAULT NULL COMMENT '法人证件类型 [UDC]PUR:CERTIFICATE_TYPE',
  `certificate_code` varchar(40) DEFAULT NULL COMMENT '法人证件编码',
  `ou_id` bigint(20) DEFAULT NULL COMMENT '公司ID',
  `ou_code` varchar(40) DEFAULT NULL COMMENT '公司编码',
  `main_category` varchar(40) DEFAULT NULL COMMENT '主营品类 [UDC]PUR:MAIN_CATEGORY',
  `plant_nature` varchar(40) DEFAULT NULL COMMENT '厂房性质 [UDC]PUR:PLANT_NATURE',
  `plant_area` double(20,8) DEFAULT NULL COMMENT '厂房面积',
  `factory_employees_number` int(18) DEFAULT NULL COMMENT '工厂员工数',
  `technology_people_number` int(18) DEFAULT NULL COMMENT '开发技术人数',
  `quality_inspection_number` int(18) DEFAULT NULL COMMENT '品质检验人数',
  `certification_system` varchar(40) DEFAULT NULL COMMENT '认证体系 [UDC]PUR:CERTIFICATION_SYSTEM',
  `product_performance_standards` varchar(200) DEFAULT NULL COMMENT '产品执行标准',
  `quality_inspection` varchar(200) DEFAULT NULL COMMENT '质量检验',
  `inspection_scope` varchar(200) DEFAULT NULL COMMENT '检验范围',
  `delivery_quality_record` varchar(200) DEFAULT NULL COMMENT '供货质量记录',
  `main_production_equipment` varchar(200) DEFAULT NULL COMMENT '主要生产设备',
  `business_scope` varchar(500) DEFAULT NULL COMMENT '经营范围',
  `company_profile` mediumtext COMMENT '企业简介',
  `payment_term` varchar(40) DEFAULT NULL COMMENT '付款条款 [UDC]ORG:PAYMENT_TERM',
  `pay_method` varchar(40) DEFAULT NULL COMMENT '付款方式 [UDC]PUR:PAY_TYPE',
  `inv_type` varchar(40) DEFAULT NULL COMMENT '默认发票类型 [UDC]COM:INV_TYPE',
  `tax_rate_no` varchar(40) DEFAULT NULL COMMENT '税率编号',
  `tax_payer_type` varchar(40) DEFAULT NULL COMMENT '纳税人类型 [UDC]ORG:PAYER_TYPE',
  `zip_code` varchar(40) DEFAULT NULL COMMENT '邮编',
  `bu_id` bigint(20) DEFAULT '0' COMMENT 'BUID',
  `doc_no` varchar(40) DEFAULT NULL COMMENT '单据编号',
  `doc_type` varchar(64) DEFAULT NULL COMMENT '单据类型 [UDC]COM:APPLY_TYPE',
  `doc_status` varchar(40) DEFAULT NULL COMMENT '单据状态 [UDC]COM:APPLY_STATUS',
  `appr_proc_inst_id` varchar(40) DEFAULT NULL COMMENT '流程实例ID',
  `appr_time` datetime DEFAULT NULL COMMENT '审批时间',
  `appr_create_user_id` bigint(20) DEFAULT '0' COMMENT '提审人ID',
  `appr_user_id` bigint(20) DEFAULT '0' COMMENT '审批人ID',
  `appr_comment` varchar(500) DEFAULT NULL COMMENT '审批意见',
  `apply_emp_id` bigint(20) DEFAULT '0' COMMENT '申请人员工ID',
  `apply_date` datetime DEFAULT NULL COMMENT '申请日期',
  `apply_desc` varchar(100) DEFAULT NULL COMMENT '申请描述',
  `addr_no` bigint(20) DEFAULT NULL COMMENT '地址号',
  `we_chat_no` varchar(100) DEFAULT NULL COMMENT '微信号',
  `qq_no` varchar(100) DEFAULT NULL COMMENT 'QQ号',
  `comp_code` varchar(40) DEFAULT NULL COMMENT 'CRM编码',
  `paid_money` varchar(100) DEFAULT NULL COMMENT '实缴资金',
  `register_mail` varchar(200) DEFAULT NULL COMMENT '联系人邮箱(注册邮箱)',
  `category_description` mediumtext COMMENT '主营品类简介',
  `intf_status` varchar(40) DEFAULT NULL COMMENT 'MDM接口同步状态 [UDC]COM:INTF_STATUS',
  `epp_vendor_id` varchar(40) DEFAULT NULL COMMENT '和MDM供应商关联的ID',
  `supp_name2` varchar(256) DEFAULT NULL COMMENT '供应商名称2',
  `supp_type3` varchar(64) DEFAULT NULL COMMENT '供应商类型3',
  `supp_type4` varchar(64) DEFAULT NULL COMMENT '供应商类型4',
  `supp_type5` varchar(64) DEFAULT NULL COMMENT '供应商类型5',
  `supp_status2` varchar(64) DEFAULT NULL COMMENT '供应商状态2',
  `supp_status3` varchar(64) DEFAULT NULL COMMENT '供应商状态3',
  `supp_group` varchar(64) DEFAULT NULL COMMENT '供应商组别',
  `supp_group2` varchar(64) DEFAULT NULL COMMENT '供应商组别2',
  `supp_group3` varchar(64) DEFAULT NULL COMMENT '供应商组别3',
  `supp_group4` varchar(64) DEFAULT NULL COMMENT '供应商组别4',
  `pid` bigint(18) DEFAULT NULL COMMENT '上级ID',
  `supp_path` varchar(512) DEFAULT NULL COMMENT '路径',
  `enrole_desc` varchar(256) DEFAULT NULL COMMENT '引入理由',
  `busi_begin_date` datetime DEFAULT NULL COMMENT '合作开始日期',
  `busi_end_date` datetime DEFAULT NULL COMMENT '合作终止日期',
  `approve_date` datetime DEFAULT NULL COMMENT '转正日期',
  `innerouter_flag` int(1) DEFAULT NULL COMMENT '内外部',
  `purchaser_emp_id` bigint(18) DEFAULT NULL COMMENT '采购员员工ID',
  `tax_type` varchar(64) DEFAULT NULL COMMENT '税区',
  `tax_code` varchar(64) DEFAULT NULL COMMENT '税码',
  `taxer_no` varchar(128) DEFAULT NULL COMMENT '税号',
  `inv_type2` varchar(64) DEFAULT NULL COMMENT '发票类型2',
  `inv_type3` varchar(64) DEFAULT NULL COMMENT '发票类型3',
  `inv_title` varchar(64) DEFAULT NULL COMMENT '开票抬头',
  `inv_address` varchar(256) DEFAULT NULL COMMENT '发票地址',
  `inv_pic_name` varchar(64) DEFAULT NULL COMMENT '开票联系人',
  `inv_pic_phone` varchar(64) DEFAULT NULL COMMENT '开票联系人电话',
  `inv_bank_name` varchar(64) DEFAULT NULL COMMENT '开票银行名称',
  `inv_bank_branch` varchar(64) DEFAULT NULL COMMENT '开票银行支行',
  `inv_bank_acc` varchar(64) DEFAULT NULL COMMENT '开票银行账号',
  `inv_tel` varchar(64) DEFAULT NULL COMMENT '开票电话',
  `tax_rate` double(20,8) DEFAULT NULL COMMENT '税率',
  `tax_rate2` double(20,8) DEFAULT NULL COMMENT '税率2',
  `tax_rate3` double(20,8) DEFAULT NULL COMMENT '税率3',
  `fin_gl_type` varchar(64) DEFAULT NULL COMMENT '总账类型 总账冲销码',
  `supp_level` varchar(64) DEFAULT NULL COMMENT '供应商等级',
  `settle_method` varchar(64) DEFAULT NULL COMMENT '结算方式',
  `recon_period` varchar(64) DEFAULT NULL COMMENT '对账周期',
  `performance_period` varchar(64) DEFAULT NULL COMMENT '绩效管理周期 绩效管理周期 月度；季度；年度',
  `curr_code` varchar(64) DEFAULT NULL COMMENT '币种',
  `supp_bank` varchar(64) DEFAULT NULL COMMENT '开户银行',
  `bank_branch` varchar(64) DEFAULT NULL COMMENT '银行支行',
  `bank_account` varchar(64) DEFAULT NULL COMMENT '银行账号',
  `indus_flag2` int(1) DEFAULT NULL COMMENT '行业标识2',
  `indus_flag3` int(1) DEFAULT NULL COMMENT '行业标识3',
  `setup_date` datetime DEFAULT NULL COMMENT '成立日期',
  `register_date` datetime DEFAULT NULL COMMENT '注册日期',
  `register_country` varchar(64) DEFAULT NULL COMMENT '注册地国家',
  `register_province` varchar(64) DEFAULT NULL COMMENT '注册地省份',
  `register_city` varchar(64) DEFAULT NULL COMMENT '注册地城市',
  `register_trademark_no` varchar(64) DEFAULT NULL COMMENT '注册商标编号',
  `register_fund_curr` varchar(64) DEFAULT NULL COMMENT '注册资金货币',
  `biz_code_cert` varchar(64) DEFAULT NULL COMMENT '组织机构代码证',
  `incharger_name` varchar(64) DEFAULT NULL COMMENT '企业负责人',
  `wh_address` varchar(256) DEFAULT NULL COMMENT '仓库地址',
  `comp_scale` varchar(64) DEFAULT NULL COMMENT '公司规模',
  `busi_scope` varchar(64) DEFAULT NULL COMMENT '业务范围',
  `product_desc` varchar(256) DEFAULT NULL COMMENT '经营产品',
  `supp_remark` varchar(1000) DEFAULT NULL COMMENT '供应商简介',
  `contract_code` varchar(80) DEFAULT NULL COMMENT '已签合同编号',
  `supp_chan` varchar(64) DEFAULT NULL COMMENT '供应渠道',
  `relate_supp_id` bigint(18) DEFAULT NULL COMMENT '关联供应商ID',
  `relate_supp_name` varchar(256) DEFAULT NULL COMMENT '关联供应商名称',
  `relate_type` varchar(64) DEFAULT NULL COMMENT '关联类型',
  `user_cont_flag` int(1) DEFAULT NULL COMMENT '账号管理方式 1:与编号相同 2:手工设置',
  `user_id` bigint(18) DEFAULT NULL COMMENT '供应商默认账号',
  `lang` varchar(64) DEFAULT NULL COMMENT '语言',
  `outer_code` varchar(64) DEFAULT NULL COMMENT 'OUTER_CODE',
  `intf_time` datetime DEFAULT NULL COMMENT '接口处理时间1',
  `intf2status` varchar(64) DEFAULT NULL COMMENT '接口状态2',
  `intf2time` datetime DEFAULT NULL COMMENT '接口处理时间2',
  `tags` varchar(256) DEFAULT NULL COMMENT '标签',
  `agency_code` varchar(64) DEFAULT NULL COMMENT '代理编号',
  `agency_name` varchar(64) DEFAULT NULL COMMENT '代理名称',
  `agency_name2` varchar(64) DEFAULT NULL COMMENT '代理名称2',
  `es1` varchar(64) DEFAULT NULL COMMENT 'ES1',
  `es2` varchar(64) DEFAULT NULL COMMENT 'ES2',
  `es3` varchar(64) DEFAULT NULL COMMENT 'ES3',
  `es4` varchar(64) DEFAULT NULL COMMENT 'ES4',
  `es5` varchar(64) DEFAULT NULL COMMENT 'ES5',
  `es6` varchar(64) DEFAULT NULL COMMENT 'ES6',
  `es7` varchar(64) DEFAULT NULL COMMENT 'ES7',
  `es8` varchar(64) DEFAULT NULL COMMENT 'ES8',
  `es9` varchar(64) DEFAULT NULL COMMENT 'ES9',
  `es10` varchar(64) DEFAULT NULL COMMENT 'ES10',
  `es11` varchar(64) DEFAULT NULL COMMENT 'ES11',
  `es12` varchar(64) DEFAULT NULL COMMENT 'ES12',
  `es13` varchar(64) DEFAULT NULL COMMENT 'ES13',
  `es14` varchar(64) DEFAULT NULL COMMENT 'ES14',
  `es15` varchar(64) DEFAULT NULL COMMENT 'ES15',
  `es16` varchar(64) DEFAULT NULL COMMENT 'ES16',
  `es17` varchar(64) DEFAULT NULL COMMENT 'ES17',
  `es18` varchar(64) DEFAULT NULL COMMENT 'ES18',
  `es19` varchar(64) DEFAULT NULL COMMENT 'ES19',
  `es20` varchar(64) DEFAULT NULL COMMENT 'ES20',
  `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
  `register_flag` varchar(2) DEFAULT NULL COMMENT '注册标识',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `create_user_id_index` (`create_user_id`) USING BTREE,
  KEY `sec_bu_id_index` (`sec_bu_id`) USING BTREE,
  KEY `sec_user_id_index` (`sec_user_id`) USING BTREE,
  KEY `sec_ou_id_index` (`sec_ou_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='供应商';

-- ----------------------------
-- Table structure for pur_supp_apply
-- ----------------------------

CREATE TABLE `pur_supp_apply` (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `sec_bu_id` bigint(20) DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) DEFAULT NULL COMMENT 'sec_ou_id',
  `supp_code` varchar(40) DEFAULT NULL COMMENT '供应商编码',
  `supp_name` varchar(200) DEFAULT NULL COMMENT '企业(供应商)名称',
  `supp_abbr` varchar(100) DEFAULT NULL COMMENT '企业(供应商)简称',
  `supp_type` varchar(40) DEFAULT NULL COMMENT '供应商类型 [UDC]PUR:SUPP_TYPE',
  `supp_type2` varchar(40) DEFAULT NULL COMMENT '供应商类型2 [UDC]PUR:SUPP_TYPE2',
  `appr_status` varchar(40) DEFAULT NULL COMMENT '审批状态 [UDC]COM:APPR_STATUS',
  `approve_status` varchar(40) DEFAULT NULL COMMENT '审批状态',
  `supp_status` varchar(40) DEFAULT NULL COMMENT '供应商状态 [UDC]PUR:SUPP_STATUS',
  `comp_prop` varchar(40) DEFAULT NULL COMMENT '供应商(企业)性质 [UDC]PUR:COMP_PROP',
  `domes_type` varchar(40) DEFAULT NULL COMMENT '国内国外 [UDC]PUR:DOMES_TYPE',
  `indus_flag1` varchar(40) DEFAULT NULL COMMENT '行业类型(标识)1 [UDC]PUR:INDUS_FLAG',
  `register_fund` varchar(40) DEFAULT NULL COMMENT '注册资金',
  `register_address` varchar(100) DEFAULT NULL COMMENT '注册地址',
  `ou_id2` bigint(20) DEFAULT NULL COMMENT '内部交易公司ID',
  `ou_code2` varchar(40) DEFAULT NULL COMMENT '内部交易公司编码',
  `ou_name2` varchar(40) DEFAULT NULL COMMENT '内部交易公司名称',
  `repr_name` varchar(40) DEFAULT NULL COMMENT '法人姓名(代表)',
  `ic_register_no` varchar(40) DEFAULT NULL COMMENT '营业执照注册号(工商登记号)',
  `tax_reg_no` varchar(40) DEFAULT NULL COMMENT '税务登记证编号',
  `tax_payer_id` varchar(40) DEFAULT NULL COMMENT '纳税人识别号',
  `cert_no` varchar(64) DEFAULT NULL COMMENT '统一信用代码',
  `total_staff` int(18) DEFAULT NULL COMMENT '公司总人数',
  `establishment_years` int(18) DEFAULT NULL COMMENT '成立年限',
  `web_address` varchar(200) DEFAULT NULL COMMENT '公司网站',
  `erp_supp_code` varchar(40) DEFAULT NULL COMMENT 'ERP供应商编码',
  `mall_settlement_status` varchar(40) DEFAULT NULL COMMENT '商城入驻状态 [UDC]PUR:SETTLEMENT_STATUS',
  `mall_settlement_time` datetime DEFAULT NULL COMMENT '商城入驻时间',
  `legal_person_phone` varchar(40) DEFAULT NULL COMMENT '法人手机号',
  `legal_person_mailbox` varchar(40) DEFAULT NULL COMMENT '法人邮箱',
  `certificate_type` varchar(40) DEFAULT NULL COMMENT '法人证件类型 [UDC]PUR:CERTIFICATE_TYPE',
  `certificate_code` varchar(40) DEFAULT NULL COMMENT '法人证件编码',
  `ou_id` bigint(20) DEFAULT NULL COMMENT '公司ID',
  `ou_code` varchar(40) DEFAULT NULL COMMENT '公司编码',
  `main_category` varchar(40) DEFAULT NULL COMMENT '主营品类 [UDC]PUR:MAIN_CATEGORY',
  `plant_nature` varchar(40) DEFAULT NULL COMMENT '厂房性质 [UDC]PUR:PLANT_NATURE',
  `plant_area` double(20,8) DEFAULT NULL COMMENT '厂房面积',
  `factory_employees_number` int(18) DEFAULT NULL COMMENT '工厂员工数',
  `technology_people_number` int(18) DEFAULT NULL COMMENT '开发技术人数',
  `quality_inspection_number` int(18) DEFAULT NULL COMMENT '品质检验人数',
  `certification_system` varchar(40) DEFAULT NULL COMMENT '认证体系 [UDC]PUR:CERTIFICATION_SYSTEM',
  `product_performance_standards` varchar(200) DEFAULT NULL COMMENT '产品执行标准',
  `quality_inspection` varchar(200) DEFAULT NULL COMMENT '质量检验',
  `inspection_scope` varchar(200) DEFAULT NULL COMMENT '检验范围',
  `delivery_quality_record` varchar(200) DEFAULT NULL COMMENT '供货质量记录',
  `main_production_equipment` varchar(200) DEFAULT NULL COMMENT '主要生产设备',
  `business_scope` varchar(500) DEFAULT NULL COMMENT '经营范围',
  `company_profile` mediumtext COMMENT '企业简介',
  `payment_term` varchar(40) DEFAULT NULL COMMENT '付款条款 [UDC]ORG:PAYMENT_TERM',
  `pay_method` varchar(40) DEFAULT NULL COMMENT '付款方式 [UDC]PUR:PAY_TYPE',
  `inv_type` varchar(40) DEFAULT NULL COMMENT '默认发票类型 [UDC]COM:INV_TYPE',
  `tax_rate_no` varchar(40) DEFAULT NULL COMMENT '税率编号',
  `tax_payer_type` varchar(40) DEFAULT NULL COMMENT '纳税人类型 [UDC]ORG:PAYER_TYPE',
  `zip_code` varchar(40) DEFAULT NULL COMMENT '邮编',
  `bu_id` bigint(20) DEFAULT '0' COMMENT 'BUID',
  `doc_no` varchar(40) DEFAULT NULL COMMENT '单据编号',
  `doc_type` varchar(64) DEFAULT NULL COMMENT '单据类型 [UDC]COM:APPLY_TYPE',
  `doc_status` varchar(40) DEFAULT NULL COMMENT '单据状态 [UDC]COM:APPLY_STATUS',
  `appr_proc_inst_id` varchar(40) DEFAULT NULL COMMENT '流程实例ID',
  `appr_time` datetime DEFAULT NULL COMMENT '审批时间',
  `appr_create_user_id` bigint(20) DEFAULT '0' COMMENT '提审人ID',
  `appr_user_id` bigint(20) DEFAULT '0' COMMENT '审批人ID',
  `appr_comment` varchar(500) DEFAULT NULL COMMENT '审批意见',
  `apply_emp_id` bigint(20) DEFAULT '0' COMMENT '申请人员工ID',
  `apply_date` datetime DEFAULT NULL COMMENT '申请日期',
  `apply_desc` varchar(100) DEFAULT NULL COMMENT '申请描述',
  `addr_no` bigint(20) DEFAULT NULL COMMENT '地址号',
  `we_chat_no` varchar(100) DEFAULT NULL COMMENT '微信号',
  `qq_no` varchar(100) DEFAULT NULL COMMENT 'QQ号',
  `comp_code` varchar(40) DEFAULT NULL COMMENT 'CRM编码',
  `paid_money` varchar(100) DEFAULT NULL COMMENT '实缴资金',
  `register_mail` varchar(200) DEFAULT NULL COMMENT '联系人邮箱(注册邮箱)',
  `category_description` mediumtext COMMENT '主营品类简介',
  `supp_name2` varchar(200) DEFAULT NULL COMMENT '供应商名称2',
  `supp_type3` varchar(40) DEFAULT NULL COMMENT '供应商类型3',
  `supp_type4` varchar(40) DEFAULT NULL COMMENT '供应商类型4',
  `supp_type5` varchar(40) DEFAULT NULL COMMENT '供应商类型5',
  `supp_status2` varchar(40) DEFAULT NULL COMMENT '供应商状态2',
  `supp_status3` varchar(40) DEFAULT NULL COMMENT '供应商状态3',
  `supp_group` varchar(40) DEFAULT NULL COMMENT '供应商组别',
  `supp_group2` varchar(40) DEFAULT NULL COMMENT '供应商组别2',
  `supp_group3` varchar(40) DEFAULT NULL COMMENT '供应商组别3',
  `supp_group4` varchar(40) DEFAULT NULL COMMENT '供应商组别4',
  `pid` bigint(20) DEFAULT '0' COMMENT '上级ID',
  `supp_path` varchar(500) DEFAULT NULL COMMENT '路径',
  `enrole_desc` varchar(200) DEFAULT NULL COMMENT '引入理由',
  `busi_begin_date` datetime DEFAULT NULL COMMENT '合作开始日期',
  `busi_end_date` datetime DEFAULT NULL COMMENT '合作终止日期',
  `approve_date` datetime DEFAULT NULL COMMENT '转正日期',
  `innerouter_flag` int(1) DEFAULT NULL COMMENT '内外部',
  `purchaser_emp_id` bigint(20) DEFAULT '0' COMMENT '采购员员工ID',
  `tax_type` varchar(40) DEFAULT NULL COMMENT '税区',
  `tax_code` varchar(40) DEFAULT NULL COMMENT '税码',
  `taxer_no` varchar(100) DEFAULT NULL COMMENT '税号',
  `inv_type2` varchar(40) DEFAULT NULL COMMENT '发票类型2',
  `inv_type3` varchar(40) DEFAULT NULL COMMENT '发票类型3',
  `inv_title` varchar(40) DEFAULT NULL COMMENT '开票抬头',
  `inv_address` varchar(200) DEFAULT NULL COMMENT '发票地址',
  `inv_pic_name` varchar(40) DEFAULT NULL COMMENT '开票联系人',
  `inv_pic_phone` varchar(40) DEFAULT NULL COMMENT '开票联系人电话',
  `inv_bank_name` varchar(40) DEFAULT NULL COMMENT '开票银行名称',
  `inv_bank_branch` varchar(40) DEFAULT NULL COMMENT '开票银行支行',
  `inv_bank_acc` varchar(40) DEFAULT NULL COMMENT '开票银行账号',
  `inv_tel` varchar(40) DEFAULT NULL COMMENT '开票电话',
  `tax_rate` double(20,8) DEFAULT NULL COMMENT '税率',
  `tax_rate2` double(20,8) DEFAULT NULL COMMENT '税率2',
  `tax_rate3` double(20,8) DEFAULT NULL COMMENT '税率3',
  `fin_gl_type` varchar(40) DEFAULT NULL COMMENT '总账类型 总账冲销码',
  `supp_level` varchar(40) DEFAULT NULL COMMENT '供应商等级',
  `settle_method` varchar(40) DEFAULT NULL COMMENT '结算方式',
  `recon_period` varchar(40) DEFAULT NULL COMMENT '对账周期',
  `performance_period` varchar(40) DEFAULT NULL COMMENT '绩效管理周期',
  `curr_code` varchar(40) DEFAULT NULL COMMENT '币种',
  `supp_bank` varchar(40) DEFAULT NULL COMMENT '开户银行',
  `bank_branch` varchar(40) DEFAULT NULL COMMENT '银行支行',
  `bank_account` varchar(40) DEFAULT NULL COMMENT '银行账号',
  `indus_flag2` int(1) DEFAULT NULL COMMENT '行业标识2',
  `indus_flag3` int(1) DEFAULT NULL COMMENT '行业标识3',
  `setup_date` datetime DEFAULT NULL COMMENT '成立日期',
  `register_date` datetime DEFAULT NULL COMMENT '注册日期',
  `register_country` varchar(40) DEFAULT NULL COMMENT '注册地国家',
  `register_province` varchar(40) DEFAULT NULL COMMENT '注册地省份',
  `register_city` varchar(40) DEFAULT NULL COMMENT '注册地城市',
  `register_trademark_no` varchar(40) DEFAULT NULL COMMENT '注册商标编号',
  `register_fund_curr` varchar(40) DEFAULT NULL COMMENT '注册资金货币',
  `biz_code_cert` varchar(40) DEFAULT NULL COMMENT '组织机构代码证',
  `incharger_name` varchar(40) DEFAULT NULL COMMENT '企业负责人',
  `wh_address` varchar(200) DEFAULT NULL COMMENT '仓库地址',
  `comp_scale` varchar(40) DEFAULT NULL COMMENT '公司规模',
  `busi_scope` varchar(40) DEFAULT NULL COMMENT '业务范围',
  `product_desc` varchar(200) DEFAULT NULL COMMENT '经营产品',
  `supp_remark` varchar(1000) DEFAULT NULL COMMENT '供应商简介',
  `contract_code` varchar(80) DEFAULT NULL COMMENT '已签合同编号',
  `supp_chan` varchar(40) DEFAULT NULL COMMENT '供应渠道',
  `relate_supp_id` bigint(20) DEFAULT '0' COMMENT '关联供应商ID',
  `relate_supp_name` varchar(200) DEFAULT NULL COMMENT '关联供应商名称',
  `relate_type` varchar(40) DEFAULT NULL COMMENT '关联类型',
  `user_cont_flag` int(1) DEFAULT NULL COMMENT '账号管理方式 1:与编号相同 2:手工设置',
  `user_id` bigint(20) DEFAULT '0' COMMENT '供应商默认账号',
  `lang` varchar(40) DEFAULT NULL COMMENT '语言',
  `agency_code` varchar(40) DEFAULT NULL COMMENT '代理编号',
  `agency_name` varchar(40) DEFAULT NULL COMMENT '代理名称',
  `agency_name2` varchar(40) DEFAULT NULL COMMENT '代理名称2',
  `agency_bu_id` bigint(20) DEFAULT '0' COMMENT '代理BUID',
  `brand_code` varchar(40) DEFAULT NULL COMMENT '品牌编号',
  `brand_name` varchar(40) DEFAULT NULL COMMENT '品牌名称',
  `brand_name2` varchar(40) DEFAULT NULL COMMENT '品牌名称2',
  `outer_code` varchar(40) DEFAULT NULL COMMENT 'E1编号',
  `es5` varchar(40) DEFAULT NULL COMMENT 'ES5',
  `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
  `proc_inst_id` varchar(255) DEFAULT NULL COMMENT '流程实例ID',
  `proc_inst_status` varchar(255) DEFAULT NULL COMMENT '流程实例状态',
  `submit_time` datetime(6) DEFAULT NULL COMMENT '提交时间',
  `approved_time` datetime(6) DEFAULT NULL COMMENT '审批通过时间',
  `register_flag` varchar(2) DEFAULT NULL COMMENT '注册标识',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `create_user_id_index` (`create_user_id`) USING BTREE,
  KEY `sec_bu_id_index` (`sec_bu_id`) USING BTREE,
  KEY `sec_user_id_index` (`sec_user_id`) USING BTREE,
  KEY `sec_ou_id_index` (`sec_ou_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='供应商申请单 APPLY_DESC 与 REMARK 之间字段与业务表相同';

-- ----------------------------
-- Table structure for pur_union_account
-- ----------------------------

CREATE TABLE `pur_union_account` (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `sec_bu_id` bigint(20) DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) DEFAULT NULL COMMENT 'sec_ou_id',
  `ou_id` bigint(20) DEFAULT NULL COMMENT '公司ID',
  `supp_id` bigint(20) DEFAULT NULL COMMENT '供应商ID',
  `bill_id` bigint(20) DEFAULT NULL COMMENT '业务单据ID',
  `bill_doc_type` varchar(40) DEFAULT NULL COMMENT '单据类型',
  `account_type` varchar(40) DEFAULT NULL COMMENT '对账类型',
  `doc_type` varchar(255) DEFAULT NULL,
  `doc_no` varchar(40) DEFAULT NULL COMMENT '单据编号',
  `po_id` bigint(20) DEFAULT NULL COMMENT '采购订单ID',
  `po_no` varchar(40) DEFAULT NULL COMMENT '单据编号',
  `recv_date` datetime DEFAULT NULL COMMENT '发货日期',
  `amt` decimal(20,2) DEFAULT NULL COMMENT '含税总金额',
  `net_amt` decimal(20,2) DEFAULT NULL COMMENT '未税总金额',
  `tax_amt` decimal(20,2) DEFAULT NULL COMMENT '税额',
  `recv_emp_id` bigint(20) DEFAULT '0' COMMENT '收货人员工ID',
  `recv_emp_name` varchar(40) DEFAULT NULL COMMENT '收货人员工名字',
  `wh_id` bigint(20) DEFAULT '0' COMMENT '仓库ID',
  `doc_status` varchar(40) DEFAULT NULL COMMENT '单据状态',
  `pur_account_check_id` bigint(20) DEFAULT NULL COMMENT '采购结算对账单ID',
  `account_flag` tinyint(2) DEFAULT NULL COMMENT '是否生成采购结算对账单0:未生成,1:已生成',
  `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
  `curr_amt` decimal(20,8) DEFAULT NULL COMMENT '外币含税金额',
  `curr_net_amt` decimal(20,8) DEFAULT NULL COMMENT '外币不含税金额',
  `parts_amt_use` decimal(20,8) DEFAULT NULL COMMENT '配额分配金额(含税)',
  `parts_net_amt_use` decimal(20,8) DEFAULT NULL COMMENT '配额分配金额(不含税)',
  `parts_amt_local_use` decimal(20,8) DEFAULT NULL COMMENT '配额分配本币金额(含税)',
  `parts_net_amt_local_use` decimal(20,8) DEFAULT NULL COMMENT '配额分配本币金额(不含税)',
  `scene_type_id` bigint(20) DEFAULT '0' COMMENT '采购场景类型ID',
  `doc_time` datetime DEFAULT NULL COMMENT '采购订单订单日期',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `create_user_id_index` (`create_user_id`) USING BTREE,
  KEY `sec_bu_id_index` (`sec_bu_id`) USING BTREE,
  KEY `sec_user_id_index` (`sec_user_id`) USING BTREE,
  KEY `sec_ou_id_index` (`sec_ou_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='采购对账单单据列表集合';

-- ----------------------------
-- Table structure for pur_union_account_d
-- ----------------------------

CREATE TABLE `pur_union_account_d` (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `sec_bu_id` bigint(20) DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) DEFAULT NULL COMMENT 'sec_ou_id',
  `mas_id` bigint(20) DEFAULT '0' COMMENT '主表ID',
  `bill_d_id` bigint(20) DEFAULT NULL COMMENT '业务单据明细ID',
  `bill_id` bigint(20) DEFAULT NULL COMMENT '业务单据ID',
  `line_no` decimal(20,3) DEFAULT NULL COMMENT '采购订单行号',
  `gr_line_no` decimal(20,3) DEFAULT NULL COMMENT '采购收货单行号',
  `tbl_line_no` decimal(20,3) DEFAULT NULL COMMENT '中间表行号',
  `po_d_id` bigint(20) DEFAULT '0' COMMENT '采购订单明细ID',
  `ss_d_id` bigint(20) DEFAULT '0' COMMENT '供应商发货单明细ID',
  `item_id` bigint(20) DEFAULT '0' COMMENT '品项ID',
  `vari_id` bigint(20) DEFAULT '0' COMMENT '异构ID',
  `po_qty` decimal(20,8) DEFAULT NULL COMMENT '订购数量',
  `ss_qty` decimal(20,8) DEFAULT NULL COMMENT '发货数量',
  `qty` decimal(20,8) DEFAULT NULL COMMENT '收货数量',
  `uom` varchar(10) DEFAULT NULL COMMENT '单位',
  `qty2` decimal(20,8) DEFAULT NULL COMMENT '收货数量2',
  `uom2` varchar(10) DEFAULT NULL COMMENT '单位2',
  `uom_ratio` decimal(20,8) DEFAULT NULL COMMENT '单位转换率',
  `uom_ratio2` decimal(20,8) DEFAULT NULL COMMENT '单位转换率2',
  `trans_price` decimal(20,8) DEFAULT NULL COMMENT '交易单价 折扣后，不含税',
  `tax_amt` decimal(20,8) DEFAULT NULL COMMENT '税额',
  `amt` decimal(20,8) DEFAULT NULL COMMENT '含税金额',
  `net_amt` decimal(20,8) DEFAULT NULL COMMENT '不含税金额',
  `curr_amt` decimal(20,8) DEFAULT NULL COMMENT '外币含税金额',
  `curr_net_amt` decimal(20,8) DEFAULT NULL COMMENT '外币不含税金额',
  `wh_id` bigint(20) DEFAULT '0' COMMENT '仓库ID',
  `deter1` varchar(40) DEFAULT NULL COMMENT '温层 [UDC]INV:TEMP_TYPE',
  `deter2` varchar(40) DEFAULT NULL COMMENT '功能区 [UDC]INV:FUNC_TYPE',
  `deter3` varchar(40) DEFAULT NULL COMMENT '客户标识',
  `deter4` varchar(40) DEFAULT NULL COMMENT '限定4',
  `deter5` varchar(40) DEFAULT NULL COMMENT '限定5',
  `deter6` varchar(40) DEFAULT NULL COMMENT '限定6',
  `deter7` varchar(40) DEFAULT NULL COMMENT '限定7',
  `deter8` varchar(40) DEFAULT NULL COMMENT '限定8',
  `wh_loc` varchar(40) DEFAULT NULL COMMENT '库位',
  `wh_posi` varchar(40) DEFAULT NULL COMMENT '货位',
  `lot_no` varchar(40) DEFAULT NULL COMMENT '收货批次',
  `menu_lot_no` varchar(40) DEFAULT NULL COMMENT '生产批次',
  `manu_date` datetime DEFAULT NULL COMMENT '生产日期',
  `batch_no` varchar(40) DEFAULT NULL COMMENT '整批号',
  `expire_date` datetime DEFAULT NULL COMMENT '过期日期',
  `expire_days` int(18) DEFAULT NULL COMMENT '保质期天数',
  `until_expire_days` int(18) DEFAULT NULL COMMENT '剩余效期天数',
  `demand_fresh_percent` decimal(20,8) DEFAULT NULL COMMENT '要求保质期比例',
  `demand_aap_days` int(18) DEFAULT NULL COMMENT '最低允收期天数',
  `is_fress_valid` int(1) DEFAULT NULL COMMENT '是否新鲜度合格',
  `actual_fresh_percent` decimal(20,8) DEFAULT NULL COMMENT '到货保质期比例',
  `shipment_date` datetime DEFAULT NULL COMMENT '供应商发货日期',
  `exception_desc` varchar(40) DEFAULT NULL COMMENT '异常备注',
  `barcode` varchar(40) DEFAULT NULL COMMENT '条码',
  `root_id` bigint(20) DEFAULT '0' COMMENT '根ID',
  `relate_doc_cls` varchar(40) DEFAULT NULL COMMENT '关联单据类别 [UDC]COM:DOC_CLS',
  `relate_doc_type` varchar(40) DEFAULT NULL COMMENT '关联单据类型',
  `relate_doc_id` bigint(20) DEFAULT '0' COMMENT '关联单据ID',
  `relate_doc_no` varchar(40) DEFAULT NULL COMMENT '关联单据编号',
  `relate_doc_did` bigint(20) DEFAULT '0' COMMENT '关联单据明细ID',
  `relate_doc_lineno` decimal(20,3) DEFAULT NULL COMMENT '关联单据行号',
  `relate_doc2_cls` varchar(40) DEFAULT NULL COMMENT '关联单据2类别 [UDC]COM:DOC_CLS',
  `relate_doc2_type` varchar(40) DEFAULT NULL COMMENT '关联单据2类型',
  `relate_doc2_id` bigint(20) DEFAULT '0' COMMENT '关联单据2ID',
  `relate_doc2_no` varchar(40) DEFAULT NULL COMMENT '关联单据2编号',
  `relate_doc2_did` bigint(20) DEFAULT '0' COMMENT '关联单据2明细ID',
  `relate_doc2_lineno` decimal(20,3) DEFAULT NULL COMMENT '关联单据2行号',
  `es1` varchar(40) DEFAULT NULL COMMENT 'ES1',
  `es2` varchar(40) DEFAULT NULL COMMENT 'ES2',
  `es3` varchar(40) DEFAULT NULL COMMENT 'ES3',
  `es4` varchar(40) DEFAULT NULL COMMENT 'ES4',
  `es5` varchar(40) DEFAULT NULL COMMENT 'ES5',
  `dbrand` varchar(40) DEFAULT NULL COMMENT '品牌',
  `base_price` decimal(20,8) DEFAULT NULL COMMENT '基价',
  `price_type` varchar(40) DEFAULT NULL COMMENT '价格类型',
  `net_price` decimal(20,8) DEFAULT NULL COMMENT '不含税价格',
  `price` decimal(20,8) DEFAULT NULL COMMENT '含税单价',
  `pb_price` decimal(20,8) DEFAULT NULL COMMENT '价格本价格',
  `pb_curr` varchar(40) DEFAULT NULL COMMENT '价格本币种',
  `pb_uom` varchar(10) DEFAULT NULL COMMENT '价格本单位',
  `disc_type` varchar(40) DEFAULT NULL COMMENT '折扣类型',
  `disc_ratio` decimal(20,8) DEFAULT NULL COMMENT '折扣率',
  `disc_amt` decimal(20,2) DEFAULT NULL COMMENT '折扣额',
  `disc_desc` varchar(100) DEFAULT NULL COMMENT '折扣描述',
  `disced_price` decimal(20,8) DEFAULT NULL COMMENT '折扣后价格',
  `tax_code` varchar(40) DEFAULT NULL COMMENT '税码',
  `tax_rate_no` varchar(40) DEFAULT NULL COMMENT '税率编号',
  `tax_rate` decimal(20,8) DEFAULT NULL COMMENT '税率',
  `curr_net_price` decimal(20,8) DEFAULT NULL COMMENT '外币含不税单价',
  `curr_price` decimal(20,8) DEFAULT NULL COMMENT '外币含税单价',
  `home_curr` varchar(40) DEFAULT NULL COMMENT '本币币种',
  `curr_code` varchar(40) DEFAULT NULL COMMENT '币种',
  `curr_rate` decimal(20,8) DEFAULT NULL COMMENT '汇率',
  `outer_ou` varchar(40) DEFAULT NULL COMMENT '外部单据公司',
  `outer_type` varchar(40) DEFAULT NULL COMMENT '外部单据类型',
  `outer_no` varchar(40) DEFAULT NULL COMMENT '外部单据编号',
  `outer_lineno` varchar(40) DEFAULT NULL COMMENT '外部单据行号',
  `payed_qty` decimal(20,8) DEFAULT NULL COMMENT '数量2',
  `payed_amt` decimal(20,2) DEFAULT NULL COMMENT '已付金额',
  `gr_no` varchar(40) DEFAULT NULL COMMENT '收货单据编号',
  `line_type` varchar(40) DEFAULT NULL COMMENT '行类型',
  `outer_line_type` varchar(40) DEFAULT NULL COMMENT '外部单据行类型',
  `pur_account_check_id` bigint(20) DEFAULT NULL COMMENT '采购结算对账单ID',
  `account_flag` tinyint(2) DEFAULT NULL COMMENT '是否生成采购结算对账单0:未生成,1:已生成',
  `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
  `so_doc_id` bigint(20) DEFAULT '0' COMMENT '销售订单单据ID',
  `so_doc_did` bigint(20) DEFAULT '0' COMMENT '销售订单单据明细ID',
  `so_doc_no` varchar(40) DEFAULT NULL COMMENT '销售订单单据编号',
  `so_doc_lineno` decimal(20,3) DEFAULT NULL COMMENT '销售订单来源单据行号',
  `parts_amt_use` decimal(20,8) DEFAULT '0.00000000' COMMENT '配额分配金额(含税)',
  `parts_net_amt_use` decimal(20,8) DEFAULT '0.00000000' COMMENT '配额分配金额(不含税)',
  `recv_addr` varchar(2000) DEFAULT NULL COMMENT '收货地址',
  `trans_type` varchar(10) DEFAULT NULL COMMENT '运输方式',
  `parts_amt_local_use` decimal(20,8) DEFAULT '0.00000000' COMMENT '配额分配本币金额(含税)',
  `parts_net_amt_local_use` decimal(20,8) DEFAULT '0.00000000' COMMENT '配额分配本币金额(不含税)',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `create_user_id_index` (`create_user_id`) USING BTREE,
  KEY `sec_bu_id_index` (`sec_bu_id`) USING BTREE,
  KEY `sec_user_id_index` (`sec_user_id`) USING BTREE,
  KEY `sec_ou_id_index` (`sec_ou_id`) USING BTREE,
  KEY `mas_id_index` (`mas_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='采购对账单单据列表明细集合';

-- ----------------------------
-- Table structure for rocket_transaction_log
-- ----------------------------

CREATE TABLE `rocket_transaction_log` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `transaction_id` varchar(100) NOT NULL COMMENT '事务id',
  `doc_code` varchar(100) DEFAULT NULL COMMENT '文件编号标识',
  `project` varchar(200) DEFAULT NULL COMMENT '项目标识',
  `business` varchar(200) DEFAULT NULL COMMENT '业务标识',
  `extend_json` varchar(200) DEFAULT NULL COMMENT '扩展信息',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `UK_t6h3pd6fijdux5e1fvvrtx99g` (`transaction_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='rocketmnq事务日志';

-- ----------------------------
-- Table structure for sal_so_d
-- ----------------------------

CREATE TABLE `sal_so_d` (
  `id` bigint(20) NOT NULL DEFAULT '0' COMMENT '唯一编号ID',
  `mas_id` bigint(20) DEFAULT NULL COMMENT '主表ID',
  `ou_id` bigint(20) DEFAULT NULL COMMENT '公司ID',
  `bu_id` bigint(20) DEFAULT NULL COMMENT 'BUID',
  `bd_id` bigint(20) DEFAULT NULL COMMENT '事业部ID',
  `pc_id` bigint(20) DEFAULT NULL COMMENT '利润中心ID',
  `line_no` decimal(20,3) DEFAULT NULL COMMENT '行号',
  `line_type` varchar(64) DEFAULT NULL COMMENT '行类型 [UDC]SAL:SO_LINE_TYPE',
  `line_status` varchar(64) DEFAULT NULL COMMENT '行状态',
  `wh_id` bigint(20) DEFAULT NULL COMMENT '仓库ID',
  `deter1` varchar(64) DEFAULT NULL COMMENT '温层 [UDC]INV:TEMP_TYPE',
  `deter2` varchar(64) DEFAULT NULL COMMENT '功能区 [UDC]INV:FUNC_TYPE',
  `deter3` varchar(64) DEFAULT NULL COMMENT '客户标识',
  `deter4` varchar(64) DEFAULT NULL COMMENT '限定4',
  `deter5` varchar(64) DEFAULT NULL COMMENT '限定5',
  `deter6` varchar(64) DEFAULT NULL COMMENT '限定6',
  `deter7` varchar(64) DEFAULT NULL COMMENT '限定7',
  `deter8` varchar(64) DEFAULT NULL COMMENT '限定8',
  `wh_loc` varchar(64) DEFAULT NULL COMMENT '库位',
  `wh_posi` varchar(64) DEFAULT NULL COMMENT '货位',
  `cust_id` bigint(20) DEFAULT NULL COMMENT '客户ID',
  `item_id` bigint(20) DEFAULT NULL COMMENT '品项ID',
  `item_code` varchar(64) DEFAULT NULL COMMENT '品项编号',
  `item_name` varchar(128) DEFAULT NULL COMMENT '品项名称',
  `item_name2` varchar(128) DEFAULT NULL COMMENT '品项名称2',
  `item_spec` varchar(64) DEFAULT NULL COMMENT '品项规格',
  `item_cs_code` varchar(64) DEFAULT NULL COMMENT '客户品项编号',
  `barcode` varchar(64) DEFAULT NULL COMMENT '条码',
  `qty` decimal(20,8) DEFAULT NULL COMMENT '数量',
  `uom` varchar(16) DEFAULT NULL COMMENT '单位',
  `qty2` decimal(20,8) DEFAULT NULL COMMENT '数量2',
  `uom2` varchar(16) DEFAULT NULL COMMENT '单位2',
  `uom_ratio` decimal(20,8) DEFAULT NULL COMMENT '单位转换率',
  `uom_ratio2` decimal(20,8) DEFAULT NULL COMMENT '单位转换率2',
  `pack_demand` varchar(64) DEFAULT NULL COMMENT '装箱要求 [UDC]COM:PACK_DEMAND',
  `pack_qty` decimal(20,8) DEFAULT NULL COMMENT '包装数量',
  `pack_uom` varchar(16) DEFAULT NULL COMMENT '包装单位',
  `net_weight` decimal(20,8) DEFAULT NULL COMMENT '净重',
  `gross_weight` decimal(20,8) DEFAULT NULL COMMENT '毛重',
  `weight_uom` varchar(64) DEFAULT NULL COMMENT '重量单位',
  `weight_ratio` decimal(20,8) DEFAULT NULL COMMENT '重量转换率 重量单位与主单位',
  `volume` decimal(20,8) DEFAULT NULL COMMENT '体积',
  `volume_uom` varchar(16) DEFAULT NULL COMMENT '体积单位',
  `base_price` decimal(20,8) DEFAULT NULL COMMENT '基价',
  `price_type` varchar(64) DEFAULT NULL COMMENT '价格类型',
  `price` decimal(20,8) DEFAULT NULL COMMENT '含税价格',
  `net_price` decimal(20,8) DEFAULT NULL COMMENT '不含税价格',
  `disc_type` varchar(64) DEFAULT NULL COMMENT '折扣类型',
  `disc_ratio` decimal(20,8) DEFAULT NULL COMMENT '折扣率',
  `disc_amt` decimal(20,2) DEFAULT NULL COMMENT '折扣额',
  `disc_desc` varchar(128) DEFAULT NULL COMMENT '折扣描述',
  `disced_price` decimal(20,8) DEFAULT NULL COMMENT '折扣后价格',
  `ref_price` decimal(20,8) DEFAULT NULL COMMENT '客户价格',
  `trans_price` decimal(20,8) DEFAULT NULL COMMENT '交易单价 折扣后，不含税',
  `pay_status` varchar(64) DEFAULT NULL COMMENT '支付状态',
  `inv_status` varchar(64) DEFAULT NULL COMMENT '发票状态',
  `inv_date` timestamp NULL DEFAULT NULL COMMENT '发票日期',
  `cust_tax_type` varchar(64) DEFAULT NULL COMMENT '客户税类型',
  `item_tax_type` varchar(64) DEFAULT NULL COMMENT '商品税类型',
  `tax_code` varchar(64) DEFAULT NULL COMMENT '税码',
  `tax_rate_no` varchar(64) DEFAULT NULL COMMENT '税率编号',
  `tax_rate` decimal(20,8) DEFAULT NULL COMMENT '税率',
  `tax_amt` decimal(20,2) DEFAULT NULL COMMENT '税额',
  `amt` decimal(20,2) DEFAULT NULL COMMENT '含税金额',
  `net_amt` decimal(20,2) DEFAULT NULL COMMENT '不含税金额',
  `curr_amt` decimal(20,2) DEFAULT NULL COMMENT '外币含税金额',
  `home_curr` varchar(64) DEFAULT NULL COMMENT '本币币种',
  `curr_code` varchar(64) DEFAULT NULL COMMENT '币种',
  `curr_rate` decimal(20,8) DEFAULT NULL COMMENT '汇率',
  `demand_fresh_percent` decimal(10,2) DEFAULT NULL COMMENT '要求保质期比例',
  `demand_aap_days` bigint(20) DEFAULT NULL COMMENT '要求效期天数',
  `alloc_status` varchar(64) DEFAULT NULL COMMENT '配货状态',
  `logis_status` varchar(64) DEFAULT NULL COMMENT '物流状态',
  `demand_date` varchar(64) DEFAULT NULL COMMENT '要求日期',
  `plan_ship_date` varchar(64) DEFAULT NULL COMMENT '计划出库日期',
  `promise_deliver_date` varchar(64) DEFAULT NULL COMMENT '承诺交货日期',
  `command_ship_time` varchar(64) DEFAULT NULL COMMENT '通知仓库发货时间',
  `pick_time` timestamp NULL DEFAULT NULL COMMENT '拣货时间',
  `ship_confirm_time` varchar(64) DEFAULT NULL COMMENT '出库确认时间',
  `cancel_qty` decimal(20,8) DEFAULT NULL COMMENT '已取消数量',
  `cancel_time` timestamp NULL DEFAULT NULL COMMENT '取消时间',
  `cancel_reason` varchar(64) DEFAULT NULL COMMENT '取消原因',
  `cancel_user_id` bigint(20) DEFAULT NULL COMMENT '取消用户ID',
  `shipped_qty` decimal(20,8) DEFAULT NULL COMMENT '已出库数量',
  `returned_qty` decimal(20,8) DEFAULT NULL COMMENT '已退货数量',
  `hard_promise_qty` decimal(20,8) DEFAULT NULL COMMENT '硬承诺数量',
  `picked_qty` decimal(20,8) DEFAULT NULL COMMENT '拣货数量',
  `prom_id` bigint(20) DEFAULT NULL COMMENT '促销ID',
  `prom_no` varchar(64) DEFAULT NULL COMMENT '促销编号',
  `root_id` bigint(20) DEFAULT NULL COMMENT '根ID',
  `relate_doc_cls` varchar(64) DEFAULT NULL COMMENT '关联单据类别 [UDC]COM:DOC_CLS',
  `relate_doc_type` varchar(64) DEFAULT NULL COMMENT '关联单据类型',
  `relate_doc_id` bigint(20) DEFAULT NULL COMMENT '关联单据ID',
  `relate_doc_no` varchar(64) DEFAULT NULL COMMENT '关联单据编号',
  `relate_doc_did` bigint(20) DEFAULT NULL COMMENT '关联单据明细ID',
  `relate_doc_lineno` decimal(20,3) DEFAULT NULL COMMENT '关联单据行号',
  `relate_doc2cls` varchar(64) DEFAULT NULL COMMENT '关联单据2类别 [UDC]COM:DOC_CLS',
  `relate_doc2type` varchar(64) DEFAULT NULL COMMENT '关联单据2类型',
  `relate_doc2id` bigint(20) DEFAULT NULL COMMENT '关联单据2ID',
  `relate_doc2no` varchar(64) DEFAULT NULL COMMENT '关联单据2编号',
  `relate_doc2did` bigint(20) DEFAULT NULL COMMENT '关联单据2明细ID',
  `relate_doc2lineno` decimal(20,3) DEFAULT NULL COMMENT '关联单据2行号',
  `es1` varchar(64) DEFAULT NULL COMMENT 'ES1',
  `es2` varchar(64) DEFAULT NULL COMMENT 'ES2',
  `es3` varchar(64) DEFAULT NULL COMMENT 'ES3',
  `es4` varchar(64) DEFAULT NULL COMMENT 'ES4',
  `es5` varchar(64) DEFAULT NULL COMMENT 'ES5',
  `es6` varchar(64) DEFAULT NULL COMMENT 'ES6',
  `es7` varchar(64) DEFAULT NULL COMMENT 'ES7',
  `es8` varchar(64) DEFAULT NULL COMMENT 'ES8',
  `es9` varchar(64) DEFAULT NULL COMMENT 'ES9',
  `es10` varchar(64) DEFAULT NULL COMMENT 'ES10',
  `en1` decimal(20,2) DEFAULT NULL COMMENT 'EN1',
  `en2` decimal(20,2) DEFAULT NULL COMMENT 'EN2',
  `en3` decimal(20,2) DEFAULT NULL COMMENT 'EN3',
  `en4` decimal(20,2) DEFAULT NULL COMMENT 'EN4',
  `en5` decimal(20,2) DEFAULT NULL COMMENT 'EN5',
  `ed1` timestamp NULL DEFAULT NULL COMMENT 'ED1',
  `ed2` timestamp NULL DEFAULT NULL COMMENT 'ED2',
  `ed3` timestamp NULL DEFAULT NULL COMMENT 'ED3',
  `tenant_id` bigint(20) DEFAULT '0' COMMENT '租户ID',
  `remark` varchar(255) DEFAULT '' COMMENT '备注',
  `create_user_id` bigint(20) DEFAULT '0' COMMENT '记录创建者ID',
  `create_time` timestamp NULL DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) DEFAULT '0' COMMENT '记录最后更新者ID',
  `modify_time` timestamp NULL DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) DEFAULT '0' COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) DEFAULT '0' COMMENT '版本信息，前端不用传',
  `last_out_lot` timestamp NULL DEFAULT NULL COMMENT '最后出库批次 针对这家客户的',
  `vari_id` bigint(20) DEFAULT NULL COMMENT '异构ID',
  `curr_net_amt` float(20,2) DEFAULT NULL COMMENT '外币不含税金额',
  `relate_doc2_cls` varchar(40) DEFAULT NULL COMMENT '关联单据2类别 [UDC]COM:DOC_CLS',
  `relate_doc2_type` varchar(40) DEFAULT NULL COMMENT '关联单据2类型',
  `relate_doc2_id` bigint(20) DEFAULT NULL COMMENT '关联单据2ID',
  `relate_doc2_no` varchar(40) DEFAULT NULL COMMENT '关联单据2编号',
  `relate_doc2_did` int(11) DEFAULT NULL COMMENT '关联单据2明细ID',
  `relate_doc2_lineno` float(20,2) DEFAULT NULL COMMENT '关联单据2行号',
  `ou_code` varchar(40) DEFAULT NULL COMMENT 'OU_CODE',
  `org_id` bigint(20) DEFAULT NULL COMMENT 'ORG_ID',
  `org_code` varchar(40) DEFAULT NULL COMMENT 'ORG_CODE',
  `return_reason_code` varchar(40) DEFAULT NULL COMMENT '退货原因码 [UDC]SAL:SO_RETURN_REASON',
  `return_mat_flag` int(11) DEFAULT NULL COMMENT '是否实物退回',
  `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
  `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
  `cost_price` decimal(20,8) DEFAULT NULL COMMENT '成本价',
  `cost_amt` decimal(20,8) DEFAULT NULL COMMENT '成本金额',
  `do_amt` decimal(20,2) DEFAULT NULL COMMENT '折扣额',
  `co_amt` decimal(20,2) DEFAULT NULL COMMENT '折扣额',
  `lot_no` varchar(64) DEFAULT NULL COMMENT 'LOTNO',
  `cancelled_qty` decimal(20,8) DEFAULT NULL COMMENT '已取消数量',
  `recv_wh_id` bigint(20) DEFAULT NULL COMMENT '收方仓库',
  `recv_deter1` varchar(40) DEFAULT NULL COMMENT '收方温层',
  `recv_deter2` varchar(40) DEFAULT NULL COMMENT '收方功能区',
  `recv_deter3` varchar(40) DEFAULT NULL COMMENT '收方客户标识',
  `ref_tax_price` decimal(20,8) DEFAULT NULL COMMENT '客户含税价格',
  `trans_tax_price` decimal(20,8) DEFAULT NULL COMMENT '交易含税单价 折扣后，含税',
  `orign_amt` decimal(20,2) DEFAULT NULL COMMENT '含税原金额',
  `orign_net_amt` decimal(20,2) DEFAULT NULL COMMENT '未税原金额',
  `disc_tax_amt` decimal(20,2) DEFAULT NULL COMMENT '折扣含税额',
  `returned_atm` decimal(20,2) DEFAULT NULL COMMENT '已退货含税金额',
  `returned_net_atm` decimal(20,2) DEFAULT NULL COMMENT '已退货未税金额',
  `cancel_net_atm` decimal(20,2) DEFAULT NULL COMMENT '已取消未税金额',
  `cancel_atm` decimal(20,2) DEFAULT NULL COMMENT '已取消含税金额',
  `shipped_atm` decimal(20,2) DEFAULT NULL COMMENT '发货未税金额',
  `shipped_net_atm` float(20,2) DEFAULT NULL COMMENT '发货未税金额',
  `aap_code` varchar(40) DEFAULT NULL COMMENT '允收期编码 [UDC]COM:AAP_CODE',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `mas_id` (`mas_id`) USING BTREE,
  KEY `item_id` (`item_id`) USING BTREE,
  KEY `item_code` (`item_code`) USING BTREE,
  KEY `create_user_id_index` (`create_user_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='销售订单明细';

-- ----------------------------
-- Table structure for send_bill
-- ----------------------------

CREATE TABLE `send_bill` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `sal_do_doc_no` varchar(40) DEFAULT NULL COMMENT '订单中心发（退）货单号',
  `tenant_id` bigint(20) DEFAULT NULL,
  `remark` varchar(255) DEFAULT NULL,
  `create_user_id` bigint(20) DEFAULT NULL,
  `creator` varchar(255) DEFAULT NULL,
  `create_time` datetime(6) DEFAULT NULL,
  `modify_user_id` bigint(20) DEFAULT NULL,
  `updater` varchar(255) DEFAULT NULL,
  `modify_time` datetime(6) DEFAULT NULL,
  `delete_flag` int(11) DEFAULT NULL,
  `audit_data_version` int(11) DEFAULT NULL,
  `ou_id` bigint(20) DEFAULT NULL COMMENT '公司ID',
  `doc_time` datetime DEFAULT NULL COMMENT '订单时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `create_user_id_index` (`create_user_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='订单中心发货单主表';

-- ----------------------------
-- Table structure for send_bill_d
-- ----------------------------

CREATE TABLE `send_bill_d` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `mas_id` bigint(20) DEFAULT '0' COMMENT '主表ID',
  `line_no` decimal(20,3) DEFAULT NULL COMMENT '行号',
  `supp_id` bigint(20) DEFAULT '0' COMMENT '供应商ID',
  `item_id` bigint(20) DEFAULT '0' COMMENT '品项ID',
  `qty` decimal(20,8) DEFAULT NULL COMMENT '数量',
  `uom` varchar(10) DEFAULT NULL COMMENT '单位',
  `amt` decimal(20,8) DEFAULT NULL COMMENT '含税金额',
  `tenant_id` bigint(20) DEFAULT NULL,
  `remark` varchar(255) DEFAULT NULL,
  `create_user_id` bigint(20) DEFAULT NULL,
  `creator` varchar(255) DEFAULT NULL,
  `create_time` datetime(6) DEFAULT NULL,
  `modify_user_id` bigint(20) DEFAULT NULL,
  `updater` varchar(255) DEFAULT NULL,
  `modify_time` datetime(6) DEFAULT NULL,
  `delete_flag` int(11) DEFAULT NULL,
  `audit_data_version` int(11) DEFAULT NULL,
  `sal_dod_id` bigint(20) DEFAULT '0' COMMENT '订单中心发（退）货单明细ID',
  `sal_dod_line_no` decimal(20,3) DEFAULT NULL COMMENT '订单中心发（退）货单明细行号',
  `sal_do_supp_id` bigint(20) DEFAULT '0' COMMENT '供应商ID',
  `sal_do_item_id` bigint(20) DEFAULT '0' COMMENT '订单中心发（退）货单商品ID',
  `sal_do_qty` decimal(20,8) DEFAULT NULL COMMENT '订单中心发（退）货数量',
  `sal_do_uom` varchar(10) DEFAULT NULL COMMENT '订单中心发（退）货单位',
  `sal_do_amt` decimal(20,8) DEFAULT NULL COMMENT '订单中心发（退）货金额',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `create_user_id_index` (`create_user_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='订单中心发货单子表';

-- ----------------------------
-- Table structure for srm_act_log
-- ----------------------------

CREATE TABLE `srm_act_log` (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `act_no` varchar(40) DEFAULT NULL COMMENT '行为编号',
  `act_type` varchar(40) DEFAULT NULL COMMENT '行为类型',
  `ou_id` bigint(20) DEFAULT NULL COMMENT '公司id',
  `supp_id` bigint(20) DEFAULT NULL COMMENT '供应商',
  `supp_categ` varchar(40) DEFAULT NULL COMMENT '供应商品类',
  `supp_area` varchar(64) DEFAULT NULL COMMENT '供应区域',
  `eval_index_id` bigint(20) DEFAULT NULL COMMENT '评价指标id',
  `reason` varchar(200) DEFAULT NULL COMMENT '原因记录',
  `ocr_date` datetime DEFAULT NULL COMMENT '发生日期',
  `attach` varchar(256) DEFAULT NULL COMMENT '附件',
  `es1` varchar(64) DEFAULT NULL COMMENT 'ES1',
  `es2` varchar(64) DEFAULT NULL COMMENT 'es2',
  `es3` varchar(64) DEFAULT NULL COMMENT 'es3',
  `es4` varchar(64) DEFAULT NULL COMMENT 'es4',
  `es5` varchar(64) DEFAULT NULL COMMENT 'es5',
  `ou_code` varchar(32) DEFAULT NULL COMMENT '公司代码',
  `ou_name` varchar(32) DEFAULT NULL COMMENT '公司名称',
  `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
  `sec_bu_id` bigint(20) DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) DEFAULT NULL COMMENT 'sec_ou_id',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `idx_srm_act_log_act_no` (`act_no`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='日常行为记录表';

-- ----------------------------
-- Table structure for srm_eval_index
-- ----------------------------

CREATE TABLE `srm_eval_index` (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `eval_index_no` varchar(64) DEFAULT NULL COMMENT '指标编号',
  `eval_index_categ` varchar(40) DEFAULT NULL COMMENT '指标类别',
  `pcode` varchar(40) DEFAULT NULL COMMENT '父级指标code,存二级指标（UDC）code',
  `pid` bigint(20) DEFAULT NULL COMMENT '父级指标',
  `eval_index_name` varchar(40) DEFAULT NULL COMMENT '指标名称',
  `eval_index_content` varchar(256) DEFAULT NULL COMMENT '指标内容',
  `score_mode` varchar(40) DEFAULT NULL COMMENT '打分方式',
  `score_role` bigint(20) DEFAULT NULL COMMENT '评分角色',
  `score_role_name` varchar(40) DEFAULT NULL COMMENT '评分角色',
  `score_method` varchar(40) DEFAULT NULL COMMENT '评分方式',
  `score_sign` varchar(40) DEFAULT NULL COMMENT '正分/扣分',
  `score_from` decimal(16,2) DEFAULT NULL COMMENT '分值从',
  `score_to` decimal(16,2) DEFAULT NULL COMMENT '分值到',
  `sys_triggered` varchar(1) DEFAULT NULL COMMENT '是否系统触发',
  `eval_index_status` varchar(1) DEFAULT NULL COMMENT '指标状态',
  `ou_id` bigint(20) DEFAULT NULL COMMENT '公司',
  `supp_type` varchar(40) DEFAULT NULL COMMENT '供应商类型',
  `supp_categ` varchar(40) DEFAULT NULL COMMENT '供应商品类',
  `supp_area` varchar(64) DEFAULT NULL COMMENT '供应区域',
  `bu_id` bigint(20) DEFAULT NULL COMMENT 'BUID',
  `es1` varchar(64) DEFAULT NULL COMMENT 'ES1',
  `es2` varchar(64) DEFAULT NULL COMMENT 'es2',
  `es3` varchar(64) DEFAULT NULL COMMENT 'es3',
  `es4` varchar(64) DEFAULT NULL COMMENT 'es4',
  `es5` varchar(64) DEFAULT NULL COMMENT 'es5',
  `ou_code` varchar(32) DEFAULT NULL COMMENT '公司代码',
  `ou_name` varchar(32) DEFAULT NULL COMMENT '公司名称',
  `sbo_type` varchar(40) DEFAULT NULL COMMENT '分箱类型',
  `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
  `sec_bu_id` bigint(20) DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) DEFAULT NULL COMMENT 'sec_ou_id',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `idx_srm_eval_index_eval_index_no` (`eval_index_no`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='评价指标表';

-- ----------------------------
-- Table structure for srm_eval_tmpl
-- ----------------------------

CREATE TABLE `srm_eval_tmpl` (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `eval_tmpl_code` varchar(40) DEFAULT NULL COMMENT '评价模板编码',
  `eval_tmpl_name` varchar(100) DEFAULT NULL COMMENT '评价模板名称',
  `period_from` datetime DEFAULT NULL COMMENT '评价期间从',
  `period_to` datetime DEFAULT NULL COMMENT '评价期间至',
  `eval_tmpl_type` varchar(40) DEFAULT NULL COMMENT '模板类型',
  `ou_id` bigint(20) DEFAULT NULL COMMENT '公司',
  `bu_id` bigint(20) DEFAULT NULL COMMENT '采购组织',
  `user_type` varchar(40) DEFAULT NULL COMMENT '使用方',
  `supp_comb` varchar(40) DEFAULT NULL COMMENT '供应商分类,【UDC】上游/下游/上游+下游',
  `supp_categ` varchar(40) DEFAULT NULL COMMENT '供应商品类',
  `supp_area` varchar(64) DEFAULT NULL COMMENT '供应区域',
  `eval_tmpl_version` int(8) DEFAULT NULL COMMENT '模板版本',
  `eval_tmpl_status` varchar(8) DEFAULT NULL COMMENT '模板状态',
  `enabled` varchar(1) DEFAULT NULL COMMENT '启用',
  `grade_rule_id` bigint(20) DEFAULT NULL COMMENT '分级准则id',
  `es1` varchar(64) DEFAULT NULL COMMENT 'ES1',
  `es2` varchar(64) DEFAULT NULL COMMENT 'es2',
  `es3` varchar(64) DEFAULT NULL COMMENT 'es3',
  `es4` varchar(64) DEFAULT NULL COMMENT 'es4',
  `es5` varchar(64) DEFAULT NULL COMMENT 'es5',
  `ou_code` varchar(32) DEFAULT NULL COMMENT '公司代码',
  `ou_name` varchar(32) DEFAULT NULL COMMENT '公司名称',
  `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
  `sec_bu_id` bigint(20) DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) DEFAULT NULL COMMENT 'sec_ou_id',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `idx_srm_eval_tmpl_eval_tmpl_code` (`eval_tmpl_code`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='评价模型主表';

-- ----------------------------
-- Table structure for srm_eval_tmpl_d
-- ----------------------------

CREATE TABLE `srm_eval_tmpl_d` (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `mas_id` bigint(20) DEFAULT NULL COMMENT '主表id',
  `eval_tmpl_code` varchar(40) DEFAULT NULL COMMENT '评价模板编码',
  `eval_index_id` bigint(20) DEFAULT NULL COMMENT '指标id',
  `eval_index_no` varchar(40) DEFAULT NULL COMMENT '指标编号',
  `eval_index_name` varchar(100) DEFAULT NULL COMMENT '指标名称',
  `weight` decimal(8,2) DEFAULT NULL COMMENT '权重',
  `score_from` decimal(16,2) DEFAULT NULL COMMENT '分值从',
  `score_to` decimal(16,2) DEFAULT NULL COMMENT '分值到',
  `score_mode` varchar(40) DEFAULT NULL COMMENT '打分方式',
  `score_method` varchar(40) DEFAULT NULL COMMENT '评分方式',
  `score_sign` varchar(1) DEFAULT NULL COMMENT '正分/扣分',
  `sys_triggered` varchar(1) DEFAULT NULL COMMENT '是否系统触发',
  `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
  `sec_bu_id` bigint(20) DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) DEFAULT NULL COMMENT 'sec_ou_id',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_srm_eval_tmpl_d_mas_id` (`mas_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='评价模型明细表';

-- ----------------------------
-- Table structure for srm_exam_result_export
-- ----------------------------

CREATE TABLE `srm_exam_result_export` (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `doc_no` varchar(40) DEFAULT NULL COMMENT '申请单号',
  `doc_class` varchar(40) DEFAULT NULL COMMENT '单据类别',
  `doc_status` varchar(40) DEFAULT NULL COMMENT '单据状态',
  `proc_inst_id` varchar(40) DEFAULT NULL COMMENT '流程实例ID',
  `appr_status` varchar(40) DEFAULT NULL COMMENT '审批状态([UDC]COM:APPR_STATUS',
  `doc_type` varchar(40) DEFAULT NULL COMMENT '单据类型',
  `ou_id` bigint(20) DEFAULT NULL COMMENT '公司id',
  `ou_code` varchar(40) DEFAULT NULL COMMENT '公司编码',
  `supp_code_list` text COMMENT '供应商',
  `export_count` int(8) DEFAULT NULL COMMENT '导出次数',
  `export_date` datetime DEFAULT NULL COMMENT '导出时间',
  `ou_name` varchar(40) DEFAULT NULL COMMENT '公司名称',
  `es1` text COMMENT 'ES1(数据id集合)',
  `es2` varchar(64) DEFAULT NULL COMMENT 'es2(考评日期起',
  `es3` varchar(64) DEFAULT NULL COMMENT 'es3（考评日期至',
  `es4` varchar(64) DEFAULT NULL COMMENT 'es4',
  `es5` varchar(64) DEFAULT NULL COMMENT 'es5',
  `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
  `sec_bu_id` bigint(20) DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) DEFAULT NULL COMMENT 'sec_ou_id',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `srm_exam_result_export_doc_no` (`doc_no`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='指定供应商评价结果导出表';

-- ----------------------------
-- Table structure for srm_exam_supp
-- ----------------------------

CREATE TABLE `srm_exam_supp` (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `score_batch` varchar(128) DEFAULT NULL COMMENT '打分表批次',
  `period_from` datetime DEFAULT NULL COMMENT '考评期间从',
  `period_to` datetime DEFAULT NULL COMMENT '考评期间至',
  `ou_code` varchar(40) DEFAULT NULL COMMENT '公司编码',
  `ou_name` varchar(40) DEFAULT NULL COMMENT '公司名称',
  `supp_code` varchar(40) DEFAULT NULL COMMENT '供应商编码',
  `supp_name` varchar(40) DEFAULT NULL COMMENT '供应商名称',
  `reason` varchar(200) DEFAULT NULL COMMENT '删除原因',
  `export_count` int(8) DEFAULT NULL COMMENT '导出次数',
  `export_date` datetime DEFAULT NULL COMMENT '导出时间',
  `doc_no` varchar(40) DEFAULT NULL COMMENT '申请单号',
  `doc_class` varchar(40) DEFAULT NULL COMMENT '单据类别',
  `doc_status` varchar(40) DEFAULT NULL COMMENT '单据状态',
  `proc_inst_id` varchar(40) DEFAULT NULL COMMENT '流程实例ID',
  `appr_status` varchar(40) DEFAULT NULL COMMENT '审批状态',
  `doc_type` varchar(40) DEFAULT NULL COMMENT '单据类型',
  `es1` varchar(64) DEFAULT NULL COMMENT 'ES1',
  `es2` varchar(64) DEFAULT NULL COMMENT 'ES2',
  `es3` varchar(64) DEFAULT NULL COMMENT 'ES3',
  `es4` varchar(64) DEFAULT NULL COMMENT 'ES4',
  `es5` varchar(64) DEFAULT NULL COMMENT 'ES5',
  `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
  `sec_bu_id` bigint(20) DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) DEFAULT NULL COMMENT 'sec_ou_id',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='供应商参评';

-- ----------------------------
-- Table structure for srm_examine_result
-- ----------------------------

CREATE TABLE `srm_examine_result` (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `doc_class` varchar(40) DEFAULT NULL COMMENT '单据类别',
  `doc_status` varchar(40) DEFAULT NULL COMMENT '单据状态',
  `proc_inst_id` varchar(40) DEFAULT NULL COMMENT '流程实例ID',
  `appr_status` varchar(40) DEFAULT NULL COMMENT '审批状态',
  `doc_type` varchar(40) DEFAULT NULL COMMENT '单据类型',
  `examine_no` varchar(64) DEFAULT NULL COMMENT '考评档案编号',
  `ou_id` bigint(20) DEFAULT NULL COMMENT '公司',
  `bu_id` bigint(20) DEFAULT NULL COMMENT '采购组织',
  `supp_name` varchar(256) DEFAULT NULL COMMENT '供应商名称',
  `curr_grade` varchar(40) DEFAULT NULL COMMENT '本次评级结果',
  `total_final_score` decimal(16,2) DEFAULT NULL COMMENT '总得分',
  `curr_rank` int(8) DEFAULT NULL COMMENT '排名',
  `last_grade` varchar(40) DEFAULT NULL COMMENT '上次评级结果',
  `supp_categ` varchar(40) DEFAULT NULL COMMENT '供应商品类',
  `supp_area` varchar(64) DEFAULT NULL COMMENT '供应区域',
  `eval_tmpl_id` bigint(20) DEFAULT NULL COMMENT '评价模型',
  `period_from` datetime DEFAULT NULL COMMENT '考评期间从',
  `period_to` datetime DEFAULT NULL COMMENT '考评期间至',
  `grade_rule_id` bigint(20) DEFAULT NULL COMMENT '评级规则',
  `sugg_strategy` varchar(64) DEFAULT NULL COMMENT '建议策略',
  `supp_feedback_content` varchar(2000) DEFAULT NULL COMMENT '供应商反馈内容',
  `supp_feedback_attach` varchar(2048) DEFAULT NULL COMMENT '供应商反馈附件',
  `supp_feedback_status` varchar(64) DEFAULT NULL COMMENT '供应商反馈状态',
  `supp_feedback_date` datetime DEFAULT NULL COMMENT '供应商反馈日期',
  `origin_grade` varchar(40) DEFAULT NULL COMMENT '修改前评级结果',
  `supp_comb` varchar(40) DEFAULT NULL COMMENT '供应商分类',
  `comb_examine_type` varchar(40) DEFAULT NULL COMMENT '考核结果类型,上游存A，下游存B',
  `supp_id` bigint(20) DEFAULT NULL COMMENT '供应商id',
  `es1` varchar(64) DEFAULT NULL COMMENT 'ES1(供应商srm编码)',
  `es2` varchar(64) DEFAULT NULL COMMENT 'es2(供应商erp编码)',
  `es3` varchar(64) DEFAULT NULL COMMENT 'es3(同一批审批流标识)',
  `es4` varchar(64) DEFAULT NULL COMMENT 'es4',
  `es5` varchar(64) DEFAULT NULL COMMENT 'es5',
  `ou_code` varchar(32) DEFAULT NULL COMMENT '公司代码',
  `ou_name` varchar(32) DEFAULT NULL COMMENT '公司名称',
  `grade_batch` varchar(128) DEFAULT NULL COMMENT '考核结果批次',
  `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
  `sec_bu_id` bigint(20) DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) DEFAULT NULL COMMENT 'sec_ou_id',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_srm_examine_result_examine_no` (`examine_no`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='考核绩效结果表';

-- ----------------------------
-- Table structure for srm_examine_result_d
-- ----------------------------

CREATE TABLE `srm_examine_result_d` (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `mas_id` bigint(20) DEFAULT NULL COMMENT '主表id',
  `eval_index_id` bigint(20) DEFAULT NULL COMMENT '指标id',
  `score_d_id` bigint(20) DEFAULT NULL COMMENT '打分明细表id',
  `eval_tmpl_did` bigint(20) DEFAULT NULL COMMENT '评价模型明细id',
  `final_score` decimal(16,2) DEFAULT NULL COMMENT '得分',
  `index_rank` int(8) DEFAULT NULL COMMENT '排名',
  `es1` varchar(64) DEFAULT NULL COMMENT 'ES1（指标编号）',
  `es2` varchar(64) DEFAULT NULL COMMENT 'es2',
  `es3` varchar(64) DEFAULT NULL COMMENT 'es3',
  `es4` varchar(64) DEFAULT NULL COMMENT 'es4',
  `es5` varchar(64) DEFAULT NULL COMMENT 'es5',
  `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
  `sec_bu_id` bigint(20) DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) DEFAULT NULL COMMENT 'sec_ou_id',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_srm_examine_result_d_eval_index_id` (`eval_index_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='考核绩效结果明细表';

-- ----------------------------
-- Table structure for srm_grade_rule
-- ----------------------------

CREATE TABLE `srm_grade_rule` (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `ou_id` bigint(20) DEFAULT NULL COMMENT '公司id',
  `bu_id` bigint(20) DEFAULT NULL COMMENT '组织',
  `user_type` varchar(40) DEFAULT NULL COMMENT '使用方',
  `grade_rule_code` varchar(40) DEFAULT NULL COMMENT '分级准则编码',
  `grade_rule_name` varchar(40) DEFAULT NULL COMMENT '分级准则名称',
  `enabled` varchar(1) DEFAULT NULL COMMENT '启用1启用，0禁用',
  `ou_code` varchar(40) DEFAULT NULL COMMENT '公司代码',
  `ou_name` varchar(40) DEFAULT NULL COMMENT '公司名称',
  `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
  `sec_bu_id` bigint(20) DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) DEFAULT NULL COMMENT 'sec_ou_id',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_srm_grade_rule_ou_id` (`ou_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='供应商分级准则主表';

-- ----------------------------
-- Table structure for srm_grade_rule_d
-- ----------------------------

CREATE TABLE `srm_grade_rule_d` (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `mas_id` bigint(20) DEFAULT NULL COMMENT '主表id',
  `grade` int(8) DEFAULT NULL COMMENT '级别',
  `grade_name` varchar(40) DEFAULT NULL COMMENT '级别命名',
  `grade_type` varchar(8) DEFAULT NULL COMMENT '分级类型.按占比、按排名',
  `grade_from` int(8) DEFAULT NULL COMMENT '分级从',
  `grade_to` int(8) DEFAULT NULL COMMENT '分级至',
  `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
  `sec_bu_id` bigint(20) DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) DEFAULT NULL COMMENT 'sec_ou_id',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_srm_grade_rule_d_mas_id` (`mas_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='供应商分级准则明细表';

-- ----------------------------
-- Table structure for srm_qr_code
-- ----------------------------

CREATE TABLE `srm_qr_code` (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `sec_bu_id` bigint(20) DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) DEFAULT NULL COMMENT 'sec_ou_id',
  `doc_no` varchar(40) DEFAULT NULL COMMENT '单据编号',
  `apply_person` varchar(20) DEFAULT NULL COMMENT '申请人',
  `supp_id` bigint(20) DEFAULT NULL COMMENT '供应商ID',
  `apply_time` datetime(6) DEFAULT NULL,
  `doc_status` varchar(20) DEFAULT NULL COMMENT '单据状态',
  `manu_date` datetime(6) DEFAULT NULL,
  `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `create_user_id_index` (`create_user_id`) USING BTREE,
  KEY `sec_bu_id_index` (`sec_bu_id`) USING BTREE,
  KEY `sec_user_id_index` (`sec_user_id`) USING BTREE,
  KEY `sec_ou_id_index` (`sec_ou_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='供应商二维码';

-- ----------------------------
-- Table structure for srm_qr_code_d
-- ----------------------------

CREATE TABLE `srm_qr_code_d` (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `sec_bu_id` bigint(20) DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) DEFAULT NULL COMMENT 'sec_ou_id',
  `mas_id` bigint(20) DEFAULT NULL COMMENT '主表ID',
  `supp_id` bigint(20) DEFAULT NULL COMMENT '供应商ID',
  `item_id` bigint(20) DEFAULT NULL COMMENT '商品ID',
  `item_name` varchar(40) DEFAULT NULL COMMENT '商品名称',
  `spec` varchar(20) DEFAULT NULL COMMENT '规格型号',
  `materia_code` varchar(40) DEFAULT NULL COMMENT '物料编码',
  `apply_qty` bigint(20) DEFAULT NULL COMMENT '商品ID',
  `manu_date` datetime(6) DEFAULT NULL,
  `print_time` datetime(6) DEFAULT NULL,
  `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `create_user_id_index` (`create_user_id`) USING BTREE,
  KEY `sec_bu_id_index` (`sec_bu_id`) USING BTREE,
  KEY `sec_user_id_index` (`sec_user_id`) USING BTREE,
  KEY `sec_ou_id_index` (`sec_ou_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='供应商二维码明细';

-- ----------------------------
-- Table structure for srm_sbo_config
-- ----------------------------

CREATE TABLE `srm_sbo_config` (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `eval_index_no` varchar(64) DEFAULT NULL COMMENT '指标编号',
  `sbo_type` varchar(40) DEFAULT NULL COMMENT '分箱类型',
  `sbo_desc` varchar(256) DEFAULT NULL COMMENT '描述',
  `result_from` decimal(16,6) DEFAULT NULL COMMENT '结果从',
  `result_to` decimal(16,6) DEFAULT NULL COMMENT '结果至',
  `sbo_score` decimal(16,2) DEFAULT NULL COMMENT '分值',
  `eval_index_id` bigint(20) DEFAULT NULL COMMENT '评价指标id',
  `eval_tmpl_id` bigint(20) DEFAULT NULL COMMENT '评价模型id',
  `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
  `sec_bu_id` bigint(20) DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) DEFAULT NULL COMMENT 'sec_ou_id',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_srm_sbo_config_eval_index_no` (`eval_index_no`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='分箱选项设置表';

-- ----------------------------
-- Table structure for srm_score
-- ----------------------------

CREATE TABLE `srm_score` (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `doc_class` varchar(40) DEFAULT NULL COMMENT '单据类别',
  `doc_status` varchar(40) DEFAULT NULL COMMENT '单据状态',
  `proc_inst_id` varchar(40) DEFAULT NULL COMMENT '流程实例ID',
  `appr_status` varchar(40) DEFAULT NULL COMMENT '审批状态',
  `doc_type` varchar(40) DEFAULT NULL COMMENT '单据类型',
  `score_no` varchar(40) DEFAULT NULL COMMENT '打分表编号',
  `ou_id` bigint(20) DEFAULT NULL COMMENT '公司',
  `bu_id` bigint(20) DEFAULT NULL COMMENT '采购组织',
  `supp_id` bigint(20) DEFAULT NULL COMMENT '供应商',
  `supp_categ` varchar(40) DEFAULT NULL COMMENT '供应商品类',
  `supp_area` varchar(64) DEFAULT NULL COMMENT '供应区域',
  `period_from` date DEFAULT NULL COMMENT '考评期间从',
  `period_to` date DEFAULT NULL COMMENT '考评期间至',
  `total_score` decimal(16,2) DEFAULT NULL COMMENT '总打分',
  `score_rule` varchar(2000) DEFAULT NULL COMMENT '打分规则',
  `es1` varchar(64) DEFAULT NULL COMMENT 'ES1(索引排序)',
  `es2` varchar(64) DEFAULT NULL COMMENT 'es2（同一批审批流标识）',
  `es3` varchar(64) DEFAULT NULL COMMENT 'es3(供应商srm编码)',
  `es4` varchar(64) DEFAULT NULL COMMENT 'es4(供应商erp编码)',
  `es5` varchar(64) DEFAULT NULL COMMENT 'es5(供应商名称)',
  `ou_code` varchar(32) DEFAULT NULL COMMENT '公司代码',
  `ou_name` varchar(32) DEFAULT NULL COMMENT '公司名称',
  `supp_comb` varchar(40) DEFAULT NULL COMMENT '供应商分类,【UDC】上游/下游/上游+下游',
  `score_batch` varchar(128) DEFAULT NULL COMMENT '打分表批次',
  `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
  `sec_bu_id` bigint(20) DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) DEFAULT NULL COMMENT 'sec_ou_id',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_srm_score_score_no` (`score_no`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='供应商打分主表';

-- ----------------------------
-- Table structure for srm_score_d
-- ----------------------------

CREATE TABLE `srm_score_d` (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `mas_id` bigint(20) DEFAULT NULL COMMENT '主表id',
  `eval_index_id` bigint(20) DEFAULT NULL COMMENT '指标id',
  `eval_index_no` varchar(64) DEFAULT NULL COMMENT '指标编号',
  `score_method` varchar(40) DEFAULT NULL COMMENT '评分方式',
  `comp_status` varchar(40) DEFAULT NULL COMMENT '计算状态',
  `origin_score` decimal(16,2) DEFAULT NULL COMMENT '打分',
  `score_persion` varchar(64) DEFAULT NULL COMMENT '打分人',
  `es1` varchar(64) DEFAULT NULL COMMENT 'ES1(A:高,B:中,C:低，为了手工打分界面回显)',
  `es2` varchar(64) DEFAULT NULL COMMENT 'es2(打分人用户名)',
  `es3` varchar(64) DEFAULT NULL COMMENT 'es3',
  `es4` varchar(64) DEFAULT NULL COMMENT 'es4',
  `es5` varchar(64) DEFAULT NULL COMMENT 'es5',
  `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
  `sec_bu_id` bigint(20) DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) DEFAULT NULL COMMENT 'sec_ou_id',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_srm_score_d_mas_id` (`mas_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='供应商打分明细表';

-- ----------------------------
-- Table structure for srm_system_score
-- ----------------------------

CREATE TABLE `srm_system_score` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '记录唯一ID',
  `score_id` bigint(20) DEFAULT NULL COMMENT '打分表id',
  `sales_growth_rate` decimal(16,2) DEFAULT NULL COMMENT '产品销售增长率',
  `sales_contribution_ratio` decimal(16,2) DEFAULT NULL COMMENT '销售贡献占比',
  `gross_margin_ratio` decimal(16,2) DEFAULT NULL COMMENT '毛利贡献比',
  `inventory_day` decimal(16,2) DEFAULT NULL COMMENT '存货周转天数',
  `unsalable_ratio` decimal(16,2) DEFAULT NULL COMMENT '滞销存货占比',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_srm_system_score_score_id` (`score_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='系统分数';

-- ----------------------------
-- Table structure for srm_user_relate
-- ----------------------------

CREATE TABLE `srm_user_relate` (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `sec_bu_id` bigint(20) DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) DEFAULT NULL COMMENT 'sec_ou_id',
  `sys_user_id` bigint(20) DEFAULT NULL COMMENT '用户ID',
  `username` varchar(40) DEFAULT NULL COMMENT '用户名',
  `supp_register_id` bigint(20) DEFAULT NULL COMMENT '供应商注册ID',
  `supp_id` bigint(20) DEFAULT NULL COMMENT '供应商ID',
  `supp_code` varchar(40) DEFAULT NULL COMMENT '供应商编码',
  `supp_name` varchar(200) DEFAULT NULL COMMENT '供应商名称',
  `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
  `enabled` int(2) DEFAULT NULL COMMENT '启用标识',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `create_user_id_index` (`create_user_id`) USING BTREE,
  KEY `sec_bu_id_index` (`sec_bu_id`) USING BTREE,
  KEY `sec_user_id_index` (`sec_user_id`) USING BTREE,
  KEY `sec_ou_id_index` (`sec_ou_id`) USING BTREE,
  KEY `sys_user_id_index` (`sys_user_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='账号信息关联';

-- ----------------------------
-- Table structure for sys_rocket_mq_consume_fail_log
-- ----------------------------

CREATE TABLE `sys_rocket_mq_consume_fail_log` (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `type_id` int(11) DEFAULT NULL COMMENT '消费失败类型：1：消费次数过多，2：业务异常，3：长时间无法消费,4:其他',
  `already_deal` varchar(255) DEFAULT NULL COMMENT '消费失败是否已处理；PROCESSED：已处理，TO_BE_PROCESSED:待处理',
  `consumer_key` varchar(64) DEFAULT NULL COMMENT '消息体key',
  `consumer_boby` longblob COMMENT '消息体',
  `consumer_group` varchar(256) DEFAULT NULL COMMENT '消费者组',
  `consumer_topic` varchar(128) DEFAULT NULL COMMENT '消费主题',
  `consumer_tag` varchar(128) DEFAULT NULL,
  `message_uuid` varchar(255) DEFAULT NULL COMMENT '消息UUID',
  `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(10) DEFAULT '0' COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
  `sec_bu_id` bigint(20) DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) DEFAULT NULL COMMENT 'sec_ou_id',
  PRIMARY KEY (`id`),
  UNIQUE KEY `UKgrpk942r3l233crbyf36p0xpx` (`consumer_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='架构补偿机制-消费失败记录';

-- ----------------------------
-- Table structure for sys_rocket_mq_consume_log
-- ----------------------------

CREATE TABLE `sys_rocket_mq_consume_log` (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `line_num` bigint(20) DEFAULT NULL COMMENT '消息行号',
  `queue_id` int(11) DEFAULT NULL COMMENT '消息体key',
  `message_id` varchar(255) DEFAULT NULL COMMENT '消息标识',
  `message_uuid` varchar(255) DEFAULT NULL COMMENT '消息UUID',
  `reconsume_times` int(11) DEFAULT NULL COMMENT '消息标识',
  `consumer_key` varchar(64) DEFAULT NULL COMMENT '消息体key',
  `consumer_group` varchar(256) DEFAULT NULL COMMENT '消费者组',
  `consumer_topic` varchar(128) DEFAULT NULL COMMENT '消费主题',
  `is_success` int(11) DEFAULT NULL COMMENT '是否消费成功:true:成功，false:失败',
  `fail_detail` varchar(255) DEFAULT NULL COMMENT '失败详情',
  `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(10) DEFAULT '0' COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
  `sec_bu_id` bigint(20) DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) DEFAULT NULL COMMENT 'sec_ou_id',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='架构补偿机制-消费记录';

-- ----------------------------
-- Table structure for tms_doc_trace
-- ----------------------------

CREATE TABLE `tms_doc_trace` (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `sec_bu_id` bigint(20) DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) DEFAULT NULL COMMENT 'sec_ou_id',
  `remark2` varchar(100) DEFAULT NULL COMMENT '备注2',
  `doc_cls` varchar(40) DEFAULT NULL COMMENT '单据类别 [UOM]COM:DOC_CLS',
  `doc_id` bigint(20) DEFAULT NULL COMMENT '单据ID',
  `doc_no` varchar(40) DEFAULT NULL COMMENT '单据编号',
  `doc_did` int(18) DEFAULT NULL COMMENT '单据明细ID',
  `sort_no` int(18) DEFAULT NULL COMMENT '排序号',
  `event_dt` datetime DEFAULT NULL COMMENT '事件发生时间',
  `event_cls` varchar(40) DEFAULT NULL COMMENT '事件类别 [UOM]TMS:EVENT_CLS',
  `event_type` varchar(40) DEFAULT NULL COMMENT '事件类型 [UOM]TMS:EVENT_TYPE',
  `event_name` varchar(40) DEFAULT NULL COMMENT '事件名称',
  `event_type2` varchar(40) DEFAULT NULL COMMENT '事件类型2 [UOM]TMS:EVENT_TYPE2',
  `event_name2` varchar(40) DEFAULT NULL COMMENT '事件名称2',
  `plan_dt` datetime DEFAULT NULL COMMENT '计划时间',
  `esti_dt` datetime DEFAULT NULL COMMENT '预计时间',
  `oper_user_id` bigint(20) DEFAULT NULL COMMENT '操作人ID',
  `oper_user_name` varchar(40) DEFAULT NULL COMMENT '操作人姓名',
  `src_cls` varchar(40) DEFAULT NULL COMMENT '来源类别',
  `src_id` bigint(20) DEFAULT NULL COMMENT '来源ID',
  `src_no` varchar(40) DEFAULT NULL COMMENT '来源编号',
  `src_did` int(18) DEFAULT NULL COMMENT '来源明细ID',
  `relate_cls` varchar(40) DEFAULT NULL COMMENT '相关类别',
  `relate_id` bigint(20) DEFAULT NULL COMMENT '相关ID',
  `relate_no` varchar(40) DEFAULT NULL COMMENT '相关编号',
  `relate_did` int(18) DEFAULT NULL COMMENT '相关明细ID',
  `del_flag` int(1) DEFAULT NULL COMMENT '删除标志',
  `contr_no` varchar(40) DEFAULT NULL COMMENT '合同号',
  `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) DEFAULT NULL COMMENT '锁版本',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `create_user_id_index` (`create_user_id`) USING BTREE,
  KEY `sec_bu_id_index` (`sec_bu_id`) USING BTREE,
  KEY `sec_user_id_index` (`sec_user_id`) USING BTREE,
  KEY `sec_ou_id_index` (`sec_ou_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='单据物流追踪';

-- ----------------------------
-- Table structure for undo_log
-- ----------------------------

CREATE TABLE `undo_log` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT 'increment id',
  `branch_id` bigint(20) NOT NULL COMMENT 'branch transaction id',
  `xid` varchar(128) NOT NULL COMMENT 'global transaction id',
  `context` varchar(128) NOT NULL COMMENT 'undo_log context,such as serialization',
  `rollback_info` longblob NOT NULL COMMENT 'rollback info',
  `log_status` int(11) NOT NULL COMMENT '0:normal status,1:defense status',
  `log_created` datetime NOT NULL COMMENT 'create datetime',
  `log_modified` datetime NOT NULL COMMENT 'modify datetime',
  PRIMARY KEY (`id`),
  UNIQUE KEY `ux_undo_log` (`xid`,`branch_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='AT transaction mode undo table';

-- ----------------------------
-- Table structure for v_itfsrm_corp_dim
-- ----------------------------

CREATE TABLE `v_itfsrm_corp_dim` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '记录唯一ID',
  `corp_code` varchar(40) DEFAULT NULL COMMENT '公司编码',
  `corp_name` varchar(400) DEFAULT NULL COMMENT '公司名称',
  `corp_sname` varchar(40) DEFAULT NULL COMMENT '公司简称',
  `investment_corpus` varchar(400) DEFAULT NULL COMMENT '投资主体',
  `investment_scorpus` varchar(100) DEFAULT NULL COMMENT '投资主体简称',
  `corp_type` varchar(40) DEFAULT NULL COMMENT '公司类型',
  `corp_level` int(11) DEFAULT NULL COMMENT '公司级次',
  `corp_calculate_level` int(11) DEFAULT NULL COMMENT '公司逻辑级次',
  `start_date` date DEFAULT NULL COMMENT '开始日期',
  `end_date` date DEFAULT NULL COMMENT '结束日期',
  `valid_flag` varchar(2) DEFAULT NULL COMMENT '是否有效',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_v_itfsrm_corp_dim_corp_code` (`corp_code`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='指标-公司维度表';

-- ----------------------------
-- Table structure for v_itfsrm_vendor_dim
-- ----------------------------

CREATE TABLE `v_itfsrm_vendor_dim` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '记录唯一ID',
  `merchants_code` bigint(20) DEFAULT NULL COMMENT '客商编码',
  `merchants_name` varchar(800) DEFAULT NULL COMMENT '客商名称',
  `merchants_name_standard` varchar(400) DEFAULT NULL COMMENT '供应商标准名称',
  `merchants_type` varchar(12) DEFAULT NULL COMMENT 'v-供应商， c-客户(通过V/C区分是供应商还是客户) ',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_v_itfsrm_vendor_dim_merchants_code` (`merchants_code`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='指标-供应商维度表';

